/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitLocalBranch;
import git4idea.GitReference;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.branch.GitBranchUiHandler;
import git4idea.branch.GitBranchUtil;
import git4idea.branch.GitBrancher;
import git4idea.branch.GitCheckoutNewBranchOperation;
import git4idea.branch.GitCheckoutOperation;
import git4idea.branch.GitCreateBranchOperation;
import git4idea.branch.GitDeleteBranchOperation;
import git4idea.branch.GitDeleteRemoteBranchOperation;
import git4idea.branch.GitDeleteRemoteTagOperation;
import git4idea.branch.GitDeleteTagOperation;
import git4idea.branch.GitMergeOperation;
import git4idea.branch.GitRebaseParams;
import git4idea.branch.GitRenameBranchOperation;
import git4idea.changes.GitChangeUtils;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.i18n.GitBundle;
import git4idea.rebase.GitRebaseUtils;
import git4idea.repo.GitRepository;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class GitBranchWorker {
    private static final Logger LOG = Logger.getInstance(GitBranchWorker.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final Git myGit;
    @NotNull
    private final GitBranchUiHandler myUiHandler;
    @NotNull
    private final GitVcs myVcs;

    public GitBranchWorker(@NotNull Project project, @NotNull Git git, @NotNull GitBranchUiHandler uiHandler) {
        if (project == null) {
            GitBranchWorker.$$$reportNull$$$0(0);
        }
        if (git == null) {
            GitBranchWorker.$$$reportNull$$$0(1);
        }
        if (uiHandler == null) {
            GitBranchWorker.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myGit = git;
        this.myUiHandler = uiHandler;
        this.myVcs = GitVcs.getInstance(this.myProject);
    }

    public void checkoutNewBranch(@NotNull String name, @NotNull List<? extends GitRepository> repositories2) {
        if (name == null) {
            GitBranchWorker.$$$reportNull$$$0(3);
        }
        if (repositories2 == null) {
            GitBranchWorker.$$$reportNull$$$0(4);
        }
        GitBranchWorker.updateInfo(repositories2);
        repositories2 = ContainerUtil.filter(repositories2, repository -> {
            GitLocalBranch currentBranch = repository.getCurrentBranch();
            return currentBranch == null || !currentBranch.getName().equals(name);
        });
        if (!repositories2.isEmpty()) {
            new GitCheckoutNewBranchOperation(this.myProject, this.myGit, this.myUiHandler, repositories2, name).execute();
        } else {
            LOG.error("Creating new branch the same as current in all repositories: " + name);
        }
    }

    public void createBranch(@NotNull String name, @NotNull Map<GitRepository, String> startPoints) {
        if (name == null) {
            GitBranchWorker.$$$reportNull$$$0(5);
        }
        if (startPoints == null) {
            GitBranchWorker.$$$reportNull$$$0(6);
        }
        this.createBranch(name, startPoints, false);
    }

    public void createBranch(@NotNull String name, @NotNull Map<GitRepository, String> startPoints, boolean force) {
        if (name == null) {
            GitBranchWorker.$$$reportNull$$$0(7);
        }
        if (startPoints == null) {
            GitBranchWorker.$$$reportNull$$$0(8);
        }
        GitBranchWorker.updateInfo(startPoints.keySet());
        new GitCreateBranchOperation(this.myProject, this.myGit, this.myUiHandler, name, startPoints, force).execute();
    }

    public void createNewTag(@NotNull String name, @NotNull String reference, @NotNull List<? extends GitRepository> repositories2) {
        if (name == null) {
            GitBranchWorker.$$$reportNull$$$0(9);
        }
        if (reference == null) {
            GitBranchWorker.$$$reportNull$$$0(10);
        }
        if (repositories2 == null) {
            GitBranchWorker.$$$reportNull$$$0(11);
        }
        for (GitRepository gitRepository : repositories2) {
            GitCommandResult result2 = this.myGit.createNewTag(gitRepository, name, null, reference);
            gitRepository.getRepositoryFiles().refreshTagsFiles();
            if (result2.success()) continue;
            String error = GitBundle.message("branch.worker.could.not.create.tag", name, GitUtil.getRepositoryManager(gitRepository.getProject()).getRepositories().size(), DvcsUtil.getShortRepositoryName((Repository)gitRepository));
            VcsNotifier.getInstance((Project)this.myProject).notifyError("git.tag.not.created", error, result2.getErrorOutputAsHtmlString(), true);
            break;
        }
    }

    public void checkoutNewBranchStartingFrom(@NotNull String newBranchName, @NotNull String startPoint, @NotNull List<? extends GitRepository> repositories2) {
        if (newBranchName == null) {
            GitBranchWorker.$$$reportNull$$$0(12);
        }
        if (startPoint == null) {
            GitBranchWorker.$$$reportNull$$$0(13);
        }
        if (repositories2 == null) {
            GitBranchWorker.$$$reportNull$$$0(14);
        }
        this.checkoutNewBranchStartingFrom(newBranchName, startPoint, false, repositories2);
    }

    public void checkoutNewBranchStartingFrom(@NotNull String newBranchName, @NotNull String startPoint, boolean overwriteIfNeeded, @NotNull List<? extends GitRepository> repositories2) {
        if (newBranchName == null) {
            GitBranchWorker.$$$reportNull$$$0(15);
        }
        if (startPoint == null) {
            GitBranchWorker.$$$reportNull$$$0(16);
        }
        if (repositories2 == null) {
            GitBranchWorker.$$$reportNull$$$0(17);
        }
        GitBranchWorker.updateInfo(repositories2);
        new GitCheckoutOperation(this.myProject, this.myGit, this.myUiHandler, repositories2, startPoint, false, overwriteIfNeeded, true, newBranchName).execute();
    }

    public void checkout(@NotNull String reference, boolean detach, @NotNull List<? extends GitRepository> repositories2) {
        if (reference == null) {
            GitBranchWorker.$$$reportNull$$$0(18);
        }
        if (repositories2 == null) {
            GitBranchWorker.$$$reportNull$$$0(19);
        }
        GitBranchWorker.updateInfo(repositories2);
        new GitCheckoutOperation(this.myProject, this.myGit, this.myUiHandler, repositories2, reference, detach, false, false, null).execute();
    }

    public void deleteBranch(@NotNull String branchName, @NotNull List<? extends GitRepository> repositories2) {
        if (branchName == null) {
            GitBranchWorker.$$$reportNull$$$0(20);
        }
        if (repositories2 == null) {
            GitBranchWorker.$$$reportNull$$$0(21);
        }
        GitBranchWorker.updateInfo(repositories2);
        new GitDeleteBranchOperation(this.myProject, this.myGit, this.myUiHandler, repositories2, branchName).execute();
    }

    public void deleteTag(@NotNull String tagName, @NotNull List<? extends GitRepository> repositories2) {
        if (tagName == null) {
            GitBranchWorker.$$$reportNull$$$0(22);
        }
        if (repositories2 == null) {
            GitBranchWorker.$$$reportNull$$$0(23);
        }
        GitBranchWorker.updateInfo(repositories2);
        new GitDeleteTagOperation(this.myProject, this.myGit, this.myUiHandler, repositories2, tagName).execute();
    }

    public void deleteRemoteTag(@NotNull String tagName, @NotNull Map<GitRepository, String> repositories2) {
        if (tagName == null) {
            GitBranchWorker.$$$reportNull$$$0(24);
        }
        if (repositories2 == null) {
            GitBranchWorker.$$$reportNull$$$0(25);
        }
        GitBranchWorker.updateInfo(repositories2.keySet());
        new GitDeleteRemoteTagOperation(this.myProject, this.myGit, this.myUiHandler, repositories2, tagName).execute();
    }

    public void deleteRemoteBranch(@NotNull String branchName, @NotNull List<? extends GitRepository> repositories2) {
        if (branchName == null) {
            GitBranchWorker.$$$reportNull$$$0(26);
        }
        if (repositories2 == null) {
            GitBranchWorker.$$$reportNull$$$0(27);
        }
        this.deleteRemoteBranches(Collections.singletonList(branchName), repositories2);
    }

    public void deleteRemoteBranches(@NotNull List<String> branchNames, @NotNull List<? extends GitRepository> repositories2) {
        if (branchNames == null) {
            GitBranchWorker.$$$reportNull$$$0(28);
        }
        if (repositories2 == null) {
            GitBranchWorker.$$$reportNull$$$0(29);
        }
        GitBranchWorker.updateInfo(repositories2);
        new GitDeleteRemoteBranchOperation(this.myProject, this.myGit, this.myUiHandler, repositories2, branchNames).execute();
    }

    @Deprecated
    public void merge(@NotNull String branchName, @NotNull GitBrancher.DeleteOnMergeOption deleteOnMerge, @NotNull List<? extends GitRepository> repositories2) {
        GitReference branch;
        if (branchName == null) {
            GitBranchWorker.$$$reportNull$$$0(30);
        }
        if (deleteOnMerge == null) {
            GitBranchWorker.$$$reportNull$$$0(31);
        }
        if (repositories2 == null) {
            GitBranchWorker.$$$reportNull$$$0(32);
        }
        if ((branch = (GitReference)ContainerUtil.find(GitBranchUtil.getCommonLocalBranches(repositories2), b -> b.getName().equals(branchName))) == null) {
            branch = (GitReference)ContainerUtil.find(GitBranchUtil.getCommonRemoteBranches(repositories2), b -> b.getName().equals(branchName));
        }
        this.merge(branch != null ? branch : new GitLocalBranch(branchName), deleteOnMerge, repositories2);
    }

    public void merge(@NotNull GitReference reference, @NotNull GitBrancher.DeleteOnMergeOption deleteOnMerge, @NotNull List<? extends GitRepository> repositories2) {
        if (reference == null) {
            GitBranchWorker.$$$reportNull$$$0(33);
        }
        if (deleteOnMerge == null) {
            GitBranchWorker.$$$reportNull$$$0(34);
        }
        if (repositories2 == null) {
            GitBranchWorker.$$$reportNull$$$0(35);
        }
        GitBranchWorker.updateInfo(repositories2);
        new GitMergeOperation(this.myProject, this.myGit, this.myUiHandler, repositories2, reference, deleteOnMerge).execute();
    }

    public void rebase(@NotNull List<? extends GitRepository> repositories2, @NotNull String branchName) {
        if (repositories2 == null) {
            GitBranchWorker.$$$reportNull$$$0(36);
        }
        if (branchName == null) {
            GitBranchWorker.$$$reportNull$$$0(37);
        }
        GitBranchWorker.updateInfo(repositories2);
        GitRebaseUtils.rebase(this.myProject, repositories2, new GitRebaseParams(this.myVcs.getVersion(), branchName), this.myUiHandler.getProgressIndicator());
    }

    public void rebaseOnCurrent(@NotNull List<? extends GitRepository> repositories2, @NotNull String branchName) {
        if (repositories2 == null) {
            GitBranchWorker.$$$reportNull$$$0(38);
        }
        if (branchName == null) {
            GitBranchWorker.$$$reportNull$$$0(39);
        }
        this.rebase(repositories2, "HEAD", branchName);
    }

    public void rebase(@NotNull List<? extends GitRepository> repositories2, @NotNull String upstream, @NotNull String branchName) {
        if (repositories2 == null) {
            GitBranchWorker.$$$reportNull$$$0(40);
        }
        if (upstream == null) {
            GitBranchWorker.$$$reportNull$$$0(41);
        }
        if (branchName == null) {
            GitBranchWorker.$$$reportNull$$$0(42);
        }
        GitBranchWorker.updateInfo(repositories2);
        GitRebaseUtils.rebase(this.myProject, repositories2, new GitRebaseParams(this.myVcs.getVersion(), branchName, null, upstream, false, false), this.myUiHandler.getProgressIndicator());
    }

    public void renameBranch(@NotNull String currentName, @NotNull String newName, @NotNull List<? extends GitRepository> repositories2) {
        if (currentName == null) {
            GitBranchWorker.$$$reportNull$$$0(43);
        }
        if (newName == null) {
            GitBranchWorker.$$$reportNull$$$0(44);
        }
        if (repositories2 == null) {
            GitBranchWorker.$$$reportNull$$$0(45);
        }
        GitBranchWorker.updateInfo(repositories2);
        new GitRenameBranchOperation(this.myProject, this.myGit, this.myUiHandler, currentName, newName, repositories2).execute();
    }

    @NotNull
    public static Collection<Change> loadTotalDiff(@NotNull Repository repository, @NotNull String branchName) throws VcsException {
        if (repository == null) {
            GitBranchWorker.$$$reportNull$$$0(46);
        }
        if (branchName == null) {
            GitBranchWorker.$$$reportNull$$$0(47);
        }
        Collection<Change> collection = GitChangeUtils.getDiffWithWorkingDir(repository.getProject(), repository.getRoot(), branchName, null, true);
        if (collection == null) {
            GitBranchWorker.$$$reportNull$$$0(48);
        }
        return collection;
    }

    private static void updateInfo(@NotNull Collection<? extends GitRepository> repositories2) {
        if (repositories2 == null) {
            GitBranchWorker.$$$reportNull$$$0(49);
        }
        for (GitRepository gitRepository : repositories2) {
            gitRepository.update();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 48 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiHandler";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: 
            case 11: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 32: 
            case 35: 
            case 36: 
            case 38: 
            case 40: 
            case 45: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startPoints";
                break;
            }
            case 10: 
            case 18: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newBranchName";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startPoint";
                break;
            }
            case 20: 
            case 26: 
            case 30: 
            case 37: 
            case 39: 
            case 42: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchName";
                break;
            }
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchNames";
                break;
            }
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deleteOnMerge";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "upstream";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentName";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/branch/GitBranchWorker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/branch/GitBranchWorker";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "loadTotalDiff";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkoutNewBranch";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createBranch";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createNewTag";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "checkoutNewBranchStartingFrom";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "checkout";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "deleteBranch";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "deleteTag";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "deleteRemoteTag";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "deleteRemoteBranch";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "deleteRemoteBranches";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
            case 36: 
            case 37: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "rebase";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "rebaseOnCurrent";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "renameBranch";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "loadTotalDiff";
                break;
            }
            case 48: {
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "updateInfo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 48 -> new IllegalStateException(string);
        };
    }
}

