/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import git4idea.actions.GitCheckoutAction;
import git4idea.actions.GitSingleCommitActionGroup;
import git4idea.i18n.GitBundle;
import git4idea.log.GitRefManager;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J3\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\u0011J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0015"}, d2={"Lgit4idea/actions/GitCheckoutActionGroup;", "Lgit4idea/actions/GitSingleCommitActionGroup;", "()V", "getCheckoutRevisionAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "commit", "Lcom/intellij/vcs/log/CommitId;", "useShortText", "", "getChildren", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "project", "Lcom/intellij/openapi/project/Project;", "repository", "Lgit4idea/repo/GitRepository;", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;Lcom/intellij/openapi/project/Project;Lgit4idea/repo/GitRepository;Lcom/intellij/vcs/log/CommitId;)[Lcom/intellij/openapi/actionSystem/AnAction;", "getRefNames", "", "", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitCheckoutActionGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitCheckoutActionGroup.kt\ngit4idea/actions/GitCheckoutActionGroup\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,78:1\n1#2:79\n857#3,2:80\n1549#3:82\n1620#3,3:83\n*S KotlinDebug\n*F\n+ 1 GitCheckoutActionGroup.kt\ngit4idea/actions/GitCheckoutActionGroup\n*L\n48#1:80,2\n52#1:82\n52#1:83,3\n*E\n"})
public final class GitCheckoutActionGroup
extends GitSingleCommitActionGroup {
    public GitCheckoutActionGroup() {
        String string = GitBundle.message("git.log.action.checkout.group", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        super(string, false);
    }

    @Override
    @NotNull
    public AnAction[] getChildren(@NotNull AnActionEvent e, @NotNull Project project, @NotNull GitRepository repository, @NotNull CommitId commit) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
        List<String> refNames = this.getRefNames(e, repository);
        ArrayList<GitCheckoutAction> actions2 = new ArrayList<GitCheckoutAction>();
        for (String refName : refNames) {
            actions2.add(new GitCheckoutAction(project, repository, refName, refName));
        }
        boolean hasMultipleActions = !((Collection)actions2).isEmpty();
        actions2.add((GitCheckoutAction)this.getCheckoutRevisionAction(commit, hasMultipleActions));
        DefaultActionGroup mainGroup = new DefaultActionGroup(GitBundle.message("git.log.action.checkout.group", new Object[0]), (List)actions2);
        mainGroup.setPopup(hasMultipleActions);
        AnAction[] anActionArray = new AnAction[]{mainGroup};
        return anActionArray;
    }

    private final AnAction getCheckoutRevisionAction(CommitId commit, boolean useShortText) {
        String string;
        String string2 = commit.getHash().toShortString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toShortString(...)");
        String hashString = string2;
        if (useShortText) {
            var6_4 = new Object[]{hashString};
            string = GitBundle.message("git.log.action.checkout.revision.short.text", var6_4);
        } else {
            var6_4 = new Object[]{hashString};
            string = GitBundle.message("git.log.action.checkout.revision.full.text", var6_4);
        }
        String string3 = string;
        Intrinsics.checkNotNull((Object)string3);
        String checkoutRevisionText = string3;
        String it = string3 = ActionUtil.wrap((String)"Git.CheckoutRevision");
        boolean bl = false;
        it.getTemplatePresentation().setText(checkoutRevisionText);
        return string3;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getRefNames(AnActionEvent e, GitRepository repository) {
        void $this$mapTo$iv$iv;
        void destination$iv;
        void $this$filterTo$iv;
        List list2 = (List)e.getData(VcsLogDataKeys.VCS_LOG_REFS);
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        List refs = list2;
        Iterable iterable = refs;
        Collection collection = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv : $this$filterTo$iv) {
            VcsRef it = (VcsRef)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getType(), (Object)GitRefManager.LOCAL_BRANCH)) continue;
            destination$iv.add(element$iv);
        }
        List localBranches2 = (List)destination$iv;
        Object object = (VcsLogData)e.getData(VcsLogInternalDataKeys.LOG_DATA);
        if (object != null && (object = object.getLogProviders()) != null && (object = (VcsLogProvider)object.get(repository.getRoot())) != null) {
            Object provider = object;
            boolean bl = false;
            ContainerUtil.sort((List)localBranches2, (Comparator)provider.getReferenceManager().getLabelsOrderComparator());
        }
        Iterable $this$map$iv = localBranches2;
        boolean $i$f$map = false;
        Iterable iterable2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VcsRef vcsRef = (VcsRef)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getName());
        }
        List refNames = (List)destination$iv$iv;
        String string = repository.getCurrentBranchName();
        if (string == null) {
            return refNames;
        }
        String currentBranchName = string;
        return CollectionsKt.minus((Iterable)refNames, (Object)currentBranchName);
    }
}

