/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.actions.styling;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\rB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u001a\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\f\u0010\u000b\u001a\u00020\u0005*\u00020\fH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/intellij/plugins/markdown/ui/actions/styling/SelectionUtil;", "", "()V", "obtainCaretSnapshots", "", "Lorg/intellij/plugins/markdown/ui/actions/styling/SelectionUtil$CaretSnapshot;", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "obtainPrimaryCaretSnapshot", "toSnapshot", "Lcom/intellij/openapi/editor/Caret;", "CaretSnapshot", "intellij.markdown"})
@SourceDebugExtension(value={"SMAP\nSelectionUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SelectionUtil.kt\norg/intellij/plugins/markdown/ui/actions/styling/SelectionUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,52:1\n1549#2:53\n1620#2,3:54\n*S KotlinDebug\n*F\n+ 1 SelectionUtil.kt\norg/intellij/plugins/markdown/ui/actions/styling/SelectionUtil\n*L\n32#1:53\n32#1:54,3\n*E\n"})
public final class SelectionUtil {
    @NotNull
    public static final SelectionUtil INSTANCE = new SelectionUtil();

    private SelectionUtil() {
    }

    @JvmStatic
    @RequiresBackgroundThread
    @Nullable
    public static final Collection<CaretSnapshot> obtainCaretSnapshots(@NotNull AnAction action, @NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        return (Collection)event.getUpdateSession().compute((Object)action, "obtainCaretSnapshot", ActionUpdateThread.EDT, () -> SelectionUtil.obtainCaretSnapshots$lambda$1(event));
    }

    @JvmStatic
    @RequiresBackgroundThread
    @Nullable
    public static final CaretSnapshot obtainPrimaryCaretSnapshot(@NotNull AnAction action, @NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        return (CaretSnapshot)event.getUpdateSession().compute((Object)action, "obtainPrimaryCaretSnapshot", ActionUpdateThread.EDT, () -> SelectionUtil.obtainPrimaryCaretSnapshot$lambda$2(event));
    }

    private final CaretSnapshot toSnapshot(Caret $this$toSnapshot) {
        return new CaretSnapshot($this$toSnapshot.getOffset(), $this$toSnapshot.getSelectionStart(), $this$toSnapshot.getSelectionEnd());
    }

    /*
     * WARNING - void declaration
     */
    private static final List obtainCaretSnapshots$lambda$1(AnActionEvent $event) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$event, (String)"$event");
        Editor editor2 = (Editor)$event.getData(CommonDataKeys.EDITOR);
        if (editor2 == null) {
            return null;
        }
        Editor editor3 = editor2;
        List list2 = editor3.getCaretModel().getAllCarets();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAllCarets(...)");
        Iterable $this$map$iv = list2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Caret caret = (Caret)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(INSTANCE.toSnapshot((Caret)it));
        }
        return (List)destination$iv$iv;
    }

    private static final CaretSnapshot obtainPrimaryCaretSnapshot$lambda$2(AnActionEvent $event) {
        Intrinsics.checkNotNullParameter((Object)$event, (String)"$event");
        Editor editor2 = (Editor)$event.getData(CommonDataKeys.EDITOR);
        if (editor2 == null) {
            return null;
        }
        Editor editor3 = editor2;
        Caret caret = editor3.getCaretModel().getPrimaryCaret();
        Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"getPrimaryCaret(...)");
        return INSTANCE.toSnapshot(caret);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u0018"}, d2={"Lorg/intellij/plugins/markdown/ui/actions/styling/SelectionUtil$CaretSnapshot;", "", "offset", "", "selectionStart", "selectionEnd", "(III)V", "hasSelection", "", "getHasSelection", "()Z", "getOffset", "()I", "getSelectionEnd", "getSelectionStart", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "toString", "", "intellij.markdown"})
    public static final class CaretSnapshot {
        private final int offset;
        private final int selectionStart;
        private final int selectionEnd;

        public CaretSnapshot(int offset, int selectionStart, int selectionEnd) {
            this.offset = offset;
            this.selectionStart = selectionStart;
            this.selectionEnd = selectionEnd;
        }

        public final int getOffset() {
            return this.offset;
        }

        public final int getSelectionStart() {
            return this.selectionStart;
        }

        public final int getSelectionEnd() {
            return this.selectionEnd;
        }

        public final boolean getHasSelection() {
            return Math.abs(this.selectionEnd - this.selectionStart) > 0;
        }

        public final int component1() {
            return this.offset;
        }

        public final int component2() {
            return this.selectionStart;
        }

        public final int component3() {
            return this.selectionEnd;
        }

        @NotNull
        public final CaretSnapshot copy(int offset, int selectionStart, int selectionEnd) {
            return new CaretSnapshot(offset, selectionStart, selectionEnd);
        }

        public static /* synthetic */ CaretSnapshot copy$default(CaretSnapshot caretSnapshot, int n, int n2, int n3, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = caretSnapshot.offset;
            }
            if ((n4 & 2) != 0) {
                n2 = caretSnapshot.selectionStart;
            }
            if ((n4 & 4) != 0) {
                n3 = caretSnapshot.selectionEnd;
            }
            return caretSnapshot.copy(n, n2, n3);
        }

        @NotNull
        public String toString() {
            return "CaretSnapshot(offset=" + this.offset + ", selectionStart=" + this.selectionStart + ", selectionEnd=" + this.selectionEnd + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.offset);
            result2 = result2 * 31 + Integer.hashCode(this.selectionStart);
            result2 = result2 * 31 + Integer.hashCode(this.selectionEnd);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CaretSnapshot)) {
                return false;
            }
            CaretSnapshot caretSnapshot = (CaretSnapshot)other;
            if (this.offset != caretSnapshot.offset) {
                return false;
            }
            if (this.selectionStart != caretSnapshot.selectionStart) {
                return false;
            }
            return this.selectionEnd == caretSnapshot.selectionEnd;
        }
    }
}

