/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.psi;

import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.PsiFileFactoryImpl;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.intellij.plugins.markdown.lang.MarkdownLanguage;
import org.intellij.plugins.markdown.lang.psi.MarkdownPsiElement;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownCodeFence;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownFile;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownHeader;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownInlineLink;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownLinkDefinition;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownLinkDestination;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownList;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownParagraph;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTable;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableCell;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableRow;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableSeparatorRow;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MarkdownPsiElementFactory {
    private MarkdownPsiElementFactory() {
    }

    @NotNull
    public static MarkdownFile createFile(@NotNull Project project, @NotNull String text2) {
        if (project == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(0);
        }
        if (text2 == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(1);
        }
        LightVirtualFile virtualFile = new LightVirtualFile("temp.rb", (Language)MarkdownLanguage.INSTANCE, (CharSequence)text2);
        PsiFile psiFile = ((PsiFileFactoryImpl)PsiFileFactory.getInstance((Project)project)).trySetupPsiForFile(virtualFile, (Language)MarkdownLanguage.INSTANCE, true, true);
        if (!(psiFile instanceof MarkdownFile)) {
            throw new RuntimeException("Cannot create a new markdown file. Text: " + text2);
        }
        MarkdownFile markdownFile = (MarkdownFile)psiFile;
        if (markdownFile == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(2);
        }
        return markdownFile;
    }

    @NotNull
    public static MarkdownCodeFence createCodeFence(@NotNull Project project, @Nullable String language, @NotNull String text2) {
        if (project == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(3);
        }
        if (text2 == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(4);
        }
        return MarkdownPsiElementFactory.createCodeFence(project, language, text2, null);
    }

    @NotNull
    public static MarkdownCodeFence createCodeFence(@NotNull Project project, @Nullable String language, @NotNull String text2, @Nullable String indent) {
        if (project == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(5);
        }
        if (text2 == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(6);
        }
        String content2 = "```" + StringUtil.notNullize((String)language) + "\n" + text2 + "\n" + StringUtil.notNullize((String)indent) + "```";
        MarkdownFile file = MarkdownPsiElementFactory.createFile(project, content2);
        MarkdownCodeFence markdownCodeFence = (MarkdownCodeFence)file.getFirstChild();
        if (markdownCodeFence == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(7);
        }
        return markdownCodeFence;
    }

    @NotNull
    public static MarkdownPsiElement createTextElement(@NotNull Project project, @NotNull String text2) {
        if (project == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(8);
        }
        if (text2 == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(9);
        }
        MarkdownPsiElement markdownPsiElement = (MarkdownPsiElement)MarkdownPsiElementFactory.createFile(project, text2).getFirstChild();
        if (markdownPsiElement == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(10);
        }
        return markdownPsiElement;
    }

    @NotNull
    public static MarkdownHeader createSetext(@NotNull Project project, @NotNull String text2, @NotNull String symbol, int count) {
        if (project == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(11);
        }
        if (text2 == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(12);
        }
        if (symbol == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(13);
        }
        MarkdownHeader markdownHeader = (MarkdownHeader)MarkdownPsiElementFactory.createFile(project, text2 + "\n" + StringUtil.repeat((String)symbol, (int)count)).getFirstChild();
        if (markdownHeader == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(14);
        }
        return markdownHeader;
    }

    @NotNull
    public static MarkdownHeader createHeader(@NotNull Project project, @NotNull String text2, int level) {
        if (project == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(15);
        }
        if (text2 == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(16);
        }
        MarkdownHeader markdownHeader = (MarkdownHeader)MarkdownPsiElementFactory.createFile(project, StringUtil.repeat((String)"#", (int)level) + " " + text2).getFirstChild();
        if (markdownHeader == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(17);
        }
        return markdownHeader;
    }

    @NotNull
    public static MarkdownHeader createHeader(@NotNull Project project, @NotNull String text2) {
        if (project == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(18);
        }
        if (text2 == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(19);
        }
        MarkdownHeader markdownHeader = (MarkdownHeader)MarkdownPsiElementFactory.createFile(project, text2).getFirstChild();
        if (markdownHeader == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(20);
        }
        return markdownHeader;
    }

    @NotNull
    public static PsiElement createNewLine(@NotNull Project project) {
        if (project == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(21);
        }
        PsiElement psiElement = MarkdownPsiElementFactory.createFile(project, "\n").getFirstChild();
        if (psiElement == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(22);
        }
        return psiElement;
    }

    @NotNull
    public static MarkdownFile createNewLines(@NotNull Project project, int num) {
        if (project == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(23);
        }
        return MarkdownPsiElementFactory.createFile(project, StringUtil.repeat((String)"\n", (int)num));
    }

    @NotNull
    public static Pair<PsiElement, PsiElement> createLinkDeclarationAndReference(@NotNull Project project, @NotNull String url, @NotNull String text2, @Nullable String title, @NotNull String reference) {
        if (project == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(24);
        }
        if (url == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(25);
        }
        if (text2 == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(26);
        }
        if (reference == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(27);
        }
        text2 = (String)ObjectUtils.notNull((Object)text2, (Object)reference);
        title = title == null ? "" : " " + (String)title;
        String linkReference = "[" + text2 + "][" + reference + "]\n\n[" + reference + "]: " + url + (String)title;
        MarkdownFile linkReferenceElement = MarkdownPsiElementFactory.createFile(project, linkReference);
        PsiElement ref = linkReferenceElement.getFirstChild();
        assert (ref instanceof MarkdownParagraph);
        PsiElement declaration = linkReferenceElement.getLastChild();
        assert (declaration instanceof MarkdownParagraph || declaration instanceof MarkdownLinkDefinition);
        Pair pair = Pair.create((Object)ref, (Object)declaration);
        if (pair == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(28);
        }
        return pair;
    }

    @ApiStatus.Experimental
    @NotNull
    public static MarkdownTableSeparatorRow createTableSeparatorRow(@NotNull Project project, @NotNull String text2) {
        int columnsCount2;
        if (project == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(29);
        }
        if (text2 == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(30);
        }
        if ((columnsCount2 = StringUtil.countChars((CharSequence)text2, (char)'|') - 1) < 1) {
            throw new IllegalArgumentException("Passed separator text should be valid and contain at least one column.\n Text passed: [" + text2 + "]");
        }
        String markdownFile = "|" + "    |".repeat(columnsCount2) + "\n" + text2;
        MarkdownFile file = MarkdownPsiElementFactory.createFile(project, markdownFile);
        MarkdownTable table = (MarkdownTable)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(0), MarkdownTable.class);
        if (table == null) {
            String psi = DebugUtil.psiToString((PsiElement)file, (boolean)true, (boolean)true);
            throw new IllegalStateException("Failed to find table. PSI:\n" + psi);
        }
        MarkdownTableSeparatorRow separatorRowElement = (MarkdownTableSeparatorRow)PsiTreeUtil.getChildOfType((PsiElement)table, MarkdownTableSeparatorRow.class);
        if (separatorRowElement == null) {
            String psi = DebugUtil.psiToString((PsiElement)file, (boolean)true, (boolean)true);
            throw new IllegalStateException("Failed to find separator row. PSI:\n" + psi);
        }
        MarkdownTableSeparatorRow markdownTableSeparatorRow = separatorRowElement;
        if (markdownTableSeparatorRow == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(31);
        }
        return markdownTableSeparatorRow;
    }

    @ApiStatus.Experimental
    @NotNull
    public static Pair<MarkdownTableCell, PsiElement> createTableCell(@NotNull Project project, @NotNull String text2) {
        if (project == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(32);
        }
        if (text2 == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(33);
        }
        String content2 = "|" + text2 + "|\n|----|";
        MarkdownFile file = MarkdownPsiElementFactory.createFile(project, content2);
        PsiElement contentElement = file.findElementAt(1);
        MarkdownTableCell cell = Objects.requireNonNull((MarkdownTableCell)PsiTreeUtil.getParentOfType((PsiElement)contentElement, MarkdownTableCell.class));
        PsiElement separator = cell.getNextSibling();
        return new Pair((Object)cell, (Object)separator);
    }

    @NotNull
    private static MarkdownTable findTable(@NotNull PsiElement element2) {
        if (element2 == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(34);
        }
        MarkdownTable markdownTable = Objects.requireNonNull((MarkdownTable)PsiTreeUtil.getParentOfType((PsiElement)element2, MarkdownTable.class));
        if (markdownTable == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(35);
        }
        return markdownTable;
    }

    @ApiStatus.Experimental
    @NotNull
    public static PsiElement createTableSeparator(@NotNull Project project) {
        if (project == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(36);
        }
        String content2 = "|    |\n|----|";
        MarkdownFile file = MarkdownPsiElementFactory.createFile(project, "|    |\n|----|");
        PsiElement psiElement = Objects.requireNonNull(file.findElementAt(0));
        if (psiElement == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(37);
        }
        return psiElement;
    }

    @ApiStatus.Experimental
    @NotNull
    public static MarkdownTableRow createTableRow(@NotNull Project project, @NotNull Collection<String> contents2) {
        int count;
        if (project == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(38);
        }
        if (contents2 == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(39);
        }
        StringBuilder builder = new StringBuilder();
        builder.append('|');
        for (count = 0; count < contents2.size(); ++count) {
            builder.append("     |");
        }
        builder.append('\n');
        builder.append('|');
        for (count = 0; count < contents2.size(); ++count) {
            builder.append("-----|");
        }
        builder.append('\n');
        builder.append('|');
        for (String content2 : contents2) {
            builder.append(content2);
            builder.append('|');
        }
        builder.append('\n');
        builder.append('|');
        for (int count2 = 0; count2 < contents2.size(); ++count2) {
            builder.append("     |");
        }
        builder.append('\n');
        MarkdownFile file = MarkdownPsiElementFactory.createFile(project, builder.toString());
        PsiElement element2 = Objects.requireNonNull(file.findElementAt(0));
        PsiElement row = Objects.requireNonNull(MarkdownPsiElementFactory.findTable(element2).getLastChild().getPrevSibling().getPrevSibling());
        if (row instanceof MarkdownTableRow) {
            MarkdownTableRow markdownTableRow = (MarkdownTableRow)row;
            if (markdownTableRow == null) {
                MarkdownPsiElementFactory.$$$reportNull$$$0(40);
            }
            return markdownTableRow;
        }
        throw new IllegalStateException("Failed to find row element");
    }

    @ApiStatus.Experimental
    @NotNull
    public static MarkdownTableRow createTableEmptyRow(@NotNull Project project, @NotNull Collection<Integer> widths) {
        if (project == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(41);
        }
        if (widths == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(42);
        }
        List contents2 = ContainerUtil.map(widths, width -> " ".repeat((int)width));
        return MarkdownPsiElementFactory.createTableRow(project, contents2);
    }

    @ApiStatus.Experimental
    @NotNull
    public static PsiElement createBlockQuoteArrow(@NotNull Project project) {
        if (project == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(43);
        }
        String contents2 = "> ";
        MarkdownFile file = MarkdownPsiElementFactory.createFile(project, "> ");
        PsiElement psiElement = Objects.requireNonNull(file.findElementAt(1));
        if (psiElement == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(44);
        }
        return psiElement;
    }

    @ApiStatus.Experimental
    @NotNull
    public static MarkdownHeader createHeader(@NotNull Project project, int level, @NotNull String text2) {
        if (project == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(45);
        }
        if (text2 == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(46);
        }
        String contents2 = StringUtil.repeat((String)"#", (int)level) + " " + text2;
        MarkdownFile file = MarkdownPsiElementFactory.createFile(project, contents2);
        PsiElement element2 = Objects.requireNonNull(file.getFirstChild());
        assert (element2 instanceof MarkdownHeader);
        MarkdownHeader markdownHeader = (MarkdownHeader)element2;
        if (markdownHeader == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(47);
        }
        return markdownHeader;
    }

    @ApiStatus.Experimental
    @NotNull
    public static PsiElement createListMarker(@NotNull Project project, @NotNull String markerText) {
        if (project == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(48);
        }
        if (markerText == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(49);
        }
        String contents2 = markerText + " list item";
        MarkdownFile file = MarkdownPsiElementFactory.createFile(project, contents2);
        PsiElement psiElement = Objects.requireNonNull(file.getFirstChild().getFirstChild().getFirstChild());
        if (psiElement == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(50);
        }
        return psiElement;
    }

    @ApiStatus.Experimental
    @NotNull
    public static Pair<PsiElement, PsiElement> createListMarkerWithCheckbox(@NotNull Project project, @NotNull String markerText, boolean checked) {
        if (project == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(51);
        }
        if (markerText == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(52);
        }
        Object text2 = markerText;
        text2 = checked ? (String)text2 + " [x]" : (String)text2 + " [ ]";
        PsiElement marker2 = MarkdownPsiElementFactory.createListMarker(project, (String)text2);
        PsiElement checkbox = Objects.requireNonNull(marker2.getNextSibling());
        return new Pair((Object)marker2, (Object)checkbox);
    }

    @ApiStatus.Experimental
    @NotNull
    public static MarkdownList createEmptyList(@NotNull Project project, boolean ordered) {
        if (project == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(53);
        }
        String contents2 = ordered ? "1) list item" : "* list item";
        MarkdownFile file = MarkdownPsiElementFactory.createFile(project, contents2);
        PsiElement list2 = Objects.requireNonNull(file.getFirstChild());
        assert (list2 instanceof MarkdownList);
        for (PsiElement child2 : list2.getChildren()) {
            child2.delete();
        }
        MarkdownList markdownList = (MarkdownList)list2;
        if (markdownList == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(54);
        }
        return markdownList;
    }

    @ApiStatus.Experimental
    @NotNull
    public static MarkdownList createList(@NotNull Project project, @NotNull @NotNull Iterable<@NotNull String> items, @NotNull Function<? super Integer, String> markerSupplier) {
        if (project == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(55);
        }
        if (items == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(56);
        }
        if (markerSupplier == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(57);
        }
        StringBuilder builder = new StringBuilder();
        int itemIndex = 0;
        for (String item : items) {
            builder.append(markerSupplier.apply((Integer)itemIndex));
            builder.append(" ");
            builder.append(item);
            builder.append("\n");
            ++itemIndex;
        }
        MarkdownFile file = MarkdownPsiElementFactory.createFile(project, builder.toString());
        PsiElement list2 = Objects.requireNonNull(file.getFirstChild());
        assert (list2 instanceof MarkdownList);
        MarkdownList markdownList = (MarkdownList)list2;
        if (markdownList == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(58);
        }
        return markdownList;
    }

    @ApiStatus.Experimental
    @NotNull
    public static MarkdownLinkDestination createLinkDestination(@NotNull Project project, @NotNull String link) {
        MarkdownLinkDestination destination;
        String content2;
        MarkdownFile file;
        PsiElement element2;
        if (project == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(59);
        }
        if (link == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(60);
        }
        if (!((element2 = Objects.requireNonNull((file = MarkdownPsiElementFactory.createFile(project, content2 = "[](" + link + ")")).getFirstChild().getFirstChild())) instanceof MarkdownInlineLink)) {
            String psi = DebugUtil.psiToString((PsiElement)file, (boolean)true, (boolean)true);
            String message = "Expected a MarkdownInlineLink but was " + element2 + ". PSI was:\n" + psi;
            throw new IllegalStateException(message);
        }
        MarkdownLinkDestination markdownLinkDestination = destination = Objects.requireNonNull(((MarkdownInlineLink)element2).getLinkDestination(), () -> "Failed to get link destination. PSI was:\n" + DebugUtil.psiToString((PsiElement)file, (boolean)true, (boolean)true));
        if (markdownLinkDestination == null) {
            MarkdownPsiElementFactory.$$$reportNull$$$0(61);
        }
        return markdownLinkDestination;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 7, 10, 14, 17, 20, 22, 28, 31, 35, 37, 40, 44, 47, 50, 54, 58, 61 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 9: 
            case 12: 
            case 16: 
            case 19: 
            case 26: 
            case 30: 
            case 33: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: 
            case 7: 
            case 10: 
            case 14: 
            case 17: 
            case 20: 
            case 22: 
            case 28: 
            case 31: 
            case 35: 
            case 37: 
            case 40: 
            case 44: 
            case 47: 
            case 50: 
            case 54: 
            case 58: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/markdown/lang/psi/MarkdownPsiElementFactory";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contents";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "widths";
                break;
            }
            case 49: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markerText";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markerSupplier";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "link";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/markdown/lang/psi/MarkdownPsiElementFactory";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createFile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createCodeFence";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createTextElement";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createSetext";
                break;
            }
            case 17: 
            case 20: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "createHeader";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewLine";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "createLinkDeclarationAndReference";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "createTableSeparatorRow";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "findTable";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "createTableSeparator";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "createTableRow";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "createBlockQuoteArrow";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "createListMarker";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmptyList";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "createList";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "createLinkDestination";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 2: 
            case 7: 
            case 10: 
            case 14: 
            case 17: 
            case 20: 
            case 22: 
            case 28: 
            case 31: 
            case 35: 
            case 37: 
            case 40: 
            case 44: 
            case 47: 
            case 50: 
            case 54: 
            case 58: 
            case 61: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createCodeFence";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createTextElement";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createSetext";
                break;
            }
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "createHeader";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createNewLine";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createNewLines";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createLinkDeclarationAndReference";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createTableSeparatorRow";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createTableCell";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "findTable";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "createTableSeparator";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "createTableRow";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "createTableEmptyRow";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "createBlockQuoteArrow";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "createListMarker";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "createListMarkerWithCheckbox";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "createEmptyList";
                break;
            }
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "createList";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "createLinkDestination";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 7, 10, 14, 17, 20, 22, 28, 31, 35, 37, 40, 44, 47, 50, 54, 58, 61 -> new IllegalStateException(string);
        };
    }
}

