/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang;

import com.intellij.codeInsight.generation.CommenterDataHolder;
import com.intellij.codeInsight.generation.SelfManagingCommenter;
import com.intellij.codeInsight.generation.SelfManagingCommenterUtil;
import com.intellij.lang.Commenter;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.util.DocumentUtil;
import com.intellij.util.text.CharArrayUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\u0018\u0000 32\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u00013B\u0005\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J(\u0010\u000e\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J(\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\rH\u0002J(\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J*\u0010\u0016\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J*\u0010\u001b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001e\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020 H\u0002J\n\u0010!\u001a\u0004\u0018\u00010\u0010H\u0016J\"\u0010!\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J*\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\n\u0010$\u001a\u0004\u0018\u00010\u0010H\u0016J\"\u0010$\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J \u0010%\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\n\u0010&\u001a\u0004\u0018\u00010\u0010H\u0016J\n\u0010'\u001a\u0004\u0018\u00010\u0010H\u0016J\b\u0010(\u001a\u00020\u0010H\u0016J \u0010)\u001a\u00020 2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020\b2\u0006\u0010+\u001a\u00020\bH\u0002J*\u0010,\u001a\u0004\u0018\u00010#2\u0006\u0010*\u001a\u00020\b2\u0006\u0010+\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J(\u0010-\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0018\u0010.\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010/\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J(\u00100\u001a\u00020\u00062\u0006\u0010*\u001a\u00020\b2\u0006\u0010+\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J(\u00101\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0018\u00102\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020 H\u0002\u00a8\u00064"}, d2={"Lorg/intellij/plugins/markdown/lang/MarkdownCommenter;", "Lcom/intellij/lang/Commenter;", "Lcom/intellij/codeInsight/generation/SelfManagingCommenter;", "Lcom/intellij/codeInsight/generation/CommenterDataHolder;", "()V", "actuallyCommentLine", "", "line", "", "offset", "document", "Lcom/intellij/openapi/editor/Document;", "insertEmptyLine", "", "actuallyReplace", "from", "", "to", "actuallyUncommentLine", "removeEmptyLine", "commentLine", "data", "createBlockCommentingState", "selectionStart", "selectionEnd", "file", "Lcom/intellij/psi/PsiFile;", "createLineCommentingState", "startLine", "endLine", "escape", "range", "Lcom/intellij/openapi/editor/RangeMarker;", "getBlockCommentPrefix", "getBlockCommentRange", "Lcom/intellij/openapi/util/TextRange;", "getBlockCommentSuffix", "getCommentPrefix", "getCommentedBlockCommentPrefix", "getCommentedBlockCommentSuffix", "getLineCommentPrefix", "getRangeMarker", "startOffset", "endOffset", "insertBlockComment", "isLineCommented", "shouldInsertEmptyLine", "shouldRemoveEmptyLine", "uncommentBlockComment", "uncommentLine", "unescape", "Companion", "intellij.markdown"})
public final class MarkdownCommenter
implements Commenter,
SelfManagingCommenter<CommenterDataHolder> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String openRoundBracket = "(";
    @NotNull
    private static final String closeRoundBracket = ")";
    @NotNull
    private static final String escapedOpenBracket = "&#40;";
    @NotNull
    private static final String escapedCloseBracket = "&#41;";
    @NotNull
    private static final String commentPrefix = "[//]: # (";
    @NotNull
    private static final String commentSuffix = ")";

    @NotNull
    public String getLineCommentPrefix() {
        return commentPrefix;
    }

    @NotNull
    public String getCommentPrefix(int line, @NotNull Document document, @NotNull CommenterDataHolder data) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return this.getLineCommentPrefix();
    }

    @Nullable
    public String getBlockCommentPrefix() {
        return null;
    }

    @Nullable
    public String getBlockCommentSuffix() {
        return null;
    }

    @Nullable
    public String getCommentedBlockCommentPrefix() {
        return null;
    }

    @Nullable
    public String getCommentedBlockCommentSuffix() {
        return null;
    }

    @Nullable
    public String getBlockCommentPrefix(int selectionStart, @NotNull Document document, @NotNull CommenterDataHolder data) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return null;
    }

    @Nullable
    public String getBlockCommentSuffix(int selectionEnd, @NotNull Document document, @NotNull CommenterDataHolder data) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return null;
    }

    public boolean isLineCommented(int line, int offset, @NotNull Document document, @NotNull CommenterDataHolder data) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return CharArrayUtil.regionMatches((CharSequence)document.getCharsSequence(), (int)offset, (CharSequence)commentPrefix) && CharArrayUtil.regionMatches((CharSequence)document.getCharsSequence(), (int)(document.getLineEndOffset(line) - 1), (CharSequence)")");
    }

    @Nullable
    public TextRange insertBlockComment(int startOffset, int endOffset, @NotNull Document document, @NotNull CommenterDataHolder data) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return null;
    }

    public void uncommentBlockComment(int startOffset, int endOffset, @NotNull Document document, @NotNull CommenterDataHolder data) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
    }

    public void commentLine(int line, int offset, @NotNull Document document, @NotNull CommenterDataHolder data) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.actuallyCommentLine(line, offset, document, this.shouldInsertEmptyLine(line, document));
    }

    public void uncommentLine(int line, int offset, @NotNull Document document, @NotNull CommenterDataHolder data) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.actuallyUncommentLine(line, offset, document, this.shouldRemoveEmptyLine(line, document));
    }

    @Nullable
    public CommenterDataHolder createLineCommentingState(int startLine, int endLine, @NotNull Document document, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return null;
    }

    @Nullable
    public CommenterDataHolder createBlockCommentingState(int selectionStart, int selectionEnd, @NotNull Document document, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return null;
    }

    @Nullable
    public TextRange getBlockCommentRange(int selectionStart, int selectionEnd, @NotNull Document document, @NotNull CommenterDataHolder data) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldInsertEmptyLine(int line, Document document) {
        if (line == 0) return false;
        if (DocumentUtil.isLineEmpty((Document)document, (int)(line - 1))) return false;
        int n = document.getLineStartOffset(line - 1);
        CommenterDataHolder commenterDataHolder = SelfManagingCommenter.EMPTY_STATE;
        Intrinsics.checkNotNullExpressionValue((Object)commenterDataHolder, (String)"EMPTY_STATE");
        if (this.isLineCommented(line - 1, n, document, commenterDataHolder)) return false;
        return true;
    }

    private final boolean shouldRemoveEmptyLine(int line, Document document) {
        return line != 0 && DocumentUtil.isLineEmpty((Document)document, (int)(line - 1)) && document.isLineModified(line - 1);
    }

    private final void actuallyCommentLine(int line, int offset, Document document, boolean insertEmptyLine) {
        int end = document.getLineEndOffset(line);
        RangeMarker marker2 = this.getRangeMarker(document, offset, end);
        this.escape(document, marker2);
        String prefix = insertEmptyLine ? "\n[//]: # (" : commentPrefix;
        SelfManagingCommenterUtil.insertBlockComment((int)marker2.getStartOffset(), (int)marker2.getEndOffset(), (Document)document, (String)prefix, (String)")");
        marker2.dispose();
    }

    private final void actuallyUncommentLine(int line, int offset, Document document, boolean removeEmptyLine) {
        int end = document.getLineEndOffset(line);
        TextRange textRange = SelfManagingCommenterUtil.getBlockCommentRange((int)offset, (int)end, (Document)document, (String)commentPrefix, (String)")");
        if (textRange == null) {
            return;
        }
        TextRange range = textRange;
        RangeMarker marker2 = removeEmptyLine ? this.getRangeMarker(document, document.getLineStartOffset(line - 1), range.getEndOffset()) : this.getRangeMarker(document, range.getStartOffset(), range.getEndOffset());
        String prefix = removeEmptyLine ? "\n[//]: # (" : commentPrefix;
        SelfManagingCommenterUtil.uncommentBlockComment((int)marker2.getStartOffset(), (int)marker2.getEndOffset(), (Document)document, (String)prefix, (String)")");
        this.unescape(document, marker2);
        marker2.dispose();
    }

    private final RangeMarker getRangeMarker(Document document, int startOffset, int endOffset) {
        RangeMarker rangeMarker;
        RangeMarker rangeMarker2 = document.createRangeMarker(startOffset, endOffset);
        Intrinsics.checkNotNullExpressionValue((Object)rangeMarker2, (String)"createRangeMarker(...)");
        RangeMarker $this$getRangeMarker_u24lambda_u240 = rangeMarker = rangeMarker2;
        boolean bl = false;
        $this$getRangeMarker_u24lambda_u240.setGreedyToLeft(true);
        $this$getRangeMarker_u24lambda_u240.setGreedyToRight(true);
        return rangeMarker;
    }

    private final void actuallyReplace(Document document, int offset, String from, String to) {
        if (CharArrayUtil.regionMatches((CharSequence)document.getCharsSequence(), (int)offset, (CharSequence)from)) {
            document.replaceString(offset, offset + from.length(), (CharSequence)to);
        }
    }

    private final void escape(Document document, RangeMarker range) {
        int end;
        int start = range.getStartOffset();
        if (start >= (end = range.getEndOffset())) {
            return;
        }
        int offset = end;
        if (start <= offset) {
            while (true) {
                this.actuallyReplace(document, offset, ")", escapedCloseBracket);
                this.actuallyReplace(document, offset, openRoundBracket, escapedOpenBracket);
                if (offset == start) break;
                --offset;
            }
        }
    }

    private final void unescape(Document document, RangeMarker range) {
        int offset = range.getEndOffset();
        int n = range.getStartOffset();
        if (n <= offset) {
            while (true) {
                this.actuallyReplace(document, offset, escapedCloseBracket, ")");
                this.actuallyReplace(document, offset, escapedOpenBracket, openRoundBracket);
                if (offset == n) break;
                --offset;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/intellij/plugins/markdown/lang/MarkdownCommenter$Companion;", "", "()V", "closeRoundBracket", "", "commentPrefix", "commentSuffix", "escapedCloseBracket", "escapedOpenBracket", "openRoundBracket", "intellij.markdown"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

