/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.images.editor;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.images.editor.ImageUtils;
import org.intellij.plugins.markdown.images.editor.MarkdownImageData;
import org.intellij.plugins.markdown.lang.psi.MarkdownPsiElementFactory;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ*\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\f\u00a8\u0006\u000f"}, d2={"Lorg/intellij/plugins/markdown/images/editor/ImagePsiElementFactory;", "", "()V", "createHtmlBlockWithImage", "Lcom/intellij/psi/PsiElement;", "project", "Lcom/intellij/openapi/project/Project;", "imageData", "Lorg/intellij/plugins/markdown/images/editor/MarkdownImageData;", "createHtmlImageTag", "createImage", "description", "", "path", "title", "intellij.markdown.images"})
@ApiStatus.Internal
public final class ImagePsiElementFactory {
    @NotNull
    public static final ImagePsiElementFactory INSTANCE = new ImagePsiElementFactory();

    private ImagePsiElementFactory() {
    }

    @NotNull
    public final PsiElement createImage(@NotNull Project project, @Nullable String description, @NotNull String path, @Nullable String title) {
        String string;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String string2 = description;
        if (string2 == null) {
            string2 = "";
        }
        if ((string = title) == null) {
            string = "";
        }
        String text2 = ImageUtils.createMarkdownImageText(string2, path, string);
        PsiElement psiElement = MarkdownPsiElementFactory.createFile(project, text2).getFirstChild().getFirstChild();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getFirstChild(...)");
        return psiElement;
    }

    @NotNull
    public final PsiElement createHtmlBlockWithImage(@NotNull Project project, @NotNull MarkdownImageData imageData) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)imageData, (String)"imageData");
        String text2 = ImageUtils.createHtmlImageText(imageData);
        PsiElement psiElement = MarkdownPsiElementFactory.createFile(project, text2).getFirstChild();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getFirstChild(...)");
        return psiElement;
    }

    @NotNull
    public final PsiElement createHtmlImageTag(@NotNull Project project, @NotNull MarkdownImageData imageData) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)imageData, (String)"imageData");
        String text2 = ImageUtils.createHtmlImageText(imageData);
        PsiElement root = MarkdownPsiElementFactory.createFile(project, "Prefix text" + text2).getFirstChild();
        PsiElement psiElement = root.getFirstChild().getNextSibling();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getNextSibling(...)");
        return psiElement;
    }
}

