/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.extensions.jcef.commandRunner;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.impl.TrustedProjects;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001c\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a8\u0006\u000b"}, d2={"Lorg/intellij/plugins/markdown/extensions/jcef/commandRunner/TrustedProjectUtil;", "", "()V", "confirmProjectIsTrusted", "", "project", "Lcom/intellij/openapi/project/Project;", "executeIfTrusted", "block", "Lkotlin/Function0;", "", "intellij.markdown"})
public final class TrustedProjectUtil {
    @NotNull
    public static final TrustedProjectUtil INSTANCE = new TrustedProjectUtil();

    private TrustedProjectUtil() {
    }

    public final boolean executeIfTrusted(@NotNull Project project, @NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        if (TrustedProjects.isTrusted((Project)project) || this.confirmProjectIsTrusted(project)) {
            block.invoke();
            return true;
        }
        return false;
    }

    private final boolean confirmProjectIsTrusted(Project project) {
        String string = IdeBundle.message((String)"untrusted.project.general.dialog.title", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = MarkdownBundle.message("markdown.untrusted.project.dialog.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        String string3 = IdeBundle.message((String)"untrusted.project.dialog.trust.button", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        String string4 = IdeBundle.message((String)"untrusted.project.dialog.distrust.button", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        return TrustedProjects.confirmLoadingUntrustedProject((Project)project, (String)string, (String)string2, (String)string3, (String)string4);
    }
}

