/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.tables.ui.presentation;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hints.presentation.BasePresentation;
import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.PresentationFactory;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.impl.ToolbarUtils;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.refactoring.suggested.UtilsKt;
import com.intellij.ui.LightweightHint;
import com.intellij.util.ui.GraphicsUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.intellij.plugins.markdown.editor.tables.TableFormattingUtils;
import org.intellij.plugins.markdown.editor.tables.TableUtils;
import org.intellij.plugins.markdown.editor.tables.actions.TableActionKeys;
import org.intellij.plugins.markdown.editor.tables.ui.presentation.GraphicsUtils;
import org.intellij.plugins.markdown.editor.tables.ui.presentation.PresentationWithCustomCursor;
import org.intellij.plugins.markdown.editor.tables.ui.presentation.TableInlayProperties;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTable;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableRow;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableSeparatorRow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0000\u0018\u0000 82\u00020\u0001:\u0003789B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ(\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002J\u0010\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u0011H\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\rH\u0002J\u0010\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020#H\u0002J\u0018\u0010$\u001a\u00020\u00172\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001fH\u0002J\u0018\u0010(\u001a\u00020\u00172\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001fH\u0002J\u0010\u0010)\u001a\u00020\u00072\u0006\u0010*\u001a\u00020\u0005H\u0002J\u0018\u0010+\u001a\u00020\u00172\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001fH\u0016J\u0018\u0010,\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010-\u001a\u00020.H\u0016J\u0018\u0010/\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u00100\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u00101\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u00102\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u0011H\u0002J\b\u00103\u001a\u00020\u0007H\u0002J\b\u00104\u001a\u00020\u0017H\u0002J\b\u00105\u001a\u000206H\u0016R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000f\u00a8\u0006:"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/ui/presentation/VerticalBarPresentation;", "Lcom/intellij/codeInsight/hints/presentation/BasePresentation;", "editor", "Lcom/intellij/openapi/editor/Editor;", "row", "Lcom/intellij/psi/PsiElement;", "hover", "", "accent", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/psi/PsiElement;ZZ)V", "boundsState", "Lorg/intellij/plugins/markdown/editor/tables/ui/presentation/VerticalBarPresentation$BoundsState;", "height", "", "getHeight", "()I", "rowLocation", "Lorg/intellij/plugins/markdown/editor/tables/ui/presentation/VerticalBarPresentation$RowLocation;", "getRowLocation", "()Lorg/intellij/plugins/markdown/editor/tables/ui/presentation/VerticalBarPresentation$RowLocation;", "width", "getWidth", "actuallyPaintBar", "", "graphics", "Ljava/awt/Graphics2D;", "rect", "Ljava/awt/Rectangle;", "calculateBarRect", "location", "calculateToolbarPosition", "Ljava/awt/Point;", "componentHeight", "createAndShowHint", "toolbar", "Lcom/intellij/openapi/actionSystem/ActionToolbar;", "handleMouseLeftClick", "event", "Ljava/awt/event/MouseEvent;", "translated", "handleMouseLeftDoubleClick", "hasRowAfter", "element", "mouseClicked", "paint", "attributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "paintFirstCircles", "paintLastCircles", "paintOtherCircles", "paintRow", "shouldShowInlay", "showToolbar", "toString", "", "BoundsState", "Companion", "RowLocation", "intellij.markdown"})
@SourceDebugExtension(value={"SMAP\nVerticalBarPresentation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VerticalBarPresentation.kt\norg/intellij/plugins/markdown/editor/tables/ui/presentation/VerticalBarPresentation\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 actions.kt\ncom/intellij/openapi/command/ActionsKt\n*L\n1#1,265:1\n1#2:266\n7#3,6:267\n*S KotlinDebug\n*F\n+ 1 VerticalBarPresentation.kt\norg/intellij/plugins/markdown/editor/tables/ui/presentation/VerticalBarPresentation\n*L\n182#1:267,6\n*E\n"})
public final class VerticalBarPresentation
extends BasePresentation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Editor editor;
    @NotNull
    private final PsiElement row;
    private final boolean hover;
    private final boolean accent;
    @NotNull
    private BoundsState boundsState;
    public static final int barWidth = 6;
    @NotNull
    private static final BoundsState initialState = new BoundsState(0, 0);

    public VerticalBarPresentation(@NotNull Editor editor2, @NotNull PsiElement row, boolean hover, boolean accent) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        this.editor = editor2;
        this.row = row;
        this.hover = hover;
        this.accent = accent;
        this.boundsState = initialState;
        PsiDocumentManager.getInstance((Project)this.row.getProject()).performForCommittedDocument(this.editor.getDocument(), () -> VerticalBarPresentation._init_$lambda$0(this));
    }

    public /* synthetic */ VerticalBarPresentation(Editor editor2, PsiElement psiElement, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl2 = false;
        }
        this(editor2, psiElement, bl, bl2);
    }

    private final boolean shouldShowInlay() {
        if (!this.row.isValid() || this.editor.isDisposed()) {
            return false;
        }
        MarkdownTable markdownTable = TableUtils.findTable(this.row);
        if (markdownTable == null) {
            return false;
        }
        MarkdownTable table = markdownTable;
        return !TableFormattingUtils.INSTANCE.isSoftWrapping(table, this.editor);
    }

    public int getWidth() {
        return this.boundsState.getWidth();
    }

    public int getHeight() {
        return this.boundsState.getHeight();
    }

    private final RowLocation getRowLocation() {
        RowLocation rowLocation;
        PsiElement psiElement = this.row;
        MarkdownTableRow markdownTableRow = psiElement instanceof MarkdownTableRow ? (MarkdownTableRow)psiElement : null;
        boolean bl = markdownTableRow != null ? TableUtils.INSTANCE.isHeaderRow(markdownTableRow) : false;
        if (bl) {
            rowLocation = RowLocation.FIRST;
        } else {
            psiElement = this.row;
            MarkdownTableRow markdownTableRow2 = psiElement instanceof MarkdownTableRow ? (MarkdownTableRow)psiElement : null;
            rowLocation = (markdownTableRow2 != null ? TableUtils.INSTANCE.isLast(markdownTableRow2) : false) ? RowLocation.LAST : (this.row instanceof MarkdownTableSeparatorRow && !this.hasRowAfter(this.row) ? RowLocation.LAST : RowLocation.OTHER);
        }
        return rowLocation;
    }

    private final boolean hasRowAfter(PsiElement element2) {
        Object v0;
        block1: {
            Sequence sequence = PsiTreeUtilKt.siblings$default((PsiElement)element2, (boolean)true, (boolean)false, (int)2, null);
            for (Object e : sequence) {
                PsiElement it = (PsiElement)e;
                boolean bl = false;
                if (!(it instanceof MarkdownTableRow)) continue;
                v0 = e;
                break block1;
            }
            v0 = null;
        }
        return v0 != null;
    }

    public void paint(@NotNull Graphics2D graphics, @NotNull TextAttributes attributes) {
        Intrinsics.checkNotNullParameter((Object)graphics, (String)"graphics");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        if (!this.row.isValid() || this.editor.isDisposed() || Intrinsics.areEqual((Object)this.boundsState, (Object)initialState)) {
            return;
        }
        GraphicsUtils.INSTANCE.useCopy(graphics, (Function1)new Function1<Graphics2D, Unit>(this){
            final /* synthetic */ VerticalBarPresentation this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Graphics2D local) {
                Intrinsics.checkNotNullParameter((Object)local, (String)"local");
                GraphicsUtil.setupAntialiasing((Graphics)local);
                GraphicsUtil.setupRoundedBorderAntialiasing((Graphics)local);
                VerticalBarPresentation.access$paintRow(this.this$0, local, VerticalBarPresentation.access$getRowLocation(this.this$0));
            }
        });
    }

    private final Rectangle calculateBarRect(RowLocation location) {
        return switch (WhenMappings.$EnumSwitchMapping$0[location.ordinal()]) {
            case 1 -> new Rectangle(0, 0, 6, this.getHeight());
            case 2 -> new Rectangle(0, 3, 6, this.getHeight() - 3);
            case 3 -> new Rectangle(0, 0, 6, this.getHeight() - 3);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final void paintRow(Graphics2D graphics, RowLocation location) {
        Rectangle rect = this.calculateBarRect(location);
        this.actuallyPaintBar(graphics, rect, this.hover, this.accent);
        graphics.setColor(TableInlayProperties.INSTANCE.getCircleColor());
        switch (WhenMappings.$EnumSwitchMapping$0[location.ordinal()]) {
            case 1: {
                this.paintOtherCircles(graphics, rect);
                break;
            }
            case 2: {
                this.paintFirstCircles(graphics, rect);
                break;
            }
            case 3: {
                this.paintLastCircles(graphics, rect);
            }
        }
    }

    private final void paintOtherCircles(Graphics2D graphics, Rectangle rect) {
        int n = 2;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            GraphicsUtils.INSTANCE.fillHalfOval(graphics, rect.x, rect.y - 3, 6, 6, true);
            GraphicsUtils.INSTANCE.fillHalfOval(graphics, rect.x, rect.y + rect.height - 3, 6, 6, false);
        }
    }

    private final void paintFirstCircles(Graphics2D graphics, Rectangle rect) {
        int n = 2;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            graphics.fillOval(rect.x, rect.y - 3, 6, 6);
            GraphicsUtils.INSTANCE.fillHalfOval(graphics, rect.x, rect.y + rect.height - 3, 6, 6, false);
        }
    }

    private final void paintLastCircles(Graphics2D graphics, Rectangle rect) {
        int n = 2;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            GraphicsUtils.INSTANCE.fillHalfOval(graphics, rect.x, rect.y - 3, 6, 6, true);
            graphics.fillOval(rect.x, rect.y + rect.height - 3, 6, 6);
        }
    }

    private final void actuallyPaintBar(Graphics2D graphics, Rectangle rect, boolean hover, boolean accent) {
        int paintCount = accent ? 2 : 1;
        for (int i = 0; i < paintCount; ++i) {
            int it = i;
            boolean bl = false;
            graphics.setColor(hover ? TableInlayProperties.INSTANCE.getBarHoverColor() : TableInlayProperties.INSTANCE.getBarColor());
            graphics.fillRect(rect.x, rect.y, rect.width, rect.height);
        }
        GraphicsUtils.INSTANCE.clearHalfOvalOverEditor(graphics, rect.x, rect.y - 3, 6, 6, true);
        GraphicsUtils.INSTANCE.clearHalfOvalOverEditor(graphics, rect.x, rect.y + rect.height - 3, 6, 6, false);
    }

    public void mouseClicked(@NotNull MouseEvent event, @NotNull Point translated) {
        int n;
        int n2;
        int n3;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)translated, (String)"translated");
        if (SwingUtilities.isLeftMouseButton(event) && (n3 = (n2 = event.getClickCount()) % (n = 2)) + (n & ((n3 ^ n) & (n3 | -n3)) >> 31) == 0) {
            this.handleMouseLeftDoubleClick(event, translated);
        } else if (SwingUtilities.isLeftMouseButton(event)) {
            this.handleMouseLeftClick(event, translated);
        }
    }

    private final void handleMouseLeftClick(MouseEvent event, Point translated) {
        this.showToolbar();
    }

    private final void handleMouseLeftDoubleClick(MouseEvent event, Point translated) {
        event.consume();
        Project project$iv = this.row.getProject();
        String name$iv = null;
        Object groupId$iv = null;
        boolean $i$f$executeCommand = false;
        CommandProcessor.getInstance().executeCommand(project$iv, new Runnable(this){
            final /* synthetic */ VerticalBarPresentation this$0;
            {
                this.this$0 = verticalBarPresentation;
            }

            public final void run() {
                boolean bl = false;
                TextRange textRange = VerticalBarPresentation.access$getRow$p(this.this$0).getTextRange();
                Caret $this$handleMouseLeftDoubleClick_u24lambda_u247_u24lambda_u246 = VerticalBarPresentation.access$getEditor$p(this.this$0).getCaretModel().getCurrentCaret();
                boolean bl2 = false;
                $this$handleMouseLeftDoubleClick_u24lambda_u247_u24lambda_u246.moveToOffset(textRange.getStartOffset());
                $this$handleMouseLeftDoubleClick_u24lambda_u247_u24lambda_u246.setSelection(textRange.getStartOffset(), textRange.getEndOffset());
            }
        }, name$iv, groupId$iv);
    }

    @NotNull
    public String toString() {
        return "VerticalBarPresentation";
    }

    private final Point calculateToolbarPosition(int componentHeight) {
        Point point = this.editor.offsetToXY(UtilsKt.getStartOffset((PsiElement)this.row));
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"offsetToXY(...)");
        Point position = point;
        Point editorParent = this.editor.getContentComponent().getTopLevelAncestor().getLocationOnScreen();
        Point editorPosition = this.editor.getContentComponent().getLocationOnScreen();
        position.translate(editorPosition.x - editorParent.x, editorPosition.y - editorParent.y);
        position.translate(0, -this.editor.getLineHeight());
        position.translate(0, -componentHeight);
        Rectangle rect = this.calculateBarRect(this.getRowLocation());
        int bottomPadding = 2;
        position.translate(rect.x, -rect.y - 12 - bottomPadding);
        return position;
    }

    private final void showToolbar() {
        JComponent targetComponent = TableActionKeys.INSTANCE.createDataContextComponent(this.editor, VerticalBarPresentation.Companion.createDataProvider(this.row));
        ToolbarUtils.INSTANCE.createImmediatelyUpdatedToolbar(VerticalBarPresentation.Companion.getRowActionGroup(), "MarkdownTableInlayToolbar", targetComponent, true, (Function1)new Function1<ActionToolbar, Unit>((Object)this){

            public final void invoke(@NotNull ActionToolbar p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                VerticalBarPresentation.access$createAndShowHint((VerticalBarPresentation)((Object)this.receiver), p0);
            }
        });
    }

    private final void createAndShowHint(ActionToolbar toolbar2) {
        LightweightHint hint = new LightweightHint(toolbar2.getComponent());
        hint.setForceShowAsPopup(true);
        Point targetPoint = this.calculateToolbarPosition(hint.getComponent().getPreferredSize().height);
        HintManagerImpl hintManager = HintManagerImpl.getInstanceImpl();
        hintManager.hideAllHints();
        int flags = 1065;
        hintManager.showEditorHint(hint, this.editor, targetPoint, flags, 0, false);
    }

    private static final void _init_$lambda$0(VerticalBarPresentation this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        ActionsKt.invokeLater((ModalityState)ModalityState.stateForComponent((Component)this$0.editor.getContentComponent()), (Function0)((Function0)new Function0<Unit>(this$0){
            final /* synthetic */ VerticalBarPresentation this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                if (VerticalBarPresentation.access$shouldShowInlay(this.this$0)) {
                    BoundsState calculated = new BoundsState(6, VerticalBarPresentation.access$getEditor$p(this.this$0).getLineHeight());
                    VerticalBarPresentation.access$setBoundsState$p(this.this$0, calculated);
                    this.this$0.fireSizeChanged(new Dimension(0, 0), new Dimension(calculated.getWidth(), calculated.getHeight()));
                }
            }
        }));
    }

    public static final /* synthetic */ void access$paintRow(VerticalBarPresentation $this, Graphics2D graphics, RowLocation location) {
        $this.paintRow(graphics, location);
    }

    public static final /* synthetic */ RowLocation access$getRowLocation(VerticalBarPresentation $this) {
        return $this.getRowLocation();
    }

    public static final /* synthetic */ void access$createAndShowHint(VerticalBarPresentation $this, ActionToolbar toolbar2) {
        $this.createAndShowHint(toolbar2);
    }

    public static final /* synthetic */ boolean access$shouldShowInlay(VerticalBarPresentation $this) {
        return $this.shouldShowInlay();
    }

    public static final /* synthetic */ Editor access$getEditor$p(VerticalBarPresentation $this) {
        return $this.editor;
    }

    public static final /* synthetic */ void access$setBoundsState$p(VerticalBarPresentation $this, BoundsState boundsState) {
        $this.boundsState = boundsState;
    }

    public static final /* synthetic */ PsiElement access$getRow$p(VerticalBarPresentation $this) {
        return $this.row;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/ui/presentation/VerticalBarPresentation$BoundsState;", "", "width", "", "height", "(II)V", "getHeight", "()I", "getWidth", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.markdown"})
    private static final class BoundsState {
        private final int width;
        private final int height;

        public BoundsState(int width, int height) {
            this.width = width;
            this.height = height;
        }

        public final int getWidth() {
            return this.width;
        }

        public final int getHeight() {
            return this.height;
        }

        public final int component1() {
            return this.width;
        }

        public final int component2() {
            return this.height;
        }

        @NotNull
        public final BoundsState copy(int width, int height) {
            return new BoundsState(width, height);
        }

        public static /* synthetic */ BoundsState copy$default(BoundsState boundsState, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = boundsState.width;
            }
            if ((n3 & 2) != 0) {
                n2 = boundsState.height;
            }
            return boundsState.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "BoundsState(width=" + this.width + ", height=" + this.height + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.width);
            result2 = result2 * 31 + Integer.hashCode(this.height);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BoundsState)) {
                return false;
            }
            BoundsState boundsState = (BoundsState)other;
            if (this.width != boundsState.width) {
                return false;
            }
            return this.height == boundsState.height;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/ui/presentation/VerticalBarPresentation$Companion;", "", "()V", "barWidth", "", "initialState", "Lorg/intellij/plugins/markdown/editor/tables/ui/presentation/VerticalBarPresentation$BoundsState;", "rowActionGroup", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "getRowActionGroup", "()Lcom/intellij/openapi/actionSystem/ActionGroup;", "create", "Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;", "factory", "Lcom/intellij/codeInsight/hints/presentation/PresentationFactory;", "editor", "Lcom/intellij/openapi/editor/Editor;", "row", "Lcom/intellij/psi/PsiElement;", "createDataProvider", "Lcom/intellij/openapi/actionSystem/DataProvider;", "wrapPresentation", "presentation", "intellij.markdown"})
    public static final class Companion {
        private Companion() {
        }

        private final ActionGroup getRowActionGroup() {
            AnAction anAction = ActionManager.getInstance().getAction("Markdown.TableRowActions");
            Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
            return (ActionGroup)anAction;
        }

        private final DataProvider createDataProvider(PsiElement row) {
            WeakReference<PsiElement> elementReference = new WeakReference<PsiElement>(row);
            return arg_0 -> Companion.createDataProvider$lambda$0(elementReference, arg_0);
        }

        private final InlayPresentation wrapPresentation(PresentationFactory factory, Editor editor2, InlayPresentation presentation) {
            return (InlayPresentation)PresentationFactory.inset$default((PresentationFactory)factory, (InlayPresentation)((InlayPresentation)new PresentationWithCustomCursor(editor2, presentation)), (int)2, (int)2, (int)0, (int)0, (int)24, null);
        }

        @NotNull
        public final InlayPresentation create(@NotNull PresentationFactory factory, @NotNull Editor editor2, @NotNull PsiElement row) {
            Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)row, (String)"row");
            return PresentationFactory.changeOnHover$default((PresentationFactory)factory, (InlayPresentation)this.wrapPresentation(factory, editor2, (InlayPresentation)new VerticalBarPresentation(editor2, row, false, false, 8, null)), (Function0)((Function0)new Function0<InlayPresentation>(factory, editor2, row){
                final /* synthetic */ PresentationFactory $factory;
                final /* synthetic */ Editor $editor;
                final /* synthetic */ PsiElement $row;
                {
                    this.$factory = $factory;
                    this.$editor = $editor;
                    this.$row = $row;
                    super(0);
                }

                @NotNull
                public final InlayPresentation invoke() {
                    return org.intellij.plugins.markdown.editor.tables.ui.presentation.VerticalBarPresentation$Companion.access$wrapPresentation(VerticalBarPresentation.Companion, this.$factory, this.$editor, (InlayPresentation)new VerticalBarPresentation(this.$editor, this.$row, true, false, 8, null));
                }
            }), null, (int)4, null);
        }

        private static final Object createDataProvider$lambda$0(WeakReference $elementReference, String it) {
            Intrinsics.checkNotNullParameter((Object)$elementReference, (String)"$elementReference");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return TableActionKeys.INSTANCE.getELEMENT().is(it) ? $elementReference : null;
        }

        public static final /* synthetic */ InlayPresentation access$wrapPresentation(Companion $this, PresentationFactory factory, Editor editor2, InlayPresentation presentation) {
            return $this.wrapPresentation(factory, editor2, presentation);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/ui/presentation/VerticalBarPresentation$RowLocation;", "", "(Ljava/lang/String;I)V", "FIRST", "LAST", "OTHER", "intellij.markdown"})
    private static final class RowLocation
    extends Enum<RowLocation> {
        public static final /* enum */ RowLocation FIRST = new RowLocation();
        public static final /* enum */ RowLocation LAST = new RowLocation();
        public static final /* enum */ RowLocation OTHER = new RowLocation();
        private static final /* synthetic */ RowLocation[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static RowLocation[] values() {
            return (RowLocation[])$VALUES.clone();
        }

        public static RowLocation valueOf(String value) {
            return Enum.valueOf(RowLocation.class, value);
        }

        @NotNull
        public static EnumEntries<RowLocation> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = rowLocationArray = new RowLocation[]{RowLocation.FIRST, RowLocation.LAST, RowLocation.OTHER};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RowLocation.values().length];
            try {
                nArray[RowLocation.OTHER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RowLocation.FIRST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RowLocation.LAST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

