/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.xml;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.PropertiesUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.PropertyKeyValueFormat;
import com.intellij.lang.properties.xml.XmlPropertiesFile;
import com.intellij.lang.properties.xml.XmlPropertiesIndex;
import com.intellij.lang.properties.xml.XmlProperty;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MostlySingularMultiMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class XmlPropertiesFileImpl
extends XmlPropertiesFile {
    @NonNls
    public static final String ENTRY_TAG_NAME = "entry";
    private static final Key<CachedValue<PropertiesFile>> KEY = Key.create((String)"xml properties file");
    private final XmlFile myFile;
    private List<IProperty> myProperties;
    private MostlySingularMultiMap<String, IProperty> myPropertiesMap;
    private boolean myAlphaSorted;
    private long myFileModificationStamp = -1L;
    private final Object myLock = new Object();

    private void ensurePropertiesLoaded() {
        while (this.myFileModificationStamp != this.myFile.getModificationStamp() || this.myPropertiesMap == null) {
            this.myFileModificationStamp = this.myFile.getModificationStamp();
            MostlySingularMultiMap propertiesMap = new MostlySingularMultiMap();
            XmlTag rootTag = this.myFile.getRootTag();
            ArrayList<IProperty> propertiesOrder = new ArrayList<IProperty>();
            if (rootTag != null) {
                XmlTag[] entries;
                for (XmlTag entry : entries = rootTag.findSubTags(ENTRY_TAG_NAME)) {
                    XmlProperty property = new XmlProperty(entry, this);
                    propertiesOrder.add(property);
                    String key = property.getKey();
                    if (key == null) continue;
                    propertiesMap.add((Object)key, (Object)property);
                }
            }
            this.myAlphaSorted = PropertiesImplUtil.isAlphaSorted(propertiesOrder);
            this.myProperties = propertiesOrder;
            this.myPropertiesMap = propertiesMap;
        }
    }

    private XmlPropertiesFileImpl(XmlFile file) {
        this.myFile = file;
    }

    @Override
    @NotNull
    public PsiFile getContainingFile() {
        XmlFile xmlFile = this.myFile;
        if (xmlFile == null) {
            XmlPropertiesFileImpl.$$$reportNull$$$0(0);
        }
        return xmlFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public List<IProperty> getProperties() {
        Object object = this.myLock;
        // MONITORENTER : object
        this.ensurePropertiesLoaded();
        List<IProperty> list = this.myProperties;
        // MONITOREXIT : object
        if (list != null) return list;
        XmlPropertiesFileImpl.$$$reportNull$$$0(1);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IProperty findPropertyByKey(@NotNull @NonNls String key) {
        if (key == null) {
            XmlPropertiesFileImpl.$$$reportNull$$$0(2);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.ensurePropertiesLoaded();
            Iterator properties = this.myPropertiesMap.get((Object)key).iterator();
            return properties.hasNext() ? (IProperty)properties.next() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public List<IProperty> findPropertiesByKey(@NotNull @NonNls String key) {
        if (key == null) {
            XmlPropertiesFileImpl.$$$reportNull$$$0(3);
        }
        Object object = this.myLock;
        // MONITORENTER : object
        this.ensurePropertiesLoaded();
        List list = ContainerUtil.collect(this.myPropertiesMap.get((Object)key).iterator());
        // MONITOREXIT : object
        if (list != null) return list;
        XmlPropertiesFileImpl.$$$reportNull$$$0(4);
        return list;
    }

    @Override
    @NotNull
    public ResourceBundle getResourceBundle() {
        ResourceBundle resourceBundle = PropertiesImplUtil.getResourceBundle(this);
        if (resourceBundle == null) {
            XmlPropertiesFileImpl.$$$reportNull$$$0(5);
        }
        return resourceBundle;
    }

    @Override
    @NotNull
    public Locale getLocale() {
        Locale locale = PropertiesUtil.getLocale(this);
        if (locale == null) {
            XmlPropertiesFileImpl.$$$reportNull$$$0(6);
        }
        return locale;
    }

    @Override
    @NotNull
    public PsiElement addProperty(@NotNull IProperty property) throws IncorrectOperationException {
        if (property == null) {
            XmlPropertiesFileImpl.$$$reportNull$$$0(7);
        }
        PsiElement psiElement = this.addProperty(property.getKey(), property.getValue()).getPsiElement().getNavigationElement();
        if (psiElement == null) {
            XmlPropertiesFileImpl.$$$reportNull$$$0(8);
        }
        return psiElement;
    }

    @Override
    @NotNull
    public PsiElement addPropertyAfter(@NotNull IProperty property, @Nullable IProperty anchor) throws IncorrectOperationException {
        if (property == null) {
            XmlPropertiesFileImpl.$$$reportNull$$$0(9);
        }
        PsiElement psiElement = this.addPropertyAfter(property.getKey(), property.getValue(), anchor).getPsiElement().getNavigationElement();
        if (psiElement == null) {
            XmlPropertiesFileImpl.$$$reportNull$$$0(10);
        }
        return psiElement;
    }

    @Override
    @NotNull
    public IProperty addPropertyAfter(@NotNull String key, @NotNull String value, IProperty anchor) {
        if (key == null) {
            XmlPropertiesFileImpl.$$$reportNull$$$0(11);
        }
        if (value == null) {
            XmlPropertiesFileImpl.$$$reportNull$$$0(12);
        }
        IProperty iProperty = this.addPropertyAfter(key, value, anchor, true);
        if (iProperty == null) {
            XmlPropertiesFileImpl.$$$reportNull$$$0(13);
        }
        return iProperty;
    }

    @NotNull
    public IProperty addPropertyAfter(String key, String value, @Nullable IProperty anchor, boolean addToEnd) {
        XmlTag anchorTag = anchor == null ? null : (XmlTag)anchor.getPsiElement().getNavigationElement();
        XmlTag rootTag = this.myFile.getRootTag();
        XmlTag entry = this.createPropertyTag(key, value);
        XmlTag addedEntry = (XmlTag)(anchorTag == null ? this.myFile.getRootTag().addSubTag(entry, !addToEnd) : rootTag.addAfter((PsiElement)entry, (PsiElement)anchorTag));
        return new XmlProperty(addedEntry, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public IProperty addProperty(@NotNull String key, @NotNull String value, @NotNull PropertyKeyValueFormat format) {
        IProperty inserted;
        if (key == null) {
            XmlPropertiesFileImpl.$$$reportNull$$$0(14);
        }
        if (value == null) {
            XmlPropertiesFileImpl.$$$reportNull$$$0(15);
        }
        if (format == null) {
            XmlPropertiesFileImpl.$$$reportNull$$$0(16);
        }
        XmlTag entry = this.createPropertyTag(key, value);
        Object object = this.myLock;
        // MONITORENTER : object
        this.ensurePropertiesLoaded();
        if (!this.myAlphaSorted) {
            IProperty iProperty = this.addPropertyAfter(key, value, null, true);
            // MONITOREXIT : object
            if (iProperty != null) return iProperty;
            XmlPropertiesFileImpl.$$$reportNull$$$0(18);
            return iProperty;
        }
        XmlProperty dummyProperty = new XmlProperty(entry, this);
        int insertIndex = Collections.binarySearch(this.myProperties, dummyProperty, (p1, p2) -> {
            String k1 = p1.getKey();
            String k2 = p2.getKey();
            return k1.compareTo(k2);
        });
        if (insertIndex == -1) {
            inserted = this.addPropertyAfter(key, value, null, false);
            this.myProperties.add(0, inserted);
        } else {
            int position = insertIndex < 0 ? -insertIndex - 2 : insertIndex;
            IProperty insertPosition = this.myProperties.get(position);
            inserted = this.addPropertyAfter(key, value, insertPosition, false);
            this.myProperties.add(position + 1, inserted);
        }
        IProperty iProperty = inserted;
        // MONITOREXIT : object
        if (iProperty != null) return iProperty;
        XmlPropertiesFileImpl.$$$reportNull$$$0(17);
        return iProperty;
    }

    private XmlTag createPropertyTag(String key, String value) {
        XmlTag rootTag = this.myFile.getRootTag();
        XmlTag entry = rootTag.createChildTag(ENTRY_TAG_NAME, "", value, false);
        entry.setAttribute("key", key);
        return entry;
    }

    public static PropertiesFile getPropertiesFile(@NotNull PsiFile file) {
        if (file == null) {
            XmlPropertiesFileImpl.$$$reportNull$$$0(19);
        }
        CachedValuesManager manager = CachedValuesManager.getManager((Project)file.getProject());
        if (file instanceof XmlFile) {
            return (PropertiesFile)manager.getCachedValue((UserDataHolder)file, KEY, () -> {
                XmlPropertiesFileImpl value = XmlPropertiesIndex.isPropertiesFile((XmlFile)file) ? new XmlPropertiesFileImpl((XmlFile)file) : null;
                return CachedValueProvider.Result.create((Object)value, (Object[])new Object[]{file});
            }, false);
        }
        return null;
    }

    @Override
    @NotNull
    public Map<String, String> getNamesMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (IProperty property : this.getProperties()) {
            result.put(property.getUnescapedKey(), property.getValue());
        }
        HashMap<String, String> hashMap = result;
        if (hashMap == null) {
            XmlPropertiesFileImpl.$$$reportNull$$$0(20);
        }
        return hashMap;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.getContainingFile().getName();
        if (string == null) {
            XmlPropertiesFileImpl.$$$reportNull$$$0(21);
        }
        return string;
    }

    @Override
    public VirtualFile getVirtualFile() {
        return this.getContainingFile().getVirtualFile();
    }

    @Override
    public PsiDirectory getParent() {
        return this.getContainingFile().getParent();
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.getContainingFile().getProject();
        if (project == null) {
            XmlPropertiesFileImpl.$$$reportNull$$$0(22);
        }
        return project;
    }

    @Override
    public String getText() {
        return this.getContainingFile().getText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAlphaSorted() {
        Object object = this.myLock;
        synchronized (object) {
            this.ensurePropertiesLoaded();
            return this.myAlphaSorted;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XmlPropertiesFileImpl that = (XmlPropertiesFileImpl)o;
        return this.myFile.equals(that.myFile);
    }

    public int hashCode() {
        return this.myFile.hashCode();
    }

    public String toString() {
        return "XmlPropertiesFileImpl:" + this.getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 7, 9, 11, 12, 14, 15, 16, 19 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/properties/xml/XmlPropertiesFileImpl";
                break;
            }
            case 2: 
            case 3: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/properties/xml/XmlPropertiesFileImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findPropertiesByKey";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceBundle";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocale";
                break;
            }
            case 8: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "addProperty";
                break;
            }
            case 10: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "addPropertyAfter";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamesMap";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findPropertyByKey";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findPropertiesByKey";
                break;
            }
            case 7: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addProperty";
                break;
            }
            case 9: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyAfter";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getPropertiesFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 7, 9, 11, 12, 14, 15, 16, 19 -> new IllegalArgumentException(string);
        };
    }
}

