/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.customizeActions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.PropertiesUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.ResourceBundleManager;
import com.intellij.lang.properties.editor.ResourceBundleAsVirtualFile;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CombinePropertiesFilesAction
extends AnAction {
    public CombinePropertiesFilesAction() {
        super(PropertiesBundle.messagePointer("combine.properties.files.title", new Object[0]), AllIcons.FileTypes.Properties);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        String newBaseName;
        List<PropertiesFile> initialPropertiesFiles;
        if (e == null) {
            CombinePropertiesFilesAction.$$$reportNull$$$0(0);
        }
        ArrayList<PropertiesFile> propertiesFiles = (initialPropertiesFiles = CombinePropertiesFilesAction.getPropertiesFiles(e)) == null ? new ArrayList<PropertiesFile>() : new ArrayList<PropertiesFile>(initialPropertiesFiles);
        List<ResourceBundle> resourceBundles = CombinePropertiesFilesAction.getResourceBundles(e);
        if (resourceBundles != null) {
            for (ResourceBundle bundle : resourceBundles) {
                propertiesFiles.addAll(bundle.getPropertiesFiles());
            }
        }
        if ((newBaseName = Messages.showInputDialog((Project)((PropertiesFile)propertiesFiles.get(0)).getProject(), (String)PropertiesBundle.message("combine.properties.files.prompt.text", new Object[0]), (String)PropertiesBundle.message("combine.properties.files.title", new Object[0]), (Icon)Messages.getQuestionIcon(), (String)PropertiesUtil.getDefaultBaseName(propertiesFiles), (InputValidator)new MyInputValidator(propertiesFiles))) != null) {
            Project project = ((PropertiesFile)propertiesFiles.get(0)).getProject();
            HashSet<ResourceBundle> uniqueBundlesToDissociate = new HashSet<ResourceBundle>();
            for (PropertiesFile propertiesFile : propertiesFiles) {
                ResourceBundle resourceBundle = propertiesFile.getResourceBundle();
                if (resourceBundle.getPropertiesFiles().size() == 1) continue;
                uniqueBundlesToDissociate.add(resourceBundle);
            }
            ResourceBundleManager resourceBundleManager = ResourceBundleManager.getInstance(project);
            for (ResourceBundle resourceBundle : uniqueBundlesToDissociate) {
                resourceBundleManager.dissociateResourceBundle(resourceBundle);
            }
            ResourceBundle resourceBundle = resourceBundleManager.combineToResourceBundleAndGet(propertiesFiles, newBaseName);
            FileEditorManager.getInstance((Project)project).openFile((VirtualFile)new ResourceBundleAsVirtualFile(resourceBundle), true);
            ProjectView.getInstance((Project)project).refresh();
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            CombinePropertiesFilesAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            CombinePropertiesFilesAction.$$$reportNull$$$0(2);
        }
        List<PropertiesFile> propertiesFiles = CombinePropertiesFilesAction.getPropertiesFiles(e);
        List<ResourceBundle> resourceBundles = CombinePropertiesFilesAction.getResourceBundles(e);
        int elementCount = 0;
        if (propertiesFiles != null) {
            elementCount += propertiesFiles.size();
        }
        if (resourceBundles != null) {
            elementCount += resourceBundles.size();
        }
        e.getPresentation().setEnabledAndVisible(elementCount > 1);
    }

    @Nullable
    private static List<ResourceBundle> getResourceBundles(@NotNull AnActionEvent e) {
        ResourceBundle[] resourceBundles;
        if (e == null) {
            CombinePropertiesFilesAction.$$$reportNull$$$0(3);
        }
        return (resourceBundles = (ResourceBundle[])e.getData(ResourceBundle.ARRAY_DATA_KEY)) == null ? null : List.of(resourceBundles);
    }

    @Nullable
    private static List<PropertiesFile> getPropertiesFiles(@NotNull AnActionEvent e) {
        PsiElement[] psiElements;
        if (e == null) {
            CombinePropertiesFilesAction.$$$reportNull$$$0(4);
        }
        if ((psiElements = (PsiElement[])e.getData(LangDataKeys.PSI_ELEMENT_ARRAY)) == null || psiElements.length == 0) {
            return null;
        }
        ArrayList<PropertiesFile> files = new ArrayList<PropertiesFile>(psiElements.length);
        for (PsiElement psiElement : psiElements) {
            PropertiesFile propertiesFile = PropertiesImplUtil.getPropertiesFile(psiElement);
            if (propertiesFile == null) {
                return null;
            }
            files.add(propertiesFile);
        }
        return files;
    }

    public boolean isDumbAware() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/properties/customizeActions/CombinePropertiesFilesAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/properties/customizeActions/CombinePropertiesFilesAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getResourceBundles";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPropertiesFiles";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static final class MyInputValidator
    implements InputValidatorEx {
        private final List<? extends PropertiesFile> myPropertiesFiles;

        private MyInputValidator(List<? extends PropertiesFile> propertiesFiles) {
            this.myPropertiesFiles = propertiesFiles;
        }

        public boolean checkInput(String newBaseName) {
            return !newBaseName.isEmpty() && this.checkBaseName(newBaseName) == null;
        }

        @Nullable
        public String getErrorText(String inputString) {
            return this.checkInput(inputString) ? null : PropertiesBundle.message("combine.properties.files.validation.error", this.checkBaseName(inputString).getFailedFile());
        }

        @Nullable
        private BaseNameError checkBaseName(String baseNameCandidate) {
            for (PropertiesFile propertiesFile : this.myPropertiesFiles) {
                String name = propertiesFile.getVirtualFile().getName();
                if (name.startsWith(baseNameCandidate) && (name.length() == baseNameCandidate.length() || PropertiesUtil.BASE_NAME_BORDER_CHAR.contains(Character.valueOf(name.charAt(baseNameCandidate.length()))))) continue;
                return new BaseNameError(name);
            }
            return null;
        }

        private static final class BaseNameError {
            private final String myFailedFile;

            private BaseNameError(String failedFile) {
                this.myFailedFile = failedFile;
            }

            public String getFailedFile() {
                return this.myFailedFile;
            }
        }
    }
}

