/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.objects;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.h;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import it.unimi.dsi.fastutil.objects.ObjectSortedSet;
import it.unimi.dsi.fastutil.objects.ObjectSpliterator;
import it.unimi.dsi.fastutil.objects.ao;
import it.unimi.dsi.fastutil.objects.ax;
import it.unimi.dsi.fastutil.objects.t;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collector;

public class ObjectLinkedOpenHashSet<K>
extends t<K>
implements Hash,
Serializable,
Cloneable {
    private static final long serialVersionUID = 0L;
    protected transient K[] key;
    protected transient int mask;
    protected transient boolean containsNull;
    protected transient int first = -1;
    protected transient int last = -1;
    protected transient long[] link;
    protected transient int n;
    protected transient int maxFill;
    protected final transient int minN;
    protected int size;
    protected final float f;
    private static final Collector<Object, ?, ObjectLinkedOpenHashSet<Object>> a = Collector.of(ObjectLinkedOpenHashSet::new, ObjectLinkedOpenHashSet::add, ObjectLinkedOpenHashSet::a, new Collector.Characteristics[0]);

    /*
     * WARNING - void declaration
     */
    public ObjectLinkedOpenHashSet(int expected, float f2) {
        void var2_2;
        void var1_1;
        if (f2 <= 0.0f || f2 >= 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f2;
        ObjectLinkedOpenHashSet objectLinkedOpenHashSet = this;
        objectLinkedOpenHashSet.minN = objectLinkedOpenHashSet.n = HashCommon.arraySize((int)var1_1, f2);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.maxFill(this.n, (float)var2_2);
        this.key = new Object[this.n + 1];
        this.link = new long[this.n + 1];
    }

    /*
     * WARNING - void declaration
     */
    public ObjectLinkedOpenHashSet(int expected) {
        this((int)var1_1, 0.75f);
        void var1_1;
    }

    public ObjectLinkedOpenHashSet() {
        this(16, 0.75f);
    }

    /*
     * WARNING - void declaration
     */
    public ObjectLinkedOpenHashSet(Collection<? extends K> c2, float f2) {
        this(c2.size(), (float)var2_2);
        void var1_1;
        void var2_2;
        this.addAll((Collection<K>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public ObjectLinkedOpenHashSet(Collection<? extends K> c2) {
        this((Collection<K>)var1_1, 0.75f);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ObjectLinkedOpenHashSet(ObjectCollection<? extends K> c2, float f2) {
        this(c2.size(), (float)var2_2);
        void var1_1;
        void var2_2;
        this.addAll((Collection<K>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public ObjectLinkedOpenHashSet(ObjectCollection<? extends K> c2) {
        this((ObjectCollection<K>)var1_1, 0.75f);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ObjectLinkedOpenHashSet(Iterator<? extends K> i2, float f2) {
        this(16, (float)var2_2);
        void var2_2;
        while (i2.hasNext()) {
            this.add(i2.next());
        }
    }

    /*
     * WARNING - void declaration
     */
    public ObjectLinkedOpenHashSet(Iterator<? extends K> i2) {
        this((Iterator<K>)var1_1, 0.75f);
        void var1_1;
    }

    public ObjectLinkedOpenHashSet(K[] a2, int offset, int length, float f2) {
        this(length < 0 ? 0 : length, f2);
        ObjectArrays.ensureOffsetLength(a2, offset, length);
        for (int i2 = 0; i2 < length; ++i2) {
            this.add(a2[offset + i2]);
        }
    }

    /*
     * WARNING - void declaration
     */
    public ObjectLinkedOpenHashSet(K[] a2, int offset, int length) {
        this((K[])var1_1, (int)var2_2, (int)var3_3, 0.75f);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ObjectLinkedOpenHashSet(K[] a2, float f2) {
        this(a2, 0, ((void)var1_1).length, (float)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ObjectLinkedOpenHashSet(K[] a2) {
        this((K[])var1_1, 0.75f);
        void var1_1;
    }

    public static <K> ObjectLinkedOpenHashSet<K> of() {
        return new ObjectLinkedOpenHashSet<K>();
    }

    public static <K> ObjectLinkedOpenHashSet<K> of(K e2) {
        K k2;
        ObjectLinkedOpenHashSet<K> objectLinkedOpenHashSet = new ObjectLinkedOpenHashSet<K>(1, 0.75f);
        objectLinkedOpenHashSet.add(k2);
        return objectLinkedOpenHashSet;
    }

    /*
     * WARNING - void declaration
     */
    public static <K> ObjectLinkedOpenHashSet<K> of(K e0, K e1) {
        K k2;
        ObjectLinkedOpenHashSet<K> objectLinkedOpenHashSet = new ObjectLinkedOpenHashSet<K>(2, 0.75f);
        objectLinkedOpenHashSet.add(k2);
        if (!objectLinkedOpenHashSet.add(e1)) {
            void var1_1;
            throw new IllegalArgumentException("Duplicate element: ".concat(String.valueOf(var1_1)));
        }
        return objectLinkedOpenHashSet;
    }

    /*
     * WARNING - void declaration
     */
    public static <K> ObjectLinkedOpenHashSet<K> of(K e0, K e1, K e2) {
        K k2;
        ObjectLinkedOpenHashSet<K> objectLinkedOpenHashSet = new ObjectLinkedOpenHashSet<K>(3, 0.75f);
        objectLinkedOpenHashSet.add(k2);
        if (!objectLinkedOpenHashSet.add(e1)) {
            void var1_1;
            throw new IllegalArgumentException("Duplicate element: ".concat(String.valueOf(var1_1)));
        }
        if (!objectLinkedOpenHashSet.add(e2)) {
            void var2_2;
            throw new IllegalArgumentException("Duplicate element: ".concat(String.valueOf(var2_2)));
        }
        return objectLinkedOpenHashSet;
    }

    @SafeVarargs
    public static <K> ObjectLinkedOpenHashSet<K> of(K ... a2) {
        K[] KArray;
        ObjectLinkedOpenHashSet<K> objectLinkedOpenHashSet = new ObjectLinkedOpenHashSet<K>(a2.length, 0.75f);
        for (K k2 : KArray) {
            if (objectLinkedOpenHashSet.add(k2)) continue;
            throw new IllegalArgumentException("Duplicate element ".concat(String.valueOf(k2)));
        }
        return objectLinkedOpenHashSet;
    }

    private ObjectLinkedOpenHashSet<K> a(ObjectLinkedOpenHashSet<? extends K> objectLinkedOpenHashSet) {
        this.addAll((Collection<? extends K>)objectLinkedOpenHashSet);
        return this;
    }

    public static <K> Collector<K, ?, ObjectLinkedOpenHashSet<K>> toSet() {
        return a;
    }

    public static <K> Collector<K, ?, ObjectLinkedOpenHashSet<K>> toSetWithExpectedSize(int expectedSize) {
        int n3;
        if (expectedSize <= 16) {
            return ObjectLinkedOpenHashSet.toSet();
        }
        return Collector.of(new ao.b(n3, n2 -> {
            if (n2 <= 16) {
                return new ObjectLinkedOpenHashSet();
            }
            return new ObjectLinkedOpenHashSet(n2);
        }), ObjectLinkedOpenHashSet::add, ObjectLinkedOpenHashSet::a, new Collector.Characteristics[0]);
    }

    public void ensureCapacity(int capacity) {
        int n2 = HashCommon.arraySize(capacity, this.f);
        if (n2 > this.n) {
            this.rehash(n2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean addAll(Collection<? extends K> c2) {
        void var1_1;
        if ((double)this.f <= 0.5) {
            this.ensureCapacity(c2.size());
        } else {
            ObjectLinkedOpenHashSet objectLinkedOpenHashSet = this;
            long l2 = objectLinkedOpenHashSet.size() + c2.size();
            ObjectLinkedOpenHashSet objectLinkedOpenHashSet2 = objectLinkedOpenHashSet;
            int n2 = (int)Math.min(0x40000000L, Math.max(2L, HashCommon.nextPowerOfTwo((long)Math.ceil((float)l2 / objectLinkedOpenHashSet2.f))));
            if (n2 > objectLinkedOpenHashSet2.n) {
                objectLinkedOpenHashSet2.rehash(n2);
            }
        }
        return super.addAll(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean add(K k2) {
        int n2;
        if (k2 == null) {
            if (this.containsNull) {
                return false;
            }
            n2 = this.n;
            this.containsNull = true;
        } else {
            void var1_1;
            K[] KArray = this.key;
            n2 = HashCommon.mix(k2.hashCode()) & this.mask;
            K k3 = this.key[n2];
            if (k3 != null) {
                if (k3.equals(k2)) {
                    return false;
                }
                while ((k3 = KArray[n2 = n2 + 1 & this.mask]) != null) {
                    if (!k3.equals(k2)) continue;
                    return false;
                }
            }
            KArray[n2] = var1_1;
        }
        if (this.size == 0) {
            ObjectLinkedOpenHashSet objectLinkedOpenHashSet = this;
            objectLinkedOpenHashSet.first = objectLinkedOpenHashSet.last = n2;
            this.link[n2] = -1L;
        } else {
            int n3 = this.last;
            this.link[n3] = this.link[n3] ^ (this.link[this.last] ^ (long)n2 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            this.link[n2] = ((long)this.last & 0xFFFFFFFFL) << 32 | 0xFFFFFFFFL;
            this.last = n2;
        }
        if (this.size++ >= this.maxFill) {
            ObjectLinkedOpenHashSet objectLinkedOpenHashSet = this;
            objectLinkedOpenHashSet.rehash(HashCommon.arraySize(objectLinkedOpenHashSet.size + 1, this.f));
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public K addOrGet(K k2) {
        void var1_1;
        int n2;
        if (k2 == null) {
            if (this.containsNull) {
                return this.key[this.n];
            }
            n2 = this.n;
            this.containsNull = true;
        } else {
            K[] KArray = this.key;
            n2 = HashCommon.mix(k2.hashCode()) & this.mask;
            K k3 = this.key[n2];
            if (k3 != null) {
                if (k3.equals(k2)) {
                    return k3;
                }
                while ((k3 = KArray[n2 = n2 + 1 & this.mask]) != null) {
                    if (!k3.equals(k2)) continue;
                    return k3;
                }
            }
            KArray[n2] = k2;
        }
        if (this.size == 0) {
            ObjectLinkedOpenHashSet objectLinkedOpenHashSet = this;
            objectLinkedOpenHashSet.first = objectLinkedOpenHashSet.last = n2;
            this.link[n2] = -1L;
        } else {
            int n3 = this.last;
            this.link[n3] = this.link[n3] ^ (this.link[this.last] ^ (long)n2 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            this.link[n2] = ((long)this.last & 0xFFFFFFFFL) << 32 | 0xFFFFFFFFL;
            this.last = n2;
        }
        if (this.size++ >= this.maxFill) {
            ObjectLinkedOpenHashSet objectLinkedOpenHashSet = this;
            objectLinkedOpenHashSet.rehash(HashCommon.arraySize(objectLinkedOpenHashSet.size + 1, this.f));
        }
        return var1_1;
    }

    private void a(int n2) {
        K[] KArray = this.key;
        while (true) {
            K k2;
            int n3 = n2;
            n2 = n3 + 1 & this.mask;
            while (true) {
                if ((k2 = KArray[n2]) == null) {
                    KArray[n3] = null;
                    return;
                }
                int n4 = HashCommon.mix(k2.hashCode()) & this.mask;
                if (n3 > n2 ? n3 >= n4 && n4 > n2 : n3 >= n4 || n4 > n2) break;
                n2 = n2 + 1 & this.mask;
            }
            KArray[n3] = k2;
            this.a(n2, n3);
        }
    }

    private boolean b(int n2) {
        --this.size;
        this.e(n2);
        this.a(n2);
        if (this.n > this.minN && this.size < this.maxFill / 4 && this.n > 16) {
            ObjectLinkedOpenHashSet objectLinkedOpenHashSet = this;
            objectLinkedOpenHashSet.rehash(objectLinkedOpenHashSet.n / 2);
        }
        return true;
    }

    @Override
    public boolean remove(Object k2) {
        if (k2 == null) {
            if (this.containsNull) {
                k2 = this;
                this.containsNull = false;
                ((ObjectLinkedOpenHashSet)k2).key[((ObjectLinkedOpenHashSet)k2).n] = null;
                --((ObjectLinkedOpenHashSet)k2).size;
                Object object = k2;
                ((ObjectLinkedOpenHashSet)object).e(((ObjectLinkedOpenHashSet)object).n);
                if (((ObjectLinkedOpenHashSet)k2).n > ((ObjectLinkedOpenHashSet)k2).minN && ((ObjectLinkedOpenHashSet)k2).size < ((ObjectLinkedOpenHashSet)k2).maxFill / 4 && ((ObjectLinkedOpenHashSet)k2).n > 16) {
                    Object object2 = k2;
                    ((ObjectLinkedOpenHashSet)object2).rehash(((ObjectLinkedOpenHashSet)object2).n / 2);
                }
                return true;
            }
            return false;
        }
        K[] KArray = this.key;
        int n2 = HashCommon.mix(k2.hashCode()) & this.mask;
        K k3 = this.key[n2];
        if (k3 == null) {
            return false;
        }
        if (k2.equals(k3)) {
            return this.b(n2);
        }
        do {
            if ((k3 = KArray[n2 = n2 + 1 & this.mask]) != null) continue;
            return false;
        } while (!k2.equals(k3));
        return this.b(n2);
    }

    @Override
    public boolean contains(Object k2) {
        if (k2 == null) {
            return this.containsNull;
        }
        K[] KArray = this.key;
        int n2 = HashCommon.mix(k2.hashCode()) & this.mask;
        K k3 = this.key[n2];
        if (k3 == null) {
            return false;
        }
        if (k2.equals(k3)) {
            return true;
        }
        do {
            if ((k3 = KArray[n2 = n2 + 1 & this.mask]) != null) continue;
            return false;
        } while (!k2.equals(k3));
        return true;
    }

    public K get(Object k2) {
        if (k2 == null) {
            return this.key[this.n];
        }
        K[] KArray = this.key;
        int n2 = HashCommon.mix(k2.hashCode()) & this.mask;
        K k3 = this.key[n2];
        if (k3 == null) {
            return null;
        }
        if (k2.equals(k3)) {
            return k3;
        }
        do {
            if ((k3 = KArray[n2 = n2 + 1 & this.mask]) != null) continue;
            return null;
        } while (!k2.equals(k3));
        return k3;
    }

    @Override
    public K removeFirst() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        int n2 = this.first;
        if (this.size == 1) {
            ObjectLinkedOpenHashSet objectLinkedOpenHashSet = this;
            objectLinkedOpenHashSet.last = -1;
            objectLinkedOpenHashSet.first = -1;
        } else {
            this.first = (int)this.link[n2];
            if (this.first >= 0) {
                int n3 = this.first;
                this.link[n3] = this.link[n3] | 0xFFFFFFFF00000000L;
            }
        }
        K k2 = this.key[n2];
        --this.size;
        if (k2 == null) {
            this.containsNull = false;
            this.key[this.n] = null;
        } else {
            this.a(n2);
        }
        if (this.n > this.minN && this.size < this.maxFill / 4 && this.n > 16) {
            ObjectLinkedOpenHashSet objectLinkedOpenHashSet = this;
            objectLinkedOpenHashSet.rehash(objectLinkedOpenHashSet.n / 2);
        }
        return k2;
    }

    @Override
    public K removeLast() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        int n2 = this.last;
        if (this.size == 1) {
            ObjectLinkedOpenHashSet objectLinkedOpenHashSet = this;
            objectLinkedOpenHashSet.last = -1;
            objectLinkedOpenHashSet.first = -1;
        } else {
            this.last = (int)(this.link[n2] >>> 32);
            if (this.last >= 0) {
                int n3 = this.last;
                this.link[n3] = this.link[n3] | 0xFFFFFFFFL;
            }
        }
        K k2 = this.key[n2];
        --this.size;
        if (k2 == null) {
            this.containsNull = false;
            this.key[this.n] = null;
        } else {
            this.a(n2);
        }
        if (this.n > this.minN && this.size < this.maxFill / 4 && this.n > 16) {
            ObjectLinkedOpenHashSet objectLinkedOpenHashSet = this;
            objectLinkedOpenHashSet.rehash(objectLinkedOpenHashSet.n / 2);
        }
        return k2;
    }

    private void c(int n2) {
        if (this.size == 1 || this.first == n2) {
            return;
        }
        if (this.last == n2) {
            int n3 = this.last = (int)(this.link[n2] >>> 32);
            this.link[n3] = this.link[n3] | 0xFFFFFFFFL;
        } else {
            long l2 = this.link[n2];
            int n4 = (int)(l2 >>> 32);
            int n5 = (int)l2;
            int n6 = n4;
            this.link[n6] = this.link[n6] ^ (this.link[n4] ^ l2 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            int n7 = n5;
            this.link[n7] = this.link[n7] ^ (this.link[n5] ^ l2 & 0xFFFFFFFF00000000L) & 0xFFFFFFFF00000000L;
        }
        int n8 = this.first;
        this.link[n8] = this.link[n8] ^ (this.link[this.first] ^ ((long)n2 & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
        this.link[n2] = 0xFFFFFFFF00000000L | (long)this.first & 0xFFFFFFFFL;
        this.first = n2;
    }

    private void d(int n2) {
        if (this.size == 1 || this.last == n2) {
            return;
        }
        if (this.first == n2) {
            int n3 = this.first = (int)this.link[n2];
            this.link[n3] = this.link[n3] | 0xFFFFFFFF00000000L;
        } else {
            long l2 = this.link[n2];
            int n4 = (int)(l2 >>> 32);
            int n5 = (int)l2;
            int n6 = n4;
            this.link[n6] = this.link[n6] ^ (this.link[n4] ^ l2 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            int n7 = n5;
            this.link[n7] = this.link[n7] ^ (this.link[n5] ^ l2 & 0xFFFFFFFF00000000L) & 0xFFFFFFFF00000000L;
        }
        int n8 = this.last;
        this.link[n8] = this.link[n8] ^ (this.link[this.last] ^ (long)n2 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
        this.link[n2] = ((long)this.last & 0xFFFFFFFFL) << 32 | 0xFFFFFFFFL;
        this.last = n2;
    }

    /*
     * WARNING - void declaration
     */
    public boolean addAndMoveToFirst(K k2) {
        void var1_1;
        int n2;
        if (k2 == null) {
            if (this.containsNull) {
                ObjectLinkedOpenHashSet objectLinkedOpenHashSet = this;
                objectLinkedOpenHashSet.c(objectLinkedOpenHashSet.n);
                return false;
            }
            this.containsNull = true;
            n2 = this.n;
        } else {
            K[] KArray = this.key;
            n2 = HashCommon.mix(k2.hashCode()) & this.mask;
            while (KArray[n2] != null) {
                if (k2.equals(KArray[n2])) {
                    this.c(n2);
                    return false;
                }
                n2 = n2 + 1 & this.mask;
            }
        }
        this.key[n2] = var1_1;
        if (this.size == 0) {
            ObjectLinkedOpenHashSet objectLinkedOpenHashSet = this;
            objectLinkedOpenHashSet.first = objectLinkedOpenHashSet.last = n2;
            this.link[n2] = -1L;
        } else {
            int n3 = this.first;
            this.link[n3] = this.link[n3] ^ (this.link[this.first] ^ ((long)n2 & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
            this.link[n2] = 0xFFFFFFFF00000000L | (long)this.first & 0xFFFFFFFFL;
            this.first = n2;
        }
        if (this.size++ >= this.maxFill) {
            ObjectLinkedOpenHashSet objectLinkedOpenHashSet = this;
            objectLinkedOpenHashSet.rehash(HashCommon.arraySize(objectLinkedOpenHashSet.size, this.f));
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean addAndMoveToLast(K k2) {
        void var1_1;
        int n2;
        if (k2 == null) {
            if (this.containsNull) {
                ObjectLinkedOpenHashSet objectLinkedOpenHashSet = this;
                objectLinkedOpenHashSet.d(objectLinkedOpenHashSet.n);
                return false;
            }
            this.containsNull = true;
            n2 = this.n;
        } else {
            K[] KArray = this.key;
            n2 = HashCommon.mix(k2.hashCode()) & this.mask;
            while (KArray[n2] != null) {
                if (k2.equals(KArray[n2])) {
                    this.d(n2);
                    return false;
                }
                n2 = n2 + 1 & this.mask;
            }
        }
        this.key[n2] = var1_1;
        if (this.size == 0) {
            ObjectLinkedOpenHashSet objectLinkedOpenHashSet = this;
            objectLinkedOpenHashSet.first = objectLinkedOpenHashSet.last = n2;
            this.link[n2] = -1L;
        } else {
            int n3 = this.last;
            this.link[n3] = this.link[n3] ^ (this.link[this.last] ^ (long)n2 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            this.link[n2] = ((long)this.last & 0xFFFFFFFFL) << 32 | 0xFFFFFFFFL;
            this.last = n2;
        }
        if (this.size++ >= this.maxFill) {
            ObjectLinkedOpenHashSet objectLinkedOpenHashSet = this;
            objectLinkedOpenHashSet.rehash(HashCommon.arraySize(objectLinkedOpenHashSet.size, this.f));
        }
        return true;
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        this.containsNull = false;
        Arrays.fill(this.key, null);
        ObjectLinkedOpenHashSet objectLinkedOpenHashSet = this;
        objectLinkedOpenHashSet.last = -1;
        objectLinkedOpenHashSet.first = -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    private void e(int n2) {
        if (this.size == 0) {
            ObjectLinkedOpenHashSet objectLinkedOpenHashSet = this;
            objectLinkedOpenHashSet.last = -1;
            objectLinkedOpenHashSet.first = -1;
            return;
        }
        if (this.first == n2) {
            this.first = (int)this.link[n2];
            if (this.first >= 0) {
                int n3 = this.first;
                this.link[n3] = this.link[n3] | 0xFFFFFFFF00000000L;
            }
            return;
        }
        if (this.last == n2) {
            this.last = (int)(this.link[n2] >>> 32);
            if (this.last >= 0) {
                int n4 = this.last;
                this.link[n4] = this.link[n4] | 0xFFFFFFFFL;
            }
            return;
        }
        long l2 = this.link[n2];
        n2 = (int)(l2 >>> 32);
        int n5 = (int)l2;
        int n6 = n2;
        this.link[n6] = this.link[n6] ^ (this.link[n2] ^ l2 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
        int n7 = n5;
        this.link[n7] = this.link[n7] ^ (this.link[n5] ^ l2 & 0xFFFFFFFF00000000L) & 0xFFFFFFFF00000000L;
    }

    protected final void a(int n2, int n3) {
        if (this.size == 1) {
            ObjectLinkedOpenHashSet objectLinkedOpenHashSet = this;
            objectLinkedOpenHashSet.first = objectLinkedOpenHashSet.last = n3;
            this.link[n3] = -1L;
            return;
        }
        if (this.first == n2) {
            this.first = n3;
            int n4 = (int)this.link[n2];
            this.link[n4] = this.link[n4] ^ (this.link[(int)this.link[n2]] ^ ((long)n3 & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
            this.link[n3] = this.link[n2];
            return;
        }
        if (this.last == n2) {
            this.last = n3;
            int n5 = (int)(this.link[n2] >>> 32);
            this.link[n5] = this.link[n5] ^ (this.link[(int)(this.link[n2] >>> 32)] ^ (long)n3 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            this.link[n3] = this.link[n2];
            return;
        }
        long l2 = this.link[n2];
        n2 = (int)(l2 >>> 32);
        int n6 = (int)l2;
        int n7 = n2;
        this.link[n7] = this.link[n7] ^ (this.link[n2] ^ (long)n3 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
        int n8 = n6;
        this.link[n8] = this.link[n8] ^ (this.link[n6] ^ ((long)n3 & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
        this.link[n3] = l2;
    }

    @Override
    public K first() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.first];
    }

    @Override
    public K last() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.last];
    }

    @Override
    public ObjectSortedSet<K> tailSet(K from) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ObjectSortedSet<K> headSet(K to) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ObjectSortedSet<K> subSet(K from, K to) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Comparator<? super K> comparator() {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public ObjectListIterator<K> iterator(K from) {
        void var1_1;
        return new a(this, var1_1);
    }

    @Override
    public ObjectListIterator<K> iterator() {
        return new a(this);
    }

    @Override
    public ObjectSpliterator<K> spliterator() {
        return ax.a((ObjectIterator)this.iterator(), (long)h.a(this), (int)81);
    }

    @Override
    public void forEach(Consumer<? super K> action) {
        int n2 = this.first;
        while (n2 != -1) {
            int n3 = n2;
            n2 = (int)this.link[n3];
            action.accept(this.key[n3]);
        }
    }

    public boolean trim() {
        ObjectLinkedOpenHashSet objectLinkedOpenHashSet = this;
        return objectLinkedOpenHashSet.trim(objectLinkedOpenHashSet.size);
    }

    public boolean trim(int n2) {
        int n3 = HashCommon.nextPowerOfTwo((int)Math.ceil((float)n2 / this.f));
        if (n3 >= this.n || this.size > HashCommon.maxFill(n3, this.f)) {
            return true;
        }
        try {
            this.rehash(n3);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    protected void rehash(int newN) {
        void var1_1;
        K[] KArray = this.key;
        int n2 = newN - 1;
        Object[] objectArray = new Object[newN + 1];
        int n3 = this.first;
        int n4 = -1;
        int n5 = -1;
        long[] lArray = this.link;
        long[] lArray2 = new long[newN + 1];
        this.first = -1;
        int n6 = this.size;
        while (n6-- != 0) {
            int n7;
            if (KArray[n3] == null) {
                n7 = newN;
            } else {
                n7 = HashCommon.mix(KArray[n3].hashCode()) & n2;
                while (objectArray[n7] != null) {
                    n7 = n7 + 1 & n2;
                }
            }
            objectArray[n7] = KArray[n3];
            if (n4 != -1) {
                int n8 = n5;
                lArray2[n8] = lArray2[n8] ^ (lArray2[n5] ^ (long)n7 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
                int n9 = n7;
                lArray2[n9] = lArray2[n9] ^ (lArray2[n7] ^ ((long)n5 & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
                n5 = n7;
            } else {
                n5 = this.first = n7;
                lArray2[n7] = -1L;
            }
            n4 = n3;
            n3 = (int)lArray[n3];
        }
        this.link = lArray2;
        this.last = n5;
        if (n5 != -1) {
            int n10 = n5;
            lArray2[n10] = lArray2[n10] | 0xFFFFFFFFL;
        }
        this.n = var1_1;
        this.mask = n2;
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.key = objectArray;
    }

    public ObjectLinkedOpenHashSet<K> clone() {
        ObjectLinkedOpenHashSet objectLinkedOpenHashSet;
        try {
            objectLinkedOpenHashSet = (ObjectLinkedOpenHashSet)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        objectLinkedOpenHashSet.key = (Object[])this.key.clone();
        objectLinkedOpenHashSet.containsNull = this.containsNull;
        objectLinkedOpenHashSet.link = (long[])this.link.clone();
        return objectLinkedOpenHashSet;
    }

    @Override
    public int hashCode() {
        int n2 = 0;
        ObjectLinkedOpenHashSet objectLinkedOpenHashSet = this;
        int n3 = objectLinkedOpenHashSet.containsNull ? objectLinkedOpenHashSet.size - 1 : objectLinkedOpenHashSet.size;
        int n4 = 0;
        while (n3-- != 0) {
            while (this.key[n4] == null) {
                ++n4;
            }
            ObjectLinkedOpenHashSet objectLinkedOpenHashSet2 = this;
            if (objectLinkedOpenHashSet2 != objectLinkedOpenHashSet2.key[n4]) {
                n2 += this.key[n4].hashCode();
            }
            ++n4;
        }
        return n2;
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        ObjectBidirectionalIterator objectBidirectionalIterator = this.iterator();
        s2.defaultWriteObject();
        int n2 = this.size;
        while (n2-- != 0) {
            s2.writeObject(objectBidirectionalIterator.next());
        }
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        this.n = HashCommon.arraySize(this.size, this.f);
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.mask = this.n - 1;
        this.key = new Object[this.n + 1];
        Object[] objectArray = this.key;
        this.link = new long[this.n + 1];
        long[] lArray = this.link;
        int n2 = -1;
        ObjectLinkedOpenHashSet objectLinkedOpenHashSet = this;
        objectLinkedOpenHashSet.last = -1;
        objectLinkedOpenHashSet.first = -1;
        int n3 = this.size;
        while (n3-- != 0) {
            int n4;
            Object object = s2.readObject();
            if (object == null) {
                n4 = this.n;
                this.containsNull = true;
            } else {
                n4 = HashCommon.mix(object.hashCode()) & this.mask;
                if (objectArray[n4] != null) {
                    while (objectArray[n4 = n4 + 1 & this.mask] != null) {
                    }
                }
            }
            objectArray[n4] = object;
            if (this.first != -1) {
                int n5 = n2;
                lArray[n5] = lArray[n5] ^ (lArray[n2] ^ (long)n4 & 0xFFFFFFFFL) & 0xFFFFFFFFL;
                int n6 = n4;
                lArray[n6] = lArray[n6] ^ (lArray[n4] ^ ((long)n2 & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
                n2 = n4;
                continue;
            }
            n2 = this.first = n4;
            int n7 = n4;
            lArray[n7] = lArray[n7] | 0xFFFFFFFF00000000L;
        }
        this.last = n2;
        if (n2 != -1) {
            int n8 = n2;
            lArray[n8] = lArray[n8] | 0xFFFFFFFFL;
        }
    }

    private final class a
    implements ObjectListIterator<K> {
        private int a = -1;
        private int b = -1;
        private int c = -1;
        private int d = -1;
        private /* synthetic */ ObjectLinkedOpenHashSet e;

        a(ObjectLinkedOpenHashSet objectLinkedOpenHashSet) {
            this.e = objectLinkedOpenHashSet;
            this.b = objectLinkedOpenHashSet.first;
            this.d = 0;
        }

        a(ObjectLinkedOpenHashSet objectLinkedOpenHashSet, K k2) {
            this.e = objectLinkedOpenHashSet;
            if (k2 == null) {
                if (objectLinkedOpenHashSet.containsNull) {
                    this.b = (int)objectLinkedOpenHashSet.link[objectLinkedOpenHashSet.n];
                    this.a = objectLinkedOpenHashSet.n;
                    return;
                }
                throw new NoSuchElementException("The key " + k2 + " does not belong to this set.");
            }
            if (Objects.equals(objectLinkedOpenHashSet.key[objectLinkedOpenHashSet.last], k2)) {
                this.a = objectLinkedOpenHashSet.last;
                this.d = objectLinkedOpenHashSet.size;
                return;
            }
            K[] KArray = objectLinkedOpenHashSet.key;
            int n2 = HashCommon.mix(k2.hashCode()) & objectLinkedOpenHashSet.mask;
            while (KArray[n2] != null) {
                if (KArray[n2].equals(k2)) {
                    this.b = (int)objectLinkedOpenHashSet.link[n2];
                    this.a = n2;
                    return;
                }
                n2 = n2 + 1 & objectLinkedOpenHashSet.mask;
            }
            throw new NoSuchElementException("The key " + k2 + " does not belong to this set.");
        }

        @Override
        public final boolean hasNext() {
            return this.b != -1;
        }

        @Override
        public final boolean hasPrevious() {
            return this.a != -1;
        }

        @Override
        public final K next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.c = this.b;
            this.b = (int)this.e.link[this.c];
            this.a = this.c;
            if (this.d >= 0) {
                ++this.d;
            }
            return this.e.key[this.c];
        }

        @Override
        public final K previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.c = this.a;
            this.a = (int)(this.e.link[this.c] >>> 32);
            this.b = this.c;
            if (this.d >= 0) {
                --this.d;
            }
            return this.e.key[this.c];
        }

        @Override
        public final void forEachRemaining(Consumer<? super K> action) {
            K[] KArray = this.e.key;
            long[] lArray = this.e.link;
            while (this.b != -1) {
                this.c = this.b;
                this.b = (int)lArray[this.c];
                this.a = this.c;
                if (this.d >= 0) {
                    ++this.d;
                }
                action.accept(KArray[this.c]);
            }
        }

        private final void a() {
            if (this.d >= 0) {
                return;
            }
            if (this.a == -1) {
                this.d = 0;
                return;
            }
            if (this.b == -1) {
                this.d = this.e.size;
                return;
            }
            int n2 = this.e.first;
            this.d = 1;
            while (n2 != this.a) {
                n2 = (int)this.e.link[n2];
                ++this.d;
            }
        }

        @Override
        public final int nextIndex() {
            this.a();
            return this.d;
        }

        @Override
        public final int previousIndex() {
            this.a();
            return this.d - 1;
        }

        @Override
        public final void remove() {
            this.a();
            if (this.c == -1) {
                throw new IllegalStateException();
            }
            if (this.c == this.a) {
                --this.d;
                this.a = (int)(this.e.link[this.c] >>> 32);
            } else {
                this.b = (int)this.e.link[this.c];
            }
            --this.e.size;
            if (this.a == -1) {
                this.e.first = this.b;
            } else {
                int n2 = this.a;
                this.e.link[n2] = this.e.link[n2] ^ (this.e.link[this.a] ^ (long)this.b & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            }
            if (this.b == -1) {
                this.e.last = this.a;
            } else {
                int n3 = this.b;
                this.e.link[n3] = this.e.link[n3] ^ (this.e.link[this.b] ^ ((long)this.a & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
            }
            int n4 = this.c;
            this.c = -1;
            if (n4 == this.e.n) {
                this.e.containsNull = false;
                this.e.key[this.e.n] = null;
                return;
            }
            K[] KArray = this.e.key;
            while (true) {
                Object k2;
                int n5 = n4;
                n4 = n5 + 1 & this.e.mask;
                while (true) {
                    if ((k2 = KArray[n4]) == null) {
                        KArray[n5] = null;
                        return;
                    }
                    int n6 = HashCommon.mix(k2.hashCode()) & this.e.mask;
                    if (n5 > n4 ? n5 >= n6 && n6 > n4 : n5 >= n6 || n6 > n4) break;
                    n4 = n4 + 1 & this.e.mask;
                }
                KArray[n5] = k2;
                if (this.b == n4) {
                    this.b = n5;
                }
                if (this.a == n4) {
                    this.a = n5;
                }
                this.e.a(n4, n5);
            }
        }
    }
}

