/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.internal.InternalThreadLocalMap;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Map;

public abstract class TypeParameterMatcher {
    private static final TypeParameterMatcher NOOP = new TypeParameterMatcher(){

        @Override
        public boolean match(Object msg) {
            return true;
        }
    };

    public static TypeParameterMatcher get(Class<?> parameterType) {
        Map<Class<?>, TypeParameterMatcher> getCache = InternalThreadLocalMap.get().typeParameterMatcherGetCache();
        TypeParameterMatcher matcher = getCache.get(parameterType);
        if (matcher == null) {
            matcher = parameterType == Object.class ? NOOP : new ReflectiveMatcher(parameterType);
            getCache.put(parameterType, matcher);
        }
        return matcher;
    }

    public static TypeParameterMatcher find(Object object, Class<?> parametrizedSuperclass, String typeParamName) {
        TypeParameterMatcher matcher;
        Class<?> thisClass;
        Map<Class<?>, Map<String, TypeParameterMatcher>> findCache = InternalThreadLocalMap.get().typeParameterMatcherFindCache();
        Map<String, TypeParameterMatcher> map2 = findCache.get(thisClass = object.getClass());
        if (map2 == null) {
            map2 = new HashMap<String, TypeParameterMatcher>();
            findCache.put(thisClass, map2);
        }
        if ((matcher = map2.get(typeParamName)) == null) {
            matcher = TypeParameterMatcher.get(TypeParameterMatcher.find0(object, parametrizedSuperclass, typeParamName));
            map2.put(typeParamName, matcher);
        }
        return matcher;
    }

    private static Class<?> find0(Object object, Class<?> parametrizedSuperclass, String typeParamName) {
        Class<?> thisClass;
        Class<?> currentClass = thisClass = object.getClass();
        while (true) {
            if (currentClass.getSuperclass() == parametrizedSuperclass) {
                int typeParamIndex = -1;
                TypeVariable<Class<?>>[] typeParams = currentClass.getSuperclass().getTypeParameters();
                for (int i2 = 0; i2 < typeParams.length; ++i2) {
                    if (!typeParamName.equals(typeParams[i2].getName())) continue;
                    typeParamIndex = i2;
                    break;
                }
                if (typeParamIndex < 0) {
                    throw new IllegalStateException("unknown type parameter '" + typeParamName + "': " + parametrizedSuperclass);
                }
                Type genericSuperType = currentClass.getGenericSuperclass();
                if (!(genericSuperType instanceof ParameterizedType)) {
                    return Object.class;
                }
                Type[] actualTypeParams = ((ParameterizedType)genericSuperType).getActualTypeArguments();
                Type actualTypeParam = actualTypeParams[typeParamIndex];
                if (actualTypeParam instanceof ParameterizedType) {
                    actualTypeParam = ((ParameterizedType)actualTypeParam).getRawType();
                }
                if (actualTypeParam instanceof Class) {
                    return (Class)actualTypeParam;
                }
                if (actualTypeParam instanceof GenericArrayType) {
                    Type componentType = ((GenericArrayType)actualTypeParam).getGenericComponentType();
                    if (componentType instanceof ParameterizedType) {
                        componentType = ((ParameterizedType)componentType).getRawType();
                    }
                    if (componentType instanceof Class) {
                        return Array.newInstance((Class)componentType, 0).getClass();
                    }
                }
                if (actualTypeParam instanceof TypeVariable) {
                    TypeVariable v2 = (TypeVariable)actualTypeParam;
                    if (!(v2.getGenericDeclaration() instanceof Class)) {
                        return Object.class;
                    }
                    currentClass = thisClass;
                    parametrizedSuperclass = (Class)v2.getGenericDeclaration();
                    typeParamName = v2.getName();
                    if (parametrizedSuperclass.isAssignableFrom(thisClass)) continue;
                    return Object.class;
                }
                return TypeParameterMatcher.fail(thisClass, typeParamName);
            }
            if ((currentClass = currentClass.getSuperclass()) == null) break;
        }
        return TypeParameterMatcher.fail(thisClass, typeParamName);
    }

    private static Class<?> fail(Class<?> type2, String typeParamName) {
        throw new IllegalStateException("cannot determine the type of the type parameter '" + typeParamName + "': " + type2);
    }

    public abstract boolean match(Object var1);

    TypeParameterMatcher() {
    }

    private static final class ReflectiveMatcher
    extends TypeParameterMatcher {
        private final Class<?> type;

        ReflectiveMatcher(Class<?> type2) {
            this.type = type2;
        }

        @Override
        public boolean match(Object msg) {
            return this.type.isInstance(msg);
        }
    }
}

