/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usageView;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiQualifiedReferenceElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SmartPsiFileRange;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UsageInfo {
    public static final UsageInfo[] EMPTY_ARRAY = new UsageInfo[0];
    private static final Logger LOG = Logger.getInstance(UsageInfo.class);
    private final SmartPsiElementPointer<?> mySmartPointer;
    private final SmartPsiFileRange myPsiFileRange;
    @Nullable
    private Class<? extends PsiReference> myReferenceClass;
    public final boolean isNonCodeUsage;
    protected boolean myDynamicUsage;

    public UsageInfo(@NotNull PsiElement originalElement, int startOffset, int endOffset, boolean isNonCodeUsage) {
        int effectiveStart;
        int effectiveEnd;
        TextRange elementRange;
        if (originalElement == null) {
            UsageInfo.$$$reportNull$$$0(0);
        }
        PsiElement element = originalElement.getNavigationElement();
        PsiFile file2 = element.getContainingFile();
        PsiElement topElement = file2 == null ? element : file2;
        LOG.assertTrue(topElement.isValid(), element);
        boolean isNullOrBinary = file2 == null || file2.getFileType().isBinary();
        TextRange textRange = elementRange = isNullOrBinary ? TextRange.EMPTY_RANGE : element.getTextRange();
        if (elementRange == null) {
            throw new IllegalArgumentException("text range null for " + element + "; " + element.getClass());
        }
        if (startOffset == -1 && endOffset == -1) {
            if (isNullOrBinary) {
                effectiveEnd = 0;
                effectiveStart = 0;
            } else {
                effectiveStart = Math.max(0, element.getTextOffset() - elementRange.getStartOffset());
                effectiveEnd = Math.max(effectiveStart, elementRange.getLength());
            }
        } else {
            effectiveStart = startOffset;
            effectiveEnd = endOffset;
            if (element != originalElement) {
                PsiFile originalFile = originalElement.getContainingFile();
                if (originalFile == file2) {
                    int delta = originalElement.getTextRange().getStartOffset() - elementRange.getStartOffset();
                    effectiveStart += delta;
                    effectiveEnd += delta;
                } else {
                    throw new IllegalArgumentException("element.getNavigationElement() for element " + originalElement + "(" + startOffset + ", " + endOffset + ") from " + originalFile + " led to different file " + file2 + ", thus making passed offsets invalid. Specify -1 for start/end offsets to calculate correct offsets for navigation.");
                }
            }
        }
        if (effectiveStart < 0 || effectiveStart > effectiveEnd) {
            throw new IllegalArgumentException("element " + element + "; startOffset " + startOffset + "; endOffset=" + endOffset + "; effectiveStart=" + effectiveStart + "; effectiveEnd=" + effectiveEnd + "; elementRange=" + elementRange + "; element.getTextOffset()=" + element.getTextOffset());
        }
        Project project = topElement.getProject();
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance(project);
        this.mySmartPointer = smartPointerManager.createSmartPsiElementPointer(element, file2);
        if (!(file2 == null || isNullOrBinary || effectiveStart == element.getTextOffset() - elementRange.getStartOffset() && effectiveEnd == elementRange.getLength())) {
            TextRange rangeToStore = TextRange.create(effectiveStart, effectiveEnd).shiftRight(elementRange.getStartOffset());
            this.myPsiFileRange = smartPointerManager.createSmartPsiFileRangePointer(file2, rangeToStore);
        } else {
            this.myPsiFileRange = null;
        }
        this.isNonCodeUsage = isNonCodeUsage;
    }

    public UsageInfo(@NotNull SmartPsiElementPointer<?> smartPointer, @Nullable SmartPsiFileRange psiFileRange, boolean dynamicUsage, boolean nonCodeUsage) {
        if (smartPointer == null) {
            UsageInfo.$$$reportNull$$$0(1);
        }
        this(smartPointer, psiFileRange, dynamicUsage, nonCodeUsage, null);
    }

    public UsageInfo(@NotNull SmartPsiElementPointer<?> smartPointer, @Nullable SmartPsiFileRange psiFileRange, boolean dynamicUsage, boolean nonCodeUsage, @Nullable Class<? extends PsiReference> referenceClass) {
        if (smartPointer == null) {
            UsageInfo.$$$reportNull$$$0(2);
        }
        this.myDynamicUsage = dynamicUsage;
        this.isNonCodeUsage = nonCodeUsage;
        this.myPsiFileRange = psiFileRange;
        this.mySmartPointer = smartPointer;
        this.myReferenceClass = referenceClass;
    }

    public UsageInfo(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            UsageInfo.$$$reportNull$$$0(3);
        }
        Project project = psiFile.getProject();
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance(project);
        this.mySmartPointer = smartPointerManager.createSmartPsiElementPointer(psiFile);
        this.myPsiFileRange = null;
        this.isNonCodeUsage = true;
    }

    public UsageInfo(@NotNull PsiElement element, boolean isNonCodeUsage) {
        if (element == null) {
            UsageInfo.$$$reportNull$$$0(4);
        }
        this(element, -1, -1, isNonCodeUsage);
    }

    public UsageInfo(@NotNull PsiElement element, int startOffset, int endOffset) {
        if (element == null) {
            UsageInfo.$$$reportNull$$$0(5);
        }
        this(element, startOffset, endOffset, false);
    }

    public UsageInfo(@NotNull PsiElement element, @NotNull TextRange rangeInElement, boolean isNonCodeUsage) {
        if (element == null) {
            UsageInfo.$$$reportNull$$$0(6);
        }
        if (rangeInElement == null) {
            UsageInfo.$$$reportNull$$$0(7);
        }
        this(element, rangeInElement.getStartOffset(), rangeInElement.getEndOffset(), isNonCodeUsage);
    }

    public UsageInfo(@NotNull PsiReference reference) {
        if (reference == null) {
            UsageInfo.$$$reportNull$$$0(8);
        }
        this(reference.getElement(), reference.getRangeInElement().getStartOffset(), reference.getRangeInElement().getEndOffset());
        this.myReferenceClass = reference.getClass();
        this.myDynamicUsage = reference instanceof PsiPolyVariantReference ? ((PsiPolyVariantReference)reference).multiResolve(false).length == 0 : reference.resolve() == null;
    }

    public UsageInfo(@NotNull PsiQualifiedReferenceElement reference) {
        if (reference == null) {
            UsageInfo.$$$reportNull$$$0(9);
        }
        this((PsiElement)reference);
        this.myReferenceClass = reference.getClass();
    }

    public UsageInfo(@NotNull PsiElement element) {
        if (element == null) {
            UsageInfo.$$$reportNull$$$0(10);
        }
        this(element, false);
    }

    @NotNull
    public SmartPsiElementPointer<?> getSmartPointer() {
        SmartPsiElementPointer<?> smartPsiElementPointer = this.mySmartPointer;
        if (smartPsiElementPointer == null) {
            UsageInfo.$$$reportNull$$$0(11);
        }
        return smartPsiElementPointer;
    }

    public SmartPsiFileRange getPsiFileRange() {
        return this.myPsiFileRange;
    }

    public boolean isNonCodeUsage() {
        return this.isNonCodeUsage;
    }

    public void setDynamicUsage(boolean dynamicUsage) {
        this.myDynamicUsage = dynamicUsage;
    }

    @Nullable
    public Class<? extends PsiReference> getReferenceClass() {
        return this.myReferenceClass;
    }

    @Nullable
    public PsiElement getElement() {
        return this.mySmartPointer.getElement();
    }

    @Nullable
    public PsiReference getReference() {
        PsiElement element = this.getElement();
        return element == null ? null : element.getReference();
    }

    @Nullable(value="null means range is invalid")
    public @Nullable(value="null means range is invalid") ProperTextRange getRangeInElement() {
        ProperTextRange result2;
        boolean isNullOrBinary;
        PsiElement element = this.getElement();
        if (element == null) {
            return null;
        }
        PsiFile psiFile = this.getFile();
        boolean bl2 = isNullOrBinary = psiFile == null || psiFile.getFileType().isBinary();
        if (isNullOrBinary) {
            return new ProperTextRange(0, 0);
        }
        TextRange elementRange = element.getTextRange();
        if (this.myPsiFileRange == null) {
            int startOffset = element.getTextOffset();
            result2 = ProperTextRange.create(startOffset, elementRange.getEndOffset());
        } else {
            Segment rangeInFile = this.myPsiFileRange.getRange();
            if (rangeInFile == null) {
                return null;
            }
            result2 = ProperTextRange.create(rangeInFile);
        }
        int delta = elementRange.getStartOffset();
        return result2.getStartOffset() < delta ? null : result2.shiftRight(-delta);
    }

    @Nullable
    public Icon getIcon() {
        return null;
    }

    @NlsContexts.Tooltip
    public String getTooltipText() {
        return null;
    }

    public int getNavigationOffset() {
        boolean isNullOrBinary;
        Segment range;
        if (this.myPsiFileRange != null && (range = this.myPsiFileRange.getRange()) != null) {
            return range.getStartOffset();
        }
        PsiElement element = this.getElement();
        if (element == null) {
            return -1;
        }
        PsiFile psiFile = this.getFile();
        boolean bl2 = isNullOrBinary = psiFile == null || psiFile.getFileType().isBinary();
        if (isNullOrBinary) {
            return 0;
        }
        TextRange range2 = element.getTextRange();
        ProperTextRange rangeInElement = this.getRangeInElement();
        if (rangeInElement == null) {
            return -1;
        }
        return range2.getStartOffset() + rangeInElement.getStartOffset();
    }

    public Segment getNavigationRange() {
        Segment range;
        if (this.myPsiFileRange != null && (range = this.myPsiFileRange.getRange()) != null) {
            return range;
        }
        PsiElement element = this.getElement();
        if (element == null) {
            return null;
        }
        TextRange range2 = element.getTextRange();
        ProperTextRange rangeInElement = this.getRangeInElement();
        if (rangeInElement == null) {
            return null;
        }
        return ((TextRange)rangeInElement).shiftRight(range2.getStartOffset());
    }

    public boolean isValid() {
        if (this.isFileOrBinary()) {
            return true;
        }
        return this.getSegment() != null;
    }

    protected boolean isFileOrBinary() {
        PsiElement element = this.getElement();
        if (this.myPsiFileRange == null && element instanceof PsiFile) {
            return true;
        }
        PsiFile psiFile = this.getFile();
        return psiFile != null && psiFile.getFileType().isBinary();
    }

    @Nullable
    public Segment getSegment() {
        ProperTextRange rangeInElement;
        Document document;
        TextRange range;
        PsiElement element = this.getElement();
        if (element instanceof PsiFile && ((PsiFile)element).getFileType().isBinary()) {
            return null;
        }
        TextRange textRange = range = element != null ? element.getTextRange() : null;
        if (range == null) {
            return null;
        }
        TextRange.assertProperRange(range, element);
        if (element instanceof PsiFile && (document = PsiDocumentManager.getInstance(this.getProject()).getDocument((PsiFile)element)) != null) {
            range = new ProperTextRange(0, document.getTextLength());
        }
        if ((rangeInElement = this.getRangeInElement()) == null) {
            return null;
        }
        return new ProperTextRange(Math.min(range.getEndOffset(), range.getStartOffset() + rangeInElement.getStartOffset()), Math.min(range.getEndOffset(), range.getStartOffset() + rangeInElement.getEndOffset()));
    }

    private FileWithOffset offset() {
        Segment range;
        VirtualFile containingFile0 = this.getVirtualFile();
        int shift0 = 0;
        if (containingFile0 instanceof VirtualFileWindow) {
            shift0 = ((VirtualFileWindow)((Object)containingFile0)).getDocumentWindow().injectedToHost(0);
            containingFile0 = ((VirtualFileWindow)((Object)containingFile0)).getDelegate();
        }
        Segment segment = range = this.myPsiFileRange == null ? this.mySmartPointer.getPsiRange() : this.myPsiFileRange.getPsiRange();
        if (range == null) {
            return null;
        }
        return new FileWithOffset(containingFile0, range.getStartOffset() + shift0);
    }

    public int compareToByStartOffset(@NotNull UsageInfo info) {
        if (info == null) {
            UsageInfo.$$$reportNull$$$0(12);
        }
        FileWithOffset offset0 = this.offset();
        FileWithOffset offset1 = info.offset();
        if (offset0 == null || offset1 == null) {
            return (offset0 == null ? 0 : 1) - (offset1 == null ? 0 : 1);
        }
        VirtualFile file0 = offset0.myFile;
        VirtualFile file1 = offset1.myFile;
        if (file0 == null || file1 == null) {
            return (file0 == null ? 0 : 1) - (file1 == null ? 0 : 1);
        }
        if (file0.equals(file1)) {
            return Integer.compare(offset0.myOffset, offset1.myOffset);
        }
        return file0.getPath().compareTo(file1.getPath());
    }

    @NotNull
    public Project getProject() {
        Project project = this.mySmartPointer.getProject();
        if (project == null) {
            UsageInfo.$$$reportNull$$$0(13);
        }
        return project;
    }

    public final boolean isWritable() {
        PsiElement element = this.getElement();
        return element == null || element.isWritable();
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || !this.getClass().equals(o2.getClass())) {
            return false;
        }
        UsageInfo usageInfo = (UsageInfo)o2;
        if (this.isNonCodeUsage != usageInfo.isNonCodeUsage) {
            return false;
        }
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance(this.getProject());
        return smartPointerManager.pointToTheSameElement(this.mySmartPointer, usageInfo.mySmartPointer) && (this.myPsiFileRange == null || usageInfo.myPsiFileRange != null && smartPointerManager.pointToTheSameElement(this.myPsiFileRange, usageInfo.myPsiFileRange));
    }

    public int hashCode() {
        int result2 = this.mySmartPointer != null ? this.mySmartPointer.hashCode() : 0;
        result2 = 29 * result2 + (this.myPsiFileRange == null ? 0 : this.myPsiFileRange.hashCode());
        result2 = 29 * result2 + (this.isNonCodeUsage ? 1 : 0);
        return result2;
    }

    public String toString() {
        PsiReference reference = this.getReference();
        if (reference == null) {
            return super.toString();
        }
        return reference.getCanonicalText() + " (" + reference.getClass() + ")";
    }

    @Nullable
    public PsiFile getFile() {
        return this.mySmartPointer.getContainingFile();
    }

    @Nullable
    public VirtualFile getVirtualFile() {
        return this.mySmartPointer.getVirtualFile();
    }

    public boolean isDynamicUsage() {
        return this.myDynamicUsage;
    }

    @Nullable(value="null means could not copy because info is no longer valid")
    public @Nullable(value="null means could not copy because info is no longer valid") UsageInfo copy() {
        Object element = this.mySmartPointer.getElement();
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance(this.getProject());
        PsiFile containingFile = this.myPsiFileRange == null ? null : this.myPsiFileRange.getContainingFile();
        Segment segment = containingFile == null ? null : this.myPsiFileRange.getRange();
        TextRange range = segment == null ? null : TextRange.create(segment);
        SmartPsiFileRange psiFileRange = range == null ? null : smartPointerManager.createSmartPsiFileRangePointer(containingFile, range);
        SmartPsiElementPointer<?> pointer = element == null || !this.isValid() ? null : smartPointerManager.createSmartPsiElementPointer(element);
        return pointer == null ? null : new UsageInfo(pointer, psiFileRange, this.isDynamicUsage(), this.isNonCodeUsage(), this.getReferenceClass());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 13: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 11: 
            case 13: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalElement";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "smartPointer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeInElement";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/usageView/UsageInfo";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/usageView/UsageInfo";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSmartPointer";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 11: 
            case 13: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "compareToByStartOffset";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 11: 
            case 13: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FileWithOffset {
        private final VirtualFile myFile;
        private final int myOffset;

        private FileWithOffset(VirtualFile file2, int offset) {
            this.myFile = file2;
            this.myOffset = offset;
        }
    }
}

