/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.util;

import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00032\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0007\u00a8\u0006\n"}, d2={"fileNameIsLikeVersionedLibraryName", "", "name", "", "putMoreLikelyPluginJarsFirst", "", "pluginDirName", "filesInLibUnderPluginDir", "", "Ljava/nio/file/Path;", "intellij.platform.util"})
public final class PluginKt {
    @ApiStatus.Internal
    public static final void putMoreLikelyPluginJarsFirst(@NotNull String pluginDirName, @NotNull List<Path> filesInLibUnderPluginDir) {
        Intrinsics.checkNotNullParameter(pluginDirName, "pluginDirName");
        Intrinsics.checkNotNullParameter(filesInLibUnderPluginDir, "filesInLibUnderPluginDir");
        Collections.sort(filesInLibUnderPluginDir, (arg_0, arg_1) -> PluginKt.putMoreLikelyPluginJarsFirst$lambda$0(pluginDirName, arg_0, arg_1));
    }

    private static final boolean fileNameIsLikeVersionedLibraryName(String name) {
        int i2 = StringsKt.lastIndexOf$default((CharSequence)name, '-', 0, false, 6, null);
        if (i2 == -1) {
            return false;
        }
        if (i2 + 1 < name.length()) {
            char c2 = name.charAt(i2 + 1);
            return Character.isDigit(c2) || (c2 == 'm' || c2 == 'M') && i2 + 2 < name.length() && Character.isDigit(name.charAt(i2 + 2));
        }
        return false;
    }

    private static final int putMoreLikelyPluginJarsFirst$lambda$0(String $pluginDirName, Path o1, Path o2) {
        boolean o1EndsWithIdea;
        boolean o1StartsWithNeededName;
        boolean o1IsVersioned;
        Intrinsics.checkNotNullParameter($pluginDirName, "$pluginDirName");
        String o2Name = ((Object)o2.getFileName()).toString();
        String o1Name = ((Object)o1.getFileName()).toString();
        boolean o2StartsWithResources = StringsKt.startsWith$default(o2Name, "resources", false, 2, null);
        boolean o1StartsWithResources = StringsKt.startsWith$default(o1Name, "resources", false, 2, null);
        if (o2StartsWithResources != o1StartsWithResources) {
            return o2StartsWithResources ? -1 : 1;
        }
        boolean o2IsVersioned = PluginKt.fileNameIsLikeVersionedLibraryName(o2Name);
        if (o2IsVersioned != (o1IsVersioned = PluginKt.fileNameIsLikeVersionedLibraryName(o1Name))) {
            return o2IsVersioned ? -1 : 1;
        }
        boolean o2StartsWithNeededName = StringsKt.startsWith(o2Name, $pluginDirName, true);
        if (o2StartsWithNeededName != (o1StartsWithNeededName = StringsKt.startsWith(o1Name, $pluginDirName, true))) {
            return o2StartsWithNeededName ? 1 : -1;
        }
        boolean o2EndsWithIdea = StringsKt.endsWith$default(o2Name, "-idea.jar", false, 2, null);
        if (o2EndsWithIdea != (o1EndsWithIdea = StringsKt.endsWith$default(o1Name, "-idea.jar", false, 2, null))) {
            return o2EndsWithIdea ? 1 : -1;
        }
        return o1Name.length() - o2Name.length();
    }
}

