/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.openapi.util.Key;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.ElementPatternCondition;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PatternConditionPlus;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.ValuePatternCondition;
import com.intellij.util.PairProcessor;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ObjectPattern<T, Self extends ObjectPattern<T, Self>>
implements Cloneable,
ElementPattern<T> {
    private InitialPatternCondition<T> myInitialCondition;
    private Object myConditions;

    protected ObjectPattern(@NotNull InitialPatternCondition<T> condition) {
        if (condition == null) {
            ObjectPattern.$$$reportNull$$$0(0);
        }
        this.myInitialCondition = condition;
        this.myConditions = null;
    }

    protected ObjectPattern(final @NotNull Class<T> aClass) {
        if (aClass == null) {
            ObjectPattern.$$$reportNull$$$0(1);
        }
        this(new InitialPatternCondition<T>(aClass){

            @Override
            public boolean accepts(@Nullable Object o2, ProcessingContext context) {
                return aClass.isInstance(o2);
            }
        });
    }

    @Override
    public final boolean accepts(@Nullable Object t2) {
        return this.accepts(t2, new ProcessingContext());
    }

    @Override
    public boolean accepts(@Nullable Object o2, ProcessingContext context) {
        if (!this.myInitialCondition.accepts(o2, context)) {
            return false;
        }
        if (this.myConditions == null) {
            return true;
        }
        if (o2 == null) {
            return false;
        }
        if (this.myConditions instanceof PatternCondition) {
            return ((PatternCondition)this.myConditions).accepts(o2, context);
        }
        List list = (List)this.myConditions;
        int listSize = list.size();
        for (int i2 = 0; i2 < listSize; ++i2) {
            if (((PatternCondition)list.get(i2)).accepts(o2, context)) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public final ElementPatternCondition<T> getCondition() {
        if (this.myConditions == null) {
            return new ElementPatternCondition<T>(this.myInitialCondition);
        }
        if (this.myConditions instanceof PatternCondition) {
            PatternCondition singleCondition = (PatternCondition)this.myConditions;
            return new ElementPatternCondition(this.myInitialCondition, Collections.singletonList(singleCondition));
        }
        return new ElementPatternCondition<T>(this.myInitialCondition, (List)this.myConditions);
    }

    @NotNull
    public Self andNot(ElementPattern pattern) {
        Capture not = StandardPatterns.not(pattern);
        Self Self = this.and(not);
        if (Self == null) {
            ObjectPattern.$$$reportNull$$$0(2);
        }
        return Self;
    }

    @NotNull
    public Self andOr(ElementPattern ... patterns) {
        if (patterns == null) {
            ObjectPattern.$$$reportNull$$$0(3);
        }
        ElementPattern or = StandardPatterns.or(patterns);
        Self Self = this.and(or);
        if (Self == null) {
            ObjectPattern.$$$reportNull$$$0(4);
        }
        return Self;
    }

    @NotNull
    public Self and(ElementPattern pattern) {
        Self Self = this.with(new PatternConditionPlus<T, T>("and", pattern){

            @Override
            public boolean processValues(T t2, ProcessingContext context, PairProcessor<? super T, ? super ProcessingContext> processor) {
                return processor.process((ProcessingContext)t2, (ProcessingContext)((ProcessingContext)context));
            }
        });
        if (Self == null) {
            ObjectPattern.$$$reportNull$$$0(5);
        }
        return Self;
    }

    @NotNull
    public Self equalTo(final @NotNull T o2) {
        if (o2 == null) {
            ObjectPattern.$$$reportNull$$$0(6);
        }
        Self Self = this.with(new ValuePatternCondition<T>("equalTo"){

            @Override
            public boolean accepts(@NotNull T t2, ProcessingContext context) {
                if (t2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                return t2.equals(o2);
            }

            @Override
            public Collection<T> getValues() {
                return Collections.singletonList(o2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/patterns/ObjectPattern$3", "accepts"));
            }
        });
        if (Self == null) {
            ObjectPattern.$$$reportNull$$$0(7);
        }
        return Self;
    }

    @NotNull
    public Self oneOf(T ... values2) {
        int length;
        if (values2 == null) {
            ObjectPattern.$$$reportNull$$$0(8);
        }
        final Collection<T> list = (length = values2.length) == 1 ? Collections.singletonList(values2[0]) : (length >= 11 ? ContainerUtil.newHashSet(values2) : Arrays.asList(values2));
        Self Self = this.with(new ValuePatternCondition<T>("oneOf"){

            @Override
            public Collection<T> getValues() {
                return list;
            }

            @Override
            public boolean accepts(@NotNull T t2, ProcessingContext context) {
                if (t2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                return list.contains(t2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/patterns/ObjectPattern$4", "accepts"));
            }
        });
        if (Self == null) {
            ObjectPattern.$$$reportNull$$$0(9);
        }
        return Self;
    }

    @NotNull
    public Self oneOf(final Collection<T> set) {
        Self Self = this.with(new ValuePatternCondition<T>("oneOf"){

            @Override
            public Collection<T> getValues() {
                return set;
            }

            @Override
            public boolean accepts(@NotNull T t2, ProcessingContext context) {
                if (t2 == null) {
                    5.$$$reportNull$$$0(0);
                }
                return set.contains(t2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/patterns/ObjectPattern$5", "accepts"));
            }
        });
        if (Self == null) {
            ObjectPattern.$$$reportNull$$$0(10);
        }
        return Self;
    }

    @NotNull
    public Self isNull() {
        return this.adapt(new ElementPatternCondition(new InitialPatternCondition(Object.class){

            @Override
            public boolean accepts(@Nullable Object o2, ProcessingContext context) {
                return o2 == null;
            }
        }));
    }

    @NotNull
    public Self notNull() {
        return this.adapt(new ElementPatternCondition(new InitialPatternCondition(Object.class){

            @Override
            public boolean accepts(@Nullable Object o2, ProcessingContext context) {
                return o2 != null;
            }
        }));
    }

    @NotNull
    public Self save(final @NotNull Key<? super T> key) {
        if (key == null) {
            ObjectPattern.$$$reportNull$$$0(11);
        }
        Self Self = this.with(new PatternCondition<T>("save"){

            @Override
            public boolean accepts(@NotNull T t2, ProcessingContext context) {
                if (t2 == null) {
                    8.$$$reportNull$$$0(0);
                }
                context.put(key, t2);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/patterns/ObjectPattern$8", "accepts"));
            }
        });
        if (Self == null) {
            ObjectPattern.$$$reportNull$$$0(12);
        }
        return Self;
    }

    @NotNull
    public Self save(final @NonNls String key) {
        Self Self = this.with(new PatternCondition<T>("save"){

            @Override
            public boolean accepts(@NotNull T t2, ProcessingContext context) {
                if (t2 == null) {
                    9.$$$reportNull$$$0(0);
                }
                context.put(key, t2);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/patterns/ObjectPattern$9", "accepts"));
            }
        });
        if (Self == null) {
            ObjectPattern.$$$reportNull$$$0(13);
        }
        return Self;
    }

    @NotNull
    public Self with(@NotNull PatternCondition<? super T> pattern) {
        if (pattern == null) {
            ObjectPattern.$$$reportNull$$$0(14);
        }
        ElementPatternCondition<? super T> condition = this.getCondition().append(pattern);
        return this.adapt(condition);
    }

    @NotNull
    private Self adapt(@NotNull ElementPatternCondition<T> condition) {
        ObjectPattern objectPattern;
        if (condition == null) {
            ObjectPattern.$$$reportNull$$$0(15);
        }
        try {
            ObjectPattern s2 = (ObjectPattern)this.clone();
            s2.myInitialCondition = condition.getInitialCondition();
            List<PatternCondition<T>> conditions = condition.getConditions();
            s2.myConditions = conditions.isEmpty() ? null : (conditions.size() == 1 ? conditions.get(0) : conditions);
            objectPattern = s2;
        }
        catch (CloneNotSupportedException e2) {
            throw new RuntimeException(e2);
        }
        if (objectPattern == null) {
            ObjectPattern.$$$reportNull$$$0(16);
        }
        return (Self)objectPattern;
    }

    @NotNull
    public Self without(final PatternCondition<? super T> pattern) {
        Self Self = this.with(new PatternCondition<T>("without"){

            @Override
            public boolean accepts(@NotNull T o2, ProcessingContext context) {
                if (o2 == null) {
                    10.$$$reportNull$$$0(0);
                }
                return !pattern.accepts(o2, context);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/patterns/ObjectPattern$10", "accepts"));
            }
        });
        if (Self == null) {
            ObjectPattern.$$$reportNull$$$0(17);
        }
        return Self;
    }

    public String toString() {
        return this.getCondition().toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 16: 
            case 17: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 16: 
            case 17: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/patterns/ObjectPattern";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patterns";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/patterns/ObjectPattern";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "andNot";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "andOr";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "and";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "equalTo";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "oneOf";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "save";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "adapt";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "without";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 16: 
            case 17: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "andOr";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "equalTo";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "oneOf";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "save";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "with";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "adapt";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class Capture<T>
    extends ObjectPattern<T, Capture<T>> {
        public Capture(@NotNull Class<T> aClass) {
            if (aClass == null) {
                Capture.$$$reportNull$$$0(0);
            }
            super(aClass);
        }

        public Capture(@NotNull InitialPatternCondition<T> condition) {
            if (condition == null) {
                Capture.$$$reportNull$$$0(1);
            }
            super(condition);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "aClass";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "condition";
                    break;
                }
            }
            objectArray[1] = "com/intellij/patterns/ObjectPattern$Capture";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

