/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lexer;

import com.intellij.lexer.LexerBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class StringLiteralLexer
extends LexerBase {
    private static final Logger LOG = Logger.getInstance(StringLiteralLexer.class);
    private static final short AFTER_FIRST_QUOTE = 1;
    private static final short AFTER_LAST_QUOTE = 2;
    public static final char NO_QUOTE_CHAR = '\uffff';
    protected CharSequence myBuffer;
    protected int myStart;
    protected int myEnd;
    private int myState;
    private int myLastState;
    protected int myBufferEnd;
    protected final char myQuoteChar;
    protected final IElementType myOriginalLiteralToken;
    private final boolean myCanEscapeEolOrFramingSpaces;
    private final String myAdditionalValidEscapes;
    private boolean mySeenEscapedSpacesOnly;
    private final boolean myAllowOctal;
    private final boolean myAllowHex;

    public StringLiteralLexer(char quoteChar, IElementType originalLiteralToken) {
        this(quoteChar, originalLiteralToken, false, null);
    }

    public StringLiteralLexer(char quoteChar, IElementType originalLiteralToken, boolean canEscapeEolOrFramingSpaces, String additionalValidEscapes) {
        this(quoteChar, originalLiteralToken, canEscapeEolOrFramingSpaces, additionalValidEscapes, true, false);
    }

    public StringLiteralLexer(char quoteChar, IElementType originalLiteralToken, boolean canEscapeEolOrFramingSpaces, String additionalValidEscapes, boolean allowOctal, boolean allowHex) {
        this.myQuoteChar = quoteChar;
        this.myOriginalLiteralToken = originalLiteralToken;
        this.myCanEscapeEolOrFramingSpaces = canEscapeEolOrFramingSpaces;
        this.myAdditionalValidEscapes = additionalValidEscapes;
        this.myAllowOctal = allowOctal;
        this.myAllowHex = allowHex;
    }

    @Override
    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            StringLiteralLexer.$$$reportNull$$$0(0);
        }
        this.myBuffer = buffer;
        this.myStart = startOffset;
        this.myState = this.myQuoteChar == '\uffff' ? 1 : initialState;
        this.myLastState = initialState;
        this.myBufferEnd = endOffset;
        this.myEnd = this.locateToken(this.myStart);
        this.mySeenEscapedSpacesOnly = true;
    }

    @Override
    public int getState() {
        return this.myLastState;
    }

    @Override
    public IElementType getTokenType() {
        if (this.myStart >= this.myEnd) {
            return null;
        }
        if (this.myBuffer.charAt(this.myStart) != '\\') {
            this.mySeenEscapedSpacesOnly = false;
            return this.myOriginalLiteralToken;
        }
        if (this.myStart + 1 >= this.myEnd) {
            return this.handleSingleSlashEscapeSequence();
        }
        char nextChar = this.myBuffer.charAt(this.myStart + 1);
        this.mySeenEscapedSpacesOnly &= nextChar == ' ';
        if (this.myCanEscapeEolOrFramingSpaces && (nextChar == '\n' || nextChar == ' ' && (this.mySeenEscapedSpacesOnly || this.isTrailingSpace(this.myStart + 2)))) {
            return StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
        }
        if (nextChar == 'u') {
            return this.getUnicodeEscapeSequenceType();
        }
        if (nextChar == 'x' && this.myAllowHex) {
            return this.getHexCodedEscapeSeq();
        }
        switch (nextChar) {
            case '0': {
                if (this.shouldAllowSlashZero()) {
                    return StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
                }
            }
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': {
                if (!this.myAllowOctal) {
                    return StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN;
                }
            }
            case '\"': 
            case '\'': 
            case '\\': 
            case 'b': 
            case 'f': 
            case 'n': 
            case 'r': 
            case 't': {
                return StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
            }
        }
        if (this.myAdditionalValidEscapes != null && this.myAdditionalValidEscapes.indexOf(nextChar) != -1) {
            return StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
        }
        return StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN;
    }

    protected boolean shouldAllowSlashZero() {
        return false;
    }

    @NotNull
    protected IElementType handleSingleSlashEscapeSequence() {
        IElementType iElementType = StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN;
        if (iElementType == null) {
            StringLiteralLexer.$$$reportNull$$$0(1);
        }
        return iElementType;
    }

    protected IElementType getHexCodedEscapeSeq() {
        return this.getStandardLimitedHexCodedEscapeSeq(4);
    }

    @NotNull
    protected IElementType getUnicodeEscapeSequenceType() {
        IElementType iElementType = this.getStandardLimitedHexCodedEscapeSeq(6);
        if (iElementType == null) {
            StringLiteralLexer.$$$reportNull$$$0(2);
        }
        return iElementType;
    }

    @NotNull
    protected IElementType getStandardLimitedHexCodedEscapeSeq(int offsetLimit) {
        for (int i2 = this.myStart + 2; i2 < this.myStart + offsetLimit; ++i2) {
            if (i2 < this.myEnd && StringUtil.isHexDigit(this.myBuffer.charAt(i2))) continue;
            IElementType iElementType = StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN;
            if (iElementType == null) {
                StringLiteralLexer.$$$reportNull$$$0(3);
            }
            return iElementType;
        }
        IElementType iElementType = StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
        if (iElementType == null) {
            StringLiteralLexer.$$$reportNull$$$0(4);
        }
        return iElementType;
    }

    private boolean isTrailingSpace(int start) {
        for (int i2 = start; i2 < this.myBufferEnd; i2 += 2) {
            char c2 = this.myBuffer.charAt(i2);
            if (c2 != '\\') {
                return false;
            }
            if (i2 == this.myBufferEnd - 1) {
                return false;
            }
            if (this.myBuffer.charAt(i2 + 1) == ' ') continue;
            return false;
        }
        return true;
    }

    @Override
    public int getTokenStart() {
        return this.myStart;
    }

    @Override
    public int getTokenEnd() {
        return this.myEnd;
    }

    private int locateToken(int start) {
        if (start == this.myBufferEnd) {
            this.myState = 2;
        }
        if (this.myState == 2) {
            return start;
        }
        int i2 = start;
        if (this.myBuffer.charAt(i2) == '\\') {
            LOG.assertTrue(this.myState == 1, this);
            if (++i2 == this.myBufferEnd || this.myBuffer.charAt(i2) == '\n' && !this.myCanEscapeEolOrFramingSpaces) {
                this.myState = 2;
                return i2;
            }
            if (this.myAllowOctal && this.myBuffer.charAt(i2) >= '0' && this.myBuffer.charAt(i2) <= '7') {
                char first2 = this.myBuffer.charAt(i2);
                if (++i2 < this.myBufferEnd && this.myBuffer.charAt(i2) >= '0' && this.myBuffer.charAt(i2) <= '7' && ++i2 < this.myBufferEnd && first2 <= '3' && this.myBuffer.charAt(i2) >= '0' && this.myBuffer.charAt(i2) <= '7') {
                    ++i2;
                }
                return i2;
            }
            if (this.myAllowHex && this.myBuffer.charAt(i2) == 'x') {
                return this.locateHexEscapeSequence(start, i2);
            }
            if (this.myBuffer.charAt(i2) == 'u') {
                return this.locateUnicodeEscapeSequence(start, i2);
            }
            int additionalLocation = this.locateAdditionalEscapeSequence(start, i2);
            if (additionalLocation != -1) {
                return additionalLocation;
            }
            return i2 + 1;
        }
        LOG.assertTrue(this.myState == 1 || this.myBuffer.charAt(i2) == this.myQuoteChar, this);
        while (i2 < this.myBufferEnd) {
            if (this.myBuffer.charAt(i2) == '\\') {
                return i2;
            }
            if (this.myState == 1 && this.myBuffer.charAt(i2) == this.myQuoteChar) {
                if (i2 + 1 == this.myBufferEnd) {
                    this.myState = 2;
                }
                return i2 + 1;
            }
            ++i2;
            this.myState = 1;
        }
        return i2;
    }

    protected int locateHexEscapeSequence(int start, int i2) {
        ++i2;
        while (i2 < start + 4) {
            if (i2 == this.myBufferEnd || this.myBuffer.charAt(i2) == '\n' || this.myBuffer.charAt(i2) == this.myQuoteChar) {
                return i2;
            }
            ++i2;
        }
        return i2;
    }

    protected int locateUnicodeEscapeSequence(int start, int i2) {
        ++i2;
        while (i2 < start + 6) {
            if (i2 == this.myBufferEnd || this.myBuffer.charAt(i2) == '\n' || this.myBuffer.charAt(i2) == this.myQuoteChar) {
                return i2;
            }
            ++i2;
        }
        return i2;
    }

    protected int locateAdditionalEscapeSequence(int start, int indexOfCharAfterSlash) {
        return -1;
    }

    @Override
    public void advance() {
        this.myLastState = this.myState;
        this.myStart = this.myEnd;
        this.myEnd = this.locateToken(this.myStart);
    }

    @Override
    @NotNull
    public CharSequence getBufferSequence() {
        CharSequence charSequence = this.myBuffer;
        if (charSequence == null) {
            StringLiteralLexer.$$$reportNull$$$0(5);
        }
        return charSequence;
    }

    @Override
    public int getBufferEnd() {
        return this.myBufferEnd;
    }

    public String toString() {
        return "StringLiteralLexer {myAllowHex=" + this.myAllowHex + ", myAllowOctal=" + this.myAllowOctal + ", mySeenEscapedSpacesOnly=" + this.mySeenEscapedSpacesOnly + ", myAdditionalValidEscapes='" + this.myAdditionalValidEscapes + '\'' + ", myCanEscapeEolOrFramingSpaces=" + this.myCanEscapeEolOrFramingSpaces + ", myOriginalLiteralToken=" + this.myOriginalLiteralToken + ", myQuoteChar=" + this.myQuoteChar + ", myBufferEnd=" + this.myBufferEnd + ", myLastState=" + this.myLastState + ", myState=" + this.myState + ", myEnd=" + this.myEnd + ", myStart=" + this.myStart + ", myToken=" + (this.myBuffer == null || this.myEnd < this.myStart || this.myEnd > this.myBuffer.length() ? null : this.myBuffer.subSequence(this.myStart, this.myEnd)) + '}';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lexer/StringLiteralLexer";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lexer/StringLiteralLexer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "handleSingleSlashEscapeSequence";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnicodeEscapeSequenceType";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getStandardLimitedHexCodedEscapeSeq";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBufferSequence";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

