/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lexer;

import com.intellij.util.ArrayUtilRt;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

class MutableRandomAccessQueue<T> {
    private Object[] myArray;
    private int myFirst;
    private int myLast;
    private boolean isWrapped;

    MutableRandomAccessQueue(int initialCapacity) {
        this.myArray = initialCapacity > 0 ? new Object[initialCapacity] : ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    }

    void addLast(T object) {
        int currentSize = this.size();
        if (currentSize == this.myArray.length) {
            this.myArray = this.normalize(Math.max(currentSize * 3 / 2, 10));
            this.myFirst = 0;
            this.myLast = currentSize;
            this.isWrapped = false;
        }
        this.myArray[this.myLast] = object;
        ++this.myLast;
        if (this.myLast == this.myArray.length) {
            this.isWrapped = !this.isWrapped;
            this.myLast = 0;
        }
    }

    void removeLast() {
        if (this.myLast == 0) {
            this.isWrapped = !this.isWrapped;
            this.myLast = this.myArray.length;
        }
        --this.myLast;
        this.myArray[this.myLast] = null;
    }

    private T getRaw(int last2) {
        return (T)this.myArray[last2];
    }

    boolean isEmpty() {
        return this.size() == 0;
    }

    int size() {
        return this.isWrapped ? this.myArray.length - this.myFirst + this.myLast : this.myLast - this.myFirst;
    }

    T pullFirst() {
        T result2 = this.peekFirst();
        this.myArray[this.myFirst] = null;
        ++this.myFirst;
        if (this.myFirst == this.myArray.length) {
            this.myFirst = 0;
            this.isWrapped = !this.isWrapped;
        }
        return result2;
    }

    T peekFirst() {
        if (this.isEmpty()) {
            throw new IndexOutOfBoundsException("queue is empty");
        }
        return this.getRaw(this.myFirst);
    }

    private int copyFromTo(int first2, int last2, Object[] result2, int destinationPos) {
        int length = last2 - first2;
        System.arraycopy(this.myArray, first2, result2, destinationPos, length);
        return length;
    }

    private T @NotNull [] normalize(int capacity) {
        Object[] result2 = new Object[capacity];
        return this.normalize(result2);
    }

    private T @NotNull [] normalize(T[] result2) {
        if (this.isWrapped) {
            int tailLength = this.copyFromTo(this.myFirst, this.myArray.length, result2, 0);
            this.copyFromTo(0, this.myLast, result2, tailLength);
        } else {
            this.copyFromTo(this.myFirst, this.myLast, result2, 0);
        }
        if (result2 == null) {
            MutableRandomAccessQueue.$$$reportNull$$$0(0);
        }
        return result2;
    }

    void clear() {
        Arrays.fill(this.myArray, null);
        this.myLast = 0;
        this.myFirst = 0;
        this.isWrapped = false;
    }

    T set(int index, T value) {
        int arrayIndex = this.myFirst + index;
        if (this.isWrapped && arrayIndex >= this.myArray.length) {
            arrayIndex -= this.myArray.length;
        }
        T old = this.getRaw(arrayIndex);
        this.myArray[arrayIndex] = value;
        return old;
    }

    T get(int index) {
        int arrayIndex = this.myFirst + index;
        if (this.isWrapped && arrayIndex >= this.myArray.length) {
            arrayIndex -= this.myArray.length;
        }
        return this.getRaw(arrayIndex);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lexer/MutableRandomAccessQueue", "normalize"));
    }
}

