/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.Platform;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class CommandLineUtil {
    private static final char INESCAPABLE_QUOTE = '\uefef';
    private static final Pattern WIN_BACKSLASHES_PRECEDING_QUOTE = Pattern.compile("(\\\\+)(?=\"|$)");
    private static final Pattern WIN_CARET_SPECIAL = Pattern.compile("[&<>()@^|!%]");
    private static final Pattern WIN_QUOTE_SPECIAL = Pattern.compile("[ \t\"*?\\[{}~()']");
    private static final Pattern WIN_QUIET_COMMAND = Pattern.compile("((?:@\\s*)++)(.*)", 2);
    private static final String SHELL_WHITELIST_CHARACTERS = "-._/@=";
    private static final char Q = '\"';
    private static final String QQ = "\"\"";

    @NotNull
    public static String specialQuote(@NotNull String parameter) {
        if (parameter == null) {
            CommandLineUtil.$$$reportNull$$$0(0);
        }
        String string2 = CommandLineUtil.quote(parameter, '\uefef');
        if (string2 == null) {
            CommandLineUtil.$$$reportNull$$$0(1);
        }
        return string2;
    }

    @NotNull
    public static List<String> toCommandLine(@NotNull @NotNull List<@NotNull String> command2) {
        if (command2 == null) {
            CommandLineUtil.$$$reportNull$$$0(2);
        }
        assert (!command2.isEmpty());
        return CommandLineUtil.toCommandLine(command2.get(0), command2.subList(1, command2.size()));
    }

    @NotNull
    public static List<String> toCommandLine(@NotNull String command2, @NotNull @NotNull List<@NotNull String> parameters2) {
        if (command2 == null) {
            CommandLineUtil.$$$reportNull$$$0(3);
        }
        if (parameters2 == null) {
            CommandLineUtil.$$$reportNull$$$0(4);
        }
        return CommandLineUtil.toCommandLine(command2, parameters2, Platform.current());
    }

    @NotNull
    public static List<String> toCommandLine(@NotNull String command2, @NotNull @NotNull List<@NotNull String> parameters2, @NotNull Platform platform) {
        if (command2 == null) {
            CommandLineUtil.$$$reportNull$$$0(5);
        }
        if (parameters2 == null) {
            CommandLineUtil.$$$reportNull$$$0(6);
        }
        if (platform == null) {
            CommandLineUtil.$$$reportNull$$$0(7);
        }
        ArrayList<String> commandLine = new ArrayList<String>(parameters2.size() + 1);
        commandLine.add(FileUtilRt.toSystemDependentName((String)command2, (char)platform.fileSeparator));
        if (platform != Platform.WINDOWS) {
            for (String parameter : parameters2) {
                if (CommandLineUtil.isQuoted(parameter, '\uefef')) {
                    parameter = CommandLineUtil.quote(StringUtilRt.unquoteString((String)parameter, (char)'\uefef'), '\"');
                }
                commandLine.add(parameter);
            }
        } else {
            CommandLineUtil.addToWindowsCommandLine(command2, parameters2, commandLine);
        }
        ArrayList<String> arrayList = commandLine;
        if (arrayList == null) {
            CommandLineUtil.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    private static void addToWindowsCommandLine(@NotNull String command2, @NotNull @NotNull List<@NotNull String> parameters2, @NotNull @NotNull List<? super @NotNull String> commandLine) {
        if (command2 == null) {
            CommandLineUtil.$$$reportNull$$$0(9);
        }
        if (parameters2 == null) {
            CommandLineUtil.$$$reportNull$$$0(10);
        }
        if (commandLine == null) {
            CommandLineUtil.$$$reportNull$$$0(11);
        }
        boolean isCmdParam = CommandLineUtil.isWinShell(command2);
        int cmdInvocationDepth = CommandLineUtil.isWinShellScript(command2) ? 2 : (isCmdParam ? 1 : 0);
        QuoteFlag quoteFlag = new QuoteFlag(false);
        for (int i2 = 0; i2 < parameters2.size(); ++i2) {
            boolean inescapableQuoting;
            String parameter = parameters2.get(i2);
            boolean bl2 = inescapableQuoting = !(parameter = StringUtilRt.unquoteString((String)parameter, (char)'\uefef')).equals(parameters2.get(i2));
            if (parameter.isEmpty()) {
                commandLine.add(QQ);
                continue;
            }
            if (isCmdParam && parameter.startsWith("/") && parameter.length() == 2) {
                commandLine.add(parameter);
                continue;
            }
            String parameterPrefix = "";
            if (isCmdParam) {
                Matcher m2 = WIN_QUIET_COMMAND.matcher(parameter);
                if (m2.matches()) {
                    parameterPrefix = m2.group(1);
                    parameter = m2.group(2);
                }
                if (parameter.equalsIgnoreCase("echo")) {
                    String parametersJoin = String.join((CharSequence)" ", parameters2.subList(i2, parameters2.size()));
                    quoteFlag.toggle();
                    parameter = CommandLineUtil.escapeParameter(parametersJoin, quoteFlag, cmdInvocationDepth, false);
                    commandLine.add(parameter);
                    break;
                }
                if (!parameter.equalsIgnoreCase("call") && ((isCmdParam = CommandLineUtil.isWinShell(parameter)) || CommandLineUtil.isWinShellScript(parameter))) {
                    ++cmdInvocationDepth;
                }
            }
            parameter = cmdInvocationDepth > 0 && !isCmdParam || inescapableQuoting ? CommandLineUtil.escapeParameter(parameter, quoteFlag, cmdInvocationDepth, !inescapableQuoting) : CommandLineUtil.backslashEscapeQuotes(parameter);
            commandLine.add(parameterPrefix.isEmpty() ? parameter : parameterPrefix + parameter);
        }
    }

    private static String escapeParameter(String s2, QuoteFlag quoteFlag, int cmdInvocationDepth, boolean escapeQuotingInside) {
        String escapingCarets = StringUtil.repeatSymbol('^', (1 << cmdInvocationDepth) - 1);
        return escapeQuotingInside ? CommandLineUtil.quoteEscape(s2, quoteFlag, escapingCarets) : CommandLineUtil.caretEscape(s2, quoteFlag, escapingCarets);
    }

    private static String caretEscape(String s2, QuoteFlag quoteFlag, String escapingCarets) {
        StringBuilder sb = new StringBuilder().append('\"');
        quoteFlag.toggle();
        int lastPos = 0;
        Matcher m2 = WIN_CARET_SPECIAL.matcher(s2);
        while (m2.find()) {
            quoteFlag.update(s2, lastPos, m2.start());
            sb.append(s2, lastPos, m2.start());
            if (!quoteFlag.enabled) {
                sb.append(escapingCarets);
            }
            sb.append(m2.group());
            lastPos = m2.end();
        }
        quoteFlag.update(s2, lastPos, s2.length());
        sb.append(s2, lastPos, s2.length());
        quoteFlag.toggle();
        return sb.append('\"').toString();
    }

    private static String quoteEscape(String s2, QuoteFlag quoteFlag, String escapingCarets) {
        StringBuilder sb = new StringBuilder();
        int lastPos = 0;
        Matcher m2 = WIN_CARET_SPECIAL.matcher(s2);
        while (m2.find()) {
            quoteFlag.update(s2, lastPos, m2.start());
            CommandLineUtil.appendQuoted(sb, s2.substring(lastPos, m2.start()));
            String specialText = m2.group();
            boolean isCaret = specialText.equals("^");
            if (isCaret) {
                specialText = escapingCarets + specialText;
            }
            if (isCaret == quoteFlag.enabled) {
                CommandLineUtil.appendQuoted(sb, specialText);
            } else {
                sb.append(specialText);
            }
            lastPos = m2.end();
        }
        quoteFlag.update(s2, lastPos, s2.length());
        CommandLineUtil.appendQuoted(sb, s2.substring(lastPos));
        if (!CommandLineUtil.isQuoted(sb, '\"') && StringUtil.indexOfAny(sb, " \t") >= 0) {
            if (sb.charAt(0) != '\"') {
                sb.insert(0, QQ);
            }
            if (sb.charAt(sb.length() - 1) != '\"') {
                sb.append(QQ);
            }
        }
        return sb.toString();
    }

    private static void appendQuoted(StringBuilder sb, String s2) {
        int numTrailingBackslashes;
        if (s2.isEmpty()) {
            return;
        }
        if (WIN_CARET_SPECIAL.matcher(s2 = CommandLineUtil.backslashEscapeQuotes(s2)).find()) {
            s2 = CommandLineUtil.quote(s2, '\"');
        }
        if ((numTrailingBackslashes = CommandLineUtil.removeClosingQuote(sb)) < 0) {
            sb.append(s2);
        } else {
            if (WIN_BACKSLASHES_PRECEDING_QUOTE.matcher(s2 = StringUtilRt.unquoteString((String)s2, (char)'\"')).matches()) {
                StringUtil.repeatSymbol(sb, '\\', numTrailingBackslashes);
            }
            sb.append(s2).append('\"');
        }
    }

    private static String backslashEscapeQuotes(String s2) {
        assert (!s2.isEmpty());
        String result2 = WIN_BACKSLASHES_PRECEDING_QUOTE.matcher(s2).replaceAll("$1$1").replace("\"", "\\\"");
        if (!result2.equals(s2) || WIN_QUOTE_SPECIAL.matcher(s2).find()) {
            result2 = CommandLineUtil.quote(result2, '\"');
        }
        return result2;
    }

    private static int removeClosingQuote(StringBuilder sb) {
        if (sb.length() < 2 || sb.charAt(sb.length() - 1) != '\"') {
            return -1;
        }
        sb.setLength(sb.length() - 1);
        int numTrailingBackslashes = sb.length() - StringUtil.trimTrailing(sb, '\\').length();
        StringUtil.repeatSymbol(sb, '\\', numTrailingBackslashes / 2);
        if (numTrailingBackslashes % 2 == 1) {
            StringUtil.repeatSymbol(sb, '\\', numTrailingBackslashes / 2 + 1);
            sb.append('\"');
            return -1;
        }
        return numTrailingBackslashes / 2;
    }

    @NotNull
    public static String getWinShellName() {
        return "cmd.exe";
    }

    private static boolean isWinShell(@NonNls String command2) {
        return "cmd".equalsIgnoreCase(command2) || "cmd.exe".equalsIgnoreCase(command2);
    }

    private static boolean isWinShellScript(@NonNls String command2) {
        return CommandLineUtil.endsWithIgnoreCase(command2, ".cmd") || CommandLineUtil.endsWithIgnoreCase(command2, ".bat");
    }

    private static boolean endsWithIgnoreCase(String str, String suffix) {
        return str.regionMatches(true, str.length() - suffix.length(), suffix, 0, suffix.length());
    }

    private static String quote(String s2, char ch) {
        return !CommandLineUtil.isQuoted(s2, ch) ? ch + s2 + ch : s2;
    }

    private static boolean isQuoted(CharSequence s2, char ch) {
        return s2.length() >= 2 && s2.charAt(0) == ch && s2.charAt(s2.length() - 1) == ch;
    }

    @Contract(pure=true)
    @NotNull
    public static String escapeParameterOnWindows(@NotNull String parameter, boolean isWinShell) {
        String result2;
        String s2;
        if (parameter == null) {
            CommandLineUtil.$$$reportNull$$$0(12);
        }
        if ((s2 = StringUtil.convertLineSeparators(parameter, "")).isEmpty()) {
            return QQ;
        }
        boolean hadLineBreaks = !s2.equals(parameter);
        String string2 = result2 = isWinShell ? CommandLineUtil.escapeParameter(s2, new QuoteFlag(hadLineBreaks), 1, true) : CommandLineUtil.backslashEscapeQuotes(s2);
        if (hadLineBreaks) {
            result2 = CommandLineUtil.quote(result2, '\"');
        }
        String string3 = result2;
        if (string3 == null) {
            CommandLineUtil.$$$reportNull$$$0(13);
        }
        return string3;
    }

    @NotNull
    public static String extractPresentableName(@NotNull String commandLine) {
        List<Object> args2;
        String execName;
        String executable;
        List<String> words;
        if (commandLine == null) {
            CommandLineUtil.$$$reportNull$$$0(14);
        }
        if ((words = StringUtil.splitHonorQuotes(executable = commandLine.trim(), ' ')).isEmpty()) {
            execName = executable;
            args2 = Collections.emptyList();
        } else {
            execName = words.get(0);
            args2 = words.subList(1, words.size());
        }
        boolean verbose = Logger.getInstance(CommandLineUtil.class).isDebugEnabled();
        String string2 = verbose ? StringUtil.shortenPathWithEllipsis(execName + " " + String.join((CharSequence)" ", args2), 250) : new File(StringUtil.unquoteString(execName)).getName();
        if (string2 == null) {
            CommandLineUtil.$$$reportNull$$$0(15);
        }
        return string2;
    }

    public static boolean hasWinShellSpecialChars(@NotNull String parameter) {
        if (parameter == null) {
            CommandLineUtil.$$$reportNull$$$0(16);
        }
        return WIN_CARET_SPECIAL.matcher(parameter).find();
    }

    @NotNull
    public static String posixQuote(@NotNull String argument) {
        if (argument == null) {
            CommandLineUtil.$$$reportNull$$$0(17);
        }
        return CommandLineUtil.posixQuote(argument, "");
    }

    @ApiStatus.Internal
    @NotNull
    public static String posixQuote(@NotNull String argument, @NotNull String extraWhiteListCharacters) {
        if (argument == null) {
            CommandLineUtil.$$$reportNull$$$0(18);
        }
        if (extraWhiteListCharacters == null) {
            CommandLineUtil.$$$reportNull$$$0(19);
        }
        String string2 = CommandLineUtil.shouldWrapWithQuotes(argument, extraWhiteListCharacters) ? "'" + StringUtil.replace(argument, "'", "'\"'\"'") + "'" : argument;
        if (string2 == null) {
            CommandLineUtil.$$$reportNull$$$0(20);
        }
        return string2;
    }

    private static boolean shouldWrapWithQuotes(@NotNull CharSequence argument, @NotNull String extraWhiteListCharacters) {
        if (argument == null) {
            CommandLineUtil.$$$reportNull$$$0(21);
        }
        if (extraWhiteListCharacters == null) {
            CommandLineUtil.$$$reportNull$$$0(22);
        }
        if (argument.length() == 0) {
            return true;
        }
        for (int i2 = 0; i2 < argument.length(); ++i2) {
            char c2 = argument.charAt(i2);
            if (Character.isAlphabetic(c2) || Character.isDigit(c2) || StringUtil.containsChar(SHELL_WHITELIST_CHARACTERS, c2) || StringUtil.containsChar(extraWhiteListCharacters, c2)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 8: 
            case 13: 
            case 15: 
            case 20: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 8: 
            case 13: 
            case 15: 
            case 20: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 1: 
            case 8: 
            case 13: 
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/CommandLineUtil";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 4: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "platform";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 17: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraWhiteListCharacters";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/CommandLineUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "specialQuote";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "toCommandLine";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeParameterOnWindows";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "extractPresentableName";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "posixQuote";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "specialQuote";
                break;
            }
            case 1: 
            case 8: 
            case 13: 
            case 15: 
            case 20: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "toCommandLine";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addToWindowsCommandLine";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "escapeParameterOnWindows";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "extractPresentableName";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "hasWinShellSpecialChars";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "posixQuote";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "shouldWrapWithQuotes";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 8: 
            case 13: 
            case 15: 
            case 20: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class QuoteFlag {
        private boolean enabled;

        private QuoteFlag(boolean value) {
            this.enabled = value;
        }

        public void toggle() {
            this.enabled = !this.enabled;
        }

        public void update(CharSequence s2, int start, int end) {
            this.enabled ^= StringUtil.countChars(s2, '\"', start, end, false) % 2 != 0;
        }
    }
}

