/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.validation;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.Scope;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.highlighting.PyHighlighter;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.resolve.PyResolveUtil;
import com.jetbrains.python.validation.PyAnnotator;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\bH\u0016J\f\u0010\t\u001a\u00020\n*\u00020\bH\u0002\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/python/validation/PyLocalVariableAnnotator;", "Lcom/jetbrains/python/validation/PyAnnotator;", "()V", "visitPyReferenceExpression", "", "node", "Lcom/jetbrains/python/psi/PyReferenceExpression;", "visitPyTargetExpression", "Lcom/jetbrains/python/psi/PyTargetExpression;", "isLocalVariable", "", "intellij.python.psi.impl"})
@SourceDebugExtension(value={"SMAP\nPyLocalVariableAnnotator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyLocalVariableAnnotator.kt\ncom/jetbrains/python/validation/PyLocalVariableAnnotator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,34:1\n1#2:35\n1747#3,3:36\n*S KotlinDebug\n*F\n+ 1 PyLocalVariableAnnotator.kt\ncom/jetbrains/python/validation/PyLocalVariableAnnotator\n*L\n20#1:36,3\n*E\n"})
public final class PyLocalVariableAnnotator
extends PyAnnotator {
    @Override
    public void visitPyTargetExpression(@NotNull PyTargetExpression node) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (!this.isLocalVariable(node)) {
                return;
            }
            ASTNode aSTNode = node.getNameElement();
            if (aSTNode == null) break block1;
            ASTNode it = aSTNode;
            boolean bl = false;
            this.addHighlightingAnnotation(it, PyHighlighter.PY_LOCAL_VARIABLE);
        }
    }

    @Override
    public void visitPyReferenceExpression(@NotNull PyReferenceExpression node) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Collection<PsiElement> collection = PyResolveUtil.resolveLocally(node);
            Intrinsics.checkNotNullExpressionValue(collection, (String)"resolveLocally(...)");
            Iterable $this$any$iv = collection;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof PyTargetExpression && this.isLocalVariable((PyTargetExpression)it))) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            this.addHighlightingAnnotation(node.getNode(), PyHighlighter.PY_LOCAL_VARIABLE);
        }
    }

    private final boolean isLocalVariable(PyTargetExpression $this$isLocalVariable) {
        if ($this$isLocalVariable.isQualified()) {
            return false;
        }
        String string = $this$isLocalVariable.getReferencedName();
        if (string == null) {
            return false;
        }
        String name2 = string;
        if (Intrinsics.areEqual((Object)name2, (Object)"_")) {
            return false;
        }
        ScopeOwner scopeOwner = ScopeUtil.getScopeOwner($this$isLocalVariable);
        if (!(scopeOwner instanceof PyFunction)) {
            return false;
        }
        Scope scope = ControlFlowCache.getScope(scopeOwner);
        Intrinsics.checkNotNullExpressionValue((Object)scope, (String)"getScope(...)");
        Scope scope2 = scope;
        return !scope2.isNonlocal(name2) && !scope2.isGlobal(name2);
    }
}

