/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.poetry;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.packaging.PyRequirementParser;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.poetry.PoetryKt;
import com.jetbrains.python.sdk.poetry.PoetryOutdatedVersion;
import com.jetbrains.python.sdk.poetry.PyPoetryPackageManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u00142\u0006\u0010\u0015\u001a\u00020\fH\u0016J\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\tJ\u0010\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u0006H\u0016J\u0018\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u00062\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u0007H\u0002J\b\u0010\u001d\u001a\u00020\u0012H\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0007H\u0016J&\u0010\u001e\u001a\u00020\u001f2\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u00062\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\b\u0010\"\u001a\u00020\u001fH\u0016J(\u0010#\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u00060$2\u0006\u0010%\u001a\u00020\u0007H\u0002J\u0012\u0010&\u001a\u0004\u0018\u00010\u000e2\u0006\u0010'\u001a\u00020\u0007H\u0016J\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00062\u0006\u0010)\u001a\u00020*H\u0016J\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00062\u0006\u0010+\u001a\u00020\u0007H\u0016J\b\u0010,\u001a\u00020\u001fH\u0016J\u0016\u0010-\u001a\b\u0012\u0004\u0012\u00020\f0\u00062\u0006\u0010.\u001a\u00020\u0012H\u0016J\u0016\u0010/\u001a\u00020\u001f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0006H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/jetbrains/python/sdk/poetry/PyPoetryPackageManager;", "Lcom/jetbrains/python/packaging/PyPackageManager;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "(Lcom/intellij/openapi/projectRoots/Sdk;)V", "installedLines", "", "", "outdatedPackages", "", "Lcom/jetbrains/python/sdk/poetry/PoetryOutdatedVersion;", "packages", "Lcom/jetbrains/python/packaging/PyPackage;", "requirements", "Lcom/jetbrains/python/packaging/PyRequirement;", "createVirtualEnv", "destinationDir", "useGlobalSite", "", "getDependents", "", "pkg", "getOutdatedPackages", "getPackages", "getRequirements", "module", "Lcom/intellij/openapi/module/Module;", "getVersion", "version", "hasManagement", "install", "", "requirementString", "extraArgs", "installManagement", "parsePoetryInstallDryRun", "Lkotlin/Pair;", "input", "parseRequirement", "line", "parseRequirements", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "text", "refresh", "refreshAndGetPackages", "alwaysRefresh", "uninstall", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nPyPoetryPackageManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyPoetryPackageManager.kt\ncom/jetbrains/python/sdk/poetry/PyPoetryPackageManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,177:1\n1549#2:178\n1620#2,3:179\n1549#2:184\n1620#2,3:185\n1747#2,3:191\n37#3,2:182\n37#3,2:188\n1313#4:190\n1314#4:195\n1#5:194\n*S KotlinDebug\n*F\n+ 1 PyPoetryPackageManager.kt\ncom/jetbrains/python/sdk/poetry/PyPoetryPackageManager\n*L\n47#1:178\n47#1:179,3\n63#1:184\n63#1:185,3\n166#1:191,3\n53#1:182,2\n65#1:188,2\n164#1:190\n164#1:195\n*E\n"})
public final class PyPoetryPackageManager
extends PyPackageManager {
    @NotNull
    private final List<String> installedLines;
    @Nullable
    private volatile List<PyPackage> packages;
    @Nullable
    private List<? extends PyRequirement> requirements;
    @NotNull
    private Map<String, PoetryOutdatedVersion> outdatedPackages;

    public PyPoetryPackageManager(@NotNull Sdk sdk2) {
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        super(sdk2);
        Object[] objectArray = new String[]{"Already installed", "Skipping", "Updating"};
        this.installedLines = CollectionsKt.listOf((Object[])objectArray);
        this.outdatedPackages = MapsKt.emptyMap();
    }

    @Override
    public void installManagement() {
    }

    @Override
    public boolean hasManagement() {
        return true;
    }

    @Override
    public void install(@NotNull String requirementString) {
        Intrinsics.checkNotNullParameter((Object)requirementString, (String)"requirementString");
        this.install((List<? extends PyRequirement>)this.parseRequirements(requirementString), (List<String>)CollectionsKt.emptyList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void install(@Nullable List<? extends PyRequirement> requirements2, @NotNull List<String> extraArgs) {
        List list;
        Intrinsics.checkNotNullParameter(extraArgs, (String)"extraArgs");
        Object[] objectArray = (Object[])requirements2;
        if (objectArray == null || objectArray.isEmpty()) {
            objectArray = new List[]{CollectionsKt.listOf((Object)"install"), extraArgs};
            list = CollectionsKt.flatten((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray));
        } else {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            objectArray = new List[3];
            objectArray[0] = CollectionsKt.listOf((Object)"add");
            Iterable iterable = requirements2;
            int n = 1;
            Object[] objectArray2 = objectArray;
            boolean $i$f$map = false;
            void var7_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                PyRequirement pyRequirement = (PyRequirement)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getName());
            }
            collection = (List)destination$iv$iv;
            objectArray2[n] = collection;
            objectArray[2] = extraArgs;
            list = CollectionsKt.flatten((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray));
        }
        List args2 = list;
        try {
            Sdk sdk2 = this.getSdk();
            Intrinsics.checkNotNullExpressionValue((Object)sdk2, (String)"getSdk(...)");
            Collection $this$toTypedArray$iv = args2;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            objectArray = thisCollection$iv.toArray(new String[0]);
            PoetryKt.runPoetry(sdk2, (String[])Arrays.copyOf(objectArray, objectArray.length));
        }
        finally {
            Sdk sdk3 = this.getSdk();
            Intrinsics.checkNotNullExpressionValue((Object)sdk3, (String)"getSdk(...)");
            VirtualFile virtualFile = PySdkExtKt.getAssociatedModuleDir(sdk3);
            if (virtualFile != null) {
                virtualFile.refresh(true, false);
            }
            this.refreshAndGetPackages(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void uninstall(@NotNull List<PyPackage> packages2) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(packages2, (String)"packages");
        String[] stringArray = (String[])packages2;
        Collection collection = CollectionsKt.listOf((Object)"remove");
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PyPackage pyPackage = (PyPackage)((Object)item$iv$iv);
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            String string = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            collection2.add(string);
        }
        List args2 = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
        try {
            Sdk sdk2 = this.getSdk();
            Intrinsics.checkNotNullExpressionValue((Object)sdk2, (String)"getSdk(...)");
            Collection $this$toTypedArray$iv = args2;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            stringArray = thisCollection$iv.toArray(new String[0]);
            PoetryKt.runPoetry(sdk2, Arrays.copyOf(stringArray, stringArray.length));
        }
        finally {
            Sdk sdk3 = this.getSdk();
            Intrinsics.checkNotNullExpressionValue((Object)sdk3, (String)"getSdk(...)");
            VirtualFile virtualFile = PySdkExtKt.getAssociatedModuleDir(sdk3);
            if (virtualFile != null) {
                virtualFile.refresh(true, false);
            }
            this.refreshAndGetPackages(true);
        }
    }

    @Override
    public void refresh() {
        Application $this$refresh_u24lambda_u244 = ApplicationManager.getApplication();
        boolean bl = false;
        $this$refresh_u24lambda_u244.invokeLater(() -> PyPoetryPackageManager.refresh$lambda$4$lambda$3($this$refresh_u24lambda_u244, this));
    }

    @Override
    @NotNull
    public String createVirtualEnv(@NotNull String destinationDir, boolean useGlobalSite) {
        Intrinsics.checkNotNullParameter((Object)destinationDir, (String)"destinationDir");
        throw new ExecutionException(PyBundle.message("python.sdk.dialog.message.creating.virtual.environments.based.on.poetry.environments.not.supported", new Object[0]));
    }

    @Override
    @Nullable
    public List<PyPackage> getPackages() {
        return this.packages;
    }

    @NotNull
    public final Map<String, PoetryOutdatedVersion> getOutdatedPackages() {
        return this.outdatedPackages;
    }

    @Override
    @NotNull
    public List<PyPackage> refreshAndGetPackages(boolean alwaysRefresh) {
        List list;
        if (alwaysRefresh || this.packages == null) {
            Object object;
            Object object2;
            this.packages = null;
            try {
                Sdk sdk2 = this.getSdk();
                Intrinsics.checkNotNullExpressionValue((Object)sdk2, (String)"getSdk(...)");
                object2 = new String[]{"install", "--dry-run", "--no-root"};
                object2 = PoetryKt.runPoetry(sdk2, object2);
            }
            catch (ExecutionException e) {
                this.packages = CollectionsKt.emptyList();
                List list2 = this.packages;
                if (list2 == null) {
                    list2 = CollectionsKt.emptyList();
                }
                return list2;
            }
            Object outputInstallDryRun = object2;
            Pair<List<PyPackage>, List<PyRequirement>> allPackage = this.parsePoetryInstallDryRun((String)outputInstallDryRun);
            this.packages = (List)allPackage.getFirst();
            this.requirements = (List)allPackage.getSecond();
            try {
                Sdk sdk3 = this.getSdk();
                Intrinsics.checkNotNullExpressionValue((Object)sdk3, (String)"getSdk(...)");
                object = new String[]{"show", "--outdated"};
                object = PoetryKt.runPoetry(sdk3, object);
            }
            catch (ExecutionException e) {
                this.outdatedPackages = MapsKt.emptyMap();
                object = Unit.INSTANCE;
            }
            String[] outputOutdatedPackages = object;
            if (outputOutdatedPackages instanceof String) {
                this.outdatedPackages = PoetryKt.parsePoetryShowOutdated((String)outputOutdatedPackages);
            }
            MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
            Topic<PyPackageManager.Listener> topic = PyPackageManager.PACKAGE_MANAGER_TOPIC;
            Intrinsics.checkNotNullExpressionValue(topic, (String)"PACKAGE_MANAGER_TOPIC");
            ((PyPackageManager.Listener)messageBus.syncPublisher(topic)).packagesRefreshed(this.getSdk());
        }
        if ((list = this.packages) == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @Nullable
    public List<PyRequirement> getRequirements(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return this.requirements;
    }

    @Override
    @NotNull
    public List<PyRequirement> parseRequirements(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        List<PyRequirement> list = PyRequirementParser.fromText(text);
        Intrinsics.checkNotNullExpressionValue(list, (String)"fromText(...)");
        return list;
    }

    @Override
    @Nullable
    public PyRequirement parseRequirement(@NotNull String line2) {
        Intrinsics.checkNotNullParameter((Object)line2, (String)"line");
        return PyRequirementParser.fromLine(line2);
    }

    @Override
    @NotNull
    public List<PyRequirement> parseRequirements(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        List<PyRequirement> list = PyRequirementParser.fromFile(file);
        Intrinsics.checkNotNullExpressionValue(list, (String)"fromFile(...)");
        return list;
    }

    @Override
    @NotNull
    public Set<PyPackage> getDependents(@NotNull PyPackage pkg) {
        Intrinsics.checkNotNullParameter((Object)((Object)pkg), (String)"pkg");
        return SetsKt.emptySet();
    }

    private final String getVersion(String version2) {
        return new Regex("^[0-9]").containsMatchIn((CharSequence)version2) ? "==" + version2 : version2;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<List<PyPackage>, List<PyRequirement>> parsePoetryInstallDryRun(String input) {
        void $this$forEach$iv;
        List pyPackages = new ArrayList();
        List pyRequirements = new ArrayList();
        Sequence sequence = SequencesKt.filter((Sequence)StringsKt.lineSequence((CharSequence)input), (Function1)parsePoetryInstallDryRun.1.INSTANCE);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PyRequirement pyRequirement;
            boolean bl;
            Triple<String, String, String> it;
            String line2;
            block6: {
                Triple<String, String, String> triple;
                line2 = (String)element$iv;
                boolean bl2 = false;
                it = triple = PyPoetryPackageManager.parsePoetryInstallDryRun$getNameAndVersion(line2);
                boolean bl3 = false;
                Iterable $this$any$iv = this.installedLines;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv2 : $this$any$iv) {
                        String installedLine = (String)element$iv2;
                        boolean bl4 = false;
                        if (!StringsKt.contains$default((CharSequence)line2, (CharSequence)installedLine, (boolean)false, (int)2, null)) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            if (bl) {
                pyPackages.add(new PyPackage((String)it.getFirst(), (String)it.getSecond(), null, CollectionsKt.emptyList()));
                if (this.parseRequirement(it.getFirst() + this.getVersion((String)it.getThird())) != null) {
                    boolean bl5 = false;
                    pyRequirements.add(pyRequirement);
                }
                continue;
            }
            if (!StringsKt.contains$default((CharSequence)line2, (CharSequence)"Installing", (boolean)false, (int)2, null)) continue;
            if (this.parseRequirement(it.getFirst() + this.getVersion((String)it.getThird())) == null) continue;
            boolean bl6 = false;
            pyRequirements.add(pyRequirement);
        }
        return new Pair((Object)CollectionsKt.toList((Iterable)CollectionsKt.distinct((Iterable)pyPackages)), (Object)CollectionsKt.toList((Iterable)CollectionsKt.distinct((Iterable)pyRequirements)));
    }

    private static final void refresh$lambda$4$lambda$3$lambda$2(PyPoetryPackageManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        VirtualFile[] virtualFileArray = this$0.getSdk().getRootProvider().getFiles(OrderRootType.CLASSES);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getFiles(...)");
        VirtualFile[] files = virtualFileArray;
        VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)true, (boolean)true, (VirtualFile[])Arrays.copyOf(files, files.length));
    }

    private static final void refresh$lambda$4$lambda$3(Application $this_with, PyPoetryPackageManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        $this_with.runWriteAction(() -> PyPoetryPackageManager.refresh$lambda$4$lambda$3$lambda$2(this$0));
        PythonSdkType.getInstance().setupSdkPaths(this$0.getSdk());
    }

    private static final Triple<String, String, String> parsePoetryInstallDryRun$getNameAndVersion(String line2) {
        String string;
        String[] stringArray = new String[]{" "};
        List it = StringsKt.split$default((CharSequence)line2, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean bl = false;
        CharSequence charSequence = (CharSequence)it.get(5);
        Object object = new Regex("[():]");
        String string2 = "";
        String installedVersion = object.replace(charSequence, string2);
        if (it.size() > 7 && Intrinsics.areEqual(it.get(6), (Object)"->")) {
            object = (CharSequence)it.get(7);
            string2 = new Regex("[():]");
            String string3 = "";
            string = string2.replace((CharSequence)object, string3);
        } else {
            string = installedVersion;
        }
        String requiredVersion = string;
        return new Triple(it.get(4), (Object)installedVersion, (Object)requiredVersion);
    }
}

