/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.requirements;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.packaging.PyPackageRequirementsSettings;
import com.jetbrains.python.packaging.common.PackagesKt;
import com.jetbrains.python.packaging.management.PythonPackageManager;
import com.jetbrains.python.requirements.InstallAllRequirementsQuickFix;
import com.jetbrains.python.requirements.InstallProjectAsEditableQuickfix;
import com.jetbrains.python.requirements.InstallRequirementQuickFix;
import com.jetbrains.python.requirements.PyGenerateRequirementsFileQuickFix;
import com.jetbrains.python.requirements.RequirementsFile;
import com.jetbrains.python.requirements.RequirementsInspectionVisitor;
import com.jetbrains.python.requirements.psi.Requirement;
import com.jetbrains.python.sdk.PySdkExtKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/jetbrains/python/requirements/UnsatisfiedRequirementInspectionVisitor;", "Lcom/jetbrains/python/requirements/RequirementsInspectionVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "onTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "(Lcom/intellij/codeInspection/ProblemsHolder;ZLcom/intellij/codeInspection/LocalInspectionToolSession;)V", "visitRequirementsFile", "", "element", "Lcom/jetbrains/python/requirements/RequirementsFile;", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nUnsatisfiedRequirementInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnsatisfiedRequirementInspection.kt\ncom/jetbrains/python/requirements/UnsatisfiedRequirementInspectionVisitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,224:1\n1549#2:225\n1620#2,3:226\n766#2:229\n857#2,2:230\n1855#2,2:232\n*S KotlinDebug\n*F\n+ 1 UnsatisfiedRequirementInspection.kt\ncom/jetbrains/python/requirements/UnsatisfiedRequirementInspectionVisitor\n*L\n77#1:225\n77#1:226,3\n78#1:229\n78#1:230,2\n79#1:232,2\n*E\n"})
final class UnsatisfiedRequirementInspectionVisitor
extends RequirementsInspectionVisitor {
    public UnsatisfiedRequirementInspectionVisitor(@NotNull ProblemsHolder holder, boolean onTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        super(holder, onTheFly, session);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitRequirementsFile(@NotNull RequirementsFile element) {
        Intrinsics.checkNotNullParameter((Object)((Object)element), (String)"element");
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)element));
        String string = PyPackageRequirementsSettings.getInstance(module).getRequirementsPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRequirementsPath(...)");
        String requirementsPath = string;
        if (!(((CharSequence)requirementsPath).length() == 0) && module != null) {
            void $this$filterTo$iv$iv;
            Object[] objectArray;
            void $this$mapTo$iv$iv;
            LocalQuickFix[] manager;
            VirtualFile file = LocalFileSystem.getInstance().findFileByPath(requirementsPath);
            if (file == null) {
                manager = ModuleRootManager.getInstance((Module)module);
                VirtualFile[] virtualFileArray = manager.getContentRoots();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getContentRoots(...)");
                for (VirtualFile root : virtualFileArray) {
                    VirtualFile fileInRoot = root.findFileByRelativePath(requirementsPath);
                    if (fileInRoot != null) continue;
                    return;
                }
            }
            if ((manager = (CharSequence)element.getText()) == null || StringsKt.isBlank((CharSequence)manager)) {
                manager = new LocalQuickFix[]{new PyGenerateRequirementsFileQuickFix(module)};
                this.getHolder().registerProblem((PsiElement)element, PyPsiBundle.message("INSP.package.requirements.requirements.file.empty", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, manager);
            }
            Project project2 = element.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            Project project3 = project2;
            Sdk sdk2 = PySdkExtKt.getPythonSdk(project3);
            if (sdk2 == null) {
                return;
            }
            Sdk sdk3 = sdk2;
            PythonPackageManager packageManager = PythonPackageManager.Companion.forSdk(project3, sdk3);
            Iterable $this$map$iv = packageManager.getInstalledPackages();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                objectArray = (Object[])item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(PackagesKt.normalizePackageName(it.getName()));
            }
            List packages2 = (List)destination$iv$iv;
            Iterable $this$filter$iv = element.requirements();
            boolean $i$f$filter = false;
            destination$iv$iv = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Requirement requirement = (Requirement)element$iv$iv;
                boolean bl = false;
                if (!(!packages2.contains(PackagesKt.normalizePackageName(requirement.getDisplayName())))) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List unsatisfiedRequirements = (List)destination$iv$iv2;
            Iterable $this$forEach$iv = unsatisfiedRequirements;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Requirement requirement = (Requirement)element$iv;
                boolean bl = false;
                objectArray = new Object[]{requirement.getDisplayName()};
                String string2 = PyBundle.message("INSP.requirements.package.not.installed", objectArray);
                objectArray = new LocalQuickFix[]{new InstallRequirementQuickFix(requirement), new InstallAllRequirementsQuickFix(unsatisfiedRequirements), new InstallProjectAsEditableQuickfix()};
                this.getHolder().registerProblem((PsiElement)requirement, string2, ProblemHighlightType.WARNING, (LocalQuickFix[])objectArray);
            }
        }
    }
}

