/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.resolve;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.QualifiedName;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PythonPathCache {
    private final Map<QualifiedName, SoftReference<List<PsiElement>>> myCache = new ConcurrentHashMap<QualifiedName, SoftReference<List<PsiElement>>>();
    private final Map<String, List<QualifiedName>> myQNameCache = new ConcurrentHashMap<String, List<QualifiedName>>();

    public void clearCache() {
        this.myCache.clear();
        this.myQNameCache.clear();
    }

    @Nullable
    public List<PsiElement> get(@NotNull QualifiedName qualifiedName) {
        SoftReference<List<PsiElement>> references2;
        if (qualifiedName == null) {
            PythonPathCache.$$$reportNull$$$0(0);
        }
        if ((references2 = this.myCache.get(qualifiedName)) == null) {
            return null;
        }
        List<PsiElement> elements = references2.get();
        if (elements != null && !elements.stream().allMatch(PsiElement::isValid)) {
            return null;
        }
        return elements != null ? Collections.unmodifiableList(elements) : null;
    }

    public void put(QualifiedName qualifiedName, List<PsiElement> results) {
        if (results != null) {
            this.myCache.put(qualifiedName, new SoftReference<List<PsiElement>>(results));
        }
    }

    @Nullable
    public List<QualifiedName> getNames(VirtualFile vFile) {
        if (vFile == null) {
            return null;
        }
        List<QualifiedName> names2 = this.myQNameCache.get(vFile.getUrl());
        return names2 != null ? Collections.unmodifiableList(names2) : null;
    }

    public void putNames(VirtualFile vFile, List<QualifiedName> qNames2) {
        this.myQNameCache.put(vFile.getUrl(), new ArrayList<QualifiedName>(qNames2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/jetbrains/python/psi/resolve/PythonPathCache", "get"));
    }

    protected class MyVirtualFileListener
    implements VirtualFileListener {
        protected MyVirtualFileListener() {
        }

        public void fileCreated(@NotNull VirtualFileEvent event) {
            if (event == null) {
                MyVirtualFileListener.$$$reportNull$$$0(0);
            }
            PythonPathCache.this.clearCache();
        }

        public void fileDeleted(@NotNull VirtualFileEvent event) {
            if (event == null) {
                MyVirtualFileListener.$$$reportNull$$$0(1);
            }
            PythonPathCache.this.clearCache();
        }

        public void fileMoved(@NotNull VirtualFileMoveEvent event) {
            if (event == null) {
                MyVirtualFileListener.$$$reportNull$$$0(2);
            }
            PythonPathCache.this.clearCache();
        }

        public void fileCopied(@NotNull VirtualFileCopyEvent event) {
            if (event == null) {
                MyVirtualFileListener.$$$reportNull$$$0(3);
            }
            PythonPathCache.this.clearCache();
        }

        public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
            if (event == null) {
                MyVirtualFileListener.$$$reportNull$$$0(4);
            }
            if (event.getPropertyName().equals("name")) {
                PythonPathCache.this.clearCache();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/jetbrains/python/psi/resolve/PythonPathCache$MyVirtualFileListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileCreated";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileDeleted";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileMoved";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileCopied";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "propertyChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

