/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.startup.StartupActivity;
import com.jetbrains.python.packaging.PyPIPackageCache;
import com.jetbrains.python.packaging.PyPIPackageUtil;
import com.jetbrains.python.packaging.PyPackageService;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.attribute.FileTime;
import java.time.Duration;
import java.time.Instant;
import org.jetbrains.annotations.NotNull;

final class PyPackagesUpdater
implements StartupActivity,
DumbAware {
    private static final Logger LOG = Logger.getInstance(PyPackagesUpdater.class);
    private static final Duration EXPIRATION_TIMEOUT = Duration.ofDays(1L);

    PyPackagesUpdater() {
    }

    public void runActivity(@NotNull Project project2) {
        if (project2 == null) {
            PyPackagesUpdater.$$$reportNull$$$0(0);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        if (!PyPackagesUpdater.checkNeeded(project2)) {
            return;
        }
        try {
            PyPIPackageUtil.INSTANCE.updatePyPICache();
        }
        catch (IOException e) {
            LOG.warn(e.getMessage());
        }
    }

    private static boolean hasPython(Project project2) {
        for (Module module : ModuleManager.getInstance((Project)project2).getModules()) {
            Sdk sdk2 = PythonSdkUtil.findPythonSdk(module);
            if (sdk2 == null || !(sdk2.getSdkType() instanceof PythonSdkType)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkNeeded(Project project2) {
        if (!PyPackagesUpdater.hasPython(project2)) {
            return false;
        }
        PyPackageService service = PyPackageService.getInstance();
        if (service.PYPI_REMOVED.booleanValue()) {
            return false;
        }
        try {
            FileTime fileMTime = Files.getLastModifiedTime(PyPIPackageCache.getDefaultCachePath(), new LinkOption[0]);
            if (fileMTime.toInstant().plus(EXPIRATION_TIMEOUT).isAfter(Instant.now())) {
                return false;
            }
        }
        catch (NoSuchFileException fileMTime) {
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
        LOG.debug("Updating outdated PyPI package cache");
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/packaging/PyPackagesUpdater", "runActivity"));
    }
}

