/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.attach;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.attach.LocalAttachHost;
import com.intellij.xdebugger.attach.XAttachDebugger;
import com.intellij.xdebugger.attach.XAttachDebuggerProvider;
import com.intellij.xdebugger.attach.XAttachHost;
import com.intellij.xdebugger.attach.XAttachPresentationGroup;
import com.jetbrains.python.debugger.PyDebuggerOptionsProvider;
import com.jetbrains.python.debugger.attach.PyAttachToProcessDebugRunner;
import com.jetbrains.python.debugger.attach.PyLocalAttachGroup;
import com.jetbrains.python.run.AbstractPythonRunConfiguration;
import com.jetbrains.python.sdk.PreferredSdkComparator;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyLocalAttachDebuggerProvider
implements XAttachDebuggerProvider {
    private static final Key<List<XAttachDebugger>> DEBUGGERS_KEY = Key.create((String)"PyLocalAttachDebuggerProvider.DEBUGGERS");

    @NotNull
    public XAttachPresentationGroup<ProcessInfo> getPresentationGroup() {
        PyLocalAttachGroup pyLocalAttachGroup = PyLocalAttachGroup.INSTANCE;
        if (pyLocalAttachGroup == null) {
            PyLocalAttachDebuggerProvider.$$$reportNull$$$0(0);
        }
        return pyLocalAttachGroup;
    }

    public boolean isAttachHostApplicable(@NotNull XAttachHost attachHost) {
        if (attachHost == null) {
            PyLocalAttachDebuggerProvider.$$$reportNull$$$0(1);
        }
        return attachHost instanceof LocalAttachHost;
    }

    @NotNull
    private static List<XAttachDebugger> getAttachDebuggersForAllLocalSdks(@NotNull Project project2) {
        RunConfiguration runConfiguration;
        if (project2 == null) {
            PyLocalAttachDebuggerProvider.$$$reportNull$$$0(2);
        }
        Sdk selected = null;
        RunnerAndConfigurationSettings settings = RunManager.getInstance((Project)project2).getSelectedConfiguration();
        if (settings != null && (runConfiguration = settings.getConfiguration()) instanceof AbstractPythonRunConfiguration) {
            selected = ((AbstractPythonRunConfiguration)runConfiguration).getSdk();
        }
        Sdk selectedSdk = selected;
        List<XAttachDebugger> result2 = PythonSdkUtil.getAllLocalCPythons().stream().filter(sdk2 -> sdk2 != selectedSdk).filter(sdk2 -> PySdkExtKt.getSdkSeemsValid(sdk2)).sorted(PreferredSdkComparator.INSTANCE).map(PyLocalAttachDebugger::new).collect(Collectors.toList());
        if (selectedSdk != null) {
            result2.add(0, new PyLocalAttachDebugger(selectedSdk));
        }
        List<XAttachDebugger> list = result2;
        if (list == null) {
            PyLocalAttachDebuggerProvider.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public List<? extends XAttachDebugger> getAvailableDebuggers(@NotNull Project project2, @NotNull XAttachHost attachHost, @NotNull ProcessInfo processInfo, @NotNull UserDataHolder contextHolder) {
        if (project2 == null) {
            PyLocalAttachDebuggerProvider.$$$reportNull$$$0(4);
        }
        if (attachHost == null) {
            PyLocalAttachDebuggerProvider.$$$reportNull$$$0(5);
        }
        if (processInfo == null) {
            PyLocalAttachDebuggerProvider.$$$reportNull$$$0(6);
        }
        if (contextHolder == null) {
            PyLocalAttachDebuggerProvider.$$$reportNull$$$0(7);
        }
        String filter = PyDebuggerOptionsProvider.getInstance(project2).getAttachProcessFilter();
        if (StringUtil.containsIgnoreCase((String)processInfo.getCommandLine(), (String)filter)) {
            List<XAttachDebugger> result2;
            if (processInfo.getExecutableCannonicalPath().isPresent() && new File((String)processInfo.getExecutableCannonicalPath().get()).exists()) {
                result2 = new ArrayList<PyLocalAttachDebugger>(Arrays.asList(new PyLocalAttachDebugger((String)processInfo.getExecutableCannonicalPath().get())));
            } else {
                result2 = (List<XAttachDebugger>)contextHolder.getUserData(DEBUGGERS_KEY);
                if (result2 != null) {
                    List<XAttachDebugger> list = result2;
                    if (list == null) {
                        PyLocalAttachDebuggerProvider.$$$reportNull$$$0(8);
                    }
                    return list;
                }
                result2 = PyLocalAttachDebuggerProvider.getAttachDebuggersForAllLocalSdks(project2);
                contextHolder.putUserData(DEBUGGERS_KEY, Collections.unmodifiableList(result2));
            }
            List<XAttachDebugger> list = result2;
            if (list == null) {
                PyLocalAttachDebuggerProvider.$$$reportNull$$$0(9);
            }
            return list;
        }
        List list = Collections.emptyList();
        if (list == null) {
            PyLocalAttachDebuggerProvider.$$$reportNull$$$0(10);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 4, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/attach/PyLocalAttachDebuggerProvider";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attachHost";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processInfo";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextHolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentationGroup";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/attach/PyLocalAttachDebuggerProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttachDebuggersForAllLocalSdks";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableDebuggers";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAttachHostApplicable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAttachDebuggersForAllLocalSdks";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableDebuggers";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 4, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }

    private static class PyLocalAttachDebugger
    implements XAttachDebugger {
        private final String mySdkHome;
        @Nullable
        private final Sdk mySdk;
        @NotNull
        @NlsSafe
        private final String myName;

        PyLocalAttachDebugger(@NotNull Sdk sdk2) {
            if (sdk2 == null) {
                PyLocalAttachDebugger.$$$reportNull$$$0(0);
            }
            this.mySdkHome = sdk2.getHomePath();
            this.mySdk = sdk2;
            this.myName = PythonSdkType.getInstance().getVersionString(sdk2) + " (" + this.mySdkHome + ")";
        }

        PyLocalAttachDebugger(@NotNull String sdkHome) {
            if (sdkHome == null) {
                PyLocalAttachDebugger.$$$reportNull$$$0(1);
            }
            this.mySdkHome = sdkHome;
            this.mySdk = PythonSdkUtil.findSdkByPath(this.mySdkHome);
            this.myName = "Python Debugger";
        }

        @NotNull
        public String getDebuggerDisplayName() {
            String string = this.myName;
            if (string == null) {
                PyLocalAttachDebugger.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void attachDebugSession(@NotNull Project project2, @NotNull XAttachHost attachHost, @NotNull ProcessInfo processInfo) throws ExecutionException {
            if (project2 == null) {
                PyLocalAttachDebugger.$$$reportNull$$$0(3);
            }
            if (attachHost == null) {
                PyLocalAttachDebugger.$$$reportNull$$$0(4);
            }
            if (processInfo == null) {
                PyLocalAttachDebugger.$$$reportNull$$$0(5);
            }
            PyAttachToProcessDebugRunner runner = new PyAttachToProcessDebugRunner(project2, processInfo.getPid(), this.mySdk);
            runner.launch();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdk";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdkHome";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/debugger/attach/PyLocalAttachDebuggerProvider$PyLocalAttachDebugger";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attachHost";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/debugger/attach/PyLocalAttachDebuggerProvider$PyLocalAttachDebugger";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDebuggerDisplayName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "attachDebugSession";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

