/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentPaths;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.AbstractPathMapper;
import com.intellij.util.PathMappingSettings;
import com.jetbrains.python.remote.PyRemotePathMapper;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bH\u0016J\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/python/debugger/PyTargetPathMapper;", "Lcom/jetbrains/python/remote/PyRemotePathMapper;", "targetEnvironment", "Lcom/intellij/execution/target/TargetEnvironment;", "pathMappingSettings", "Lcom/intellij/util/PathMappingSettings;", "(Lcom/intellij/execution/target/TargetEnvironment;Lcom/intellij/util/PathMappingSettings;)V", "convertToLocal", "", "remotePath", "convertToRemote", "localPath", "getFileMappings", "", "Lcom/intellij/util/PathMappingSettings$PathMapping;", "isEmpty", "", "intellij.python.community.impl"})
@ApiStatus.Internal
public final class PyTargetPathMapper
extends PyRemotePathMapper {
    @NotNull
    private final TargetEnvironment targetEnvironment;
    @NotNull
    private final PathMappingSettings pathMappingSettings;

    public PyTargetPathMapper(@NotNull TargetEnvironment targetEnvironment, @NotNull PathMappingSettings pathMappingSettings) {
        Intrinsics.checkNotNullParameter((Object)targetEnvironment, (String)"targetEnvironment");
        Intrinsics.checkNotNullParameter((Object)pathMappingSettings, (String)"pathMappingSettings");
        this.targetEnvironment = targetEnvironment;
        this.pathMappingSettings = pathMappingSettings;
    }

    @Override
    @NotNull
    public String convertToLocal(@NotNull String remotePath) {
        String string;
        String string2;
        Intrinsics.checkNotNullParameter((Object)remotePath, (String)"remotePath");
        String string3 = AbstractPathMapper.convertToLocal((String)remotePath, (Iterable)this.pathMappingSettings.getPathMappings());
        if (string3 == null) {
            string3 = (String)CollectionsKt.firstOrNull((List)TargetEnvironmentPaths.getLocalPaths((TargetEnvironment)this.targetEnvironment, (String)remotePath));
        }
        if ((string2 = string3) == null) {
            String string4 = super.convertToLocal(remotePath);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"convertToLocal(...)");
        } else {
            string = string2;
        }
        return string;
    }

    @Override
    @NotNull
    public String convertToRemote(@NotNull String localPath) {
        String string;
        String string2;
        Intrinsics.checkNotNullParameter((Object)localPath, (String)"localPath");
        String string3 = AbstractPathMapper.convertToRemote((String)localPath, (Collection)this.pathMappingSettings.getPathMappings());
        if (string3 == null) {
            String string4 = FileUtil.toSystemDependentName((String)localPath);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toSystemDependentName(...)");
            string3 = (String)CollectionsKt.firstOrNull((List)TargetEnvironmentPaths.getTargetPaths((TargetEnvironment)this.targetEnvironment, (String)string4));
        }
        if ((string2 = string3) == null) {
            String string5 = super.convertToRemote(localPath);
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"convertToRemote(...)");
        } else {
            string = string2;
        }
        return string;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @NotNull
    public final List<PathMappingSettings.PathMapping> getFileMappings() {
        List list = this.pathMappingSettings.getPathMappings();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPathMappings(...)");
        return list;
    }
}

