/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PySourcePosition {
    private final String file;
    private final int line;

    protected PySourcePosition(String file, int line2) {
        this.file = this.normalize(file);
        this.line = line2;
    }

    @Nullable
    protected String normalize(@Nullable String file) {
        if (file == null) {
            return null;
        }
        return FileUtil.toSystemIndependentName((String)file);
    }

    public String getFile() {
        return this.file;
    }

    public int getLine() {
        return this.line;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PySourcePosition)) {
            return false;
        }
        PySourcePosition that = (PySourcePosition)o;
        if (this.line != that.line) {
            return false;
        }
        return !(this.file != null ? !this.file.equals(that.file) : that.file != null);
    }

    public int hashCode() {
        int result2 = this.file != null ? this.file.hashCode() : 0;
        result2 = 31 * result2 + this.line;
        return result2;
    }

    public String toString() {
        return "PySourcePosition(" + this.file + ":" + this.line + ")";
    }

    public static boolean isWindowsPath(@NotNull String path2) {
        if (path2 == null) {
            PySourcePosition.$$$reportNull$$$0(0);
        }
        return path2.contains("\\") || OSAgnosticPathUtil.startsWithWindowsDrive((String)path2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/jetbrains/python/debugger/PySourcePosition", "isWindowsPath"));
    }
}

