/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.configuration;

import com.intellij.execution.target.TargetConfigurationWithLocalFsAccess;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.util.Comparing;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.run.PythonInterpreterTargetEnvironmentFactory;
import com.jetbrains.python.run.TargetConfigurationWithLocalFsAccessExKt;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class PyConfigurableInterpreterList {
    private ProjectSdksModel myModel;

    public static PyConfigurableInterpreterList getInstance(@Nullable Project project2) {
        Project effectiveProject = project2 != null ? project2 : ProjectManager.getInstance().getDefaultProject();
        PyConfigurableInterpreterList instance = (PyConfigurableInterpreterList)effectiveProject.getService(PyConfigurableInterpreterList.class);
        if (effectiveProject != project2) {
            instance.disposeModel();
        }
        return instance;
    }

    public ProjectSdksModel getModel() {
        if (this.myModel == null) {
            this.myModel = new ProjectSdksModel();
            this.myModel.reset(null);
        }
        return this.myModel;
    }

    public void disposeModel() {
        if (this.myModel != null) {
            this.myModel.disposeUIResources();
            this.myModel = null;
        }
    }

    public List<Sdk> getAllPythonSdks(@Nullable Project project2, @Nullable Module module) {
        TargetConfigurationWithLocalFsAccess targetModuleSitsOn = module != null ? PythonInterpreterTargetEnvironmentFactory.Companion.getTargetModuleResidesOn(module) : null;
        ArrayList<Sdk> result2 = new ArrayList<Sdk>();
        for (Sdk sdk2 : this.getModel().getSdks()) {
            TargetEnvironmentConfiguration sdkConfig;
            if (!(sdk2.getSdkType() instanceof PythonSdkType) || targetModuleSitsOn != null && !TargetConfigurationWithLocalFsAccessExKt.codeCouldProbablyBeRunWithConfig(targetModuleSitsOn, sdkConfig = PySdkExtKt.getTargetEnvConfiguration(sdk2))) continue;
            result2.add(sdk2);
        }
        result2.sort(new PyInterpreterComparator(project2));
        return result2;
    }

    public List<Sdk> getAllPythonSdks() {
        return this.getAllPythonSdks(null, null);
    }

    private static class PyInterpreterComparator
    implements Comparator<Sdk> {
        @Nullable
        private final Project myProject;

        PyInterpreterComparator(@Nullable Project project2) {
            this.myProject = project2;
        }

        @Override
        public int compare(Sdk o1, Sdk o2) {
            if (!(o1.getSdkType() instanceof PythonSdkType) || !(o2.getSdkType() instanceof PythonSdkType)) {
                return -Comparing.compare((Comparable)((Object)o1.getName()), (Comparable)((Object)o2.getName()));
            }
            boolean isVEnv1 = PythonSdkUtil.isVirtualEnv(o1) || PythonSdkUtil.isCondaVirtualEnv(o1);
            boolean isVEnv2 = PythonSdkUtil.isVirtualEnv(o2) || PythonSdkUtil.isCondaVirtualEnv(o2);
            boolean isRemote1 = PythonSdkUtil.isRemote(o1);
            boolean isRemote2 = PythonSdkUtil.isRemote(o2);
            if (isVEnv1) {
                if (isVEnv2) {
                    if (this.myProject != null && PyInterpreterComparator.associatedWithCurrent(o1, this.myProject)) {
                        if (PyInterpreterComparator.associatedWithCurrent(o2, this.myProject)) {
                            return PyInterpreterComparator.compareSdk(o1, o2);
                        }
                        return -1;
                    }
                    return PyInterpreterComparator.compareSdk(o1, o2);
                }
                return -1;
            }
            if (isVEnv2) {
                return 1;
            }
            if (isRemote1) {
                if (isRemote2) {
                    return PyInterpreterComparator.compareSdk(o1, o2);
                }
                return 1;
            }
            if (isRemote2) {
                return -1;
            }
            return PyInterpreterComparator.compareSdk(o1, o2);
        }

        private static int compareSdk(Sdk o1, Sdk o2) {
            PythonSdkFlavor<?> flavor2;
            LanguageLevel level2;
            PythonSdkFlavor<?> flavor1 = PythonSdkFlavor.getFlavor(o1);
            LanguageLevel level1 = flavor1 != null ? flavor1.getLanguageLevel(o1) : LanguageLevel.getDefault();
            int compare = Comparing.compare((Comparable)((Object)level1), (Comparable)((Object)(level2 = (flavor2 = PythonSdkFlavor.getFlavor(o2)) != null ? flavor2.getLanguageLevel(o2) : LanguageLevel.getDefault())));
            if (compare != 0) {
                return -compare;
            }
            return Comparing.compare((Comparable)((Object)o1.getName()), (Comparable)((Object)o2.getName()));
        }

        private static boolean associatedWithCurrent(Sdk o1, Project project2) {
            PythonSdkAdditionalData data = (PythonSdkAdditionalData)o1.getSdkAdditionalData();
            if (data != null) {
                String path2 = data.getAssociatedModulePath();
                String projectBasePath = project2.getBasePath();
                if (path2 != null && path2.equals(projectBasePath)) {
                    return true;
                }
            }
            return false;
        }
    }
}

