/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp;

import com.intellij.find.SearchReplaceComponent;
import com.intellij.find.SearchSession;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.SaveAndSyncHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.terminal.TerminalTitle;
import com.intellij.terminal.TerminalTitleKt;
import com.intellij.ui.util.UiSizeUtilKt;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.JBInsets;
import com.jediterm.core.util.TermSize;
import com.jediterm.terminal.RequestOrigin;
import com.jediterm.terminal.Terminal;
import com.jediterm.terminal.TtyConnector;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.action.TerminalInterruptCommandAction;
import org.jetbrains.plugins.terminal.action.TerminalMoveCaretToLineEndAction;
import org.jetbrains.plugins.terminal.action.TerminalMoveCaretToLineStartAction;
import org.jetbrains.plugins.terminal.exp.BlockTerminalController;
import org.jetbrains.plugins.terminal.exp.BlockTerminalSearchSession;
import org.jetbrains.plugins.terminal.exp.BlockTerminalSession;
import org.jetbrains.plugins.terminal.exp.CommandFinishedEvent;
import org.jetbrains.plugins.terminal.exp.ShellCommandListener;
import org.jetbrains.plugins.terminal.exp.SimpleTerminalController;
import org.jetbrains.plugins.terminal.exp.SimpleTerminalView;
import org.jetbrains.plugins.terminal.exp.TerminalCommandExecutor;
import org.jetbrains.plugins.terminal.exp.TerminalContentView;
import org.jetbrains.plugins.terminal.exp.TerminalFocusModel;
import org.jetbrains.plugins.terminal.exp.TerminalModel;
import org.jetbrains.plugins.terminal.exp.TerminalOutputController;
import org.jetbrains.plugins.terminal.exp.TerminalOutputView;
import org.jetbrains.plugins.terminal.exp.TerminalPromotedEditorAction;
import org.jetbrains.plugins.terminal.exp.TerminalPromptController;
import org.jetbrains.plugins.terminal.exp.TerminalPromptView;
import org.jetbrains.plugins.terminal.exp.TerminalSelectionController;
import org.jetbrains.plugins.terminal.exp.TerminalUi;
import org.jetbrains.plugins.terminal.exp.TerminalUiUtils;
import org.jetbrains.plugins.terminal.exp.TerminalUiUtilsKt;
import org.jetbrains.plugins.terminal.util.ShellType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002:\u0001AB%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020#2\u0006\u0010)\u001a\u00020*H\u0003J\u0018\u0010+\u001a\u00020#2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0016J\b\u00100\u001a\u00020#H\u0016J\u000e\u00101\u001a\b\u0012\u0004\u0012\u00020*02H\u0002J\n\u00103\u001a\u0004\u0018\u00010/H\u0016J\b\u00104\u001a\u00020#H\u0002J\b\u00105\u001a\u00020#H\u0002J\b\u00106\u001a\u00020#H\u0002J\u0018\u00107\u001a\u00020#2\u0006\u00108\u001a\u00020\u000f2\u0006\u00109\u001a\u00020\u000fH\u0002J\b\u0010:\u001a\u00020*H\u0016J\u0010\u0010;\u001a\u00020#2\u0006\u0010<\u001a\u00020=H\u0016J\u0010\u0010>\u001a\u00020#2\u0006\u0010?\u001a\u00020=H\u0016J\b\u0010@\u001a\u00020#H\u0002R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lorg/jetbrains/plugins/terminal/exp/BlockTerminalView;", "Lorg/jetbrains/plugins/terminal/exp/TerminalContentView;", "Lorg/jetbrains/plugins/terminal/exp/TerminalCommandExecutor;", "project", "Lcom/intellij/openapi/project/Project;", "session", "Lorg/jetbrains/plugins/terminal/exp/BlockTerminalSession;", "settings", "Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;", "terminalTitle", "Lcom/intellij/terminal/TerminalTitle;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/terminal/exp/BlockTerminalSession;Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;Lcom/intellij/terminal/TerminalTitle;)V", "alternateBufferView", "Lorg/jetbrains/plugins/terminal/exp/SimpleTerminalView;", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "controller", "Lorg/jetbrains/plugins/terminal/exp/BlockTerminalController;", "focusModel", "Lorg/jetbrains/plugins/terminal/exp/TerminalFocusModel;", "outputView", "Lorg/jetbrains/plugins/terminal/exp/TerminalOutputView;", "getOutputView", "()Lorg/jetbrains/plugins/terminal/exp/TerminalOutputView;", "preferredFocusableComponent", "getPreferredFocusableComponent", "promptView", "Lorg/jetbrains/plugins/terminal/exp/TerminalPromptView;", "getPromptView", "()Lorg/jetbrains/plugins/terminal/exp/TerminalPromptView;", "selectionController", "Lorg/jetbrains/plugins/terminal/exp/TerminalSelectionController;", "addTerminationCallback", "", "onTerminated", "Ljava/lang/Runnable;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "alternateBufferStateChanged", "enabled", "", "connectToTty", "ttyConnector", "Lcom/jediterm/terminal/TtyConnector;", "initialTermSize", "Lcom/jediterm/core/util/TermSize;", "dispose", "getDisposed", "Lkotlin/Function0;", "getTerminalSize", "installActions", "installAlternateBufferPanel", "installPromptAndOutput", "installTypingEventsForwarding", "origin", "destination", "isFocused", "sendCommandToExecute", "shellCommand", "", "startCommandExecution", "command", "updateTerminalSize", "BlockTerminalPanel", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nBlockTerminalView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlockTerminalView.kt\norg/jetbrains/plugins/terminal/exp/BlockTerminalView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,316:1\n1#2:317\n1855#3,2:318\n*S KotlinDebug\n*F\n+ 1 BlockTerminalView.kt\norg/jetbrains/plugins/terminal/exp/BlockTerminalView\n*L\n224#1:318,2\n*E\n"})
public final class BlockTerminalView
implements TerminalContentView,
TerminalCommandExecutor {
    @NotNull
    private final Project project;
    @NotNull
    private final BlockTerminalSession session;
    @NotNull
    private final JBTerminalSystemSettingsProviderBase settings;
    @NotNull
    private final BlockTerminalController controller;
    @NotNull
    private final TerminalSelectionController selectionController;
    @NotNull
    private final TerminalFocusModel focusModel;
    @NotNull
    private final TerminalOutputView outputView;
    @NotNull
    private final TerminalPromptView promptView;
    @Nullable
    private SimpleTerminalView alternateBufferView;
    @NotNull
    private final JComponent component;

    public BlockTerminalView(@NotNull Project project, @NotNull BlockTerminalSession session2, @NotNull JBTerminalSystemSettingsProviderBase settings, @NotNull TerminalTitle terminalTitle) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)terminalTitle, (String)"terminalTitle");
        this.project = project;
        this.session = session2;
        this.settings = settings;
        this.focusModel = new TerminalFocusModel(this.project, this);
        this.outputView = new TerminalOutputView(this.project, this.session, this.settings, this.focusModel);
        this.promptView = new TerminalPromptView(this.project, this.settings, this.session, this);
        this.component = new BlockTerminalPanel();
        this.selectionController = new TerminalSelectionController(this.focusModel, this.outputView.getController().getSelectionModel(), this.outputView.getController().getOutputModel());
        this.controller = new BlockTerminalController(this.project, this.session, this.outputView.getController(), this.promptView.getController(), this.selectionController, this.focusModel);
        Disposer.register((Disposable)this, (Disposable)this.outputView);
        Disposer.register((Disposable)this, (Disposable)this.promptView);
        this.promptView.getController().addListener(new TerminalPromptController.PromptStateListener(){

            @Override
            public void promptVisibilityChanged(boolean visible) {
                this.getComponent().revalidate();
                Function0 function0 = this.getDisposed();
                ModalityState modalityState = ModalityState.any();
                Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"any(...)");
                TerminalUiUtilsKt.invokeLater((Function0<Boolean>)function0, modalityState, () -> 1.promptVisibilityChanged$lambda$0(this));
            }

            private static final void promptVisibilityChanged$lambda$0(BlockTerminalView this$0) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                if (this$0.focusModel.isActive()) {
                    IdeFocusManager.getInstance((Project)this$0.project).requestFocus((Component)this$0.getPreferredFocusableComponent(), true);
                }
            }
        });
        TerminalPromptController.addDocumentListener$default(this.promptView.getController(), new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (UiSizeUtilKt.getPreferredHeight((JComponent)this.getPromptView().getComponent()) != this.getPromptView().getComponent().getHeight()) {
                    this.getComponent().revalidate();
                }
            }
        }, null, 2, null);
        TerminalOutputController.addDocumentListener$default(this.outputView.getController(), new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.getComponent().revalidate();
            }
        }, null, 2, null);
        this.getComponent().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(@Nullable ComponentEvent e) {
                this.updateTerminalSize();
            }
        });
        this.getComponent().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                IdeFocusManager.getInstance((Project)project).requestFocus((Component)this.getPreferredFocusableComponent(), true);
            }
        });
        TerminalModel.addTerminalListener$default(this.session.getModel(), new TerminalModel.TerminalListener(){

            @Override
            public void onAlternateBufferChanged(boolean enabled) {
                Function0 function0 = this.getDisposed();
                ModalityState modalityState = ModalityState.any();
                Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"any(...)");
                TerminalUiUtilsKt.invokeLater((Function0<Boolean>)function0, modalityState, () -> 6.onAlternateBufferChanged$lambda$0(this, enabled));
            }

            private static final void onAlternateBufferChanged$lambda$0(BlockTerminalView this$0, boolean $enabled) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                this$0.alternateBufferStateChanged($enabled);
            }
        }, null, 2, null);
        TerminalTitleKt.bindApplicationTitle((TerminalTitle)terminalTitle, (Terminal)((Terminal)this.session.getController$intellij_terminal()), (Disposable)this);
        BlockTerminalController.addListener$default(this.controller, new BlockTerminalController.BlockTerminalControllerListener(){

            @Override
            public void searchSessionStarted(@NotNull SearchSession session2) {
                Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
                TerminalOutputView terminalOutputView = this.getOutputView();
                SearchReplaceComponent searchReplaceComponent = session2.getComponent();
                Intrinsics.checkNotNullExpressionValue((Object)searchReplaceComponent, (String)"getComponent(...)");
                terminalOutputView.installSearchComponent(searchReplaceComponent);
            }

            @Override
            public void searchSessionFinished(@NotNull SearchSession session2) {
                Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
                TerminalOutputView terminalOutputView = this.getOutputView();
                SearchReplaceComponent searchReplaceComponent = session2.getComponent();
                Intrinsics.checkNotNullExpressionValue((Object)searchReplaceComponent, (String)"getComponent(...)");
                terminalOutputView.removeSearchComponent(searchReplaceComponent);
            }
        }, null, 2, null);
        this.installTypingEventsForwarding(this.outputView.getPreferredFocusableComponent(), this.promptView.getPreferredFocusableComponent());
        this.installPromptAndOutput();
        this.installActions();
        TerminalFocusModel.addListener$default(this.focusModel, new TerminalFocusModel.TerminalFocusListener(){

            @Override
            public void activeStateChanged(boolean isActive) {
                if (isActive) {
                    if (GeneralSettings.Companion.getInstance().isSaveOnFrameDeactivation()) {
                        FileDocumentManager.getInstance().saveAllDocuments();
                    }
                } else {
                    SaveAndSyncHandler.Companion.getInstance().scheduleRefresh();
                }
            }
        }, null, 2, null);
        this.session.getCommandManager$intellij_terminal().addListener(new ShellCommandListener(){

            @Override
            public void commandFinished(@NotNull CommandFinishedEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                SaveAndSyncHandler.Companion.getInstance().scheduleRefresh();
            }
        }, this);
    }

    @NotNull
    public final TerminalOutputView getOutputView() {
        return this.outputView;
    }

    @NotNull
    public final TerminalPromptView getPromptView() {
        return this.promptView;
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        return this.component;
    }

    @Override
    @NotNull
    public JComponent getPreferredFocusableComponent() {
        JComponent jComponent;
        if (this.alternateBufferView != null) {
            SimpleTerminalView simpleTerminalView = this.alternateBufferView;
            Intrinsics.checkNotNull((Object)simpleTerminalView);
            jComponent = simpleTerminalView.getPreferredFocusableComponent();
        } else if (this.controller.getSearchSession() != null) {
            BlockTerminalSearchSession blockTerminalSearchSession = this.controller.getSearchSession();
            Intrinsics.checkNotNull((Object)blockTerminalSearchSession);
            JTextComponent jTextComponent = blockTerminalSearchSession.getComponent().getSearchTextComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jTextComponent, (String)"getSearchTextComponent(...)");
            jComponent = jTextComponent;
        } else {
            jComponent = this.promptView.getComponent().isVisible() && this.selectionController.getPrimarySelection() == null ? this.promptView.getPreferredFocusableComponent() : this.outputView.getPreferredFocusableComponent();
        }
        return jComponent;
    }

    @Override
    public void connectToTty(@NotNull TtyConnector ttyConnector, @NotNull TermSize initialTermSize) {
        Intrinsics.checkNotNullParameter((Object)ttyConnector, (String)"ttyConnector");
        Intrinsics.checkNotNullParameter((Object)initialTermSize, (String)"initialTermSize");
        this.session.getController$intellij_terminal().resize(initialTermSize, RequestOrigin.User);
        this.session.start(ttyConnector);
    }

    @RequiresEdt(generateAssertion=false)
    private final void alternateBufferStateChanged(boolean enabled) {
        if (enabled) {
            this.installAlternateBufferPanel();
        } else {
            SimpleTerminalView simpleTerminalView = this.alternateBufferView;
            if (simpleTerminalView != null) {
                SimpleTerminalView it = simpleTerminalView;
                boolean bl = false;
                Disposer.dispose((Disposable)it);
            }
            this.alternateBufferView = null;
            this.installPromptAndOutput();
        }
        this.outputView.getController().alternateBufferStateChanged$intellij_terminal(enabled);
        IdeFocusManager.getInstance((Project)this.project).requestFocus((Component)this.getPreferredFocusableComponent(), true);
        Function0<Boolean> function0 = this.getDisposed();
        ModalityState modalityState = ModalityState.any();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"any(...)");
        TerminalUiUtilsKt.invokeLater(function0, modalityState, () -> BlockTerminalView.alternateBufferStateChanged$lambda$1(this));
    }

    private final void installAlternateBufferPanel() {
        SimpleTerminalView view = new SimpleTerminalView(this.project, this.settings, this.session, false);
        Disposer.register((Disposable)this, (Disposable)view);
        this.alternateBufferView = view;
        JComponent $this$installAlternateBufferPanel_u24lambda_u242 = this.getComponent();
        boolean bl = false;
        $this$installAlternateBufferPanel_u24lambda_u242.removeAll();
        $this$installAlternateBufferPanel_u24lambda_u242.add(view.getComponent());
        $this$installAlternateBufferPanel_u24lambda_u242.revalidate();
    }

    private final void installPromptAndOutput() {
        JComponent $this$installPromptAndOutput_u24lambda_u243 = this.getComponent();
        boolean bl = false;
        $this$installPromptAndOutput_u24lambda_u243.removeAll();
        $this$installPromptAndOutput_u24lambda_u243.add(this.outputView.getComponent());
        $this$installPromptAndOutput_u24lambda_u243.add(this.promptView.getComponent());
        $this$installPromptAndOutput_u24lambda_u243.revalidate();
    }

    private final void installTypingEventsForwarding(JComponent origin, JComponent destination) {
        origin.addKeyListener(new KeyAdapter(destination, this){
            final /* synthetic */ JComponent $destination;
            final /* synthetic */ BlockTerminalView this$0;
            {
                this.$destination = $destination;
                this.this$0 = $receiver;
            }

            public void keyTyped(@NotNull KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.getID() == 400 && this.$destination.isShowing()) {
                    e.consume();
                    IdeFocusManager.getInstance((Project)BlockTerminalView.access$getProject$p(this.this$0)).requestFocus((Component)this.$destination, true);
                    KeyEvent newEvent = new KeyEvent(this.$destination, e.getID(), e.getWhen(), e.getModifiers(), e.getKeyCode(), e.getKeyChar(), e.getKeyLocation());
                    this.$destination.dispatchEvent(newEvent);
                }
            }
        });
    }

    private final void installActions() {
        new TerminalInterruptCommandAction().registerCustomShortcutSet(this.getComponent(), null);
        if (this.session.getShellIntegration().getShellType() != ShellType.POWERSHELL) {
            Object[] objectArray = new Object[]{new TerminalMoveCaretToLineStartAction(), new TerminalMoveCaretToLineEndAction()};
            Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])objectArray);
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator.next();
                boolean bl = false;
                ((TerminalPromotedEditorAction)((Object)it)).registerCustomShortcutSet(this.getComponent(), null);
            }
        }
    }

    @Override
    public void startCommandExecution(@NotNull String command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        this.controller.startCommandExecution(command);
    }

    private final void updateTerminalSize() {
        TermSize termSize = this.getTerminalSize();
        if (termSize == null) {
            return;
        }
        TermSize newSize = termSize;
        this.controller.resize(newSize);
    }

    @Override
    @Nullable
    public TermSize getTerminalSize() {
        Pair pair;
        if (this.alternateBufferView != null) {
            SimpleTerminalView simpleTerminalView = this.alternateBufferView;
            Intrinsics.checkNotNull((Object)simpleTerminalView);
            it = simpleTerminalView;
            boolean bl = false;
            pair = TuplesKt.to((Object)((SimpleTerminalView)it).getTerminalWidth(), (Object)((SimpleTerminalView)it).getCharSize());
        } else {
            it = this.outputView;
            boolean bl = false;
            pair = TuplesKt.to((Object)((TerminalOutputView)it).getTerminalWidth(), (Object)((TerminalOutputView)it).getCharSize());
        }
        Pair pair2 = pair;
        int width = ((Number)pair2.component1()).intValue();
        Dimension charSize = (Dimension)pair2.component2();
        return width > 0 && this.getComponent().getHeight() > 0 ? TerminalUiUtils.INSTANCE.calculateTerminalSize(new Dimension(width, this.getComponent().getHeight()), charSize) : null;
    }

    @Override
    public boolean isFocused() {
        return this.outputView.getComponent().hasFocus() || this.promptView.getComponent().hasFocus();
    }

    @Override
    public void addTerminationCallback(@NotNull Runnable onTerminated, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)onTerminated, (String)"onTerminated");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.session.addTerminationCallback(onTerminated, parentDisposable);
    }

    @Override
    public void sendCommandToExecute(@NotNull String shellCommand2) {
        Intrinsics.checkNotNullParameter((Object)shellCommand2, (String)"shellCommand");
        this.controller.startCommandExecution(shellCommand2);
    }

    public void dispose() {
    }

    private final Function0<Boolean> getDisposed() {
        return TerminalUiUtilsKt.getDisposed((Editor)this.outputView.getController().getOutputModel().getEditor());
    }

    private static final void alternateBufferStateChanged$lambda$1(BlockTerminalView this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.updateTerminalSize();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/terminal/exp/BlockTerminalView$BlockTerminalPanel;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "(Lorg/jetbrains/plugins/terminal/exp/BlockTerminalView;)V", "doLayout", "", "getData", "", "dataId", "", "layoutPromptAndOutput", "rect", "Ljava/awt/Rectangle;", "intellij.terminal"})
    private final class BlockTerminalPanel
    extends JPanel
    implements DataProvider {
        public BlockTerminalPanel() {
            this.setBackground((Color)TerminalUi.INSTANCE.defaultBackground((Editor)BlockTerminalView.this.getOutputView().getController().getOutputModel().getEditor()));
        }

        @Nullable
        public Object getData(@NotNull String dataId) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
            String string = dataId;
            if (Intrinsics.areEqual((Object)string, (Object)TerminalPromptController.Companion.getKEY().getName())) {
                object = BlockTerminalView.this.getPromptView().getController();
            } else if (Intrinsics.areEqual((Object)string, (Object)TerminalOutputController.Companion.getKEY().getName())) {
                object = BlockTerminalView.this.getOutputView().getController();
            } else if (Intrinsics.areEqual((Object)string, (Object)SimpleTerminalController.Companion.getKEY().getName())) {
                SimpleTerminalView simpleTerminalView = BlockTerminalView.this.alternateBufferView;
                object = simpleTerminalView != null ? simpleTerminalView.getController() : null;
            } else {
                object = Intrinsics.areEqual((Object)string, (Object)BlockTerminalController.Companion.getKEY().getName()) ? BlockTerminalView.this.controller : (Intrinsics.areEqual((Object)string, (Object)TerminalSelectionController.Companion.getKEY().getName()) ? BlockTerminalView.this.selectionController : (Intrinsics.areEqual((Object)string, (Object)TerminalFocusModel.Companion.getKEY().getName()) ? BlockTerminalView.this.focusModel : (Intrinsics.areEqual((Object)string, (Object)BlockTerminalSession.Companion.getDATA_KEY().getName()) ? BlockTerminalView.this.session : null)));
            }
            return object;
        }

        @Override
        public void doLayout() {
            Rectangle rect = this.getBounds();
            JBInsets.removeFrom((Rectangle)rect, (Insets)this.getInsets());
            switch (this.getComponentCount()) {
                case 1: {
                    Component component2 = this.getComponent(0);
                    component2.setBounds(rect);
                    break;
                }
                case 2: {
                    Intrinsics.checkNotNull((Object)rect);
                    this.layoutPromptAndOutput(rect);
                    break;
                }
                default: {
                    throw new IllegalStateException("Maximum 2 components expected".toString());
                }
            }
        }

        private final void layoutPromptAndOutput(Rectangle rect) {
            Component topComponent = this.getComponent(0);
            Component bottomComponent = this.getComponent(1);
            Dimension topPrefSize = topComponent.isVisible() ? topComponent.getPreferredSize() : new Dimension();
            Dimension bottomPrefSize = bottomComponent.isVisible() ? bottomComponent.getPreferredSize() : new Dimension();
            int bottomHeight = Math.max(rect.height - topPrefSize.height, bottomPrefSize.height);
            int topHeight = rect.height - bottomHeight;
            topComponent.setBounds(new Rectangle(rect.x, rect.y, rect.width, topHeight));
            bottomComponent.setBounds(new Rectangle(rect.x, rect.y + topHeight, rect.width, bottomHeight));
        }
    }
}

