/*
 * Decompiled with CFR 0.152.
 */
package org.toml.ide.json;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.json.pointer.JsonPointerPosition;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.util.Consumer;
import com.intellij.util.ThreeState;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.extension.adapters.JsonPropertyAdapter;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaDocumentationProvider;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaResolver;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import com.jetbrains.jsonSchema.impl.light.legacy.JsonSchemaObjectReadingUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.toml.ide.experiments.TomlExperiments;
import org.toml.ide.json.TomlJsonSchemaCompletionFileFilter;
import org.toml.lang.psi.TomlLiteral;
import org.toml.lang.psi.TomlTableHeader;
import org.toml.lang.psi.ext.TomlLiteralKind;
import org.toml.lang.psi.ext.TomlLiteralKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \t2\u00020\u0001:\u0002\t\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/toml/ide/json/TomlJsonSchemaCompletionContributor;", "Lcom/intellij/codeInsight/completion/CompletionContributor;", "()V", "fillCompletionVariants", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "Companion", "Worker", "intellij.toml.json"})
public final class TomlJsonSchemaCompletionContributor
extends CompletionContributor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final double LOW_PRIORITY = -1000.0;
    @NotNull
    private static final List<JsonSchemaType> JSON_COMPOUND_TYPES;

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        if (!TomlExperiments.INSTANCE.isJsonSchemaEnabled()) {
            return;
        }
        PsiFile psiFile = parameters.getOriginalFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getOriginalFile(...)");
        if (!TomlJsonSchemaCompletionFileFilter.Companion.shouldCompleteInFile(psiFile)) {
            return;
        }
        PsiElement psiElement = parameters.getPosition();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPosition(...)");
        PsiElement position = psiElement;
        JsonSchemaService jsonSchemaService = JsonSchemaService.Impl.get((Project)position.getProject());
        JsonSchemaObject jsonSchemaObject = jsonSchemaService.getSchemaObject(parameters.getOriginalFile());
        if (jsonSchemaObject != null) {
            PsiElement psiElement2 = parameters.getOriginalPosition();
            if (psiElement2 == null) {
                psiElement2 = parameters.getPosition();
            }
            PsiElement psiElement3 = psiElement2;
            Intrinsics.checkNotNull((Object)psiElement3);
            PsiElement completionPosition = psiElement3;
            PsiElement psiElement4 = parameters.getPosition();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement4, (String)"getPosition(...)");
            Worker worker = new Worker(jsonSchemaObject, psiElement4, completionPosition, (Consumer<LookupElement>)((Consumer)result));
            worker.work();
        }
    }

    static {
        Object[] objectArray = new JsonSchemaType[]{JsonSchemaType._array, JsonSchemaType._object, JsonSchemaType._any, null};
        JSON_COMPOUND_TYPES = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/toml/ide/json/TomlJsonSchemaCompletionContributor$Companion;", "", "()V", "JSON_COMPOUND_TYPES", "", "Lcom/jetbrains/jsonSchema/impl/JsonSchemaType;", "LOW_PRIORITY", "", "intellij.toml.json"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\b\u00a2\u0006\u0002\u0010\nJ>\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00032\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00112\u0006\u0010\u0006\u001a\u00020\u0005H\u0002J\u0018\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\u0003H\u0002J\u0010\u0010\"\u001a\u00020\t2\u0006\u0010#\u001a\u00020\u001bH\u0002J\u0017\u0010$\u001a\u00070%\u00a2\u0006\u0002\b&2\b\u0010'\u001a\u0004\u0018\u00010(H\u0002J\u0018\u0010)\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010*\u001a\u00020\fH\u0002J\u0018\u0010+\u001a\b\u0012\u0004\u0012\u00020\t0,2\b\u0010'\u001a\u0004\u0018\u00010(H\u0002J\u0006\u0010-\u001a\u00020\u0017R\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lorg/toml/ide/json/TomlJsonSchemaCompletionContributor$Worker;", "", "rootSchema", "Lcom/jetbrains/jsonSchema/impl/JsonSchemaObject;", "position", "Lcom/intellij/psi/PsiElement;", "originalPosition", "resultConsumer", "Lcom/intellij/util/Consumer;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "(Lcom/jetbrains/jsonSchema/impl/JsonSchemaObject;Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;Lcom/intellij/util/Consumer;)V", "isInsideStringLiteral", "", "()Z", "project", "Lcom/intellij/openapi/project/Project;", "variants", "", "getVariants", "()Ljava/util/Set;", "walker", "Lcom/jetbrains/jsonSchema/extension/JsonLikePsiWalker;", "addAllPropertyVariants", "", "schema", "properties", "", "", "adapter", "Lcom/jetbrains/jsonSchema/extension/adapters/JsonPropertyAdapter;", "knownNames", "addPropertyVariant", "key", "jsonSchemaObject", "buildPairLookupElement", "element", "getIconForType", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "type", "Lcom/jetbrains/jsonSchema/impl/JsonSchemaType;", "suggestValues", "isSurelyValue", "suggestValuesByType", "", "work", "intellij.toml.json"})
    @SourceDebugExtension(value={"SMAP\nTomlJsonSchemaCompletionContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TomlJsonSchemaCompletionContributor.kt\norg/toml/ide/json/TomlJsonSchemaCompletionContributor$Worker\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,191:1\n60#2,2:192\n1549#3:194\n1620#3,3:195\n*S KotlinDebug\n*F\n+ 1 TomlJsonSchemaCompletionContributor.kt\norg/toml/ide/json/TomlJsonSchemaCompletionContributor$Worker\n*L\n109#1:192,2\n162#1:194\n162#1:195,3\n*E\n"})
    private static final class Worker {
        @NotNull
        private final JsonSchemaObject rootSchema;
        @NotNull
        private final PsiElement position;
        @NotNull
        private final PsiElement originalPosition;
        @NotNull
        private final Consumer<LookupElement> resultConsumer;
        @NotNull
        private final Set<LookupElement> variants;
        @Nullable
        private final JsonLikePsiWalker walker;
        @NotNull
        private final Project project;

        public Worker(@NotNull JsonSchemaObject rootSchema, @NotNull PsiElement position, @NotNull PsiElement originalPosition, @NotNull Consumer<LookupElement> resultConsumer) {
            Intrinsics.checkNotNullParameter((Object)rootSchema, (String)"rootSchema");
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            Intrinsics.checkNotNullParameter((Object)originalPosition, (String)"originalPosition");
            Intrinsics.checkNotNullParameter(resultConsumer, (String)"resultConsumer");
            this.rootSchema = rootSchema;
            this.position = position;
            this.originalPosition = originalPosition;
            this.resultConsumer = resultConsumer;
            this.variants = new LinkedHashSet();
            this.walker = JsonLikePsiWalker.getWalker((PsiElement)this.position, (JsonSchemaObject)this.rootSchema);
            Project project = this.originalPosition.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            this.project = project;
        }

        @NotNull
        public final Set<LookupElement> getVariants() {
            return this.variants;
        }

        public final void work() {
            PsiElement checkable;
            JsonLikePsiWalker jsonLikePsiWalker = this.walker;
            PsiElement psiElement = jsonLikePsiWalker != null ? jsonLikePsiWalker.findElementToCheck(this.position) : null;
            if (psiElement == null) {
                return;
            }
            ThreeState isName = this.walker.isName(checkable = psiElement);
            JsonPointerPosition pointerPosition = this.walker.findPosition(checkable, isName == ThreeState.NO);
            if (pointerPosition == null || pointerPosition.isEmpty() && isName == ThreeState.NO) {
                return;
            }
            Collection collection = new JsonSchemaResolver(this.project, this.rootSchema, pointerPosition).resolve();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"resolve(...)");
            Collection schemas = collection;
            HashSet knownNames = new HashSet();
            for (JsonSchemaObject schema : schemas) {
                if (isName != ThreeState.NO) {
                    Set properties = this.walker.getPropertyNamesOfParentObject(this.originalPosition, this.position);
                    JsonPropertyAdapter adapter = this.walker.getParentPropertyAdapter(checkable);
                    Intrinsics.checkNotNull((Object)schema);
                    Intrinsics.checkNotNull((Object)properties);
                    this.addAllPropertyVariants(schema, properties, adapter, knownNames, this.originalPosition);
                }
                if (isName == ThreeState.YES) continue;
                Intrinsics.checkNotNull((Object)schema);
                this.suggestValues(schema, isName == ThreeState.NO);
            }
            for (LookupElement variant : this.variants) {
                this.resultConsumer.consume((Object)variant);
            }
        }

        private final void addAllPropertyVariants(JsonSchemaObject schema, Collection<String> properties, JsonPropertyAdapter adapter, Set<String> knownNames, PsiElement originalPosition) {
            StreamEx variants2 = (StreamEx)StreamEx.of((Iterator)schema.getPropertyNames()).filter(arg_0 -> Worker.addAllPropertyVariants$lambda$0((Function1)new Function1<String, Boolean>(properties, knownNames, adapter){
                final /* synthetic */ Collection<String> $properties;
                final /* synthetic */ Set<String> $knownNames;
                final /* synthetic */ JsonPropertyAdapter $adapter;
                {
                    this.$properties = $properties;
                    this.$knownNames = $knownNames;
                    this.$adapter = $adapter;
                    super(1);
                }

                /*
                 * Enabled aggressive block sorting
                 */
                @NotNull
                public final Boolean invoke(String name) {
                    boolean bl;
                    if (this.$properties.contains(name) || this.$knownNames.contains(name)) {
                        JsonPropertyAdapter jsonPropertyAdapter = this.$adapter;
                        if (!Intrinsics.areEqual((Object)name, (Object)(jsonPropertyAdapter != null ? jsonPropertyAdapter.getName() : null))) {
                            bl = false;
                            return bl;
                        }
                    }
                    bl = true;
                    return bl;
                }
            }, arg_0));
            for (String variant : variants2) {
                boolean isTomlHeader;
                Intrinsics.checkNotNull((Object)variant);
                knownNames.add(variant);
                JsonSchemaObject jsonSchemaObject = schema.getPropertyByName(variant);
                if (jsonSchemaObject == null) continue;
                PsiElement $this$parentOfType_u24default$iv = originalPosition;
                boolean withSelf$iv = false;
                boolean $i$f$parentOfType = false;
                boolean bl = isTomlHeader = PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, TomlTableHeader.class, (boolean)true) != null;
                if (isTomlHeader && !JSON_COMPOUND_TYPES.contains(JsonSchemaObjectReadingUtils.guessType((JsonSchemaObject)jsonSchemaObject))) continue;
                this.addPropertyVariant(variant, jsonSchemaObject);
            }
        }

        private final void addPropertyVariant(String key, JsonSchemaObject jsonSchemaObject) {
            JsonSchemaObject jsonSchemaObject2;
            String description;
            CharSequence charSequence;
            Collection collection = new JsonSchemaResolver(this.project, jsonSchemaObject).resolve();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"resolve(...)");
            Collection currentVariants = collection;
            JsonSchemaObject jsonSchemaObject3 = (JsonSchemaObject)CollectionsKt.firstOrNull((Iterable)currentVariants);
            if (jsonSchemaObject3 == null) {
                jsonSchemaObject3 = jsonSchemaObject;
            }
            if ((charSequence = (CharSequence)(description = JsonSchemaDocumentationProvider.getBestDocumentation((boolean)true, (JsonSchemaObject)(jsonSchemaObject2 = jsonSchemaObject3)))) == null || StringsKt.isBlank((CharSequence)charSequence)) {
                String string = JsonSchemaObjectReadingUtils.getTypeDescription((JsonSchemaObject)jsonSchemaObject2, (boolean)true);
                if (string == null) {
                    string = "";
                }
                description = string;
            }
            LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)key).withTypeText(description).withIcon(this.getIconForType(JsonSchemaObjectReadingUtils.guessType((JsonSchemaObject)jsonSchemaObject2)));
            Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder, (String)"withIcon(...)");
            LookupElementBuilder lookupElement = lookupElementBuilder;
            this.variants.add((LookupElement)lookupElement);
        }

        private final boolean isInsideStringLiteral() {
            PsiElement psiElement = this.position.getParent();
            TomlLiteral tomlLiteral = psiElement instanceof TomlLiteral ? (TomlLiteral)psiElement : null;
            return (tomlLiteral != null ? TomlLiteralKt.getKind(tomlLiteral) : null) instanceof TomlLiteralKind.String;
        }

        private final void suggestValues(JsonSchemaObject schema, boolean isSurelyValue) {
            List enumVariants = schema.getEnum();
            if (enumVariants != null) {
                for (Object o : enumVariants) {
                    if (this.isInsideStringLiteral() && !(o instanceof String)) continue;
                    String string = this.isInsideStringLiteral() ? StringUtil.unquoteString((String)o.toString()) : o.toString();
                    Intrinsics.checkNotNull((Object)string);
                    String variant = string;
                    LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)variant);
                    Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder, (String)"create(...)");
                    this.variants.add((LookupElement)lookupElementBuilder);
                }
            } else if (isSurelyValue && !this.isInsideStringLiteral()) {
                this.variants.addAll((Collection<LookupElement>)this.suggestValuesByType(JsonSchemaObjectReadingUtils.guessType((JsonSchemaObject)schema)));
            }
        }

        private final List<LookupElement> suggestValuesByType(JsonSchemaType type) {
            JsonSchemaType jsonSchemaType = type;
            return switch (jsonSchemaType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[jsonSchemaType.ordinal()]) {
                case 1 -> CollectionsKt.listOf((Object)this.buildPairLookupElement("{}"));
                case 2 -> CollectionsKt.listOf((Object)this.buildPairLookupElement("[]"));
                case 3 -> CollectionsKt.listOf((Object)this.buildPairLookupElement("\"\""));
                case 4 -> {
                    void $this$mapTo$iv$iv;
                    Object[] var2_2 = new String[]{"true", "false"};
                    Iterable $this$map$iv = CollectionsKt.listOf((Object[])var2_2);
                    boolean $i$f$map = false;
                    Iterable var4_4 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        String var9_9 = (String)item$iv$iv;
                        Collection var11_11 = destination$iv$iv;
                        boolean $i$a$-map-TomlJsonSchemaCompletionContributor$Worker$suggestValuesByType$1 = false;
                        var11_11.add(LookupElementBuilder.create((String)it));
                    }
                    yield (List)destination$iv$iv;
                }
                default -> CollectionsKt.emptyList();
            };
        }

        private final LookupElement buildPairLookupElement(String element) {
            LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)element).withInsertHandler(Worker::buildPairLookupElement$lambda$2);
            Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder, (String)"withInsertHandler(...)");
            LookupElementBuilder builder = lookupElementBuilder;
            LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)((LookupElement)builder), (double)-1000.0);
            Intrinsics.checkNotNullExpressionValue((Object)lookupElement, (String)"withPriority(...)");
            return lookupElement;
        }

        private final Icon getIconForType(JsonSchemaType type) {
            JsonSchemaType jsonSchemaType = type;
            Icon icon = switch (jsonSchemaType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[jsonSchemaType.ordinal()]) {
                case 1 -> AllIcons.Json.Object;
                case 2 -> AllIcons.Json.Array;
                default -> IconManager.Companion.getInstance().getPlatformIcon(PlatformIcons.Property);
            };
            Intrinsics.checkNotNull((Object)icon);
            return icon;
        }

        private static final boolean addAllPropertyVariants$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final void buildPairLookupElement$lambda$2(InsertionContext context, LookupElement lookupElement) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)lookupElement, (String)"<anonymous parameter 1>");
            EditorModificationUtil.moveCaretRelatively((Editor)context.getEditor(), (int)-1);
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[JsonSchemaType.values().length];
                try {
                    nArray[JsonSchemaType._object.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[JsonSchemaType._array.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[JsonSchemaType._string.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[JsonSchemaType._boolean.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

