/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.logs.internal;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.events.EventBuilder;
import io.opentelemetry.api.events.EventEmitter;
import io.opentelemetry.api.events.EventEmitterBuilder;
import io.opentelemetry.api.events.EventEmitterProvider;
import io.opentelemetry.api.logs.LogRecordBuilder;
import io.opentelemetry.api.logs.Logger;
import io.opentelemetry.api.logs.LoggerBuilder;
import io.opentelemetry.api.logs.LoggerProvider;
import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.logs.internal.SdkEventBuilder;
import java.util.concurrent.TimeUnit;

public final class SdkEventEmitterProvider
implements EventEmitterProvider {
    static final AttributeKey<String> EVENT_DOMAIN = AttributeKey.stringKey("event.domain");
    static final AttributeKey<String> EVENT_NAME = AttributeKey.stringKey("event.name");
    static final String DEFAULT_EVENT_DOMAIN = "unknown";
    private final LoggerProvider delegateLoggerProvider;
    private final Clock clock;

    private SdkEventEmitterProvider(LoggerProvider delegateLoggerProvider, Clock clock) {
        this.delegateLoggerProvider = delegateLoggerProvider;
        this.clock = clock;
    }

    public static SdkEventEmitterProvider create(LoggerProvider delegateLoggerProvider) {
        return new SdkEventEmitterProvider(delegateLoggerProvider, Clock.getDefault());
    }

    public static SdkEventEmitterProvider create(LoggerProvider delegateLoggerProvider, Clock clock) {
        return new SdkEventEmitterProvider(delegateLoggerProvider, clock);
    }

    @Override
    public EventEmitter get(String instrumentationScopeName) {
        return this.eventEmitterBuilder(instrumentationScopeName).setEventDomain(DEFAULT_EVENT_DOMAIN).build();
    }

    @Override
    public EventEmitterBuilder eventEmitterBuilder(String instrumentationScopeName) {
        return new SdkEventEmitterBuilder(this.clock, this.delegateLoggerProvider.loggerBuilder(instrumentationScopeName));
    }

    static void addEventNameAndDomain(LogRecordBuilder logRecordBuilder, String eventDomain, String eventName) {
        logRecordBuilder.setAttribute(EVENT_DOMAIN, eventDomain).setAttribute(EVENT_NAME, eventName);
    }

    private static class SdkEventEmitterBuilder
    implements EventEmitterBuilder {
        private final Clock clock;
        private final LoggerBuilder delegateLoggerBuilder;
        private String eventDomain = "unknown";

        private SdkEventEmitterBuilder(Clock clock, LoggerBuilder delegateLoggerBuilder) {
            this.clock = clock;
            this.delegateLoggerBuilder = delegateLoggerBuilder;
        }

        @Override
        public EventEmitterBuilder setEventDomain(String eventDomain) {
            this.eventDomain = eventDomain;
            return this;
        }

        @Override
        public EventEmitterBuilder setSchemaUrl(String schemaUrl) {
            this.delegateLoggerBuilder.setSchemaUrl(schemaUrl);
            return this;
        }

        @Override
        public EventEmitterBuilder setInstrumentationVersion(String instrumentationScopeVersion) {
            this.delegateLoggerBuilder.setInstrumentationVersion(instrumentationScopeVersion);
            return this;
        }

        @Override
        public EventEmitter build() {
            return new SdkEventEmitter(this.clock, this.delegateLoggerBuilder.build(), this.eventDomain);
        }
    }

    private static class SdkEventEmitter
    implements EventEmitter {
        private final Clock clock;
        private final Logger delegateLogger;
        private final String eventDomain;

        private SdkEventEmitter(Clock clock, Logger delegateLogger, String eventDomain) {
            this.clock = clock;
            this.delegateLogger = delegateLogger;
            this.eventDomain = eventDomain;
        }

        @Override
        public EventBuilder builder(String eventName, Attributes attributes) {
            return new SdkEventBuilder(this.delegateLogger.logRecordBuilder().setTimestamp(this.clock.now(), TimeUnit.NANOSECONDS).setAllAttributes(attributes), this.eventDomain, eventName);
        }

        @Override
        public void emit(String eventName, Attributes attributes) {
            LogRecordBuilder logRecordBuilder = this.delegateLogger.logRecordBuilder().setTimestamp(this.clock.now(), TimeUnit.NANOSECONDS).setAllAttributes(attributes);
            SdkEventEmitterProvider.addEventNameAndDomain(logRecordBuilder, this.eventDomain, eventName);
            logRecordBuilder.emit();
        }
    }
}

