/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.execution.junit;

import java.util.Map;

public final class MapSerializerUtil {
    public static final String TEST_FAILED = "testFailed";
    public static final String TEST_IGNORED = "testIgnored";
    public static final EscapeInfoProvider STD_ESCAPER = new EscapeInfoProvider(){

        @Override
        public char escape(char c) {
            switch (c) {
                case '\n': {
                    return 'n';
                }
                case '\r': {
                    return 'r';
                }
                case '\b': {
                    return 'b';
                }
                case '\u0085': {
                    return 'x';
                }
                case '\u2028': {
                    return 'l';
                }
                case '\u2029': {
                    return 'p';
                }
                case '|': {
                    return '|';
                }
                case '\'': {
                    return '\'';
                }
                case '[': {
                    return '[';
                }
                case ']': {
                    return ']';
                }
            }
            return '\u0000';
        }

        @Override
        public char escapeCharacter() {
            return '|';
        }
    };

    public static String escapeStr(String str, EscapeInfoProvider p) {
        if (str == null) {
            return null;
        }
        int finalCount = MapSerializerUtil.calcFinalEscapedStringCount(str, p);
        if (str.length() == finalCount) {
            return str;
        }
        char[] resultChars = new char[finalCount];
        int resultPos = 0;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            char escaped = p.escape(c);
            if (escaped != '\u0000') {
                resultChars[resultPos++] = p.escapeCharacter();
                resultChars[resultPos++] = escaped;
                continue;
            }
            resultChars[resultPos++] = c;
        }
        if (resultPos != finalCount) {
            throw new RuntimeException("Incorrect escaping for '" + str + "'");
        }
        return new String(resultChars);
    }

    private static int calcFinalEscapedStringCount(String name, EscapeInfoProvider p) {
        int result2 = 0;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (p.escape(c) != '\u0000') {
                result2 += 2;
                continue;
            }
            ++result2;
        }
        return result2;
    }

    public static String asString(String messageName, Map attributes) {
        String text = "##teamcity[" + messageName;
        for (Object attrName : attributes.keySet()) {
            text = text + " " + attrName + "='" + MapSerializerUtil.escapeStr((String)attributes.get(attrName), STD_ESCAPER) + "'";
        }
        text = text + "]";
        return text;
    }

    public static interface EscapeInfoProvider {
        public char escape(char var1);

        public char escapeCharacter();
    }
}

