/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject.config.ui;

import com.intellij.DynamicBundle;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainSyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.AncestorListenerAdapter;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.intellij.plugins.intelliLang.inject.InjectedLanguage;
import org.intellij.plugins.intelliLang.inject.config.BaseInjection;
import org.intellij.plugins.intelliLang.inject.config.ui.AbstractInjectionPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class LanguagePanel
extends AbstractInjectionPanel<BaseInjection> {
    private JPanel myRoot;
    private ComboBox<@Nls String> myLanguage;
    private EditorTextField myPrefix;
    private EditorTextField mySuffix;

    public LanguagePanel(Project project, BaseInjection injection) {
        super(injection, project);
        this.$$$setupUI$$$();
        final String[] languageIDs = (String[])ContainerUtil.map2Array((Object[])InjectedLanguage.getAvailableLanguages(), String.class, Language::getID);
        Arrays.sort(languageIDs, String::compareToIgnoreCase);
        this.myLanguage.setModel(new DefaultComboBoxModel<String>(languageIDs));
        this.myLanguage.setRenderer((ListCellRenderer)new ColoredListCellRenderer<String>(){
            final Set<String> IDs;
            {
                this.IDs = Set.of(languageIDs);
            }

            protected void customizeCellRenderer(@NotNull JList list, @Nls String s, int index, boolean selected, boolean hasFocus) {
                LanguageFileType fileType;
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                SimpleTextAttributes attributes = this.IDs.contains(s) ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.ERROR_ATTRIBUTES;
                this.append(s, attributes);
                Language language = InjectedLanguage.findLanguageById(s);
                if (language != null && (fileType = language.getAssociatedFileType()) != null) {
                    this.setIcon(fileType.getIcon());
                    this.append(" ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    this.append("(" + fileType.getDescription() + ")", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "org/intellij/plugins/intelliLang/inject/config/ui/LanguagePanel$1", "customizeCellRenderer"));
            }
        });
        this.myLanguage.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    LanguagePanel.this.updateHighlighters();
                }
            }
        });
        this.myRoot.addAncestorListener((AncestorListener)new AncestorListenerAdapter(){

            public void ancestorAdded(AncestorEvent event) {
                LanguagePanel.this.updateHighlighters();
            }
        });
    }

    void updateHighlighters() {
        EditorImpl editor = (EditorImpl)this.myPrefix.getEditor();
        if (editor == null) {
            return;
        }
        EditorImpl editor2 = (EditorImpl)this.mySuffix.getEditor();
        assert (editor2 != null);
        Language language = InjectedLanguage.findLanguageById(this.getLanguage());
        if (language == null) {
            editor.setHighlighter((EditorHighlighter)new LexerEditorHighlighter((SyntaxHighlighter)new PlainSyntaxHighlighter(), editor.getColorsScheme()));
            editor2.setHighlighter((EditorHighlighter)new LexerEditorHighlighter((SyntaxHighlighter)new PlainSyntaxHighlighter(), editor.getColorsScheme()));
        } else {
            SyntaxHighlighter s1 = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)language, (Project)this.myProject, null);
            SyntaxHighlighter s2 = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)language, (Project)this.myProject, null);
            editor.setHighlighter((EditorHighlighter)new LexerEditorHighlighter(s1, editor.getColorsScheme()));
            editor2.setHighlighter((EditorHighlighter)new LexerEditorHighlighter(s2, editor2.getColorsScheme()));
        }
    }

    @NotNull
    public String getLanguage() {
        String string = (String)this.myLanguage.getSelectedItem();
        if (string == null) {
            LanguagePanel.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void setLanguage(@NlsSafe String id) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.myLanguage.getModel();
        if (model.getIndexOf(id) == -1 && id.length() > 0) {
            model.insertElementAt(id, 0);
        }
        this.myLanguage.setSelectedItem((Object)id);
        this.updateHighlighters();
    }

    public String getPrefix() {
        return this.myPrefix.getText();
    }

    public void setPrefix(String s) {
        if (!this.myPrefix.getText().equals(s)) {
            this.myPrefix.setText(s);
        }
    }

    public String getSuffix() {
        return this.mySuffix.getText();
    }

    public void setSuffix(String s) {
        if (!this.mySuffix.getText().equals(s)) {
            this.mySuffix.setText(s);
        }
    }

    @Override
    protected void resetImpl() {
        this.setLanguage(this.myOrigInjection.getInjectedLanguageId());
        this.setPrefix(this.myOrigInjection.getPrefix());
        this.setSuffix(this.myOrigInjection.getSuffix());
    }

    @Override
    protected void apply(BaseInjection i) {
        i.setInjectedLanguageId(this.getLanguage());
        i.setPrefix(this.getPrefix());
        i.setSuffix(this.getSuffix());
    }

    @Override
    public JPanel getComponent() {
        return this.myRoot;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        EditorTextField editorTextField;
        EditorTextField editorTextField2;
        ComboBox comboBox;
        JPanel jPanel;
        this.myRoot = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/IntelliLangBundle", LanguagePanel.class).getString("language.title"), (int)0, (int)0, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/IntelliLangBundle", LanguagePanel.class).getString("language.label.id"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/IntelliLangBundle", LanguagePanel.class).getString("language.label.prefix"));
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/IntelliLangBundle", LanguagePanel.class).getString("language.label.suffix"));
        jPanel.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLanguage = comboBox = new ComboBox();
        jPanel.add((Component)comboBox, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myPrefix = editorTextField2 = new EditorTextField();
        jPanel.add((Component)editorTextField2, new GridConstraints(1, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        this.mySuffix = editorTextField = new EditorTextField();
        jPanel.add((Component)editorTextField, new GridConstraints(2, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        jLabel.setLabelFor((Component)comboBox);
        jLabel2.setLabelFor((Component)editorTextField2);
        jLabel3.setLabelFor((Component)editorTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRoot;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/intelliLang/inject/config/ui/LanguagePanel", "getLanguage"));
    }
}

