/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.visualization.r.inlays.table;

import javax.swing.table.AbstractTableModel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.dataframe.DataFrame;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0011\u001a\u00020\bH\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\bH\u0016J\u0006\u0010\u0015\u001a\u00020\bJ\u0006\u0010\u0016\u001a\u00020\bJ\b\u0010\u0017\u001a\u00020\bH\u0016J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R$\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR$\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\r\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/table/PagingTableModel;", "Ljavax/swing/table/AbstractTableModel;", "dataFrame", "Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/dataframe/DataFrame;", "(Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/dataframe/DataFrame;)V", "getDataFrame", "()Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/dataframe/DataFrame;", "value", "", "pageOffset", "getPageOffset", "()I", "setPageOffset", "(I)V", "pageSize", "getPageSize", "setPageSize", "getColumnCount", "getColumnName", "", "columnIndex", "getPageCount", "getRealRowCount", "getRowCount", "getValueAt", "", "rowIndex", "intellij.notebooks.visualization"})
public final class PagingTableModel
extends AbstractTableModel {
    @NotNull
    private final DataFrame dataFrame;
    private int pageSize;
    private int pageOffset;

    public PagingTableModel(@NotNull DataFrame dataFrame) {
        Intrinsics.checkNotNullParameter((Object)dataFrame, (String)"dataFrame");
        this.dataFrame = dataFrame;
        this.pageSize = 10;
    }

    @NotNull
    public final DataFrame getDataFrame() {
        return this.dataFrame;
    }

    public final int getPageSize() {
        return this.pageSize;
    }

    public final void setPageSize(int value) {
        if (value == this.pageSize) {
            return;
        }
        int oldPageSize = this.pageSize;
        this.pageSize = value;
        this.setPageOffset(oldPageSize * this.pageOffset / this.pageSize);
        this.fireTableDataChanged();
    }

    public final int getPageOffset() {
        return this.pageOffset;
    }

    public final void setPageOffset(int value) {
        this.pageOffset = value < 0 ? 0 : (value >= this.getPageCount() ? this.getPageCount() - 1 : value);
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return Math.min(this.dataFrame.getDim().height - this.pageOffset * this.pageSize, this.pageSize);
    }

    @Override
    public int getColumnCount() {
        return this.dataFrame.getDim().width;
    }

    @Override
    @Nullable
    public Object getValueAt(int rowIndex, int columnIndex) {
        int realRow = rowIndex + this.pageOffset * this.pageSize;
        return this.dataFrame.get(columnIndex).toList().get(realRow);
    }

    @Override
    @NotNull
    public String getColumnName(int columnIndex) {
        return this.dataFrame.get(columnIndex).getName();
    }

    public final int getPageCount() {
        return (int)Math.ceil((double)this.dataFrame.getDim().height / (double)this.pageSize);
    }

    public final int getRealRowCount() {
        return this.dataFrame.getDim().height;
    }
}

