/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.visualization.r.inlays.components;

import com.intellij.icons.AllIcons;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.TextTransferable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.visualization.VisualisationIcons;
import org.jetbrains.plugins.notebooks.visualization.r.VisualizationBundle;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.ClipboardUtils;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.components.ToolBarProvider;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.dataframe.DataFrame;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.dataframe.columns.Column;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.dataframe.columns.DoubleType;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.dataframe.columns.IntType;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.dataframe.columns.Type;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.table.DataFrameColumnModel;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.table.DataFrameTableModel;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.table.DoubleTableCellRenderer;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.table.IntegerTableCellRenderer;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.table.StringTableCellRenderer;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.table.filters.gui.TableFilterHeader;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.table.paging.TablePaginator;
import org.jetbrains.plugins.notebooks.visualization.r.ui.MaterialTable;
import org.jetbrains.plugins.notebooks.visualization.r.ui.MaterialTableUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002:\u0002&'B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0019\u001a\u00020\bH\u0002J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0016J\u0010\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u000e\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\"J\u0010\u0010#\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020$H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/components/InlayTablePage;", "Ljavax/swing/JPanel;", "Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/components/ToolBarProvider;", "()V", "filterHeader", "Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/table/filters/gui/TableFilterHeader;", "onChange", "Lkotlin/Function0;", "", "getOnChange", "()Lkotlin/jvm/functions/Function0;", "setOnChange", "(Lkotlin/jvm/functions/Function0;)V", "paginator", "Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/table/paging/TablePaginator;", "preferredHeight", "", "getPreferredHeight", "()I", "scrollPane", "Lcom/intellij/ui/components/JBScrollPane;", "getScrollPane", "()Lcom/intellij/ui/components/JBScrollPane;", "table", "Lorg/jetbrains/plugins/notebooks/visualization/r/ui/MaterialTable;", "addTableFilterHeader", "createActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "saveAsCsv", "project", "Lcom/intellij/openapi/project/Project;", "setDataFrame", "dataFrame", "Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/dataframe/DataFrame;", "setupSelectAllAction", "Ljavax/swing/JTable;", "setupTablePopupMenu", "NumberComparator", "TableCopyProvider", "intellij.notebooks.visualization"})
public final class InlayTablePage
extends JPanel
implements ToolBarProvider {
    @Nullable
    private Function0<Unit> onChange;
    @NotNull
    private final MaterialTable table = new MaterialTable();
    @NotNull
    private final JBScrollPane scrollPane = new JBScrollPane((Component)((Object)this.table));
    @Nullable
    private TableFilterHeader filterHeader;
    @Nullable
    private TablePaginator paginator;

    public InlayTablePage() {
        super(new BorderLayout());
        this.table.putClientProperty("AuxEditorComponent", true);
        this.scrollPane.setBorder(IdeBorderFactory.createBorder((int)4));
        this.scrollPane.setViewportBorder(IdeBorderFactory.createBorder((int)13));
        this.setupTablePopupMenu((JTable)((Object)this.table));
        this.setupSelectAllAction((JTable)((Object)this.table));
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(@NotNull KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (filterHeader == null && Character.isLetterOrDigit(e.getKeyChar())) {
                    this.addTableFilterHeader();
                }
            }
        });
        DataManager.registerDataProvider((JComponent)((JComponent)((Object)this.table)), arg_0 -> InlayTablePage._init_$lambda$0(this, arg_0));
        this.add((Component)this.scrollPane, "Center");
    }

    @Nullable
    public final Function0<Unit> getOnChange() {
        return this.onChange;
    }

    public final void setOnChange(@Nullable Function0<Unit> function0) {
        this.onChange = function0;
    }

    @NotNull
    public final JBScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public final int getPreferredHeight() {
        return this.table.getPreferredSize().height;
    }

    private final void setupTablePopupMenu(JTable table) {
        JMenuItem copyAll = new JMenuItem(VisualizationBundle.INSTANCE.message("inlay.table.copy.all", new Object[0]));
        copyAll.addActionListener(arg_0 -> InlayTablePage.setupTablePopupMenu$lambda$1(table, arg_0));
        JMenuItem copySelected = new JMenuItem(VisualizationBundle.INSTANCE.message("inlay.table.copy.selected", new Object[0]));
        copySelected.addActionListener(arg_0 -> InlayTablePage.setupTablePopupMenu$lambda$2(table, arg_0));
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add(copyAll);
        popupMenu.add(copySelected);
        table.setComponentPopupMenu(popupMenu);
    }

    private final void setupSelectAllAction(JTable table) {
        String actionName = VisualizationBundle.INSTANCE.message("action.name.table.select.all", new Object[0]);
        AbstractAction action2 = new AbstractAction(actionName, table){
            final /* synthetic */ JTable $table;
            {
                this.$table = $table;
                super($actionName);
            }

            public void actionPerformed(@NotNull ActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$table.setRowSelectionInterval(0, this.$table.getRowCount() - 1);
                this.$table.setColumnSelectionInterval(0, this.$table.getColumnCount() - 1);
            }
        };
        table.getActionMap().put(actionName, action2);
        table.getInputMap(0).put(KeyStroke.getKeyStroke(65, 2), actionName);
    }

    public final void setDataFrame(@NotNull DataFrame dataFrame) {
        Intrinsics.checkNotNullParameter((Object)dataFrame, (String)"dataFrame");
        this.table.setColumnModel(new DataFrameColumnModel(dataFrame));
        this.table.setModel(new DataFrameTableModel(dataFrame));
        int n = dataFrame.getColumns().size();
        for (int i = 0; i < n; ++i) {
            Type<?> type;
            this.table.getColumnModel().getColumn(i).setCellRenderer(Intrinsics.areEqual(type = dataFrame.get(i).getType(), (Object)IntType.INSTANCE) ? (TableCellRenderer)new IntegerTableCellRenderer() : (Intrinsics.areEqual(type, (Object)DoubleType.INSTANCE) ? (TableCellRenderer)new DoubleTableCellRenderer() : (TableCellRenderer)new StringTableCellRenderer()));
        }
        MaterialTableUtils.fitColumnsWidth$default(MaterialTableUtils.INSTANCE, (JTable)((Object)this.table), 0, null, 6, null);
        TableRowSorter<TableModel> tableRowSorter = new TableRowSorter<TableModel>(this.table.getModel());
        tableRowSorter.setSortsOnUpdates(true);
        Iterator<Column<?>> iterator2 = dataFrame.getColumns().iterator();
        int n2 = 0;
        while (iterator2.hasNext()) {
            int i = n2++;
            Column<?> column = iterator2.next();
            if (column.getType() instanceof IntType) {
                tableRowSorter.setComparator(i, new NumberComparator());
                continue;
            }
            if (!(column.getType() instanceof DoubleType)) continue;
            tableRowSorter.setComparator(i, new NumberComparator());
        }
        this.table.setRowSorter(tableRowSorter);
    }

    private final void addTableFilterHeader() {
        TableFilterHeader tableFilterHeader = this.filterHeader = new TableFilterHeader();
        Intrinsics.checkNotNull((Object)((Object)tableFilterHeader));
        tableFilterHeader.installTable((JTable)((Object)this.table));
    }

    @Override
    @NotNull
    public List<AnAction> createActions() {
        String string = VisualizationBundle.INSTANCE.message("inlay.table.export.as.text", new Object[0]);
        String string2 = VisualizationBundle.INSTANCE.message("inlay.table.export.as.description", new Object[0]);
        Object[] objectArray = AllIcons.ToolbarDecorator.Export;
        DumbAwareAction actionSaveAsCsv2 = new DumbAwareAction(this, string, string2, (Icon)objectArray){
            final /* synthetic */ InlayTablePage this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Project project = e.getProject();
                if (project == null) {
                    return;
                }
                InlayTablePage.access$saveAsCsv(this.this$0, project);
            }
        };
        string2 = VisualizationBundle.INSTANCE.message("inlay.table.filter.text", new Object[0]);
        objectArray = VisualizationBundle.INSTANCE.message("inlay.table.filter.description", new Object[0]);
        Object object = AllIcons.Actions.Find;
        DumbAwareToggleAction filterTable2 = new DumbAwareToggleAction(this, string2, (String)objectArray, (Icon)object){
            final /* synthetic */ InlayTablePage this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3);
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.EDT;
            }

            public boolean isSelected(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                return InlayTablePage.access$getFilterHeader$p(this.this$0) != null;
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (state) {
                    InlayTablePage.access$addTableFilterHeader(this.this$0);
                } else {
                    TableFilterHeader tableFilterHeader = InlayTablePage.access$getFilterHeader$p(this.this$0);
                    if (tableFilterHeader != null) {
                        tableFilterHeader.installTable(null);
                    }
                    InlayTablePage.access$setFilterHeader$p(this.this$0, null);
                }
            }
        };
        objectArray = VisualizationBundle.INSTANCE.message("inlay.table.pagination.text", new Object[0]);
        object = VisualizationBundle.INSTANCE.message("inlay.table.pagination.description", new Object[0]);
        Icon icon = VisualisationIcons.Table.Pagination;
        DumbAwareToggleAction paginateTable2 = new DumbAwareToggleAction(this, (String)objectArray, (String)object, icon){
            final /* synthetic */ InlayTablePage this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3);
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.EDT;
            }

            public boolean isSelected(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                return InlayTablePage.access$getPaginator$p(this.this$0) != null;
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (state) {
                    InlayTablePage.access$setPaginator$p(this.this$0, new TablePaginator());
                    TablePaginator tablePaginator = InlayTablePage.access$getPaginator$p(this.this$0);
                    Intrinsics.checkNotNull((Object)tablePaginator);
                    tablePaginator.setTable((JTable)((Object)InlayTablePage.access$getTable$p(this.this$0)));
                } else {
                    TablePaginator tablePaginator = InlayTablePage.access$getPaginator$p(this.this$0);
                    if (tablePaginator != null) {
                        tablePaginator.setTable(null);
                    }
                    InlayTablePage.access$setPaginator$p(this.this$0, null);
                }
            }
        };
        objectArray = new AnAction[]{actionSaveAsCsv2, filterTable2, paginateTable2};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void saveAsCsv(Project project) {
        String[] stringArray = new String[]{"csv", "tsv"};
        FileSaverDescriptor descriptor = new FileSaverDescriptor(VisualizationBundle.INSTANCE.message("inlay.table.export.as.csv.text", new Object[0]), VisualizationBundle.INSTANCE.message("inlay.table.export.as.csv.description", new Object[0]), stringArray);
        FileSaverDialog fileSaverDialog = FileChooserFactory.getInstance().createSaveFileDialog(descriptor, (Component)this);
        Intrinsics.checkNotNullExpressionValue((Object)fileSaverDialog, (String)"createSaveFileDialog(...)");
        FileSaverDialog chooser = fileSaverDialog;
        String string = project.getBasePath();
        if (string == null) {
            return;
        }
        String basePath = string;
        VirtualFile virtualBaseDir = LocalFileSystem.getInstance().findFileByIoFile(new File(basePath));
        VirtualFileWrapper virtualFileWrapper = chooser.save(virtualBaseDir, "table.csv");
        if (virtualFileWrapper == null) {
            return;
        }
        VirtualFileWrapper fileWrapper = virtualFileWrapper;
        File file = fileWrapper.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getFile(...)");
        Object object = file;
        Object object2 = Charsets.UTF_8;
        int n = 8192;
        Object object3 = object;
        object3 = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object3), (Charset)object2);
        object = object3 instanceof BufferedWriter ? (BufferedWriter)object3 : new BufferedWriter((Writer)object3, n);
        object2 = null;
        try {
            String cellBreak;
            BufferedWriter out = (BufferedWriter)object;
            boolean bl = false;
            File file2 = fileWrapper.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getFile(...)");
            String string2 = cellBreak = Intrinsics.areEqual((Object)FilesKt.getExtension((File)file2), (Object)"csv") ? ";" : "\t";
            if (this.table.getSelectedColumnCount() == 0 || this.table.getSelectedRowCount() == 0) {
                InlayTablePage.saveAsCsv$saveAll(this, out, cellBreak);
            } else {
                InlayTablePage.saveAsCsv$saveSelection(this, out, cellBreak);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
    }

    private static final Object _init_$lambda$0(InlayTablePage this$0, String dataId) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        return PlatformDataKeys.COPY_PROVIDER.is(dataId) ? new TableCopyProvider(this$0.table) : null;
    }

    private static final void setupTablePopupMenu$lambda$1(JTable $table, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)$table, (String)"$table");
        ClipboardUtils.copyAllToClipboard$default(ClipboardUtils.INSTANCE, $table, null, 0, 6, null);
    }

    private static final void setupTablePopupMenu$lambda$2(JTable $table, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)$table, (String)"$table");
        ClipboardUtils.copySelectedToClipboard$default(ClipboardUtils.INSTANCE, $table, null, 2, null);
    }

    private static final void saveAsCsv$saveSelection(InlayTablePage this$0, BufferedWriter out, String cellBreak) {
        int selectedColumnCount = this$0.table.getSelectedColumnCount();
        int selectedRowCount = this$0.table.getSelectedRowCount();
        int[] selectedRows = this$0.table.getSelectedRows();
        int[] selectedColumns = this$0.table.getSelectedColumns();
        for (int i = 0; i < selectedRowCount; ++i) {
            for (int j = 0; j < selectedColumnCount; ++j) {
                Object object = this$0.table.getValueAt(selectedRows[i], selectedColumns[j]);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValueAt(...)");
                out.write(ClipboardUtils.escape$default(ClipboardUtils.INSTANCE, object, null, 2, null));
                if (j >= selectedColumnCount - 1) continue;
                out.write(cellBreak);
            }
            if (i >= this$0.table.getRowCount() - 1) continue;
            out.append("\r");
        }
    }

    private static final void saveAsCsv$saveAll(InlayTablePage this$0, BufferedWriter out, String cellBreak) {
        int n = this$0.table.getRowCount();
        for (int i = 0; i < n; ++i) {
            int n2 = this$0.table.getColumnCount();
            for (int j = 0; j < n2; ++j) {
                Object object = this$0.table.getValueAt(i, j);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValueAt(...)");
                out.write(ClipboardUtils.escape$default(ClipboardUtils.INSTANCE, object, null, 2, null));
                if (j >= this$0.table.getColumnCount() - 1) continue;
                out.write(cellBreak);
            }
            if (i >= this$0.table.getRowCount() - 1) continue;
            out.append("\r");
        }
    }

    public static final /* synthetic */ void access$saveAsCsv(InlayTablePage $this, Project project) {
        $this.saveAsCsv(project);
    }

    public static final /* synthetic */ void access$setFilterHeader$p(InlayTablePage $this, TableFilterHeader tableFilterHeader) {
        $this.filterHeader = tableFilterHeader;
    }

    public static final /* synthetic */ TablePaginator access$getPaginator$p(InlayTablePage $this) {
        return $this.paginator;
    }

    public static final /* synthetic */ void access$setPaginator$p(InlayTablePage $this, TablePaginator tablePaginator) {
        $this.paginator = tablePaginator;
    }

    public static final /* synthetic */ MaterialTable access$getTable$p(InlayTablePage $this) {
        return $this.table;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0082\u0004\u0018\u0000*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\u0012\u0012\u0004\u0012\u0002H\u00010\u0003j\b\u0012\u0004\u0012\u0002H\u0001`\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J\u001d\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00028\u00002\u0006\u0010\t\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/components/InlayTablePage$NumberComparator;", "T", "", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "(Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/components/InlayTablePage;)V", "compare", "", "o1", "o2", "(Ljava/lang/Comparable;Ljava/lang/Comparable;)I", "intellij.notebooks.visualization"})
    private final class NumberComparator<T extends Comparable<?>>
    implements Comparator<T> {
        @Override
        public int compare(@NotNull T o1, @NotNull T o2) {
            Intrinsics.checkNotNullParameter(o1, (String)"o1");
            Intrinsics.checkNotNullParameter(o2, (String)"o2");
            return ComparisonsKt.compareValues(o1, o2);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/components/InlayTablePage$TableCopyProvider;", "Lcom/intellij/ide/CopyProvider;", "table", "Lcom/intellij/ui/table/JBTable;", "(Lcom/intellij/ui/table/JBTable;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isCopyEnabled", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "isCopyVisible", "performCopy", "", "intellij.notebooks.visualization"})
    public static final class TableCopyProvider
    implements CopyProvider {
        @NotNull
        private final JBTable table;

        public TableCopyProvider(@NotNull JBTable table) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            this.table = table;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }

        public void performCopy(@NotNull DataContext dataContext) {
            Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
            CharSequence copySelectedToString = ClipboardUtils.copySelectedToString$default(ClipboardUtils.INSTANCE, (JTable)this.table, null, 2, null);
            CopyPasteManager.getInstance().setContents((Transferable)new TextTransferable(copySelectedToString));
        }

        public boolean isCopyEnabled(@NotNull DataContext dataContext) {
            Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
            return this.table.getSelectedRowCount() > 0;
        }

        public boolean isCopyVisible(@NotNull DataContext dataContext) {
            Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
            return true;
        }
    }
}

