/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.visualization.outputs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.ui.visualization.NotebookUtilKt;
import org.jetbrains.plugins.notebooks.visualization.NotebookCellInlayController;
import org.jetbrains.plugins.notebooks.visualization.NotebookCellLines;
import org.jetbrains.plugins.notebooks.visualization.NotebookIntervalPointer;
import org.jetbrains.plugins.notebooks.visualization.NotebookIntervalPointerFactory;
import org.jetbrains.plugins.notebooks.visualization.outputs.NotebookOutputComponentFactory;
import org.jetbrains.plugins.notebooks.visualization.outputs.NotebookOutputComponentFactoryGetter;
import org.jetbrains.plugins.notebooks.visualization.outputs.NotebookOutputDataKey;
import org.jetbrains.plugins.notebooks.visualization.outputs.NotebookOutputDataKeyExtractor;
import org.jetbrains.plugins.notebooks.visualization.outputs.NotebookOutputInlayControllerKt;
import org.jetbrains.plugins.notebooks.visualization.outputs.NotebookOutputInlayShowable;
import org.jetbrains.plugins.notebooks.visualization.outputs.OutputListener;
import org.jetbrains.plugins.notebooks.visualization.outputs.impl.CollapsingComponent;
import org.jetbrains.plugins.notebooks.visualization.outputs.impl.InnerComponent;
import org.jetbrains.plugins.notebooks.visualization.outputs.impl.SurroundingComponent;
import org.jetbrains.plugins.notebooks.visualization.ui.NotebookEditorUiUtilKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 ;2\u00020\u0001:\u0002;<B\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\u0017\u001a\u00020\u00182\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u001cH\u0002J\f\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\fH\u0002J7\u0010\u001e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001a\"\b\b\u0000\u0010\u001f*\u00020 2\u0010\u0010\u0002\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u0002H\u001f0!2\u0006\u0010\"\u001a\u0002H\u001fH\u0002\u00a2\u0006\u0002\u0010#J%\u0010$\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001a\"\b\b\u0000\u0010\u001f*\u00020 2\u0006\u0010\"\u001a\u0002H\u001fH\u0002\u00a2\u0006\u0002\u0010%J\"\u0010&\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020)\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030!0(0'H\u0002J\b\u0010*\u001a\u00020\u0018H\u0016J(\u0010+\u001a\u00020\u00182\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0016J\u0016\u00102\u001a\u00020\u001c2\f\u00103\u001a\b\u0012\u0004\u0012\u00020 04H\u0002J\u0016\u00105\u001a\u00020\u00142\f\u00106\u001a\b\u0012\u0004\u0012\u00020 04H\u0002J<\u00107\u001a\u000208\"\b\b\u0000\u00109*\u00020)\"\b\b\u0001\u0010\u001f*\u00020 *\u000e\u0012\u0004\u0012\u0002H9\u0012\u0004\u0012\u0002H\u001f0!2\u0006\u0010:\u001a\u00020)2\u0006\u0010\"\u001a\u00020 H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001e\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lorg/jetbrains/plugins/notebooks/visualization/outputs/NotebookOutputInlayController;", "Lorg/jetbrains/plugins/notebooks/visualization/NotebookCellInlayController;", "factory", "Lorg/jetbrains/plugins/notebooks/visualization/NotebookCellInlayController$Factory;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "intervalPointer", "Lorg/jetbrains/plugins/notebooks/visualization/NotebookIntervalPointer;", "(Lorg/jetbrains/plugins/notebooks/visualization/NotebookCellInlayController$Factory;Lcom/intellij/openapi/editor/impl/EditorImpl;Lorg/jetbrains/plugins/notebooks/visualization/NotebookIntervalPointer;)V", "getFactory", "()Lorg/jetbrains/plugins/notebooks/visualization/NotebookCellInlayController$Factory;", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "getInlay", "()Lcom/intellij/openapi/editor/Inlay;", "setInlay", "(Lcom/intellij/openapi/editor/Inlay;)V", "innerComponent", "Lorg/jetbrains/plugins/notebooks/visualization/outputs/impl/InnerComponent;", "isInReplaceInlay", "", "outerComponent", "Lorg/jetbrains/plugins/notebooks/visualization/outputs/impl/SurroundingComponent;", "addIntoInnerComponent", "", "newComponent", "Lorg/jetbrains/plugins/notebooks/visualization/outputs/NotebookOutputComponentFactory$CreatedComponent;", "pos", "", "createInlay", "createOutput", "K", "Lorg/jetbrains/plugins/notebooks/visualization/outputs/NotebookOutputDataKey;", "Lorg/jetbrains/plugins/notebooks/visualization/outputs/NotebookOutputComponentFactory;", "outputDataKey", "(Lorg/jetbrains/plugins/notebooks/visualization/outputs/NotebookOutputComponentFactory;Lorg/jetbrains/plugins/notebooks/visualization/outputs/NotebookOutputDataKey;)Lorg/jetbrains/plugins/notebooks/visualization/outputs/NotebookOutputComponentFactory$CreatedComponent;", "createOutputGuessingFactory", "(Lorg/jetbrains/plugins/notebooks/visualization/outputs/NotebookOutputDataKey;)Lorg/jetbrains/plugins/notebooks/visualization/outputs/NotebookOutputComponentFactory$CreatedComponent;", "getComponentsWithFactories", "", "Lkotlin/Pair;", "Ljavax/swing/JComponent;", "onViewportChange", "paintGutter", "g", "Ljava/awt/Graphics;", "r", "Ljava/awt/Rectangle;", "interval", "Lorg/jetbrains/plugins/notebooks/visualization/NotebookCellLines$Interval;", "rankCompatibility", "outputDataKeys", "", "updateData", "newDataKeys", "matchWithTypes", "Lorg/jetbrains/plugins/notebooks/visualization/outputs/NotebookOutputComponentFactory$Match;", "C", "component", "Companion", "Factory", "intellij.notebooks.visualization"})
@SourceDebugExtension(value={"SMAP\nNotebookOutputInlayController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotebookOutputInlayController.kt\norg/jetbrains/plugins/notebooks/visualization/outputs/NotebookOutputInlayController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,368:1\n2976#2,5:369\n14#3:374\n1#4:375\n9#5:376\n*S KotlinDebug\n*F\n+ 1 NotebookOutputInlayController.kt\norg/jetbrains/plugins/notebooks/visualization/outputs/NotebookOutputInlayController\n*L\n137#1:369,5\n186#1:374\n254#1:376\n*E\n"})
public final class NotebookOutputInlayController
implements NotebookCellInlayController {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final NotebookCellInlayController.Factory factory;
    @NotNull
    private final EditorImpl editor;
    @NotNull
    private final NotebookIntervalPointer intervalPointer;
    @NotNull
    private final InnerComponent innerComponent;
    @NotNull
    private final SurroundingComponent outerComponent;
    @NotNull
    private Inlay<?> inlay;
    private boolean isInReplaceInlay;
    @NotNull
    private static final String key;

    private NotebookOutputInlayController(NotebookCellInlayController.Factory factory, EditorImpl editor, NotebookIntervalPointer intervalPointer) {
        this.factory = factory;
        this.editor = editor;
        this.intervalPointer = intervalPointer;
        this.innerComponent = new InnerComponent(this.editor);
        this.outerComponent = SurroundingComponent.Companion.create(this.editor, this.innerComponent);
        this.inlay = this.createInlay();
        this.innerComponent.setMaxHeight(!ApplicationManager.getApplication().isUnitTestMode() ? (int)((double)Toolkit.getDefaultToolkit().getScreenSize().height * 0.3) : 200);
    }

    @Override
    @NotNull
    public NotebookCellInlayController.Factory getFactory() {
        return this.factory;
    }

    @Override
    @NotNull
    public Inlay<?> getInlay() {
        return this.inlay;
    }

    public void setInlay(@NotNull Inlay<?> inlay) {
        Intrinsics.checkNotNullParameter(inlay, (String)"<set-?>");
        this.inlay = inlay;
    }

    @Override
    public void onViewportChange() {
        Component[] componentArray = this.innerComponent.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
        for (Component collapsingComponent : componentArray) {
            Intrinsics.checkNotNull((Object)collapsingComponent, (String)"null cannot be cast to non-null type org.jetbrains.plugins.notebooks.visualization.outputs.impl.CollapsingComponent");
            JComponent jComponent = ((CollapsingComponent)collapsingComponent).getMainComponent();
            NotebookOutputInlayShowable notebookOutputInlayShowable = jComponent instanceof NotebookOutputInlayShowable ? (NotebookOutputInlayShowable)((Object)jComponent) : null;
            if (notebookOutputInlayShowable == null) continue;
            NotebookOutputInlayShowable component = notebookOutputInlayShowable;
            if (!(component instanceof Component)) {
                return;
            }
            Rectangle componentRect = SwingUtilities.convertRectangle((Component)((Object)component), ((Component)((Object)component)).getBounds(), this.editor.getScrollPane().getViewport().getView());
            component.setShown(this.editor.getScrollPane().getViewport().getViewRect().intersects(componentRect));
        }
    }

    private final Inlay<?> createInlay() {
        Inlay inlay;
        EditorEx editorEx = (EditorEx)this.editor;
        JComponent jComponent = this.outerComponent;
        int n = NotebookUtilKt.getNotebookAppearance((Editor)this.editor).getNOTEBOOK_OUTPUT_INLAY_PRIORITY();
        DocumentEx documentEx = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        Document document = (Document)documentEx;
        NotebookCellLines.Interval interval = this.intervalPointer.get();
        if (interval == null || (interval = interval.getLines()) == null) {
            interval = new IntRange(0, 0);
        }
        Inlay it = inlay = NotebookEditorUiUtilKt.addComponentInlay$default(editorEx, jComponent, true, false, false, n, NotebookOutputInlayControllerKt.access$computeInlayOffset(document, (IntRange)interval), 8, null);
        boolean bl = false;
        Disposer.register((Disposable)((Disposable)it), () -> NotebookOutputInlayController.createInlay$lambda$1$lambda$0(this));
        return inlay;
    }

    @Override
    public void paintGutter(@NotNull EditorImpl editor, @NotNull Graphics g, @NotNull Rectangle r, @NotNull NotebookCellLines.Interval interval) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
        Integer n = NotebookEditorUiUtilKt.yOffsetFromEditor(this.innerComponent, (Editor)editor);
        if (n == null) {
            return;
        }
        int yOffset = n;
        Rectangle bounds = new Rectangle();
        Rectangle oldClip = g.getClipBounds();
        g.setClip(new Rectangle(oldClip.x, yOffset, oldClip.width, this.innerComponent.getHeight()).intersection(oldClip));
        Component[] componentArray = this.innerComponent.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
        for (Component collapsingComponent : componentArray) {
            NotebookOutputComponentFactory.GutterPainter painter;
            Intrinsics.checkNotNull((Object)collapsingComponent, (String)"null cannot be cast to non-null type org.jetbrains.plugins.notebooks.visualization.outputs.impl.CollapsingComponent");
            JComponent mainComponent = ((CollapsingComponent)collapsingComponent).getMainComponent();
            ((CollapsingComponent)collapsingComponent).paintGutter((EditorEx)editor, yOffset, g);
            if (NotebookOutputComponentFactory.Companion.getGutterPainter(mainComponent) == null) continue;
            boolean bl = false;
            Integer n2 = NotebookEditorUiUtilKt.yOffsetFromEditor(mainComponent, (Editor)editor);
            if (n2 == null) continue;
            int yOffset2 = ((Number)n2).intValue();
            boolean bl2 = false;
            bounds.setBounds(r.x, yOffset2, r.width, mainComponent.getHeight());
            painter.paintGutter(editor, g, bounds);
        }
        g.setClip(oldClip);
    }

    private final int rankCompatibility(List<? extends NotebookOutputDataKey> outputDataKeys2) {
        Iterable $this$sumBy$iv = CollectionsKt.zip((Iterable)this.getComponentsWithFactories(), (Iterable)outputDataKeys2);
        boolean $i$f$sumBy = false;
        int sum$iv = 0;
        for (Object element$iv : $this$sumBy$iv) {
            Pair pair = (Pair)element$iv;
            int n = sum$iv;
            boolean bl = false;
            Pair pair2 = (Pair)pair.component1();
            NotebookOutputDataKey outputDataKey = (NotebookOutputDataKey)pair.component2();
            JComponent component = (JComponent)pair2.component1();
            NotebookOutputComponentFactory factory = (NotebookOutputComponentFactory)pair2.component2();
            int n2 = switch (WhenMappings.$EnumSwitchMapping$0[this.matchWithTypes(factory, component, outputDataKey).ordinal()]) {
                case 1 -> 0;
                case 2 -> 1;
                case 3 -> 1000;
                default -> throw new NoWhenBranchMatchedException();
            };
            sum$iv = n + n2;
        }
        return sum$iv;
    }

    private final List<Pair<JComponent, NotebookOutputComponentFactory<?, ?>>> getComponentsWithFactories() {
        List list;
        List it = list = (List)new ArrayList();
        boolean bl = false;
        for (JComponent component : this.innerComponent.getMainComponents()) {
            NotebookOutputComponentFactory factory = NotebookOutputInlayControllerKt.access$getOutputComponentFactory(component);
            if (factory == null) continue;
            ((Collection)it).add(TuplesKt.to((Object)component, (Object)factory));
        }
        return list;
    }

    private final <C extends JComponent, K extends NotebookOutputDataKey> NotebookOutputComponentFactory.Match matchWithTypes(NotebookOutputComponentFactory<C, K> $this$matchWithTypes, JComponent component, NotebookOutputDataKey outputDataKey) {
        NotebookOutputComponentFactory.Match match;
        if (!$this$matchWithTypes.getComponentClass().isAssignableFrom(component.getClass())) {
            match = NotebookOutputComponentFactory.Match.NONE;
        } else if (!$this$matchWithTypes.getOutputDataKeyClass().isAssignableFrom(outputDataKey.getClass())) {
            match = NotebookOutputComponentFactory.Match.NONE;
        } else {
            Intrinsics.checkNotNull((Object)component, (String)"null cannot be cast to non-null type C of org.jetbrains.plugins.notebooks.visualization.outputs.NotebookOutputInlayController.matchWithTypes");
            Intrinsics.checkNotNull((Object)outputDataKey, (String)"null cannot be cast to non-null type K of org.jetbrains.plugins.notebooks.visualization.outputs.NotebookOutputInlayController.matchWithTypes");
            match = $this$matchWithTypes.match(component, outputDataKey);
        }
        return match;
    }

    private final boolean updateData(List<? extends NotebookOutputDataKey> newDataKeys) {
        int idx;
        Iterator<? extends NotebookOutputDataKey> newDataKeyIterator = newDataKeys.iterator();
        Iterator<Pair<JComponent, NotebookOutputComponentFactory<?, ?>>> oldComponentsWithFactories = this.getComponentsWithFactories().iterator();
        boolean isFilled = false;
        Iterator<Object> iterator2 = CollectionsKt.withIndex((Iterator)NotebookOutputInlayControllerKt.access$zip(newDataKeyIterator, oldComponentsWithFactories));
        while (iterator2.hasNext()) {
            IndexedValue indexedValue = (IndexedValue)iterator2.next();
            idx = indexedValue.component1();
            Pair pair1 = (Pair)indexedValue.component2();
            NotebookOutputDataKey newDataKey = (NotebookOutputDataKey)pair1.component1();
            Pair pair2 = (Pair)pair1.component2();
            JComponent oldComponent = (JComponent)pair2.component1();
            NotebookOutputComponentFactory oldFactory = (NotebookOutputComponentFactory)pair2.component2();
            isFilled = (switch (WhenMappings.$EnumSwitchMapping$0[this.matchWithTypes(oldFactory, oldComponent, newDataKey).ordinal()]) {
                case 1 -> {
                    this.innerComponent.remove(idx);
                    Companion.disposeComponent(oldComponent);
                    NotebookOutputComponentFactory.CreatedComponent<?> newComponent = this.createOutputGuessingFactory(newDataKey);
                    if (newComponent != null) {
                        this.addIntoInnerComponent(newComponent, idx);
                        yield true;
                    }
                    yield false;
                }
                case 2 -> {
                    Intrinsics.checkNotNull((Object)oldFactory, (String)"null cannot be cast to non-null type org.jetbrains.plugins.notebooks.visualization.outputs.NotebookOutputComponentFactory<javax.swing.JComponent, org.jetbrains.plugins.notebooks.visualization.outputs.NotebookOutputDataKey>");
                    oldFactory.updateComponent(this.editor, oldComponent, newDataKey);
                    Container $this$asSafely$iv = oldComponent.getParent();
                    boolean $i$f$asSafely = false;
                    Container v1 = $this$asSafely$iv;
                    if (!(v1 instanceof CollapsingComponent)) {
                        v1 = null;
                    }
                    CollapsingComponent v2 = (CollapsingComponent)v1;
                    if (v2 != null) {
                        v2.updateStubIfCollapsed();
                    }
                    yield true;
                }
                case 3 -> true;
                default -> throw new NoWhenBranchMatchedException();
            }) || isFilled;
        }
        iterator2 = oldComponentsWithFactories;
        while (iterator2.hasNext()) {
            Pair<JComponent, NotebookOutputComponentFactory<?, ?>> ignored = iterator2.next();
            idx = this.innerComponent.getComponentCount() - 1;
            Component it = this.innerComponent.getComponent(idx);
            boolean bl = false;
            Component old = it instanceof CollapsingComponent ? (Component)((CollapsingComponent)it).getMainComponent() : it;
            this.innerComponent.remove(idx);
            Intrinsics.checkNotNull((Object)old, (String)"null cannot be cast to non-null type javax.swing.JComponent");
            Companion.disposeComponent((JComponent)old);
        }
        iterator2 = newDataKeyIterator;
        while (iterator2.hasNext()) {
            NotebookOutputDataKey outputDataKey = (NotebookOutputDataKey)iterator2.next();
            NotebookOutputComponentFactory.CreatedComponent<?> newComponent = this.createOutputGuessingFactory(outputDataKey);
            if (newComponent == null) continue;
            isFilled = true;
            NotebookOutputInlayController.addIntoInnerComponent$default(this, newComponent, 0, 2, null);
        }
        return isFilled;
    }

    private final void addIntoInnerComponent(NotebookOutputComponentFactory.CreatedComponent<?> newComponent, int pos) {
        NotebookOutputComponentFactory.CreatedComponent<?> createdComponent;
        NotebookOutputComponentFactory.CreatedComponent<?> $this$addIntoInnerComponent_u24lambda_u248 = createdComponent = newComponent;
        boolean bl = false;
        Disposable disposable = $this$addIntoInnerComponent_u24lambda_u248.getDisposable();
        if (disposable != null) {
            Disposable it = disposable;
            boolean bl2 = false;
            Companion.addDisposable((JComponent)$this$addIntoInnerComponent_u24lambda_u248.getComponent(), it);
        }
        CollapsingComponent collapsingComponent = new CollapsingComponent(this.editor, (JComponent)newComponent.getComponent(), newComponent.getResizable(), newComponent.getCollapsedTextSupplier());
        this.innerComponent.add(collapsingComponent, new InnerComponent.Constraint(newComponent.getWidthStretching(), newComponent.getLimitHeight()), pos);
        ((JComponent)newComponent.getComponent()).revalidate();
    }

    static /* synthetic */ void addIntoInnerComponent$default(NotebookOutputInlayController notebookOutputInlayController, NotebookOutputComponentFactory.CreatedComponent createdComponent, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = -1;
        }
        notebookOutputInlayController.addIntoInnerComponent(createdComponent, n);
    }

    private final <K extends NotebookOutputDataKey> NotebookOutputComponentFactory.CreatedComponent<?> createOutputGuessingFactory(K outputDataKey) {
        return (NotebookOutputComponentFactory.CreatedComponent)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)NotebookOutputComponentFactoryGetter.Companion.getInstance().getList()), (Function1)new Function1<NotebookOutputComponentFactory<?, ?>, Boolean>(outputDataKey){
            final /* synthetic */ K $outputDataKey;
            {
                this.$outputDataKey = $outputDataKey;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull NotebookOutputComponentFactory<?, ?> factory) {
                Intrinsics.checkNotNullParameter(factory, (String)"factory");
                return factory.getOutputDataKeyClass().isAssignableFrom(this.$outputDataKey.getClass());
            }
        }), (Function1)new Function1<NotebookOutputComponentFactory<?, ?>, NotebookOutputComponentFactory.CreatedComponent<?>>(this, outputDataKey){
            final /* synthetic */ NotebookOutputInlayController this$0;
            final /* synthetic */ K $outputDataKey;
            {
                this.this$0 = $receiver;
                this.$outputDataKey = $outputDataKey;
                super(1);
            }

            @Nullable
            public final NotebookOutputComponentFactory.CreatedComponent<?> invoke(@NotNull NotebookOutputComponentFactory<?, ?> factory) {
                Intrinsics.checkNotNullParameter(factory, (String)"factory");
                return NotebookOutputInlayController.access$createOutput(this.this$0, factory, this.$outputDataKey);
            }
        }));
    }

    private final <K extends NotebookOutputDataKey> NotebookOutputComponentFactory.CreatedComponent<?> createOutput(NotebookOutputComponentFactory<?, K> factory, K outputDataKey) {
        NotebookOutputComponentFactory.CreatedComponent<?> result2;
        NotebookOutputComponentFactory.CreatedComponent<?> createdComponent;
        NotebookCellLines.Interval interval = this.intervalPointer.get();
        if (interval == null || (interval = interval.getLines()) == null) {
            return null;
        }
        NotebookCellLines.Interval lines = interval;
        ((OutputListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(NotebookOutputInlayControllerKt.getOUTPUT_LISTENER())).beforeOutputCreated((Editor)this.editor, lines.getLast());
        try {
            createdComponent = factory.createComponent(this.editor, outputDataKey);
        }
        catch (Throwable t) {
            NotebookOutputInlayController $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(NotebookOutputInlayController.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error(factory.getClass().getName() + " shouldn't throw exceptions at .createComponent()", t);
            createdComponent = null;
        }
        NotebookOutputComponentFactory.CreatedComponent<?> createdComponent2 = result2 = createdComponent;
        if (createdComponent2 != null) {
            NotebookOutputComponentFactory.CreatedComponent<?> it = createdComponent = createdComponent2;
            boolean bl = false;
            NotebookOutputInlayControllerKt.access$setOutputComponentFactory(it.getComponent(), factory);
            NotebookOutputComponentFactory.Companion.setGutterPainter$intellij_notebooks_visualization((JComponent)it.getComponent(), it.getGutterPainter());
        }
        ((OutputListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(NotebookOutputInlayControllerKt.getOUTPUT_LISTENER())).outputCreated((Editor)this.editor, lines.getLast());
        return result2;
    }

    private static final void createInlay$lambda$1$lambda$0(NotebookOutputInlayController this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (this$0.isInReplaceInlay) {
            return;
        }
        for (JComponent disposable : this$0.innerComponent.getMainComponents()) {
            Companion.disposeComponent(disposable);
        }
    }

    public static final /* synthetic */ NotebookOutputComponentFactory.CreatedComponent access$createOutput(NotebookOutputInlayController $this, NotebookOutputComponentFactory factory, NotebookOutputDataKey outputDataKey) {
        return $this.createOutput(factory, outputDataKey);
    }

    public /* synthetic */ NotebookOutputInlayController(NotebookCellInlayController.Factory factory, EditorImpl editor, NotebookIntervalPointer intervalPointer, DefaultConstructorMarker $constructor_marker) {
        this(factory, editor, intervalPointer);
    }

    static {
        String string = Reflection.getOrCreateKotlinClass(NotebookOutputInlayController.class).getQualifiedName();
        Intrinsics.checkNotNull((Object)string);
        key = string;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\n\u0010\n\u001a\u00020\u0006*\u00020\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/notebooks/visualization/outputs/NotebookOutputInlayController$Companion;", "", "()V", "key", "", "addDisposable", "", "Ljavax/swing/JComponent;", "disposable", "Lcom/intellij/openapi/Disposable;", "disposeComponent", "intellij.notebooks.visualization"})
    @SourceDebugExtension(value={"SMAP\nNotebookOutputInlayController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotebookOutputInlayController.kt\norg/jetbrains/plugins/notebooks/visualization/outputs/NotebookOutputInlayController$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,368:1\n1#2:369\n*E\n"})
    private static final class Companion {
        private Companion() {
        }

        public final void addDisposable(@NotNull JComponent $this$addDisposable, @NotNull Disposable disposable) {
            Intrinsics.checkNotNullParameter((Object)$this$addDisposable, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
            $this$addDisposable.putClientProperty(key, disposable);
        }

        public final void disposeComponent(@NotNull JComponent $this$disposeComponent) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)$this$disposeComponent, (String)"<this>");
                Object object = $this$disposeComponent.getClientProperty(key);
                Disposable disposable = object instanceof Disposable ? (Disposable)object : null;
                if (disposable == null) break block0;
                Disposable p0 = disposable;
                boolean bl = false;
                Disposer.dispose((Disposable)p0);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J6\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/notebooks/visualization/outputs/NotebookOutputInlayController$Factory;", "Lorg/jetbrains/plugins/notebooks/visualization/NotebookCellInlayController$Factory;", "()V", "compute", "Lorg/jetbrains/plugins/notebooks/visualization/NotebookCellInlayController;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "currentControllers", "", "intervalIterator", "", "Lorg/jetbrains/plugins/notebooks/visualization/NotebookCellLines$Interval;", "overriddenPointer", "Lorg/jetbrains/plugins/notebooks/visualization/NotebookIntervalPointer;", "intellij.notebooks.visualization"})
    @SourceDebugExtension(value={"SMAP\nNotebookOutputInlayController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotebookOutputInlayController.kt\norg/jetbrains/plugins/notebooks/visualization/outputs/NotebookOutputInlayController$Factory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,368:1\n1#2:369\n800#3,11:370\n766#3:381\n857#3,2:382\n1963#3,14:384\n*S KotlinDebug\n*F\n+ 1 NotebookOutputInlayController.kt\norg/jetbrains/plugins/notebooks/visualization/outputs/NotebookOutputInlayController$Factory\n*L\n296#1:370,11\n297#1:381\n297#1:382,2\n298#1:384,14\n*E\n"})
    public static final class Factory
    implements NotebookCellInlayController.Factory {
        @Override
        @Nullable
        public NotebookCellInlayController compute(@NotNull EditorImpl editor, @NotNull Collection<? extends NotebookCellInlayController> currentControllers, @NotNull ListIterator<NotebookCellLines.Interval> intervalIterator) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter(currentControllers, (String)"currentControllers");
            Intrinsics.checkNotNullParameter(intervalIterator, (String)"intervalIterator");
            return this.compute(editor, currentControllers, intervalIterator, null);
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final NotebookCellInlayController compute(@NotNull EditorImpl editor, @NotNull Collection<? extends NotebookCellInlayController> currentControllers, @NotNull ListIterator<NotebookCellLines.Interval> intervalIterator, @Nullable NotebookIntervalPointer overriddenPointer) {
            NotebookOutputInlayController controller;
            NotebookOutputInlayController notebookOutputInlayController;
            NotebookOutputInlayController notebookOutputInlayController2;
            NotebookIntervalPointer intervalPointer;
            Object v2;
            void $this$maxByOrNull$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv;
            List list;
            Iterable iterable;
            NotebookCellLines.Interval interval;
            block15: {
                block14: {
                    Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                    Intrinsics.checkNotNullParameter(currentControllers, (String)"currentControllers");
                    Intrinsics.checkNotNullParameter(intervalIterator, (String)"intervalIterator");
                    interval = intervalIterator.next();
                    if (interval.getType() != NotebookCellLines.CellType.CODE) {
                        return null;
                    }
                    if (!Registry.is((String)"jupyter.diff.viewer.output") && editor.getEditorKind() == EditorKind.DIFF) {
                        return null;
                    }
                    List list2 = (List)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)NotebookOutputDataKeyExtractor.EP_NAME.getExtensionList()), (Function1)((Function1)new Function1<NotebookOutputDataKeyExtractor, List<? extends NotebookOutputDataKey>>(editor, interval){
                        final /* synthetic */ EditorImpl $editor;
                        final /* synthetic */ NotebookCellLines.Interval $interval;
                        {
                            this.$editor = $editor;
                            this.$interval = $interval;
                            super(1);
                        }

                        @Nullable
                        public final List<NotebookOutputDataKey> invoke(@NotNull NotebookOutputDataKeyExtractor it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            return it.extract(this.$editor, this.$interval);
                        }
                    })));
                    if (list2 == null) break block14;
                    List it = iterable = list2;
                    boolean bl = false;
                    List list3 = list = !((Collection)it).isEmpty() ? iterable : null;
                    if (list != null) break block15;
                }
                return null;
            }
            List outputDataKeys2 = list;
            DocumentEx documentEx = editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
            int expectedOffset = NotebookOutputInlayControllerKt.access$computeInlayOffset((Document)documentEx, interval.getLines());
            iterable = currentControllers;
            boolean $i$f$filterIsInstance = false;
            void bl = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof NotebookOutputInlayController)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                NotebookOutputInlayController it = (NotebookOutputInlayController)element$iv$iv;
                boolean bl2 = false;
                if (!(it.getInlay().getOffset() == expectedOffset)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$maxByOrNull = false;
            Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v2 = null;
            } else {
                Object maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v2 = maxElem$iv;
                } else {
                    NotebookOutputInlayController it = (NotebookOutputInlayController)maxElem$iv;
                    boolean bl3 = false;
                    int maxValue$iv = it.rankCompatibility(outputDataKeys2);
                    do {
                        Object e$iv = iterator$iv.next();
                        NotebookOutputInlayController it2 = (NotebookOutputInlayController)e$iv;
                        $i$a$-maxByOrNull-NotebookOutputInlayController$Factory$compute$existsController$2 = false;
                        int v$iv = it2.rankCompatibility(outputDataKeys2);
                        if (maxValue$iv >= v$iv) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v2 = maxElem$iv;
                }
            }
            NotebookOutputInlayController existsController = v2;
            NotebookIntervalPointer notebookIntervalPointer = overriddenPointer;
            if (notebookIntervalPointer == null) {
                notebookIntervalPointer = intervalPointer = NotebookIntervalPointerFactory.Companion.get((Editor)editor).create(interval);
            }
            if ((notebookOutputInlayController2 = existsController) == null) {
                notebookOutputInlayController2 = new NotebookOutputInlayController(this, editor, intervalPointer, null);
            }
            NotebookOutputInlayController it = notebookOutputInlayController = (controller = notebookOutputInlayController2);
            boolean bl4 = false;
            return it.updateData(outputDataKeys2) ? notebookOutputInlayController : null;
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NotebookOutputComponentFactory.Match.values().length];
            try {
                nArray[NotebookOutputComponentFactory.Match.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NotebookOutputComponentFactory.Match.COMPATIBLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NotebookOutputComponentFactory.Match.SAME.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

