/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.utils.time;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0014\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0000H\u0086\u0002J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u000e\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0000J\u000e\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0000J\t\u0010\u001b\u001a\u00020\u0006H\u00d6\u0001J\u000e\u0010\u001c\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0000J\u000e\u0010\u001d\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0000J\u0011\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0000H\u0086\u0002J\t\u0010 \u001a\u00020!H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\bR\u0011\u0010\u0012\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\b\u00a8\u0006#"}, d2={"Lio/kinference/utils/time/Duration;", "", "millis", "", "(J)V", "days", "", "getDays", "()I", "hours", "getHours", "isZero", "", "()Z", "getMillis", "()J", "minutes", "getMinutes", "seconds", "getSeconds", "compareTo", "other", "component1", "copy", "equals", "greater", "greaterOrEqual", "hashCode", "less", "lessOrEqual", "minus", "plus", "toString", "", "Companion", "utils-common"})
public final class Duration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long millis;
    @NotNull
    private static final Duration ZERO = new Duration(0L);

    public Duration(long millis) {
        this.millis = millis;
    }

    public final long getMillis() {
        return this.millis;
    }

    public final boolean isZero() {
        return this.millis == 0L;
    }

    public final int getSeconds() {
        return MathKt.roundToInt((double)((double)this.millis / (double)1000));
    }

    public final int getMinutes() {
        return MathKt.roundToInt((double)((double)this.getSeconds() / (double)60));
    }

    public final int getHours() {
        return MathKt.roundToInt((double)((double)this.getMinutes() / (double)60));
    }

    public final int getDays() {
        return MathKt.roundToInt((double)((double)this.getHours() / (double)24));
    }

    public final int compareTo(@NotNull Duration other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Intrinsics.compare((long)this.millis, (long)other.millis);
    }

    public final boolean less(@NotNull Duration other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.compareTo(other) < 0;
    }

    public final boolean lessOrEqual(@NotNull Duration other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.compareTo(other) <= 0;
    }

    public final boolean greater(@NotNull Duration other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.compareTo(other) > 0;
    }

    public final boolean greaterOrEqual(@NotNull Duration other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.compareTo(other) >= 0;
    }

    @NotNull
    public final Duration minus(@NotNull Duration other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new Duration(Math.abs(this.millis - other.millis));
    }

    @NotNull
    public final Duration plus(@NotNull Duration other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new Duration(this.millis + other.millis);
    }

    public final long component1() {
        return this.millis;
    }

    @NotNull
    public final Duration copy(long millis) {
        return new Duration(millis);
    }

    public static /* synthetic */ Duration copy$default(Duration duration, long l2, int n, Object object) {
        if ((n & 1) != 0) {
            l2 = duration.millis;
        }
        return duration.copy(l2);
    }

    @NotNull
    public String toString() {
        return "Duration(millis=" + this.millis + ")";
    }

    public int hashCode() {
        return Long.hashCode(this.millis);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Duration)) {
            return false;
        }
        Duration duration = (Duration)other;
        return this.millis == duration.millis;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\bJ\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\bJ\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lio/kinference/utils/time/Duration$Companion;", "", "()V", "ZERO", "Lio/kinference/utils/time/Duration;", "getZERO", "()Lio/kinference/utils/time/Duration;", "days", "", "hours", "minutes", "seconds", "utils-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Duration getZERO() {
            return ZERO;
        }

        @NotNull
        public final Duration seconds(int seconds) {
            return new Duration((long)seconds * (long)1000);
        }

        @NotNull
        public final Duration minutes(int minutes) {
            return this.seconds(minutes * 60);
        }

        @NotNull
        public final Duration hours(int hours) {
            return this.minutes(hours * 60);
        }

        @NotNull
        public final Duration days(int days) {
            return this.hours(days * 24);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

