/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.ndarray.extensions.argMinMax;

import io.kinference.ndarray.arrays.IntNDArray;
import io.kinference.ndarray.arrays.MutableIntNDArray;
import io.kinference.ndarray.arrays.NDArrayUtilsKt;
import io.kinference.ndarray.arrays.pointers.IntPointer;
import io.kinference.ndarray.arrays.tiled.IntTiledArray;
import io.kinference.ndarray.extensions.argMinMax.ArgMinMaxMode;
import io.kinference.ndarray.extensions.argMinMax.IntArgMinMaxKt;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\u001a:\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u00022\u0018\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001H\u0002\u001aJ\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00022\u0018\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001H\u0002\u001a2\u0010\u0011\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00032\b\b\u0002\u0010\u0015\u001a\u00020\u0016H\u0000\" \u0010\u0000\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\" \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\" \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\" \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"greater", "Lkotlin/Function2;", "", "", "greaterOrEqual", "less", "lessOrEqual", "argMinMaxAlongLastAxis", "Lio/kinference/ndarray/arrays/MutableIntNDArray;", "input", "Lio/kinference/ndarray/arrays/IntNDArray;", "output", "iterations", "comparator", "argMinMaxDefault", "dimsToReduce", "elementsPerDim", "argMinMaxInt", "axis", "keepDims", "selectLastIndex", "mode", "Lio/kinference/ndarray/extensions/argMinMax/ArgMinMaxMode;", "ndarray-core"})
@SourceDebugExtension(value={"SMAP\nIntArgMinMax.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntArgMinMax.kt\nio/kinference/ndarray/extensions/argMinMax/IntArgMinMaxKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,128:1\n1#2:129\n*E\n"})
public final class IntArgMinMaxKt {
    @NotNull
    private static final Function2<Integer, Integer, Boolean> lessOrEqual = lessOrEqual.1.INSTANCE;
    @NotNull
    private static final Function2<Integer, Integer, Boolean> less = less.1.INSTANCE;
    @NotNull
    private static final Function2<Integer, Integer, Boolean> greaterOrEqual = greaterOrEqual.1.INSTANCE;
    @NotNull
    private static final Function2<Integer, Integer, Boolean> greater = greater.1.INSTANCE;

    @NotNull
    public static final IntNDArray argMinMaxInt(@NotNull IntNDArray input, int axis2, boolean keepDims2, boolean selectLastIndex2, @NotNull ArgMinMaxMode mode2) {
        int[] nArray;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)((Object)mode2), (String)"mode");
        int actualAxis = NDArrayUtilsKt.indexAxis(input, axis2);
        int iterations = NDArrayUtilsKt.computeBlockSize$default(input, 0, actualAxis, 1, null);
        int elementsPerDim = NDArrayUtilsKt.computeBlockSize$default(input, actualAxis + 1, 0, 2, null);
        int dimsToReduce = input.getShape()[actualAxis];
        if (keepDims2) {
            int[] nArray2;
            int[] nArray3 = input.getShape();
            int[] nArray4 = Arrays.copyOf(nArray3, nArray3.length);
            Intrinsics.checkNotNullExpressionValue((Object)nArray4, (String)"copyOf(...)");
            int[] $this$argMinMaxInt_u24lambda_u240 = nArray2 = nArray4;
            boolean bl = false;
            $this$argMinMaxInt_u24lambda_u240[actualAxis] = 1;
            nArray = nArray2;
        } else {
            nArray = ArraysKt.sliceArray((int[])input.getShape(), (Collection)CollectionsKt.minus((Iterable)((Iterable)ArraysKt.getIndices((int[])input.getShape())), (Object)actualAxis));
        }
        int[] outputShape2 = nArray;
        MutableIntNDArray outputArray2 = new MutableIntNDArray(outputShape2);
        Function2<Integer, Integer, Boolean> comparator = switch (WhenMappings.$EnumSwitchMapping$0[mode2.ordinal()]) {
            case 1 -> {
                if (selectLastIndex2) {
                    yield lessOrEqual;
                }
                yield less;
            }
            case 2 -> {
                if (selectLastIndex2) {
                    yield greaterOrEqual;
                }
                yield greater;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
        return input.getShape()[actualAxis] == 1 ? (IntNDArray)outputArray2 : (actualAxis == ArraysKt.getLastIndex((int[])input.getShape()) ? (IntNDArray)IntArgMinMaxKt.argMinMaxAlongLastAxis(input, outputArray2, iterations, comparator) : (IntNDArray)IntArgMinMaxKt.argMinMaxDefault(input, outputArray2, iterations, dimsToReduce, elementsPerDim, comparator));
    }

    public static /* synthetic */ IntNDArray argMinMaxInt$default(IntNDArray intNDArray, int n, boolean bl, boolean bl2, ArgMinMaxMode argMinMaxMode, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            argMinMaxMode = ArgMinMaxMode.MAX;
        }
        return IntArgMinMaxKt.argMinMaxInt(intNDArray, n, bl, bl2, argMinMaxMode);
    }

    private static final MutableIntNDArray argMinMaxAlongLastAxis(IntNDArray input, MutableIntNDArray output, int iterations, Function2<? super Integer, ? super Integer, Boolean> comparator) {
        IntPointer outputPointer = IntTiledArray.pointer$default(output.getArray(), 0, 1, null);
        int blocksPerIteration = input.getBlocksInRow$ndarray_core();
        int[][] inputBlocks = input.getArray().getBlocks();
        int blockSize = input.getArray().getBlockSize();
        for (int i = 0; i < iterations; ++i) {
            int iter = i;
            boolean bl = false;
            int startBlock = iter * blocksPerIteration;
            int minMaxValue = inputBlocks[startBlock][0];
            int minMaxIndex = 0;
            for (int blockIdx = 0; blockIdx < blocksPerIteration; ++blockIdx) {
                int[] block = inputBlocks[startBlock + blockIdx];
                int indexOffset = blockIdx * blockSize;
                for (int idx = 0; idx < blockSize; ++idx) {
                    int value = block[idx];
                    if (!((Boolean)comparator.invoke((Object)value, (Object)minMaxValue)).booleanValue()) continue;
                    minMaxValue = value;
                    minMaxIndex = indexOffset + idx;
                }
            }
            outputPointer.setAndIncrement(minMaxIndex);
        }
        return output;
    }

    private static final MutableIntNDArray argMinMaxDefault(IntNDArray input, MutableIntNDArray output, int iterations, int dimsToReduce, int elementsPerDim, Function2<? super Integer, ? super Integer, Boolean> comparator) {
        int[][] inputBlocks = input.getArray().getBlocks();
        int[][] outputBlocks = output.getArray().getBlocks();
        IntTiledArray minMaxValuesArray = new IntTiledArray(elementsPerDim, output.getArray().getBlockSize());
        int[][] minMaxValuesBlocks = minMaxValuesArray.getBlocks();
        int blocksPerDim = elementsPerDim / input.getArray().getBlockSize();
        int blockSize = output.getArray().getBlockSize();
        for (int i = 0; i < iterations; ++i) {
            int iter = i;
            boolean bl = false;
            int outputBlockIterOffset = iter * blocksPerDim;
            int inputBlockIterOffset = blocksPerDim * dimsToReduce * iter;
            for (int blockIdx = 0; blockIdx < blocksPerDim; ++blockIdx) {
                int[] inputBlock = inputBlocks[inputBlockIterOffset + blockIdx];
                int[] minMaxValuesBlock = minMaxValuesBlocks[blockIdx];
                for (int idx = 0; idx < blockSize; ++idx) {
                    minMaxValuesBlock[idx] = inputBlock[idx];
                }
            }
            for (int dimIdx = 1; dimIdx < dimsToReduce; ++dimIdx) {
                int inputBlockFullOffset = inputBlockIterOffset + dimIdx * blocksPerDim;
                for (int blockIdx = 0; blockIdx < blocksPerDim; ++blockIdx) {
                    int[] inputBlock = inputBlocks[inputBlockFullOffset + blockIdx];
                    int[] minMaxValuesBlock = minMaxValuesBlocks[blockIdx];
                    int[] outputBlock = outputBlocks[outputBlockIterOffset + blockIdx];
                    for (int idx = 0; idx < blockSize; ++idx) {
                        int value = inputBlock[idx];
                        if (!((Boolean)comparator.invoke((Object)value, (Object)minMaxValuesBlock[idx])).booleanValue()) continue;
                        minMaxValuesBlock[idx] = value;
                        outputBlock[idx] = dimIdx;
                    }
                }
            }
        }
        return output;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ArgMinMaxMode.values().length];
            try {
                nArray[ArgMinMaxMode.MIN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ArgMinMaxMode.MAX.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

