/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.settings.local;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.settings.local.ModernStringDataType;
import com.intellij.platform.settings.local.MvMapManagerKt;
import com.intellij.platform.settings.local.MvStoreHelperKt;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.type.ByteArrayDataType;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0002\u001a\r\u0010\u0002\u001a\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010\u0004\u001a$\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007H\u0002\u00a8\u0006\f"}, d2={"getDatabaseFile", "Ljava/nio/file/Path;", "nowAsDuration", "Lkotlin/time/Duration;", "()J", "openMap", "Lorg/h2/mvstore/MVMap;", "", "", "store", "Lorg/h2/mvstore/MVStore;", "name", "intellij.platform.settings.local"})
public final class MvMapManagerKt {
    private static final long nowAsDuration() {
        return DurationKt.toDuration((long)System.currentTimeMillis(), (DurationUnit)DurationUnit.MILLISECONDS);
    }

    private static final Path getDatabaseFile() {
        Path path = PathManager.getConfigDir().resolve("app-internal-state.db");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    private static final MVMap<String, byte[]> openMap(MVStore store2, String name) {
        MVMap.Builder mapBuilder = new MVMap.Builder();
        mapBuilder.setKeyType(ModernStringDataType.INSTANCE);
        mapBuilder.setValueType(ByteArrayDataType.INSTANCE);
        return MvStoreHelperKt.openOrResetMap(store2, name, mapBuilder, (Function0<? extends Logger>)((Function0)openMap.1.INSTANCE));
    }

    public static final /* synthetic */ long access$nowAsDuration() {
        return MvMapManagerKt.nowAsDuration();
    }

    public static final /* synthetic */ Path access$getDatabaseFile() {
        return MvMapManagerKt.getDatabaseFile();
    }

    public static final /* synthetic */ MVMap access$openMap(MVStore store2, String name) {
        return MvMapManagerKt.openMap(store2, name);
    }
}

