/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.settings.local;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.h2.mvstore.MVMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\u0004J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0004J\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u0005J\u000e\u0010\u000f\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0004R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/platform/settings/local/MvMapManager;", "", "map", "Lorg/h2/mvstore/MVMap;", "", "", "(Lorg/h2/mvstore/MVMap;)V", "clear", "", "get", "key", "hasKeyStartsWith", "", "put", "value", "remove", "intellij.platform.settings.local"})
public final class MvMapManager {
    @NotNull
    private final MVMap<String, byte[]> map;

    public MvMapManager(@NotNull MVMap<String, byte[]> map2) {
        Intrinsics.checkNotNullParameter(map2, (String)"map");
        this.map = map2;
    }

    @Nullable
    public final byte[] get(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.map.get(key);
    }

    public final void remove(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.map.remove(key);
    }

    public final void clear() {
        this.map.clear();
    }

    public final void put(@NotNull String key, @Nullable byte[] value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.map.operate(key, value, new MVMap.DecisionMaker<byte[]>(){

            @NotNull
            public MVMap.Decision decide(@Nullable byte[] existingValue, @Nullable byte[] providedValue) {
                if (Arrays.equals(existingValue, providedValue)) {
                    return MVMap.Decision.ABORT;
                }
                return MVMap.Decision.PUT;
            }
        });
    }

    public final boolean hasKeyStartsWith(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String ceilingKey = this.map.ceilingKey(key);
        return ceilingKey != null && StringsKt.startsWith$default((String)ceilingKey, (String)key, (boolean)false, (int)2, null);
    }
}

