/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.providers.vsmac.mappings;

import com.intellij.ide.startup.importSettings.db.KnownColorSchemes;
import com.intellij.ide.startup.importSettings.models.BundledEditorColorScheme;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ide/startup/importSettings/providers/vsmac/mappings/SchemesMappings;", "", "()V", "schemeMap", "Lcom/intellij/ide/startup/importSettings/models/BundledEditorColorScheme;", "scheme", "", "intellij.ide.startup.importSettings"})
public final class SchemesMappings {
    @NotNull
    public static final SchemesMappings INSTANCE = new SchemesMappings();

    private SchemesMappings() {
    }

    @NotNull
    public final BundledEditorColorScheme schemeMap(@NotNull String scheme) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        return switch (scheme) {
            case "Light" -> KnownColorSchemes.INSTANCE.getLight();
            case "Dark" -> KnownColorSchemes.INSTANCE.getDarcula();
            case "Gruvbox" -> KnownColorSchemes.INSTANCE.getDarcula();
            case "High Contrast Dark" -> KnownColorSchemes.INSTANCE.getHighContrast();
            case "High Contrast Light" -> KnownColorSchemes.INSTANCE.getLight();
            case "Monokai" -> KnownColorSchemes.INSTANCE.getDarcula();
            case "Nightshade" -> KnownColorSchemes.INSTANCE.getHighContrast();
            case "Oblivion" -> KnownColorSchemes.INSTANCE.getDarcula();
            case "Solarized Dark" -> KnownColorSchemes.INSTANCE.getDarcula();
            case "Solarized Light" -> KnownColorSchemes.INSTANCE.getLight();
            case "Tango" -> KnownColorSchemes.INSTANCE.getLight();
            case "Legacy \u2013 Dark" -> KnownColorSchemes.INSTANCE.getDarcula();
            case "Legacy \u2013 Light" -> KnownColorSchemes.INSTANCE.getLight();
            default -> {
                String v1 = scheme.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"toLowerCase(...)");
                yield StringsKt.endsWith$default((String)v1, (String)"light", (boolean)false, (int)2, null) ? KnownColorSchemes.INSTANCE.getLight() : KnownColorSchemes.INSTANCE.getDarcula();
            }
        };
    }
}

