/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ide.editor;

import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.CaretState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtilEx;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.impl.FoldingModelImpl;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.jetbrains.rd.ide.document.DocumentExKt;
import com.jetbrains.rd.ide.editor.UtilKt;
import com.jetbrains.rd.ide.model.DocOffsetAndVirtualModel;
import com.jetbrains.rd.ide.model.RdCaret;
import com.jetbrains.rd.ide.model.RdCaretId;
import com.jetbrains.rd.ide.model.RdCaretState;
import com.jetbrains.rd.ide.model.RdCaretStateChange;
import com.jetbrains.rd.ide.model.RdCaretStateSnapshot;
import com.jetbrains.rd.ide.model.RdCaretStateSnapshotBase;
import com.jetbrains.rd.ide.model.RdDocumentChange;
import com.jetbrains.rd.ide.model.RdFileEditorCompositeId;
import com.jetbrains.rd.ide.model.RdFileEditorId;
import com.jetbrains.rd.ide.model.RdSelection;
import com.jetbrains.rd.ide.model.RdSelectionChangeBase;
import com.jetbrains.rd.ide.model.ScrollKind;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.ide.model.TextControlLocation;
import com.jetbrains.rd.ide.model.VisibleRange;
import com.jetbrains.rd.platform.util.UserDataHolderKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u009a\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\n\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u001a\"\u0010\n\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u001a\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e\u001a\u0016\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\u000e\u001a\u001e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001f\u001a\u000e\u0010 \u001a\u00020!2\u0006\u0010\r\u001a\u00020\u000e\u001a\r\u0010\"\u001a\u00020\u001c*\u00020#H\u0086\u0002\u001a\u000f\u0010\"\u001a\u00020\u001c*\u0004\u0018\u00010\u001fH\u0086\u0002\u001a\r\u0010$\u001a\u00020\u001c*\u00020#H\u0086\u0002\u001a\u000f\u0010$\u001a\u00020\u001c*\u0004\u0018\u00010\u001fH\u0086\u0002\u001a\n\u0010%\u001a\u00020&*\u00020'\u001a\n\u0010(\u001a\u00020\u001a*\u00020)\u001a\u0010\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00120+*\u00020)\u001a-\u0010,\u001a\u00020\f*\u00020\u00032\u0006\u0010-\u001a\u00020\u001c2\u0006\u0010.\u001a\u00020\u00102\u000e\b\u0004\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001f00H\u0082\b\u001a\u0012\u00101\u001a\u00020\u001f*\u00020\u000e2\u0006\u00102\u001a\u00020\f\u001a\"\u00101\u001a\u00020\u001f*\u00020\u000e2\u0006\u0010-\u001a\u00020\u001c2\u0006\u00103\u001a\u00020\u001c2\u0006\u00104\u001a\u00020\u0010\u001a\n\u00105\u001a\u00020\u001a*\u000206\u001a\u0014\u00107\u001a\u0004\u0018\u00010\u0003*\u00020)2\u0006\u0010\u0002\u001a\u00020\u0001\u001a\n\u00108\u001a\u000209*\u000209\u001a\n\u00108\u001a\u000206*\u000206\u001a\n\u0010:\u001a\u00020&*\u00020\f\u001a\n\u0010:\u001a\u00020&*\u00020\u0012\u001a\n\u0010:\u001a\u00020&*\u00020\u0001\u001a\n\u0010:\u001a\u00020&*\u00020\u001a\u001a\n\u0010:\u001a\u00020&*\u00020;\u001a\n\u0010:\u001a\u00020&*\u00020<\u001a\n\u0010:\u001a\u00020&*\u00020\u0016\u001a\n\u0010:\u001a\u00020&*\u00020'\u001a\n\u0010=\u001a\u00020>*\u00020?\"3\u0010\u0002\u001a\u0004\u0018\u00010\u0001*\u00020\u00032\b\u0010\u0000\u001a\u0004\u0018\u00010\u00018F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\b\u0010\t\u001a\u0004\b\u0004\u0010\u0005\"\u0004\b\u0006\u0010\u0007\u00a8\u0006@"}, d2={"<set-?>", "Lcom/jetbrains/rd/ide/model/RdCaretId;", "id", "Lcom/intellij/openapi/editor/Caret;", "getId", "(Lcom/intellij/openapi/editor/Caret;)Lcom/jetbrains/rd/ide/model/RdCaretId;", "setId", "(Lcom/intellij/openapi/editor/Caret;Lcom/jetbrains/rd/ide/model/RdCaretId;)V", "id$delegate", "Lkotlin/properties/ReadWriteProperty;", "addCaretTo", "positionModel", "Lcom/jetbrains/rd/ide/model/DocOffsetAndVirtualModel;", "editor", "Lcom/intellij/openapi/editor/Editor;", "isPrimary", "", "caret", "Lcom/jetbrains/rd/ide/model/RdCaret;", "applySelectionTo", "", "selectionModel", "Lcom/jetbrains/rd/ide/model/RdSelection;", "caretToSync", "applyStateTo", "newState", "Lcom/jetbrains/rd/ide/model/RdCaretState;", "calcVirtualDelta", "", "caretOffset", "visualPosition", "Lcom/intellij/openapi/editor/VisualPosition;", "calculateVisibleRange", "Lcom/jetbrains/rd/ide/model/VisibleRange;", "component1", "Lcom/intellij/openapi/editor/LogicalPosition;", "component2", "createLogCategory", "", "Lcom/jetbrains/rd/ide/model/TextControlId;", "createModelCaretState", "Lcom/intellij/openapi/editor/CaretModel;", "createModelCarets", "", "createModelPosition", "offset", "ignoreVirtualDelta", "calcVisualPosition", "Lkotlin/Function0;", "docOffsetAndVirtualToVisualPosition", "pos", "virtualDelta", "logicalLeansForward", "getActualState", "Lcom/jetbrains/rd/ide/model/RdSelectionChangeBase;", "getCaretById", "reverse", "Lcom/jetbrains/rd/ide/model/RdDocumentChange;", "toDebugString", "Lcom/jetbrains/rd/ide/model/RdFileEditorCompositeId;", "Lcom/jetbrains/rd/ide/model/RdFileEditorId;", "toScrollType", "Lcom/intellij/openapi/editor/ScrollType;", "Lcom/jetbrains/rd/ide/model/ScrollKind;", "intellij.rd.platform"})
@SourceDebugExtension(value={"SMAP\nUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Util.kt\ncom/jetbrains/rd/ide/editor/UtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,197:1\n144#1,6:208\n144#1,6:214\n144#1,6:220\n288#2,2:198\n1045#2:200\n1549#2:201\n1620#2,3:202\n1549#2:205\n1620#2,2:206\n1622#2:226\n1549#2:227\n1620#2,3:228\n*S KotlinDebug\n*F\n+ 1 Util.kt\ncom/jetbrains/rd/ide/editor/UtilKt\n*L\n120#1:208,6\n121#1:214,6\n122#1:220,6\n11#1:198,2\n67#1:200\n68#1:201\n68#1:202,3\n118#1:205\n118#1:206,2\n118#1:226\n176#1:227\n176#1:228,3\n*E\n"})
public final class UtilKt {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final ReadWriteProperty id$delegate;

    @Nullable
    public static final Caret getCaretById(@NotNull CaretModel $this$getCaretById, @NotNull RdCaretId id) {
        Object v1;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$getCaretById, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            List list2 = $this$getCaretById.getAllCarets();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAllCarets(...)");
            Iterable $this$firstOrNull$iv = list2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Caret it = (Caret)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (!Intrinsics.areEqual((Object)UtilKt.getId(it), (Object)id)) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    @Nullable
    public static final RdCaretId getId(@NotNull Caret $this$id) {
        Intrinsics.checkNotNullParameter((Object)$this$id, (String)"<this>");
        return (RdCaretId)id$delegate.getValue((Object)$this$id, $$delegatedProperties[0]);
    }

    public static final void setId(@NotNull Caret $this$id, @Nullable RdCaretId rdCaretId) {
        Intrinsics.checkNotNullParameter((Object)$this$id, (String)"<this>");
        id$delegate.setValue((Object)$this$id, $$delegatedProperties[0], (Object)rdCaretId);
    }

    @NotNull
    public static final ScrollType toScrollType(@NotNull ScrollKind $this$toScrollType) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toScrollType), (String)"<this>");
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$toScrollType.ordinal()]) {
            case 1 -> ScrollType.MAKE_VISIBLE;
            case 2 -> ScrollType.RELATIVE;
            case 3 -> ScrollType.CENTER;
            case 4 -> ScrollType.CENTER_DOWN;
            case 5 -> ScrollType.CENTER_UP;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public static final VisualPosition docOffsetAndVirtualToVisualPosition(@NotNull Editor $this$docOffsetAndVirtualToVisualPosition, @NotNull DocOffsetAndVirtualModel pos) {
        Intrinsics.checkNotNullParameter((Object)$this$docOffsetAndVirtualToVisualPosition, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Boolean bl = pos.getLogicalLeansForward();
        return UtilKt.docOffsetAndVirtualToVisualPosition($this$docOffsetAndVirtualToVisualPosition, pos.getOffset(), pos.getVirtualDelta(), bl != null ? bl : false);
    }

    @NotNull
    public static final VisualPosition docOffsetAndVirtualToVisualPosition(@NotNull Editor $this$docOffsetAndVirtualToVisualPosition, int offset, int virtualDelta, boolean logicalLeansForward) {
        Intrinsics.checkNotNullParameter((Object)$this$docOffsetAndVirtualToVisualPosition, (String)"<this>");
        if (!(virtualDelta >= 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        VisualPosition visualPosition = $this$docOffsetAndVirtualToVisualPosition.offsetToVisualPosition(offset, logicalLeansForward, false);
        Intrinsics.checkNotNullExpressionValue((Object)visualPosition, (String)"offsetToVisualPosition(...)");
        VisualPosition vPos = visualPosition;
        return virtualDelta == 0 ? vPos : new VisualPosition(vPos.line, vPos.column + virtualDelta, vPos.leansRight);
    }

    @NotNull
    public static final VisibleRange calculateVisibleRange(@NotNull Editor editor) {
        List list2;
        Sequence sequence;
        Sequence sequence2;
        Sequence sequence3;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        ProperTextRange properTextRange = editor.calculateVisibleRange();
        Intrinsics.checkNotNullExpressionValue((Object)properTextRange, (String)"calculateVisibleRange(...)");
        ProperTextRange visibleRange = properTextRange;
        Object[] objectArray = editor.getFoldingModel();
        FoldingModelImpl foldingModelImpl = objectArray instanceof FoldingModelImpl ? (FoldingModelImpl)objectArray : null;
        List regionsOverlapping2 = foldingModelImpl != null && (objectArray = foldingModelImpl.fetchVisible()) != null && (sequence3 = ArraysKt.asSequence((Object[])objectArray)) != null && (sequence2 = SequencesKt.filter((Sequence)sequence3, (Function1)((Function1)new Function1<FoldRegion, Boolean>(visibleRange){
            final /* synthetic */ ProperTextRange $visibleRange;
            {
                this.$visibleRange = $visibleRange;
                super(1);
            }

            @NotNull
            public final Boolean invoke(FoldRegion it) {
                return this.$visibleRange.contains((Segment)it) && !it.isExpanded();
            }
        }))) != null && (sequence = SequencesKt.map((Sequence)sequence2, (Function1)calculateVisibleRange.regionsOverlapping.2.INSTANCE)) != null && (list2 = SequencesKt.toList((Sequence)sequence)) != null ? list2 : CollectionsKt.emptyList();
        return new VisibleRange(visibleRange.getStartOffset(), visibleRange.getEndOffset(), regionsOverlapping2);
    }

    /*
     * WARNING - void declaration
     */
    public static final void applyStateTo(@NotNull RdCaretState newState, @NotNull Editor editor) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (editor.isDisposed()) {
            return;
        }
        Iterable $this$sortedBy$iv = newState.getCarets();
        boolean $i$f$sortedBy = false;
        List newCarets = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                RdCaret it = (RdCaret)a;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getId().getNumber());
                it = (RdCaret)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getId().getNumber()));
            }
        });
        Iterable $this$map$iv = newCarets;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void caret;
            RdCaret rdCaret = (RdCaret)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Boolean bl2 = caret.getOffset().getLogicalLeansForward();
            LogicalPosition caretPosition = editor.offsetToLogicalPosition(caret.getOffset().getOffset()).leanForward(bl2 != null ? bl2 : false);
            Boolean bl3 = caret.getSelection().getStart().getLogicalLeansForward();
            LogicalPosition selectionStart = editor.offsetToLogicalPosition(caret.getSelection().getStart().getOffset()).leanForward(bl3 != null ? bl3 : false);
            Boolean bl4 = caret.getSelection().getEnd().getLogicalLeansForward();
            LogicalPosition selectionEnd = editor.offsetToLogicalPosition(caret.getSelection().getEnd().getOffset()).leanForward(bl4 != null ? bl4 : false);
            collection.add(new CaretState(caretPosition, caret.getOffset().getVirtualDelta(), selectionStart, selectionEnd));
        }
        List states = (List)destination$iv$iv;
        editor.getCaretModel().setCaretsAndSelections(states);
        for (RdCaret newCaret : newCarets) {
            Caret caret;
            VisualPosition visualPosition = UtilKt.docOffsetAndVirtualToVisualPosition(editor, newCaret.getOffset());
            if (editor.getCaretModel().getCaretAt(visualPosition) == null) {
                throw new IllegalStateException(("Cannot find caret at " + visualPosition).toString());
            }
            UtilKt.setId(caret, newCaret.getId());
            if (!Intrinsics.areEqual((Object)newCaret.getId(), (Object)newState.getPrimaryCaretId()) || editor.getCaretModel().getPrimaryCaret() == caret) continue;
            editor.getCaretModel().removeCaret(caret);
            UtilKt.addCaretTo(newCaret, editor, true);
        }
    }

    public static final void applySelectionTo(@NotNull RdSelection selectionModel, @NotNull Caret caretToSync, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)selectionModel, (String)"selectionModel");
        Intrinsics.checkNotNullParameter((Object)caretToSync, (String)"caretToSync");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        DocOffsetAndVirtualModel docOffsetAndVirtualModel = selectionModel.getStart();
        int startOffset = docOffsetAndVirtualModel.component1();
        int startVDelta = docOffsetAndVirtualModel.component2();
        DocOffsetAndVirtualModel docOffsetAndVirtualModel2 = selectionModel.getEnd();
        int endOffset = docOffsetAndVirtualModel2.component1();
        int endVDelta = docOffsetAndVirtualModel2.component2();
        if (startVDelta > 0 || endVDelta > 0) {
            VisualPosition startVPos = UtilKt.docOffsetAndVirtualToVisualPosition(editor, selectionModel.getStart());
            VisualPosition endVPos = UtilKt.docOffsetAndVirtualToVisualPosition(editor, selectionModel.getEnd());
            caretToSync.setSelection(startVPos, startOffset, endVPos, endOffset);
        } else {
            caretToSync.setSelection(startOffset, endOffset);
        }
    }

    @Nullable
    public static final Caret addCaretTo(@NotNull RdCaret caret, @NotNull Editor editor, boolean isPrimary) {
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Caret caret2 = UtilKt.addCaretTo(caret.getOffset(), editor, isPrimary);
        if (caret2 == null) {
            return null;
        }
        Caret caretToSync = caret2;
        UtilKt.applySelectionTo(caret.getSelection(), caretToSync, editor);
        UtilKt.setId(caretToSync, caret.getId());
        return caretToSync;
    }

    public static /* synthetic */ Caret addCaretTo$default(RdCaret rdCaret, Editor editor, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return UtilKt.addCaretTo(rdCaret, editor, bl);
    }

    @Nullable
    public static final Caret addCaretTo(@NotNull DocOffsetAndVirtualModel positionModel, @NotNull Editor editor, boolean isPrimary) {
        Intrinsics.checkNotNullParameter((Object)positionModel, (String)"positionModel");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        VisualPosition pos = UtilKt.docOffsetAndVirtualToVisualPosition(editor, positionModel);
        return editor.getCaretModel().addCaret(pos, isPrimary);
    }

    public static /* synthetic */ Caret addCaretTo$default(DocOffsetAndVirtualModel docOffsetAndVirtualModel, Editor editor, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return UtilKt.addCaretTo(docOffsetAndVirtualModel, editor, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<RdCaret> createModelCarets(@NotNull CaretModel $this$createModelCarets) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$createModelCarets, (String)"<this>");
        List list2 = $this$createModelCarets.getAllCarets();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAllCarets(...)");
        Iterable $this$map$iv = list2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            RdCaretId id;
            DocOffsetAndVirtualModel docOffsetAndVirtualModel;
            void $this$createModelPosition$iv;
            DocOffsetAndVirtualModel docOffsetAndVirtualModel2;
            void $this$createModelPosition$iv2;
            DocOffsetAndVirtualModel docOffsetAndVirtualModel3;
            void $this$createModelPosition$iv3;
            void caret;
            Caret caret2 = (Caret)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)caret);
            if (UtilKt.getId((Caret)caret) == null) {
                throw new IllegalStateException("Caret has no ID assigned".toString());
            }
            void var11_11 = caret;
            int n = caret.getOffset();
            int ignoreVirtualDelta$iv = 0;
            boolean $i$f$createModelPosition = false;
            boolean isInBulkUpdate$iv = $this$createModelPosition$iv3.getEditor().getDocument().isInBulkUpdate();
            if (isInBulkUpdate$iv) {
                docOffsetAndVirtualModel3 = new DocOffsetAndVirtualModel((int)offset$iv, 0, false);
            } else {
                VisualPosition visualPosition;
                Editor editor;
                Intrinsics.checkNotNullExpressionValue((Object)$this$createModelPosition$iv3.getEditor(), (String)"getEditor(...)");
                void var16_18 = offset$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)caret.getVisualPosition(), (String)"getVisualPosition(...)");
                int virtualDelta$iv = UtilKt.calcVirtualDelta(editor, (int)var16_18, visualPosition);
                docOffsetAndVirtualModel3 = new DocOffsetAndVirtualModel((int)offset$iv, virtualDelta$iv, $this$createModelPosition$iv3.getLogicalPosition().leansForward);
            }
            DocOffsetAndVirtualModel offset = docOffsetAndVirtualModel3;
            void offset$iv = caret;
            ignoreVirtualDelta$iv = caret.getSelectionStart();
            int ignoreVirtualDelta$iv2 = 1;
            boolean $i$f$createModelPosition2 = false;
            boolean isInBulkUpdate$iv2 = $this$createModelPosition$iv2.getEditor().getDocument().isInBulkUpdate();
            if (isInBulkUpdate$iv2) {
                docOffsetAndVirtualModel2 = new DocOffsetAndVirtualModel((int)offset$iv2, 0, false);
            } else {
                int virtualDelta$iv = 0;
                docOffsetAndVirtualModel2 = new DocOffsetAndVirtualModel((int)offset$iv2, virtualDelta$iv, $this$createModelPosition$iv2.getLogicalPosition().leansForward);
            }
            DocOffsetAndVirtualModel startPos = docOffsetAndVirtualModel2;
            void offset$iv2 = caret;
            ignoreVirtualDelta$iv2 = caret.getSelectionEnd();
            boolean ignoreVirtualDelta$iv3 = true;
            boolean $i$f$createModelPosition3 = false;
            boolean isInBulkUpdate$iv3 = $this$createModelPosition$iv.getEditor().getDocument().isInBulkUpdate();
            if (isInBulkUpdate$iv3) {
                docOffsetAndVirtualModel = new DocOffsetAndVirtualModel((int)offset$iv, 0, false);
            } else {
                int virtualDelta$iv = 0;
                docOffsetAndVirtualModel = new DocOffsetAndVirtualModel((int)offset$iv, virtualDelta$iv, $this$createModelPosition$iv.getLogicalPosition().leansForward);
            }
            DocOffsetAndVirtualModel endPos = docOffsetAndVirtualModel;
            RdSelection selection = new RdSelection(startPos, endPos);
            collection.add(new RdCaret(id, offset, selection));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final RdCaretState createModelCaretState(@NotNull CaretModel $this$createModelCaretState) {
        Intrinsics.checkNotNullParameter((Object)$this$createModelCaretState, (String)"<this>");
        Caret caret = $this$createModelCaretState.getPrimaryCaret();
        Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"getPrimaryCaret(...)");
        RdCaretId rdCaretId = UtilKt.getId(caret);
        if (rdCaretId == null) {
            throw new IllegalStateException("Primary caret has no ID assigned".toString());
        }
        RdCaretId primaryId = rdCaretId;
        return new RdCaretState(primaryId, UtilKt.createModelCarets($this$createModelCaretState));
    }

    @NotNull
    public static final RdCaretState getActualState(@NotNull RdSelectionChangeBase $this$getActualState) {
        RdCaretState rdCaretState;
        Intrinsics.checkNotNullParameter((Object)$this$getActualState, (String)"<this>");
        RdSelectionChangeBase rdSelectionChangeBase = $this$getActualState;
        if (rdSelectionChangeBase instanceof RdCaretStateChange) {
            rdCaretState = ((RdCaretStateChange)$this$getActualState).getNewState();
        } else if (rdSelectionChangeBase instanceof RdCaretStateSnapshotBase) {
            rdCaretState = ((RdCaretStateSnapshotBase)$this$getActualState).getState();
        } else {
            throw new IllegalStateException(("Unsupported selection change: " + $this$getActualState).toString());
        }
        return rdCaretState;
    }

    private static final DocOffsetAndVirtualModel createModelPosition(Caret $this$createModelPosition, int offset, boolean ignoreVirtualDelta, Function0<VisualPosition> calcVisualPosition) {
        int n;
        boolean $i$f$createModelPosition = false;
        boolean isInBulkUpdate = $this$createModelPosition.getEditor().getDocument().isInBulkUpdate();
        if (isInBulkUpdate) {
            return new DocOffsetAndVirtualModel(offset, 0, false);
        }
        if (ignoreVirtualDelta) {
            n = 0;
        } else {
            Editor editor = $this$createModelPosition.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
            n = UtilKt.calcVirtualDelta(editor, offset, (VisualPosition)calcVisualPosition.invoke());
        }
        int virtualDelta = n;
        return new DocOffsetAndVirtualModel(offset, virtualDelta, $this$createModelPosition.getLogicalPosition().leansForward);
    }

    public static final int calcVirtualDelta(@NotNull Editor editor, int caretOffset, @NotNull VisualPosition visualPosition) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)visualPosition, (String)"visualPosition");
        LogicalPosition logicalPosition = editor.visualToLogicalPosition(visualPosition);
        Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"visualToLogicalPosition(...)");
        LogicalPosition logicalPosition2 = logicalPosition;
        int delta = EditorModificationUtilEx.calcAfterLineEnd((Editor)editor, (int)caretOffset, (LogicalPosition)logicalPosition2, (VisualPosition)visualPosition);
        return delta < 0 ? 0 : delta;
    }

    @NotNull
    public static final RdSelectionChangeBase reverse(@NotNull RdSelectionChangeBase $this$reverse) {
        RdSelectionChangeBase rdSelectionChangeBase;
        Intrinsics.checkNotNullParameter((Object)$this$reverse, (String)"<this>");
        RdSelectionChangeBase rdSelectionChangeBase2 = $this$reverse;
        if (rdSelectionChangeBase2 instanceof RdCaretStateChange) {
            rdSelectionChangeBase = new RdCaretStateChange(((RdCaretStateChange)$this$reverse).getNewState(), ((RdCaretStateChange)$this$reverse).getOldState(), $this$reverse.getEditorId());
        } else if (rdSelectionChangeBase2 instanceof RdCaretStateSnapshot) {
            rdSelectionChangeBase = $this$reverse;
        } else {
            throw new IllegalStateException(("unsupported change type " + $this$reverse).toString());
        }
        return rdSelectionChangeBase;
    }

    @NotNull
    public static final RdDocumentChange reverse(@NotNull RdDocumentChange $this$reverse) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$reverse, (String)"<this>");
        String string2 = $this$reverse.getText();
        if (string2 != null) {
            String string3 = string2;
            int n = $this$reverse.getOffset();
            int n2 = $this$reverse.getOffset() + $this$reverse.getNewText().length();
            CharSequence charSequence = $this$reverse.getOldText();
            string = ((Object)StringsKt.replaceRange((CharSequence)string3, (int)n, (int)n2, (CharSequence)charSequence)).toString();
        } else {
            string = null;
        }
        String oldDocumentText = string;
        return new RdDocumentChange($this$reverse.getOffset(), $this$reverse.getMoveOffset(), $this$reverse.getOldText(), $this$reverse.getNewText(), $this$reverse.getModificationKind(), $this$reverse.getOldDocumentLength() - $this$reverse.getOldText().length() + $this$reverse.getNewText().length(), oldDocumentText, $this$reverse.isWholeTextReplaced(), $this$reverse.getDocumentId());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String toDebugString(@NotNull RdCaretState $this$toDebugString) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$this$toDebugString, (String)"<this>");
        Iterable iterable = $this$toDebugString.getCarets();
        String string = UtilKt.toDebugString($this$toDebugString.getPrimaryCaretId());
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RdCaret rdCaret = (RdCaret)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(UtilKt.toDebugString((RdCaret)it));
        }
        return "(primary: " + string + ", carets: " + (List)destination$iv$iv + ")";
    }

    @NotNull
    public static final String toDebugString(@NotNull RdCaret $this$toDebugString) {
        Intrinsics.checkNotNullParameter((Object)$this$toDebugString, (String)"<this>");
        return "(id: " + UtilKt.toDebugString($this$toDebugString.getId()) + ", offset: " + UtilKt.toDebugString($this$toDebugString.getOffset()) + ", selection: " + UtilKt.toDebugString($this$toDebugString.getSelection()) + ")";
    }

    @NotNull
    public static final String toDebugString(@NotNull RdCaretId $this$toDebugString) {
        Intrinsics.checkNotNullParameter((Object)$this$toDebugString, (String)"<this>");
        return ($this$toDebugString.isClient() ? "c" : "s") + $this$toDebugString.getNumber();
    }

    @NotNull
    public static final String toDebugString(@NotNull DocOffsetAndVirtualModel $this$toDebugString) {
        Intrinsics.checkNotNullParameter((Object)$this$toDebugString, (String)"<this>");
        return "(" + $this$toDebugString.getOffset() + ", " + $this$toDebugString.getVirtualDelta() + ", " + $this$toDebugString.getLogicalLeansForward() + ")";
    }

    @NotNull
    public static final String toDebugString(@NotNull RdSelection $this$toDebugString) {
        Intrinsics.checkNotNullParameter((Object)$this$toDebugString, (String)"<this>");
        return "(start: " + UtilKt.toDebugString($this$toDebugString.getStart()) + " - end: " + UtilKt.toDebugString($this$toDebugString.getEnd()) + ")";
    }

    @NotNull
    public static final String toDebugString(@NotNull TextControlId $this$toDebugString) {
        Intrinsics.checkNotNullParameter((Object)$this$toDebugString, (String)"<this>");
        return "(" + DocumentExKt.toDebugString($this$toDebugString.getDocumentId()) + ", " + $this$toDebugString.getClientId() + ", " + $this$toDebugString.getTabIndex() + ", " + $this$toDebugString.getKind() + ")";
    }

    @NotNull
    public static final String toDebugString(@NotNull RdFileEditorId $this$toDebugString) {
        Intrinsics.checkNotNullParameter((Object)$this$toDebugString, (String)"<this>");
        return "(" + $this$toDebugString.getCompositeId() + ", " + $this$toDebugString.getProviderId() + ", " + $this$toDebugString.getIndex() + ")";
    }

    @NotNull
    public static final String toDebugString(@NotNull RdFileEditorCompositeId $this$toDebugString) {
        Intrinsics.checkNotNullParameter((Object)$this$toDebugString, (String)"<this>");
        return "(" + $this$toDebugString.getFileId() + ", " + $this$toDebugString.getClientId() + ", " + $this$toDebugString.getIndex() + ")";
    }

    @NotNull
    public static final String createLogCategory(@NotNull TextControlId $this$createLogCategory) {
        Intrinsics.checkNotNullParameter((Object)$this$createLogCategory, (String)"<this>");
        String fileName = DocumentExKt.createLogCategory($this$createLogCategory.getDocumentId());
        int tabIndex = $this$createLogCategory.getTabIndex();
        TextControlLocation kind = $this$createLogCategory.getKind();
        return fileName + ", " + tabIndex + ", " + kind;
    }

    public static final int component1(@Nullable VisualPosition $this$component1) {
        VisualPosition visualPosition = $this$component1;
        return visualPosition != null ? visualPosition.line : -1;
    }

    public static final int component2(@Nullable VisualPosition $this$component2) {
        VisualPosition visualPosition = $this$component2;
        return visualPosition != null ? visualPosition.column : -1;
    }

    public static final int component1(@NotNull LogicalPosition $this$component1) {
        Intrinsics.checkNotNullParameter((Object)$this$component1, (String)"<this>");
        return $this$component1.line;
    }

    public static final int component2(@NotNull LogicalPosition $this$component2) {
        Intrinsics.checkNotNullParameter((Object)$this$component2, (String)"<this>");
        return $this$component2.column;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(UtilKt.class, "id", "getId(Lcom/intellij/openapi/editor/Caret;)Lcom/jetbrains/rd/ide/model/RdCaretId;", 1)))};
        $$delegatedProperties = kPropertyArray;
        id$delegate = UserDataHolderKt.userData$default(null, 1, null);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ScrollKind.values().length];
            try {
                nArray[ScrollKind.Smart.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScrollKind.Relative.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScrollKind.Center.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScrollKind.LowerHalf.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScrollKind.UpperHalf.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

