/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.ide.inspection.grammar;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.grazie.GrazieBundle;
import com.intellij.grazie.GrazieConfig;
import com.intellij.grazie.ide.inspection.grammar.GrazieInspection;
import com.intellij.grazie.text.CheckerRunner;
import com.intellij.grazie.text.TextChecker;
import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.text.TextExtractor;
import com.intellij.grazie.text.TextProblem;
import com.intellij.lang.Language;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.spellchecker.ui.SpellCheckingEditorCustomization;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/grazie/ide/inspection/grammar/GrazieInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "getDisplayName", "", "Companion", "intellij.grazie.core"})
public final class GrazieInspection
extends LocalInspectionTool {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Lazy<Boolean> hasSpellChecking$delegate = LazyKt.lazy((Function0)Companion.hasSpellChecking.2.INSTANCE);

    @NotNull
    public String getDisplayName() {
        return GrazieBundle.message("grazie.grammar.inspection.grammar.text", new Object[0]);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        PsiFile psiFile = holder.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
        PsiFile file2 = psiFile;
        if (Companion.ignoreGrammarChecking(file2)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        List<TextChecker> checkers = TextChecker.allCheckers();
        Set<TextContent.TextDomain> checkedDomains = Companion.checkedDomains();
        Function1<PsiElement, Boolean> areChecksDisabled = Companion.getDisabledChecker(file2);
        return new PsiElementVisitor(areChecksDisabled, checkedDomains, session, checkers, isOnTheFly, holder){
            final /* synthetic */ Function1<PsiElement, Boolean> $areChecksDisabled;
            final /* synthetic */ Set<TextContent.TextDomain> $checkedDomains;
            final /* synthetic */ LocalInspectionToolSession $session;
            final /* synthetic */ List<TextChecker> $checkers;
            final /* synthetic */ boolean $isOnTheFly;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$areChecksDisabled = $areChecksDisabled;
                this.$checkedDomains = $checkedDomains;
                this.$session = $session;
                this.$checkers = $checkers;
                this.$isOnTheFly = $isOnTheFly;
                this.$holder = $holder;
            }

            /*
             * WARNING - void declaration
             */
            public void visitElement(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof PsiWhiteSpace || ((Boolean)this.$areChecksDisabled.invoke((Object)element)).booleanValue()) {
                    return;
                }
                List<TextContent> list = TextExtractor.findUniqueTextsAt(element, this.$checkedDomains);
                Intrinsics.checkNotNullExpressionValue(list, (String)"findUniqueTextsAt(...)");
                List<TextContent> texts = list;
                Iterable iterable = texts;
                int n = 0;
                Iterator<T> iterator = iterable.iterator();
                while (iterator.hasNext()) {
                    void it;
                    T t = iterator.next();
                    TextContent textContent = (TextContent)t;
                    int n2 = n;
                    boolean bl = false;
                    int n3 = it.length();
                    n = n2 + n3;
                }
                if (n > 50000) {
                    return;
                }
                TextRange textRange = this.$session.getPriorityRange();
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getPriorityRange(...)");
                for (TextContent extracted : GrazieInspection.Companion.sortByPriority(texts, textRange)) {
                    CheckerRunner runner = new CheckerRunner(extracted);
                    List<TextChecker> list2 = this.$checkers;
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"$checkers");
                    runner.run(list2, (Function1<? super TextProblem, Unit>)((Function1)new Function1<TextProblem, Unit>(runner, this.$isOnTheFly, this.$holder){
                        final /* synthetic */ CheckerRunner $runner;
                        final /* synthetic */ boolean $isOnTheFly;
                        final /* synthetic */ ProblemsHolder $holder;
                        {
                            this.$runner = $runner;
                            this.$isOnTheFly = $isOnTheFly;
                            this.$holder = $holder;
                            super(1);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke(@NotNull TextProblem problem) {
                            void $this$forEach$iv;
                            Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
                            Iterable iterable = this.$runner.toProblemDescriptors(problem, this.$isOnTheFly);
                            ProblemsHolder problemsHolder = this.$holder;
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                ProblemDescriptor p0 = (ProblemDescriptor)element$iv;
                                boolean bl = false;
                                problemsHolder.registerProblem(p0);
                            }
                        }
                    }));
                }
            }
        };
    }

    @JvmStatic
    public static final boolean ignoreGrammarChecking(@NotNull PsiFile file2) {
        return Companion.ignoreGrammarChecking(file2);
    }

    @JvmStatic
    @NotNull
    public static final Set<TextContent.TextDomain> checkedDomains() {
        return Companion.checkedDomains();
    }

    @JvmStatic
    @NotNull
    public static final Function1<PsiElement, Boolean> getDisabledChecker(@NotNull PsiFile file2) {
        return Companion.getDisabledChecker(file2);
    }

    @JvmStatic
    @NotNull
    public static final List<TextContent> sortByPriority(@NotNull List<? extends TextContent> texts, @NotNull TextRange priorityRange) {
        return Companion.sortByPriority(texts, priorityRange);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0007J\u001c\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00040\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J$\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0007R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0019"}, d2={"Lcom/intellij/grazie/ide/inspection/grammar/GrazieInspection$Companion;", "", "()V", "hasSpellChecking", "", "getHasSpellChecking", "()Z", "hasSpellChecking$delegate", "Lkotlin/Lazy;", "checkedDomains", "", "Lcom/intellij/grazie/text/TextContent$TextDomain;", "getDisabledChecker", "Lkotlin/Function1;", "Lcom/intellij/psi/PsiElement;", "file", "Lcom/intellij/psi/PsiFile;", "ignoreGrammarChecking", "isSpellCheckingDisabled", "sortByPriority", "", "Lcom/intellij/grazie/text/TextContent;", "texts", "priorityRange", "Lcom/intellij/openapi/util/TextRange;", "intellij.grazie.core"})
    @SourceDebugExtension(value={"SMAP\nGrazieInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrazieInspection.kt\ncom/intellij/grazie/ide/inspection/grammar/GrazieInspection$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,118:1\n1045#2:119\n*S KotlinDebug\n*F\n+ 1 GrazieInspection.kt\ncom/intellij/grazie/ide/inspection/grammar/GrazieInspection$Companion\n*L\n107#1:119\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean getHasSpellChecking() {
            Lazy lazy = hasSpellChecking$delegate;
            return (Boolean)lazy.getValue();
        }

        @JvmStatic
        public final boolean ignoreGrammarChecking(@NotNull PsiFile file2) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            return this.getHasSpellChecking() && this.isSpellCheckingDisabled(file2);
        }

        private final boolean isSpellCheckingDisabled(PsiFile file2) {
            return SpellCheckingEditorCustomization.isSpellCheckingDisabled((PsiFile)file2);
        }

        @JvmStatic
        @NotNull
        public final Set<TextContent.TextDomain> checkedDomains() {
            EnumSet<Enum> result2 = EnumSet.of((Enum)TextContent.TextDomain.PLAIN_TEXT);
            if (GrazieConfig.Companion.get().getCheckingContext().isCheckInStringLiteralsEnabled()) {
                result2.add(TextContent.TextDomain.LITERALS);
            }
            if (GrazieConfig.Companion.get().getCheckingContext().isCheckInCommentsEnabled()) {
                result2.add(TextContent.TextDomain.COMMENTS);
            }
            if (GrazieConfig.Companion.get().getCheckingContext().isCheckInDocumentationEnabled()) {
                result2.add(TextContent.TextDomain.DOCUMENTATION);
            }
            Intrinsics.checkNotNull(result2);
            return result2;
        }

        @JvmStatic
        @NotNull
        public final Function1<PsiElement, Boolean> getDisabledChecker(@NotNull PsiFile file2) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Language language = file2.getLanguage();
            Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
            Language fileLanguage = language;
            Set<Language> supportedLanguages = TextExtractor.getSupportedLanguages();
            Set<String> disabledLanguages = GrazieConfig.Companion.get().getCheckingContext().getEffectivelyDisabledLanguageIds();
            return (Function1)new Function1<PsiElement, Boolean>(fileLanguage, supportedLanguages, disabledLanguages){
                final /* synthetic */ Language $fileLanguage;
                final /* synthetic */ Set<Language> $supportedLanguages;
                final /* synthetic */ Set<String> $disabledLanguages;
                {
                    this.$fileLanguage = $fileLanguage;
                    this.$supportedLanguages = $supportedLanguages;
                    this.$disabledLanguages = $disabledLanguages;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull PsiElement element) {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    Language lang = element.getLanguage();
                    if (this.$fileLanguage.isKindOf(lang)) {
                        lang = this.$fileLanguage;
                    }
                    while (lang != null && !this.$supportedLanguages.contains(lang)) {
                        lang = lang.getBaseLanguage();
                    }
                    return lang != null && this.$disabledLanguages.contains(lang.getID());
                }
            };
        }

        @JvmStatic
        @NotNull
        public final List<TextContent> sortByPriority(@NotNull List<? extends TextContent> texts, @NotNull TextRange priorityRange) {
            Intrinsics.checkNotNullParameter(texts, (String)"texts");
            Intrinsics.checkNotNullParameter((Object)priorityRange, (String)"priorityRange");
            Iterable $this$sortedBy$iv = texts;
            boolean $i$f$sortedBy = false;
            return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(priorityRange){
                final /* synthetic */ TextRange $priorityRange$inlined;
                {
                    this.$priorityRange$inlined = textRange;
                }

                public final int compare(T a, T b) {
                    TextContent text2 = (TextContent)a;
                    boolean bl = false;
                    TextRange textRange = text2.textRangeToFile(new TextRange(0, text2.length()));
                    Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"textRangeToFile(...)");
                    TextRange textRangeInFile = textRange;
                    text2 = (TextContent)b;
                    Comparable comparable = Integer.valueOf(textRangeInFile.contains(this.$priorityRange$inlined) ? 0 : (textRangeInFile.intersects(this.$priorityRange$inlined) ? 1 : 2));
                    bl = false;
                    TextRange textRange2 = text2.textRangeToFile(new TextRange(0, text2.length()));
                    Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"textRangeToFile(...)");
                    textRangeInFile = textRange2;
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(textRangeInFile.contains(this.$priorityRange$inlined) ? 0 : (textRangeInFile.intersects(this.$priorityRange$inlined) ? 1 : 2)));
                }
            });
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

