/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.ide.inspection.detection;

import ai.grazie.nlp.langs.Language;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.grazie.GrazieBundle;
import com.intellij.grazie.GrazieConfig;
import com.intellij.grazie.config.DetectionContext;
import com.intellij.grazie.detection.ExtensionsKt;
import com.intellij.grazie.detection.LangDetector;
import com.intellij.grazie.ide.inspection.detection.problem.LanguageDetectionProblemDescriptor;
import com.intellij.grazie.ide.inspection.grammar.GrazieInspection;
import com.intellij.grazie.jlanguage.Lang;
import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.text.TextExtractor;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.KeyWithDefaultValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016R!\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/grazie/ide/inspection/detection/LanguageDetectionInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "()V", "key", "Lcom/intellij/openapi/util/KeyWithDefaultValue;", "Lcom/intellij/grazie/config/DetectionContext$Local;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "getDisplayName", "", "inspectionFinished", "", "inspectionStarted", "intellij.grazie.core"})
@SourceDebugExtension(value={"SMAP\nLanguageDetectionInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LanguageDetectionInspection.kt\ncom/intellij/grazie/ide/inspection/detection/LanguageDetectionInspection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,69:1\n1549#2:70\n1620#2,3:71\n*S KotlinDebug\n*F\n+ 1 LanguageDetectionInspection.kt\ncom/intellij/grazie/ide/inspection/detection/LanguageDetectionInspection\n*L\n33#1:70\n33#1:71,3\n*E\n"})
public final class LanguageDetectionInspection
extends LocalInspectionTool {
    @NotNull
    private final KeyWithDefaultValue<DetectionContext.Local> key;

    public LanguageDetectionInspection() {
        KeyWithDefaultValue keyWithDefaultValue = KeyWithDefaultValue.create((String)"language-detection-inspection-key", (Object)new DetectionContext.Local(null, 1, null));
        Intrinsics.checkNotNullExpressionValue((Object)keyWithDefaultValue, (String)"create(...)");
        this.key = keyWithDefaultValue;
    }

    public void inspectionStarted(@NotNull LocalInspectionToolSession session, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Object object = session.getUserData((Key)this.key);
        Intrinsics.checkNotNull((Object)object);
        ((DetectionContext.Local)object).clear();
    }

    /*
     * WARNING - void declaration
     */
    public void inspectionFinished(@NotNull LocalInspectionToolSession session, @NotNull ProblemsHolder holder) {
        Collection<Language> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        GrazieConfig.State state = GrazieConfig.Companion.get();
        Object object = session.getUserData((Key)this.key);
        Intrinsics.checkNotNull((Object)object);
        DetectionContext.Local context = (DetectionContext.Local)object;
        Iterable iterable = state.getAvailableLanguages();
        Set<Language> set = state.getDetectionContext().getDisabled();
        DetectionContext.Local local = context;
        boolean $i$f$map = false;
        void var8_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Lang lang = (Lang)((Object)item$iv$iv);
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ExtensionsKt.toLanguage((Lang)it));
        }
        collection = (List)destination$iv$iv;
        Set<Language> languages2 = local.getToNotify(CollectionsKt.toSet((Iterable)SetsKt.plus(set, (Iterable)collection)));
        if (languages2.isEmpty()) {
            return;
        }
        ProblemDescriptor descriptor2 = (ProblemDescriptor)ActionsKt.runReadAction((Function0)((Function0)new Function0<ProblemDescriptor>(holder, session, languages2){
            final /* synthetic */ ProblemsHolder $holder;
            final /* synthetic */ LocalInspectionToolSession $session;
            final /* synthetic */ Set<Language> $languages;
            {
                this.$holder = $holder;
                this.$session = $session;
                this.$languages = $languages;
                super(0);
            }

            @Nullable
            public final ProblemDescriptor invoke() {
                InspectionManager inspectionManager = this.$holder.getManager();
                Intrinsics.checkNotNullExpressionValue((Object)inspectionManager, (String)"getManager(...)");
                boolean bl = this.$holder.isOnTheFly();
                PsiFile psiFile = this.$session.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
                return LanguageDetectionProblemDescriptor.INSTANCE.create(inspectionManager, bl, psiFile, this.$languages);
            }
        }));
        if (descriptor2 != null) {
            holder.registerProblem(descriptor2);
        }
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        PsiFile psiFile = holder.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
        PsiFile file2 = psiFile;
        if (!isOnTheFly || InjectedLanguageManager.getInstance((Project)holder.getProject()).isInjectedFragment(file2) || GrazieInspection.Companion.ignoreGrammarChecking(file2)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        Set<TextContent.TextDomain> domains = GrazieInspection.Companion.checkedDomains();
        Function1<PsiElement, Boolean> areChecksDisabled = GrazieInspection.Companion.getDisabledChecker(file2);
        return new PsiElementVisitor(areChecksDisabled, session, this, domains){
            final /* synthetic */ Function1<PsiElement, Boolean> $areChecksDisabled;
            final /* synthetic */ LocalInspectionToolSession $session;
            final /* synthetic */ LanguageDetectionInspection this$0;
            final /* synthetic */ Set<TextContent.TextDomain> $domains;
            {
                this.$areChecksDisabled = $areChecksDisabled;
                this.$session = $session;
                this.this$0 = $receiver;
                this.$domains = $domains;
            }

            public void visitElement(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof PsiWhiteSpace || ((Boolean)this.$areChecksDisabled.invoke((Object)element)).booleanValue()) {
                    return;
                }
                Object object = this.$session.getUserData((Key)LanguageDetectionInspection.access$getKey$p(this.this$0));
                Intrinsics.checkNotNull((Object)object);
                DetectionContext.Local context = (DetectionContext.Local)object;
                List<TextContent> list = TextExtractor.findUniqueTextsAt(element, this.$domains);
                Intrinsics.checkNotNullExpressionValue(list, (String)"findUniqueTextsAt(...)");
                List<TextContent> texts = list;
                Iterable $this$forEach$iv = texts;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    TextContent it = (TextContent)element$iv;
                    boolean bl = false;
                    ProgressManager.checkCanceled();
                    Intrinsics.checkNotNull((Object)it);
                    LangDetector.INSTANCE.updateContext(it, context);
                }
            }
        };
    }

    @NotNull
    public String getDisplayName() {
        return GrazieBundle.message("grazie.detection.inspection.text", new Object[0]);
    }

    public static final /* synthetic */ KeyWithDefaultValue access$getKey$p(LanguageDetectionInspection $this) {
        return $this.key;
    }
}

