/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractByteCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractObjectCollection;
import com.carrotsearch.hppc.ByteContainer;
import com.carrotsearch.hppc.ObjectByteAssociativeContainer;
import com.carrotsearch.hppc.ObjectByteHashMap;
import com.carrotsearch.hppc.ObjectByteMap;
import com.carrotsearch.hppc.ObjectCollection;
import com.carrotsearch.hppc.ObjectContainer;
import com.carrotsearch.hppc.ObjectLookupContainer;
import com.carrotsearch.hppc.comparators.ObjectByteComparator;
import com.carrotsearch.hppc.cursors.ByteCursor;
import com.carrotsearch.hppc.cursors.ObjectByteCursor;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.predicates.BytePredicate;
import com.carrotsearch.hppc.predicates.ObjectBytePredicate;
import com.carrotsearch.hppc.predicates.ObjectPredicate;
import com.carrotsearch.hppc.procedures.ByteProcedure;
import com.carrotsearch.hppc.procedures.ObjectByteProcedure;
import com.carrotsearch.hppc.procedures.ObjectProcedure;
import com.carrotsearch.hppc.sorting.QuickSort;
import java.util.Comparator;
import java.util.Iterator;
import java.util.function.IntBinaryOperator;

public class SortedIterationObjectByteHashMap<KType>
implements ObjectByteMap<KType> {
    public final ObjectByteHashMap<KType> delegate;
    public final int[] iterationOrder;

    public SortedIterationObjectByteHashMap(ObjectByteHashMap<KType> delegate, Comparator<KType> comparator) {
        this.delegate = delegate;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    public SortedIterationObjectByteHashMap(ObjectByteHashMap<KType> delegate, ObjectByteComparator<KType> comparator) {
        this.delegate = delegate;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    private int[] createEntryIndexes() {
        Object[] keys = this.delegate.keys;
        int size = this.delegate.size();
        int[] entryIndexes = new int[size];
        int entry2 = 0;
        if (this.delegate.hasEmptyKey) {
            entryIndexes[entry2++] = this.delegate.mask + 1;
        }
        int keyIndex = 0;
        while (entry2 < size) {
            if (keys[keyIndex] != null) {
                entryIndexes[entry2++] = keyIndex;
            }
            ++keyIndex;
        }
        return entryIndexes;
    }

    protected int[] sortIterationOrder(int[] entryIndexes, Comparator<KType> comparator) {
        QuickSort.sort(entryIndexes, (i, j) -> {
            Object[] keys = this.delegate.keys;
            return comparator.compare(keys[entryIndexes[i]], keys[entryIndexes[j]]);
        });
        return entryIndexes;
    }

    protected int[] sortIterationOrder(final int[] entryIndexes, final ObjectByteComparator<KType> comparator) {
        QuickSort.sort(entryIndexes, new IntBinaryOperator(){
            final KType[] keys;
            final byte[] values;
            {
                this.keys = SortedIterationObjectByteHashMap.this.delegate.keys;
                this.values = SortedIterationObjectByteHashMap.this.delegate.values;
            }

            @Override
            public int applyAsInt(int i, int j) {
                int index1 = entryIndexes[i];
                int index2 = entryIndexes[j];
                return comparator.compare(this.keys[index1], this.values[index1], this.keys[index2], this.values[index2]);
            }
        });
        return entryIndexes;
    }

    @Override
    public Iterator<ObjectByteCursor<KType>> iterator() {
        assert (this.checkUnmodified());
        return new EntryIterator();
    }

    @Override
    public boolean containsKey(KType key2) {
        return this.delegate.containsKey(key2);
    }

    @Override
    public int size() {
        assert (this.checkUnmodified());
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public int removeAll(ObjectContainer<? super KType> container) {
        throw SortedIterationObjectByteHashMap.readOnlyException();
    }

    @Override
    public int removeAll(ObjectPredicate<? super KType> predicate) {
        throw SortedIterationObjectByteHashMap.readOnlyException();
    }

    @Override
    public int removeAll(ObjectBytePredicate<? super KType> predicate) {
        throw SortedIterationObjectByteHashMap.readOnlyException();
    }

    @Override
    public <T extends ObjectByteProcedure<? super KType>> T forEach(T procedure) {
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        Object[] keys = this.delegate.keys;
        byte[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            int slot = iterationOrder[i];
            procedure.apply((Object)keys[slot], values[slot]);
        }
        return procedure;
    }

    @Override
    public <T extends ObjectBytePredicate<? super KType>> T forEach(T predicate) {
        int slot;
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        Object[] keys = this.delegate.keys;
        byte[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size && predicate.apply((Object)keys[slot = iterationOrder[i]], values[slot]); ++i) {
        }
        return predicate;
    }

    @Override
    public ObjectCollection<KType> keys() {
        assert (this.checkUnmodified());
        return new KeysContainer();
    }

    @Override
    public ByteContainer values() {
        assert (this.checkUnmodified());
        return new ValuesContainer();
    }

    @Override
    public byte get(KType key2) {
        return this.delegate.get(key2);
    }

    @Override
    public byte getOrDefault(KType key2, byte defaultValue) {
        return this.delegate.getOrDefault(key2, defaultValue);
    }

    @Override
    public byte put(KType key2, byte value) {
        throw SortedIterationObjectByteHashMap.readOnlyException();
    }

    @Override
    public int putAll(ObjectByteAssociativeContainer<? extends KType> container) {
        throw SortedIterationObjectByteHashMap.readOnlyException();
    }

    @Override
    public int putAll(Iterable<? extends ObjectByteCursor<? extends KType>> iterable) {
        throw SortedIterationObjectByteHashMap.readOnlyException();
    }

    @Override
    public byte putOrAdd(KType key2, byte putValue, byte incrementValue) {
        throw SortedIterationObjectByteHashMap.readOnlyException();
    }

    @Override
    public byte addTo(KType key2, byte additionValue) {
        throw SortedIterationObjectByteHashMap.readOnlyException();
    }

    @Override
    public byte remove(KType key2) {
        throw SortedIterationObjectByteHashMap.readOnlyException();
    }

    @Override
    public int indexOf(KType key2) {
        return this.delegate.indexOf(key2);
    }

    @Override
    public boolean indexExists(int index) {
        return this.delegate.indexExists(index);
    }

    @Override
    public byte indexGet(int index) {
        return this.delegate.indexGet(index);
    }

    @Override
    public byte indexReplace(int index, byte newValue) {
        throw SortedIterationObjectByteHashMap.readOnlyException();
    }

    @Override
    public void indexInsert(int index, KType key2, byte value) {
        throw SortedIterationObjectByteHashMap.readOnlyException();
    }

    @Override
    public byte indexRemove(int index) {
        throw SortedIterationObjectByteHashMap.readOnlyException();
    }

    @Override
    public void clear() {
        throw SortedIterationObjectByteHashMap.readOnlyException();
    }

    @Override
    public void release() {
        throw SortedIterationObjectByteHashMap.readOnlyException();
    }

    @Override
    public String visualizeKeyDistribution(int characters) {
        return this.delegate.visualizeKeyDistribution(characters);
    }

    private static RuntimeException readOnlyException() {
        throw new UnsupportedOperationException("Read-only view cannot be modified");
    }

    private boolean checkUnmodified() {
        assert (this.delegate.size() == this.iterationOrder.length) : "The delegate map changed; this is not supported by this read-only view";
        return true;
    }

    private final class EntryIterator
    extends AbstractIterator<ObjectByteCursor<KType>> {
        private final ObjectByteCursor<KType> cursor = new ObjectByteCursor();
        private int index;

        private EntryIterator() {
        }

        @Override
        protected ObjectByteCursor<KType> fetch() {
            if (this.index < SortedIterationObjectByteHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationObjectByteHashMap.this.iterationOrder[this.index++];
                this.cursor.key = SortedIterationObjectByteHashMap.this.delegate.keys[slot];
                this.cursor.value = SortedIterationObjectByteHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (ObjectByteCursor)this.done();
        }
    }

    private final class KeysContainer
    extends AbstractObjectCollection<KType>
    implements ObjectLookupContainer<KType> {
        private final SortedIterationObjectByteHashMap<KType> owner;

        private KeysContainer() {
            this.owner = SortedIterationObjectByteHashMap.this;
        }

        @Override
        public boolean contains(KType e) {
            return this.owner.containsKey(e);
        }

        @Override
        public <T extends ObjectProcedure<? super KType>> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(k));
            return procedure;
        }

        @Override
        public <T extends ObjectPredicate<? super KType>> T forEach(T predicate) {
            this.owner.forEach((key2, value) -> predicate.apply(key2));
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<ObjectCursor<KType>> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            throw SortedIterationObjectByteHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationObjectByteHashMap.readOnlyException();
        }

        @Override
        public int removeAll(ObjectPredicate<? super KType> predicate) {
            throw SortedIterationObjectByteHashMap.readOnlyException();
        }

        @Override
        public int removeAll(KType e) {
            throw SortedIterationObjectByteHashMap.readOnlyException();
        }
    }

    private final class ValuesContainer
    extends AbstractByteCollection {
        private final SortedIterationObjectByteHashMap<KType> owner;

        private ValuesContainer() {
            this.owner = SortedIterationObjectByteHashMap.this;
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public boolean contains(byte value) {
            for (ObjectByteCursor c : this.owner) {
                if (value != c.value) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends ByteProcedure> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(v));
            return procedure;
        }

        @Override
        public <T extends BytePredicate> T forEach(T predicate) {
            this.owner.forEach((k, v) -> predicate.apply(v));
            return predicate;
        }

        @Override
        public Iterator<ByteCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAll(byte e) {
            throw SortedIterationObjectByteHashMap.readOnlyException();
        }

        @Override
        public int removeAll(BytePredicate predicate) {
            throw SortedIterationObjectByteHashMap.readOnlyException();
        }

        @Override
        public void clear() {
            throw SortedIterationObjectByteHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationObjectByteHashMap.readOnlyException();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<ByteCursor> {
        private final ByteCursor cursor = new ByteCursor();
        private int index;

        private ValuesIterator() {
        }

        @Override
        protected ByteCursor fetch() {
            if (this.index < SortedIterationObjectByteHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationObjectByteHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationObjectByteHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (ByteCursor)this.done();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<ObjectCursor<KType>> {
        private final ObjectCursor<KType> cursor = new ObjectCursor();
        private int index;

        private KeysIterator() {
        }

        @Override
        protected ObjectCursor<KType> fetch() {
            if (this.index < SortedIterationObjectByteHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationObjectByteHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationObjectByteHashMap.this.delegate.keys[slot];
                return this.cursor;
            }
            return (ObjectCursor)this.done();
        }
    }
}

