/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.preview;

import com.intellij.ide.plugins.cl.PluginClassLoader;
import com.intellij.jupyter.core.jupyter.preview.JupyterHttpUtilsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.util.PathUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.http.client.utils.URIBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.HttpRequestHandler;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\b&\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0015\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0004J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0018\u001a\u00020\u0004H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001a"}, d2={"Lcom/intellij/jupyter/core/jupyter/preview/JupyterCefHttpHandlerBase;", "Lorg/jetbrains/ide/HttpRequestHandler;", "absolutePathFiles", "", "", "(Ljava/util/Collection;)V", "appName", "getAppName", "()Ljava/lang/String;", "getFileFromUrl", "fullUri", "isSupported", "", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "process", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "context", "Lio/netty/channel/ChannelHandlerContext;", "processInternalLibs", "", "uri", "readFile", "file", "Companion", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterCefHttpHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterCefHttpHandler.kt\ncom/intellij/jupyter/core/jupyter/preview/JupyterCefHttpHandlerBase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,125:1\n1#2:126\n9#3:127\n9#3:128\n*S KotlinDebug\n*F\n+ 1 JupyterCefHttpHandler.kt\ncom/intellij/jupyter/core/jupyter/preview/JupyterCefHttpHandlerBase\n*L\n86#1:127\n91#1:128\n*E\n"})
public abstract class JupyterCefHttpHandlerBase
extends HttpRequestHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Collection<String> absolutePathFiles;
    @NotNull
    private static final Set<String> allowedTypes;
    @NotNull
    private static final String JUPYTER_HTTP_URI = "jupyter";
    @NotNull
    private static final String prefix = "/jupyter";

    public JupyterCefHttpHandlerBase(@NotNull Collection<String> absolutePathFiles) {
        Intrinsics.checkNotNullParameter(absolutePathFiles, (String)"absolutePathFiles");
        this.absolutePathFiles = absolutePathFiles;
    }

    public /* synthetic */ JupyterCefHttpHandlerBase(Collection collection, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            collection = CollectionsKt.emptyList();
        }
        this(collection);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isSupported(@NotNull FullHttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (!super.isSupported(request)) return false;
        String it = request.uri();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        if (StringsKt.startsWith$default((String)it, (String)prefix, (boolean)false, (int)2, null)) return true;
        if (!this.absolutePathFiles.contains(it)) return false;
        return true;
    }

    public boolean process(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) {
        Intrinsics.checkNotNullParameter((Object)urlDecoder, (String)"urlDecoder");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String str = request.uri();
        String fullUri = new URI(str).getPath();
        Intrinsics.checkNotNull((Object)fullUri);
        String string = this.getFileFromUrl(fullUri);
        if (string == null) {
            return false;
        }
        String uri = string;
        byte[] byArray = this.processInternalLibs(uri);
        if (byArray == null) {
            return false;
        }
        byte[] readBytes = byArray;
        String string2 = this.getAppName() + "/" + uri;
        Channel channel = context.channel();
        Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel(...)");
        EmptyHttpHeaders emptyHttpHeaders = EmptyHttpHeaders.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)emptyHttpHeaders, (String)"INSTANCE");
        this.sendData(readBytes, string2, request, channel, (HttpHeaders)emptyHttpHeaders);
        return true;
    }

    @Nullable
    public final byte[] processInternalLibs(@NotNull String uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        try {
            String string = FileUtilRt.getExtension((String)uri);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExtension(...)");
            String extension = string;
            if (allowedTypes.contains(extension) || ApplicationManager.getApplication().isInternal() && Intrinsics.areEqual((Object)extension, (Object)"map")) {
                return this.readFile(uri);
            }
            JupyterCefHttpHandlerBase $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(JupyterCefHttpHandlerBase.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.info("Extension not allowed: " + extension);
            return null;
        }
        catch (Throwable t) {
            JupyterCefHttpHandlerBase $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(JupyterCefHttpHandlerBase.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Cannot process: " + uri, t);
            return null;
        }
    }

    private final String getFileFromUrl(String fullUri) {
        if (this.absolutePathFiles.contains(fullUri)) {
            return fullUri;
        }
        if (!StringsKt.startsWith$default((String)fullUri, (String)prefix, (boolean)false, (int)2, null)) {
            return null;
        }
        String string = StringsKt.replace$default((String)fullUri, (String)"//", (String)"/", (boolean)false, (int)4, null).substring(8);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        char[] cArray = new char[]{'/'};
        String uri = StringsKt.trimStart((String)string, (char[])cArray);
        if (((CharSequence)uri).length() == 0) {
            return null;
        }
        if (StringsKt.contains$default((CharSequence)uri, (CharSequence)"..", (boolean)false, (int)2, null)) {
            return null;
        }
        return uri;
    }

    @NotNull
    public abstract String getAppName();

    private final byte[] readFile(String file) {
        if (StringsKt.contains$default((CharSequence)file, (CharSequence)"BASE_EXTENSION_PATH", (boolean)false, (int)2, null)) {
            return null;
        }
        String appName = this.getAppName();
        URL resource = JupyterCefHttpHandlerBase.Companion.getResource(appName + "/" + file);
        return TextStreamsKt.readBytes((URL)resource);
    }

    public JupyterCefHttpHandlerBase() {
        this(null, 1, null);
    }

    static {
        Object[] objectArray = new String[]{"css", "js", "html", "svg", "woff2", "ttf"};
        allowedTypes = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\tJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/jupyter/core/jupyter/preview/JupyterCefHttpHandlerBase$Companion;", "", "()V", "JUPYTER_HTTP_URI", "", "allowedTypes", "", "prefix", "getIndexUrl", "Lorg/apache/http/client/utils/URIBuilder;", "getJupyterHttpUrl", "getResource", "Ljava/net/URL;", "path", "intellij.jupyter.core"})
    @SourceDebugExtension(value={"SMAP\nJupyterCefHttpHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterCefHttpHandler.kt\ncom/intellij/jupyter/core/jupyter/preview/JupyterCefHttpHandlerBase$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,125:1\n1#2:126\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final URIBuilder getJupyterHttpUrl() {
            return JupyterHttpUtilsKt.addPathSegment(JupyterHttpUtilsKt.getJupyterBaseUrl("http"), JupyterCefHttpHandlerBase.JUPYTER_HTTP_URI);
        }

        @NotNull
        public final URIBuilder getIndexUrl() {
            return JupyterHttpUtilsKt.addPathSegment(this.getJupyterHttpUrl(), "index.html");
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        private final URL getResource(String path) {
            block3: {
                javaClass = Companion.class;
                v0 = javaClass.getClassLoader().getResource(path);
                if (v0 != null) break block3;
                var6_3 = javaClass.getClassLoader();
                v1 = var6_3 instanceof PluginClassLoader != false ? (PluginClassLoader)var6_3 : null;
                if (v1 == null || (v1 = v1.getPluginDescriptor()) == null || (v1 = v1.getPluginPath()) == null) ** GOTO lbl-1000
                it /* !! */  = v1;
                $i$a$-let-JupyterCefHttpHandlerBase$Companion$getResource$url$1 = false;
                var9_6 = new String[]{path};
                v2 = Path.of(NioPathUtil.toCanonicalPath((Path)it /* !! */ ), var9_6);
                v1 = v2;
                if (v2 != null && (v1 = v1.toUri()) != null) {
                    v0 = v1.toURL();
                } else lbl-1000:
                // 2 sources

                {
                    v0 = null;
                }
            }
            if ((url = v0) != null) {
                return url;
            }
            v3 = PathUtil.getJarPathForClass(javaClass);
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getJarPathForClass(...)");
            myPath = v3;
            result = new File(new File(myPath).getParentFile().getParentFile(), path);
            v4 = result.toURI().toURL();
            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"toURL(...)");
            return v4;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

