/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.profilers.async.core;

import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.profiler.ultimate.async.extractor.AsyncProfilerExtractor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.system.OS;
import com.jetbrains.performancePlugin.Timer;
import java.io.File;
import java.lang.invoke.CallSite;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

final class AsyncProfilerCommandBuilder {
    private static final Logger LOG = Logger.getInstance(AsyncProfilerCommandBuilder.class);
    private static final List<String> DEFAULT_PROFILING_OPTIONS = List.of("event=wall", "interval=10ms", "jfr", "jfrsync=profile");
    private static final List<String> DUMP_OPTIONS = List.of("summary", "traces", "flat", "jfr", "collapsed", "flamegraph", "tree");
    @NotNull
    private final String mySnapshotsPath;

    AsyncProfilerCommandBuilder(@NotNull String snapshotPaths) {
        if (snapshotPaths == null) {
            AsyncProfilerCommandBuilder.$$$reportNull$$$0(0);
        }
        this.mySnapshotsPath = snapshotPaths;
    }

    @NotNull
    public String buildStartCommand(@NotNull List<String> options) {
        String dbgHelpOption;
        if (options == null) {
            AsyncProfilerCommandBuilder.$$$reportNull$$$0(1);
        }
        if (!ContainerUtil.exists(options, e -> e.startsWith("file="))) {
            options = ContainerUtil.append(options, (Object[])new String[]{"file=" + this.getDumpFileName("jfr")});
        }
        if ((dbgHelpOption = AsyncProfilerExtractor.dbgHelpOption()) != null) {
            options = ContainerUtil.append((List)options, (Object[])new String[]{dbgHelpOption});
        }
        return AsyncProfilerCommandBuilder.buildCommand("start", AsyncProfilerCommandBuilder.mergeParameters(options, DEFAULT_PROFILING_OPTIONS));
    }

    @NotNull
    private static String buildCommand(String initialCommand, @NotNull List<String> options) {
        if (options == null) {
            AsyncProfilerCommandBuilder.$$$reportNull$$$0(2);
        }
        StringBuilder builder = new StringBuilder(initialCommand);
        for (String option : options) {
            builder.append(",").append(option);
        }
        LOG.info("Async profiler arguments: " + builder);
        String string = builder.toString();
        if (string == null) {
            AsyncProfilerCommandBuilder.$$$reportNull$$$0(3);
        }
        return string;
    }

    public List<String> buildStopAndDumpCommands(@NotNull List<String> options) {
        if (options == null) {
            AsyncProfilerCommandBuilder.$$$reportNull$$$0(4);
        }
        if (options.isEmpty()) {
            return List.of(AsyncProfilerCommandBuilder.buildCommand("stop", Arrays.asList("collapsed", "file=" + this.getDumpFileName("collapsed"))));
        }
        ArrayList<CallSite> dumpOptions = new ArrayList<CallSite>();
        ArrayList<String> profilingOptions = new ArrayList<String>();
        for (String option : options) {
            String string = option.split("=")[0].trim();
            if (DUMP_OPTIONS.contains(string)) {
                dumpOptions.add((CallSite)((Object)(option + ",file=" + this.getDumpFileName(string))));
                continue;
            }
            profilingOptions.add(option);
        }
        ArrayList<String> stopCommands = new ArrayList<String>();
        for (String string : dumpOptions) {
            stopCommands.add(AsyncProfilerCommandBuilder.buildCommand("stop", AsyncProfilerCommandBuilder.mergeParameters(profilingOptions, Arrays.asList(string.split(",")))));
        }
        return stopCommands;
    }

    private static Map<String, String> parseParametersList(@NotNull List<String> options) {
        if (options == null) {
            AsyncProfilerCommandBuilder.$$$reportNull$$$0(5);
        }
        return options.stream().map(option -> option.split("=")).collect(Collectors.toMap(element -> element[0].trim(), element -> ((String[])element).length > 1 ? element[1].trim() : ""));
    }

    @NotNull
    private String getDumpFileName(@NotNull String profilingType) {
        if (profilingType == null) {
            AsyncProfilerCommandBuilder.$$$reportNull$$$0(6);
        }
        String buildNumber = ApplicationInfo.getInstance().getBuild().asString();
        String activityName = Timer.instance.getActivityName();
        String time = new SimpleDateFormat("MMddHHmmss").format(new Date());
        String fileExtension = profilingType.equals("jfr") ? "jfr" : (profilingType.equals("flamegraph") || profilingType.equals("tree") ? "html" : "txt");
        String fileName = String.format("%s%s%s-%s-%s.%s", this.mySnapshotsPath, File.separator, buildNumber, activityName, time, fileExtension);
        if (OS.CURRENT == OS.Windows && fileName.length() > 255) {
            LOG.warn("Path to profile file is longer than 255.");
        }
        String string = fileName;
        if (string == null) {
            AsyncProfilerCommandBuilder.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static List<String> mergeParameters(@NotNull List<String> options, @NotNull List<String> defaultOptions) {
        if (options == null) {
            AsyncProfilerCommandBuilder.$$$reportNull$$$0(8);
        }
        if (defaultOptions == null) {
            AsyncProfilerCommandBuilder.$$$reportNull$$$0(9);
        }
        Map<String, String> userOptions = AsyncProfilerCommandBuilder.parseParametersList(options);
        Map<String, String> defOptions = AsyncProfilerCommandBuilder.parseParametersList(defaultOptions);
        HashMap<String, String> mergedOptions = new HashMap<String, String>(defOptions);
        mergedOptions.putAll(userOptions);
        return ContainerUtil.map(mergedOptions.keySet(), key -> ((String)mergedOptions.get(key)).isEmpty() ? key : key + "=" + (String)mergedOptions.get(key));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "snapshotPaths";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/performancePlugin/profilers/async/core/AsyncProfilerCommandBuilder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilingType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/performancePlugin/profilers/async/core/AsyncProfilerCommandBuilder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildCommand";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDumpFileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildStartCommand";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildCommand";
                break;
            }
            case 3: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildStopAndDumpCommands";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parseParametersList";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDumpFileName";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "mergeParameters";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 7 -> new IllegalStateException(string);
        };
    }
}

