/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.text;

import javax.swing.JList;
import javax.swing.ListModel;
import org.assertj.core.util.VisibleForTesting;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.cell.JListCellReader;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.driver.BasicJListCellReader;
import org.assertj.swing.text.TextReader;

public class JListTextReader
extends TextReader<JList> {
    private final JListCellReader cellReader;

    public JListTextReader() {
        this(new BasicJListCellReader());
    }

    @VisibleForTesting
    JListTextReader(@Nonnull JListCellReader cellReader) {
        this.cellReader = cellReader;
    }

    @Override
    @Nonnull
    public Class<JList> supportedComponent() {
        return JList.class;
    }

    @Override
    @RunsInCurrentThread
    protected boolean checkContainsText(@Nonnull JList list, @Nonnull String text2) {
        ListModel model = list.getModel();
        int elementCount = model.getSize();
        for (int i = 0; i < elementCount; ++i) {
            String elementText = this.cellReader.valueAt(list, i);
            if (elementText == null || !elementText.contains(text2)) continue;
            return true;
        }
        return false;
    }
}

