/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.assertions;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.Comparator;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.data.Offset;
import org.assertj.core.util.VisibleForTesting;
import org.assertj.swing.internal.assertions.Images;

public class ImageAssert
extends AbstractAssert<ImageAssert, BufferedImage> {
    @VisibleForTesting
    Images images = Images.instance();

    protected ImageAssert(BufferedImage actual) {
        super(actual, ImageAssert.class);
    }

    public ImageAssert isEqualTo(BufferedImage expected) {
        this.images.assertEqual(this.info, (BufferedImage)this.actual, expected);
        return this;
    }

    public ImageAssert isEqualTo(BufferedImage expected, Offset<Integer> offset) {
        this.images.assertEqual(this.info, (BufferedImage)this.actual, expected, offset);
        return this;
    }

    public ImageAssert isNotEqualTo(BufferedImage other) {
        this.images.assertNotEqual(this.info, (BufferedImage)this.actual, other);
        return this;
    }

    public ImageAssert hasSize(Dimension expected) {
        this.images.assertHasSize(this.info, (BufferedImage)this.actual, expected);
        return this;
    }

    @Override
    public ImageAssert usingComparator(Comparator<? super BufferedImage> customComparator) {
        throw new UnsupportedOperationException("custom Comparator is not supported for image comparison");
    }

    @Override
    public ImageAssert usingDefaultComparator() {
        super.usingDefaultComparator();
        this.images = Images.instance();
        return (ImageAssert)this.myself;
    }
}

