/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.utils;

import java.time.temporal.ChronoUnit;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/jetbrains/performancePlugin/utils/TimeArgumentParserUtil;", "", "()V", "Companion", "intellij.performanceTesting"})
public final class TimeArgumentParserUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Regex ARGS_PATTERN = new Regex("^([0-9]*)(ms|s|m)$");
    @NotNull
    private static final Map<String, ChronoUnit> POSSIBLE_VALUES;

    static {
        Pair[] pairArray = new Pair[]{new Pair((Object)"ms", (Object)ChronoUnit.MILLIS), new Pair((Object)"s", (Object)ChronoUnit.SECONDS), new Pair((Object)"m", (Object)ChronoUnit.MINUTES)};
        POSSIBLE_VALUES = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\b0\n2\u0006\u0010\f\u001a\u00020\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/jetbrains/performancePlugin/utils/TimeArgumentParserUtil$Companion;", "", "()V", "ARGS_PATTERN", "Lkotlin/text/Regex;", "POSSIBLE_VALUES", "", "", "Ljava/time/temporal/ChronoUnit;", "parse", "Lkotlin/Pair;", "", "input", "intellij.performanceTesting"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Pair<Long, ChronoUnit> parse(@NotNull String input) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Object object = Regex.find$default((Regex)ARGS_PATTERN, (CharSequence)input, (int)0, (int)2, null);
            if (object == null || (object = object.getGroupValues()) == null) {
                throw new RuntimeException("Can't parse input " + input + "\n Correct format is '4ms'(or s or m)");
            }
            Object object2 = object;
            String time = (String)object2.get(1);
            String timeUnit = (String)object2.get(2);
            ChronoUnit chronoUnit = (ChronoUnit)POSSIBLE_VALUES.get(timeUnit);
            if (chronoUnit == null) {
                throw new RuntimeException("Timeunit '" + timeUnit + "' isn't supported. Must be one of " + POSSIBLE_VALUES);
            }
            return new Pair((Object)Long.parseLong(time), (Object)chronoUnit);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

