/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.remotedriver.xpath;

import com.intellij.driver.model.LocalRefDelegate;
import com.intellij.driver.model.RefDelegate;
import com.intellij.driver.model.RemoteRefDelegate;
import com.intellij.driver.model.transport.Ref;
import com.jetbrains.performancePlugin.remotedriver.dataextractor.TextToKeyCache;
import com.jetbrains.performancePlugin.remotedriver.xpath.XpathDataModelCreator;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\fJ$\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\u00112\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/performancePlugin/remotedriver/xpath/XpathSearcher;", "", "textToKeyCache", "Lcom/jetbrains/performancePlugin/remotedriver/dataextractor/TextToKeyCache;", "(Lcom/jetbrains/performancePlugin/remotedriver/dataextractor/TextToKeyCache;)V", "modelCreator", "Lcom/jetbrains/performancePlugin/remotedriver/xpath/XpathDataModelCreator;", "xPath", "Ljavax/xml/xpath/XPath;", "kotlin.jvm.PlatformType", "findComponent", "Lcom/intellij/driver/model/RefDelegate;", "Ljava/awt/Component;", "xpathExpression", "", "component", "findComponents", "", "intellij.performanceTesting.remoteDriver"})
@SourceDebugExtension(value={"SMAP\nXpathSearcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XpathSearcher.kt\ncom/jetbrains/performancePlugin/remotedriver/xpath/XpathSearcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,46:1\n1603#2,9:47\n1855#2:56\n1856#2:58\n1612#2:59\n800#2,11:60\n1855#2,2:71\n1612#2:73\n1#3:57\n*S KotlinDebug\n*F\n+ 1 XpathSearcher.kt\ncom/jetbrains/performancePlugin/remotedriver/xpath/XpathSearcher\n*L\n34#1:47,9\n34#1:56\n34#1:58\n34#1:59\n34#1:60,11\n34#1:71,2\n34#1:73\n34#1:57\n*E\n"})
public final class XpathSearcher {
    @NotNull
    private final XpathDataModelCreator modelCreator;
    private final XPath xPath;

    public XpathSearcher(@NotNull TextToKeyCache textToKeyCache) {
        Intrinsics.checkNotNullParameter((Object)textToKeyCache, (String)"textToKeyCache");
        this.modelCreator = new XpathDataModelCreator(textToKeyCache, null, 2, null);
        this.xPath = XPathFactory.newInstance().newXPath();
    }

    @NotNull
    public final RefDelegate<Component> findComponent(@NotNull String xpathExpression, @Nullable Component component) {
        Intrinsics.checkNotNullParameter((Object)xpathExpression, (String)"xpathExpression");
        List<RefDelegate<Component>> components = this.findComponents(xpathExpression, component);
        if (components.size() > 1) {
            throw new IllegalStateException("To many components found by xpath '" + xpathExpression + "'");
        }
        if (components.isEmpty()) {
            throw new IllegalStateException("No components found by xpath '" + xpathExpression + "'");
        }
        return (RefDelegate)CollectionsKt.first(components);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<RefDelegate<Component>> findComponents(@NotNull String xpathExpression, @Nullable Component component) {
        Iterable $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        boolean bl;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)xpathExpression, (String)"xpathExpression");
        Document model = XpathDataModelCreator.create$default(this.modelCreator, component, null, 2, null);
        Object object = this.xPath.compile(xpathExpression).evaluate(model, XPathConstants.NODESET);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.w3c.dom.NodeList");
        NodeList result = (NodeList)object;
        Iterable $this$mapNotNull$iv = (Iterable)RangesKt.until((int)0, (int)result.getLength());
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Node it$iv$iv;
            int element$iv$iv$iv;
            int element$iv$iv = element$iv$iv$iv = ((IntIterator)iterator2).nextInt();
            bl = false;
            int it = element$iv$iv;
            boolean bl2 = false;
            if (result.item(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$filterIsInstance = false;
        $this$mapNotNullTo$iv$iv = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof Element)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        $i$f$mapNotNull = false;
        $this$filterIsInstanceTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            RefDelegate refDelegate;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            bl = false;
            Element it = (Element)element$iv$iv;
            boolean bl4 = false;
            if (it.hasAttribute("remoteId")) {
                String remoteId = it.getAttribute("remoteId");
                String className = it.getAttribute("javaclass");
                String identityHash = it.getAttribute("hashCode");
                Intrinsics.checkNotNull((Object)identityHash);
                refDelegate = new RemoteRefDelegate(new Ref(remoteId, className, Integer.parseInt(identityHash), null));
            } else {
                Object object2 = it.getUserData("component");
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type java.awt.Component");
                refDelegate = new LocalRefDelegate<Component>((Component)object2);
            }
            RefDelegate it$iv$iv = refDelegate;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

